#  ICE Revision: $Id$ 
"""Parameter file is read into memory and modified there"""

raise "PyFoam","Old. Buggy. Just here forsentimental reasons"

import string,sys

from FileBasis import FileBasisBackup

class ParsedParameterFile(FileBasisBackup):
    """ Parameterfile whose complete representation is read into
    memory, can be manipulated and afterwards written to disk"""

    def __init__(self,name,backup=False,debug=False):
        """@param name: The name of the parameter file
        @param backup: create a backup-copy of the file"""

        FileBasisBackup.__init__(self,name,backup=backup)
        self.debug=debug
        
        self.header=None
        
        self.readFile()

        if self.content.has_key("FoamFile"):
            self.header={ "FoamFile" : self.content["FoamFile"] }
            self.content.pop("FoamFile")
            
    def parse(self,content):
        """Constructs a representation of the file"""
        parser=FoamFileParser(content,debug=self.debug)
        self.content=parser.getData()
        return self.content
        
    def __str__(self):
        """Generates a string from the contents in memory"""
        string="// File generated by PyFoam - sorry for the ugliness\n\n"
        if self.header:
            generator=FoamFileGenerator(self.header)
            string+=str(generator)
            string+="\n// End of header\n\n"
            
        generator=FoamFileGenerator(self.content)
        string+=str(generator)

        return string
    
class FoamFileParser(object):
    """Class that parses a string that contains the contents of an
    OpenFOAM-file and bilds a nested structure of directories and
    lists from it"""

    def __init__(self,content,debug=False):
        """@param content: the string to be parsed
        @param debug: output debug information during parsing"""
        
        self.data=None
        self.debug=debug
        content=self.rmComments(content)
        self.data,ind=self.parseDict(content,0)
        
    def getData(self):
        """ Get the data structure"""
        return self.data

    def getChar(self,c,ind):
        """Get the next character from a string (if there is any)
        @param c: the string
        @param ind: the current index
        @return: the character (empty string if past the end) and the new index"""

        if self.isOK(c,ind):
            #            print "Get",ind,"\"",c[ind],"\""
            return c[ind],ind+1
        else:
            return "",ind

    def peekChar(self,c,ind):
        if self.isOK(c,ind):
            return c[ind]
        else:
            return ""

    def isOK(self,c,ind):
        """Check whether there are still characters in the string"""

        #        print "isOK",ind,len(c)
        return ind<len(c)
    
    def skipSpace(self,c,ind):
        """Skip spaces and set index to the next non-whitespace character
        @return: The index of the next non-whitespace character"""

        while self.isOK(c,ind) and string.whitespace.find(self.peekChar(c,ind))>=0:
            #            print "Skipping",ind,self.peekChar(c,ind),string.whitespace.find(self.peekChar(c,ind))
            ind+=1

        return ind

    def getName(self,c,ind):
        """Gets a name for a dictionary entry
        @return: name and index of the next char after it"""
        name=""

        first=True
        
        while self.isOK(c,ind):
            if first:
                first=False
                z=self.peekChar(c,ind)
                if string.digits.find(z)>=0:
                    return name,ind
                
            z,ind=self.getChar(c,ind)
            if string.whitespace.find(z)>=0:
                break
            elif z==";":
                ind-=1
                break
            else:
                name+=z

        if self.debug:
            print "Got Name:",name
            
        return name,ind

    def getString(self,c,ind):
        """Get a quoted string and return it (including the quotes)"""

        z,ind=self.getChar(c,ind)
        prev=z
        qs=z
        
        while self.isOK(c,ind):
            z,ind=self.getChar(c,ind)
            qs+=z
            if z!="\"" and prev!="\\":
                prev=z
            else:
                if self.peekChar(c,ind)==";":
                    break
                else:
                    prev=z

        if self.debug:
            print "Got String:",qs

        return qs,ind

    def checkForList(self,c,ind):
        """Look-ahead to find out whether the next thing is a list"""

        z=self.peekChar(c,ind)
        if z=="(":
            return True,ind+1
        elif string.digits.find(z)<0 and c.find("List",ind)==ind:
            return False,ind
        else:
            indOld=ind
            while self.isOK(c,ind):
                z,ind=self.getChar(c,ind)
                if z=="(":
                    break
                elif z==";":
                    break
            if z=="(":
                return True,ind
            else:
                return False,indOld
            
    def parseList(self,c,ind):
        """Parse a list"""
        data=[]

        while self.isOK(c,ind):
            d=None
            ind=self.skipSpace(c,ind)
            z=self.peekChar(c,ind)
            if z==")":
                ind+=1
                ind=self.skipSpace(c,ind)
                z,ind=self.getChar(c,ind)
                if z!=";":
                    # list of boundaries is wrong
                    # pass
                    if not self.isOK(c,ind):
                        # propably a boundary file
                        pass
                    else:
                        self.parserError("';' expected in parseList",c,ind)
                break
            elif z=="{":
                d,ind=self.parseDict(c,ind+1)
                ind=self.skipSpace(c,ind)
                z,ind=self.getChar(c,ind)
                if z!="}":
                    self.parserError("'}' expected",c,ind)
            elif z=="(":
                d,ind=self.parseList(c,ind+1)
            elif z=="\"":
                d,ind=self.getString(c,ind)
            else:
                d,ind=self.getValue(c,ind)
                
                #            print data,d
            if self.debug:
                print "Appending:",d,"to list"
                
            data.append(d)

        return data,ind

    def getValue(self,c,ind):
        """Get characters up to the next white-space"""
        v=""
        while self.isOK(c,ind):
            z,ind=self.getChar(c,ind)
            if string.whitespace.find(z)>=0:
                ind-=1
                break
            else:
                v+=z

        if self.debug:
            print "Got Value:",v
                
        return v,ind
    
    def parseValue(self,c,ind):
        """Parse a value that ends withe semi-colon"""
        data=""

        while self.isOK(c,ind):
            z,ind=self.getChar(c,ind)
            if z==";":
                break
            else:
                data+=z
                
        if self.debug:
            print "Parsed value:",data
                
        return data,ind

    def printContext(self,c,ind):
        """Prints the context of the current index"""
        print "------"
        print c[max(0,ind-100):max(0,ind-1)]
        print "------"
        print ">",c[ind-1],"<"
        print "------"
        print c[min(len(c),ind):min(len(c),ind+100)]
        print "------"

    def parserError(self,text,c,ind):
        """Prints the error message of the parser and exit"""
        print "PARSER ERROR:",text
        print "On index",ind
        self.printContext(c,ind)
        raise ParseError
        sys.exit(-1)
        
    def parseDict(self,c,ind):
        """Parse assuming a dictionary
        @param c: the string that is to be parsed
        @param ind: index of the next chatacter to analyze"""
        
        data={}
        nrAnonym=1
        
        while self.isOK(c,ind):
            name=""
            d=None
            
            ind=self.skipSpace(c,ind)

            z=self.peekChar(c,ind)
            if z=="}":
                break
            name,ind=self.getName(c,ind)
            ind=self.skipSpace(c,ind)
            z=self.peekChar(c,ind)
            if z=="{":
                d,ind=self.parseDict(c,ind+1)
                #                print "Rest:",c[ind:]
                
                ind=self.skipSpace(c,ind)
                z,ind=self.getChar(c,ind)
                if z!="}":
                    print d                    
                    self.parserError("'}' expected",c,ind)
            elif z=="\"":
                d,ind=self.getString(c,ind)
                ind=self.skipSpace(c,ind)
                z,ind=self.getChar(c,ind)
                if z!=";":
                    self.parserError("';' expected",c,ind)
            elif z==";":
                z,ind=self.getChar(c,ind)
                d=""
            elif c[ind:ind+len("uniform ")]=="uniform ":
                semiPos=c.find(";",ind+len("uniform "))
                d=c[ind+len("uniform "):semiPos]
                ind=semiPos+1
            else:
                isLst,ind=self.checkForList(c,ind)
                if isLst:
                    d,ind=self.parseList(c,ind)
                else:
                    d,ind=self.parseValue(c,ind)

            if name=="" and d!="":
                name="anonymValue%03d" % nrAnonym
                nrAnonym+=1

            if name!="":
                if self.debug:
                    print "Got Name:",name,"with value:",d
                
                data[name]=d
                #                print "Dict:",data
            
        return data,ind
        
    def rmComments(self,c):
        """Removes the comments from a string"""
        ind=0
        inComment=False
        s=""
        
        while ind<len(c):
            oneStep=False
            if not inComment and c[ind]!="/":
                oneStep=True
            elif inComment:
                if c[ind]!="*":
                    ind+=1
                else:
                    ind+=1
                    if ind<len(c):
                        if c[ind]=="/":
                            inComment=False
                        ind+=1
            else:
                oneStep=True
                if ind+1<len(c):
                    if c[ind+1]=="*":
                        inComment=True
                        ind+=1
                        oneStep=False
                    elif c[ind+1]=="/":
                        i=c.find("\n",ind+1)
                        if i>=0:
                            ind=i
                        else:
                            ind=len(c)
                            oneStep=False
                            
            if oneStep:
                s+=c[ind]
                ind+=1

        return s
            
class FoamFileGenerator(object):
    """Class that generates a OpenFOAM-compatible representation of a
    data-structure"""

    def __init__(self,data):
        self.data=data

    def __str__(self):
        return self.strDict(self.data)

    def strDict(self,dic,indent=0):
        s=""
        for k,v in dic.iteritems():
            if k.find("anonymValue")==0:
                k=""
                
            s+=(" "*indent)+k
            if type(v)==str:
                s+=" "+v+";\n"
            elif type(v)==dict:
                s+="\n"+(" "*indent)+"{\n"
                s+=self.strDict(v,indent+2)
                s+="\n"+(" "*indent)+"}\n"
            elif type(v)==list:
                s+="\n"
                s+=self.strList(v,indent+2)
            else:
                s+=" "+str(v)+";\n"
                
        return s
    
    def strList(self,lst,indent=0):
        s=""

        theLen=len(lst)
        
        if len(lst)>2 and len(lst)%2==0:
            if type(lst[0])==str and type(lst[1])==dict:
                theLen=len(lst)/2
                
        s+=(" "*indent)+str(theLen)+"\n"
        s+=(" "*indent)+"(\n"
        for v in lst:
            if type(v)==str:
                s+=(" "*(indent+2))+v+"\n"
            elif type(v)==dict:
                s+="\n"+(" "*(indent+2))+"{\n"
                s+=self.strDict(v,indent+4)
                s+="\n"+(" "*(indent+2))+"}\n"
            elif type(v)==list:
                s+="\n"
                s+=self.strList(v,indent+2)
            else:
                s+=(" "*(indent+2))+str(v)+"\n"
            
        s+=(" "*indent)+");\n"
        
        return s
