# coding: utf-8

"""
    CyberSource Merged Spec

    All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class TssV2TransactionsGet200ResponsePaymentInformationBankAccount(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'suffix': 'str',
        'prefix': 'str',
        'check_number': 'str',
        'type': 'str',
        'name': 'str',
        'check_digit': 'str',
        'encoder_id': 'str'
    }

    attribute_map = {
        'suffix': 'suffix',
        'prefix': 'prefix',
        'check_number': 'checkNumber',
        'type': 'type',
        'name': 'name',
        'check_digit': 'checkDigit',
        'encoder_id': 'encoderId'
    }

    def __init__(self, suffix=None, prefix=None, check_number=None, type=None, name=None, check_digit=None, encoder_id=None):
        """
        TssV2TransactionsGet200ResponsePaymentInformationBankAccount - a model defined in Swagger
        """

        self._suffix = None
        self._prefix = None
        self._check_number = None
        self._type = None
        self._name = None
        self._check_digit = None
        self._encoder_id = None

        if suffix is not None:
          self.suffix = suffix
        if prefix is not None:
          self.prefix = prefix
        if check_number is not None:
          self.check_number = check_number
        if type is not None:
          self.type = type
        if name is not None:
          self.name = name
        if check_digit is not None:
          self.check_digit = check_digit
        if encoder_id is not None:
          self.encoder_id = encoder_id

    @property
    def suffix(self):
        """
        Gets the suffix of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        Last four digits of the customer’s payment account number. 

        :return: The suffix of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        :rtype: str
        """
        return self._suffix

    @suffix.setter
    def suffix(self, suffix):
        """
        Sets the suffix of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        Last four digits of the customer’s payment account number. 

        :param suffix: The suffix of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        :type: str
        """

        self._suffix = suffix

    @property
    def prefix(self):
        """
        Gets the prefix of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        Bank Identification Number (BIN). This is the initial four to six numbers on a credit card account number. 

        :return: The prefix of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """
        Sets the prefix of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        Bank Identification Number (BIN). This is the initial four to six numbers on a credit card account number. 

        :param prefix: The prefix of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        :type: str
        """

        self._prefix = prefix

    @property
    def check_number(self):
        """
        Gets the check_number of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        Check number.  Chase Paymentech Solutions - Optional. CyberSource ACH Service - Not used. RBS WorldPay Atlanta - Optional on debits. Required on credits. TeleCheck - Strongly recommended on debit requests. Optional on credits. 

        :return: The check_number of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        :rtype: str
        """
        return self._check_number

    @check_number.setter
    def check_number(self, check_number):
        """
        Sets the check_number of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        Check number.  Chase Paymentech Solutions - Optional. CyberSource ACH Service - Not used. RBS WorldPay Atlanta - Optional on debits. Required on credits. TeleCheck - Strongly recommended on debit requests. Optional on credits. 

        :param check_number: The check_number of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        :type: str
        """
        if check_number is not None and len(check_number) > 8:
            raise ValueError("Invalid value for `check_number`, length must be less than or equal to `8`")

        self._check_number = check_number

    @property
    def type(self):
        """
        Gets the type of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        Account type.  Possible values:  - **C**: Checking.  - **G**: General ledger. This value is supported only on Wells Fargo ACH.  - **S**: Savings (U.S. dollars only).  - **X**: Corporate checking (U.S. dollars only). 

        :return: The type of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        Account type.  Possible values:  - **C**: Checking.  - **G**: General ledger. This value is supported only on Wells Fargo ACH.  - **S**: Savings (U.S. dollars only).  - **X**: Corporate checking (U.S. dollars only). 

        :param type: The type of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        :type: str
        """
        if type is not None and len(type) > 1:
            raise ValueError("Invalid value for `type`, length must be less than or equal to `1`")

        self._type = type

    @property
    def name(self):
        """
        Gets the name of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        Name used on the bank account. You can use this field only when scoring a direct debit transaction 

        :return: The name of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        Name used on the bank account. You can use this field only when scoring a direct debit transaction 

        :param name: The name of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        :type: str
        """

        self._name = name

    @property
    def check_digit(self):
        """
        Gets the check_digit of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        Code used to validate the customer’s account number. Required for some countries if you do not or are not allowed to provide the IBAN instead. You may use this field only when scoring a direct debit transaction.  For all possible values, see the `bank_check_digit` field description in the _Decision Manager Using the SCMP API Developer Guide_ on the [CyberSource Business Center.](https://ebc2.cybersource.com/ebc2/) Click **Decision Manager** > **Documentation** > **Guides** > _Decision Manager Using the SCMP API Developer Guide_ (PDF link). 

        :return: The check_digit of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        :rtype: str
        """
        return self._check_digit

    @check_digit.setter
    def check_digit(self, check_digit):
        """
        Sets the check_digit of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        Code used to validate the customer’s account number. Required for some countries if you do not or are not allowed to provide the IBAN instead. You may use this field only when scoring a direct debit transaction.  For all possible values, see the `bank_check_digit` field description in the _Decision Manager Using the SCMP API Developer Guide_ on the [CyberSource Business Center.](https://ebc2.cybersource.com/ebc2/) Click **Decision Manager** > **Documentation** > **Guides** > _Decision Manager Using the SCMP API Developer Guide_ (PDF link). 

        :param check_digit: The check_digit of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        :type: str
        """

        self._check_digit = check_digit

    @property
    def encoder_id(self):
        """
        Gets the encoder_id of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        Identifier for the bank that provided the customer’s encoded account number.  To obtain the bank identifier, contact your processor.  For details, see `account_encoder_id` request-level field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :return: The encoder_id of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        :rtype: str
        """
        return self._encoder_id

    @encoder_id.setter
    def encoder_id(self, encoder_id):
        """
        Sets the encoder_id of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        Identifier for the bank that provided the customer’s encoded account number.  To obtain the bank identifier, contact your processor.  For details, see `account_encoder_id` request-level field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 

        :param encoder_id: The encoder_id of this TssV2TransactionsGet200ResponsePaymentInformationBankAccount.
        :type: str
        """
        if encoder_id is not None and len(encoder_id) > 3:
            raise ValueError("Invalid value for `encoder_id`, length must be less than or equal to `3`")

        self._encoder_id = encoder_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TssV2TransactionsGet200ResponsePaymentInformationBankAccount):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
