"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnSkill = exports.toJson_Overrides = exports.toJson_SkillPackage = exports.toJson_AuthenticationConfiguration = exports.toJson_CfnSkillProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnSkillProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnSkillProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AuthenticationConfiguration': toJson_AuthenticationConfiguration(obj.authenticationConfiguration),
        'VendorId': obj.vendorId,
        'SkillPackage': toJson_SkillPackage(obj.skillPackage),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnSkillProps = toJson_CfnSkillProps;
/**
 * Converts an object of type 'AuthenticationConfiguration' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AuthenticationConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ClientId': obj.clientId,
        'RefreshToken': obj.refreshToken,
        'ClientSecret': obj.clientSecret,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AuthenticationConfiguration = toJson_AuthenticationConfiguration;
/**
 * Converts an object of type 'SkillPackage' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_SkillPackage(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'S3BucketRole': obj.s3BucketRole,
        'Overrides': toJson_Overrides(obj.overrides),
        'S3ObjectVersion': obj.s3ObjectVersion,
        'S3Bucket': obj.s3Bucket,
        'S3Key': obj.s3Key,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_SkillPackage = toJson_SkillPackage;
/**
 * Converts an object of type 'Overrides' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Overrides(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Manifest': obj.manifest,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Overrides = toJson_Overrides;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Alexa::ASK::Skill`
 *
 * @cloudformationResource Alexa::ASK::Skill
 * @stability external
 * @link http://unknown-url
 */
class CfnSkill extends cdk.CfnResource {
    /**
     * Create a new `Alexa::ASK::Skill`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnSkill.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnSkillProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
    }
}
exports.CfnSkill = CfnSkill;
_a = JSII_RTTI_SYMBOL_1;
CfnSkill[_a] = { fqn: "@cdk-cloudformation/alexa-ask-skill.CfnSkill", version: "0.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnSkill.CFN_RESOURCE_TYPE_NAME = "Alexa::ASK::Skill";
//# sourceMappingURL=data:application/json;base64,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