import * as cdk from '@aws-cdk/core';
import { CfnVirtualNode } from './appmesh.generated';
import { HealthCheck } from './shared-interfaces';
/**
 * (experimental) Properties for a VirtualNode listener.
 *
 * @experimental
 */
export interface VirtualNodeListenerConfig {
    /**
     * (experimental) Single listener config for a VirtualNode.
     *
     * @experimental
     */
    readonly listener: CfnVirtualNode.ListenerProperty;
}
/**
 * Represents the properties needed to define a Listeners for a VirtualNode
 */
interface VirtualNodeListenerCommonOptions {
    /**
     * (experimental) Port to listen for connections on.
     *
     * @default - 8080
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) The health check information for the listener.
     *
     * @default - no healthcheck
     * @experimental
     */
    readonly healthCheck?: HealthCheck;
}
/**
 * (experimental) Represent the HTTP Node Listener prorperty.
 *
 * @experimental
 */
export interface HttpVirtualNodeListenerOptions extends VirtualNodeListenerCommonOptions {
    /**
     * (experimental) Timeout for HTTP protocol.
     *
     * @default - None
     * @experimental
     */
    readonly timeout?: HttpTimeout;
}
/**
 * (experimental) Represent the GRPC Node Listener prorperty.
 *
 * @experimental
 */
export interface GrpcVirtualNodeListenerOptions extends VirtualNodeListenerCommonOptions {
    /**
     * (experimental) Timeout for GRPC protocol.
     *
     * @default - None
     * @experimental
     */
    readonly timeout?: GrpcTimeout;
}
/**
 * (experimental) Represent the TCP Node Listener prorperty.
 *
 * @experimental
 */
export interface TcpVirtualNodeListenerOptions extends VirtualNodeListenerCommonOptions {
    /**
     * (experimental) Timeout for TCP protocol.
     *
     * @default - None
     * @experimental
     */
    readonly timeout?: TcpTimeout;
}
/**
 * (experimental) Represents timeouts for HTTP protocols.
 *
 * @experimental
 */
export interface HttpTimeout {
    /**
     * (experimental) Represents an idle timeout.
     *
     * The amount of time that a connection may be idle.
     *
     * @default - none
     * @experimental
     */
    readonly idle?: cdk.Duration;
    /**
     * (experimental) Represents per request timeout.
     *
     * @default - 15 s
     * @experimental
     */
    readonly perRequest?: cdk.Duration;
}
/**
 * (experimental) Represents timeouts for GRPC protocols.
 *
 * @experimental
 */
export interface GrpcTimeout {
    /**
     * (experimental) Represents an idle timeout.
     *
     * The amount of time that a connection may be idle.
     *
     * @default - none
     * @experimental
     */
    readonly idle?: cdk.Duration;
    /**
     * (experimental) Represents per request timeout.
     *
     * @default - 15 s
     * @experimental
     */
    readonly perRequest?: cdk.Duration;
}
/**
 * (experimental) Represents timeouts for TCP protocols.
 *
 * @experimental
 */
export interface TcpTimeout {
    /**
     * (experimental) Represents an idle timeout.
     *
     * The amount of time that a connection may be idle.
     *
     * @default - none
     * @experimental
     */
    readonly idle?: cdk.Duration;
}
/**
 * (experimental) Defines listener for a VirtualNode.
 *
 * @experimental
 */
export declare abstract class VirtualNodeListener {
    /**
     * (experimental) Returns an HTTP Listener for a VirtualNode.
     *
     * @experimental
     */
    static http(props?: HttpVirtualNodeListenerOptions): VirtualNodeListener;
    /**
     * (experimental) Returns an HTTP2 Listener for a VirtualNode.
     *
     * @experimental
     */
    static http2(props?: HttpVirtualNodeListenerOptions): VirtualNodeListener;
    /**
     * (experimental) Returns an GRPC Listener for a VirtualNode.
     *
     * @experimental
     */
    static grpc(props?: GrpcVirtualNodeListenerOptions): VirtualNodeListener;
    /**
     * (experimental) Returns an TCP Listener for a VirtualNode.
     *
     * @experimental
     */
    static tcp(props?: TcpVirtualNodeListenerOptions): VirtualNodeListener;
    /**
     * (experimental) Binds the current object when adding Listener to a VirtualNode.
     *
     * @experimental
     */
    abstract bind(scope: cdk.Construct): VirtualNodeListenerConfig;
}
export {};
