import * as cdk from '@aws-cdk/core';
import { CfnRoute } from './appmesh.generated';
import { IVirtualNode } from './virtual-node';
/**
 * (experimental) Properties for the Weighted Targets in the route.
 *
 * @experimental
 */
export interface WeightedTarget {
    /**
     * (experimental) The VirtualNode the route points to.
     *
     * @experimental
     */
    readonly virtualNode: IVirtualNode;
    /**
     * (experimental) The weight for the target.
     *
     * @default 1
     * @experimental
     */
    readonly weight?: number;
}
/**
 * (experimental) The criterion for determining a request match for this GatewayRoute.
 *
 * @experimental
 */
export interface HttpRouteMatch {
    /**
     * (experimental) Specifies the path to match requests with.
     *
     * This parameter must always start with /, which by itself matches all requests to the virtual service name.
     * You can also match for path-based routing of requests. For example, if your virtual service name is my-service.local
     * and you want the route to match requests to my-service.local/metrics, your prefix should be /metrics.
     *
     * @experimental
     */
    readonly prefixPath: string;
}
/**
 * (experimental) The criterion for determining a request match for this GatewayRoute.
 *
 * @experimental
 */
export interface GrpcRouteMatch {
    /**
     * (experimental) The fully qualified domain name for the service to match from the request.
     *
     * @experimental
     */
    readonly serviceName: string;
}
/**
 * (experimental) Properties specific for HTTP Based Routes.
 *
 * @experimental
 */
export interface HttpRouteSpecOptions {
    /**
     * (experimental) The criterion for determining a request match for this Route.
     *
     * @default - matches on '/'
     * @experimental
     */
    readonly match?: HttpRouteMatch;
    /**
     * (experimental) List of targets that traffic is routed to when a request matches the route.
     *
     * @experimental
     */
    readonly weightedTargets: WeightedTarget[];
}
/**
 * (experimental) Properties specific for a TCP Based Routes.
 *
 * @experimental
 */
export interface TcpRouteSpecOptions {
    /**
     * (experimental) List of targets that traffic is routed to when a request matches the route.
     *
     * @experimental
     */
    readonly weightedTargets: WeightedTarget[];
}
/**
 * (experimental) Properties specific for a GRPC Based Routes.
 *
 * @experimental
 */
export interface GrpcRouteSpecOptions {
    /**
     * (experimental) The criterion for determining a request match for this Route.
     *
     * @experimental
     */
    readonly match: GrpcRouteMatch;
    /**
     * (experimental) List of targets that traffic is routed to when a request matches the route.
     *
     * @experimental
     */
    readonly weightedTargets: WeightedTarget[];
}
/**
 * (experimental) All Properties for GatewayRoute Specs.
 *
 * @experimental
 */
export interface RouteSpecConfig {
    /**
     * (experimental) The spec for an http route.
     *
     * @default - no http spec
     * @experimental
     */
    readonly httpRouteSpec?: CfnRoute.HttpRouteProperty;
    /**
     * (experimental) The spec for an http2 route.
     *
     * @default - no http2 spec
     * @experimental
     */
    readonly http2RouteSpec?: CfnRoute.HttpRouteProperty;
    /**
     * (experimental) The spec for a grpc route.
     *
     * @default - no grpc spec
     * @experimental
     */
    readonly grpcRouteSpec?: CfnRoute.GrpcRouteProperty;
    /**
     * (experimental) The spec for a tcp route.
     *
     * @default - no tcp spec
     * @experimental
     */
    readonly tcpRouteSpec?: CfnRoute.TcpRouteProperty;
}
/**
 * (experimental) Used to generate specs with different protocols for a RouteSpec.
 *
 * @experimental
 */
export declare abstract class RouteSpec {
    /**
     * (experimental) Creates an HTTP Based RouteSpec.
     *
     * @experimental
     */
    static http(options: HttpRouteSpecOptions): RouteSpec;
    /**
     * (experimental) Creates an HTTP2 Based RouteSpec.
     *
     * @experimental
     */
    static http2(options: HttpRouteSpecOptions): RouteSpec;
    /**
     * (experimental) Creates a TCP Based RouteSpec.
     *
     * @experimental
     */
    static tcp(options: TcpRouteSpecOptions): RouteSpec;
    /**
     * (experimental) Creates a GRPC Based RouteSpec.
     *
     * @experimental
     */
    static grpc(options: GrpcRouteSpecOptions): RouteSpec;
    /**
     * (experimental) Called when the GatewayRouteSpec type is initialized.
     *
     * Can be used to enforce
     * mutual exclusivity with future properties
     *
     * @experimental
     */
    abstract bind(scope: cdk.Construct): RouteSpecConfig;
}
