# Optical data

## Implemented optical satellites

|Satellites | Class | Product Types | Use archive | Default Resolution |
|--- | --- | --- | --- | ---|
|Sentinel-2 | {meth}`~eoreader.products.optical.s2_product.S2Product` | L1C & L2A | Yes | 20m|
|Sentinel-2 Theia | {meth}`~eoreader.products.optical.s2_theia_product.S2TheiaProduct` | L2A | Yes | 20m|
|Sentinel-3 SLSTR | {meth}`~eoreader.products.optical.s3_product.S3Product` | RBT | Yes | 300m|
|Sentinel-3 OLCI | {meth}`~eoreader.products.optical.s3_product.S3Product` | EFR | Yes | 500m|
|Landsat 8 OLCI | {meth}`~eoreader.products.optical.l8_product.L8Product` | Level 1 | Collection 1: No, Collection 2: Yes | 30m|
|Landsat 7 ETM | {meth}`~eoreader.products.optical.l7_product.L7Product` | Level 1 | Collection 1: No, Collection 2: Yes | 30m|
|Landsat 5 TM | {meth}`~eoreader.products.optical.l5_product.L5Product` | Level 1 | Collection 1: No, Collection 2: Yes | 30m|
|Landsat 4 TM | {meth}`~eoreader.products.optical.l4_product.L4Product` | Level 1 | Collection 1: No, Collection 2: Yes | 30m|
|Landsat 5 MSS | {meth}`~eoreader.products.optical.l5_product.L5Product` | Level 1 | Collection 1: No, Collection 2: Yes | 60m|
|Landsat 4 MSS | {meth}`~eoreader.products.optical.l4_product.L4Product` | Level 1 | Collection 1: No, Collection 2: Yes | 60m|
|Landsat 3 MSS | {meth}`~eoreader.products.optical.l3_product.L3Product` | Level 1 | Collection 1: No, Collection 2: Yes | 60m|
|Landsat 2 MSS | {meth}`~eoreader.products.optical.l2_product.L2Product` | Level 1 | Collection 1: No, Collection 2: Yes | 60m|
|Landsat 1 MSS | {meth}`~eoreader.products.optical.l1_product.L1Product` | Level 1 | Collection 1: No, Collection 2: Yes | 60m|
|PlanetScope | {meth}`~eoreader.products.optical.pla_product.PlaProduct` | L3A & L3B | Yes | 3m|
|Pleiades | {meth}`~eoreader.products.optical.pld_product.PldProduct` | SEN, PRJ, ORT & MOS | Yes | 0.5 or 2m|
|SPOT 7 | {meth}`~eoreader.products.optical.spot7_product.Spot7Product` | SEN, PRJ, ORT & MOS | Yes | 1.5 or 6m|
|SPOT 6 | {meth}`~eoreader.products.optical.spot6_product.Spot6Product` | SEN, PRJ, ORT & MOS | Yes | 1.5 or 6m|
|GeoEye-1* | {meth}`~eoreader.products.optical.maxar_product.MaxarProduct` | Standard & Ortho | Yes | 0.3 to 0.6 (PAN or pansharpened), 1.6 to 2.4m (MS)|
|WorldView-2* | {meth}`~eoreader.products.optical.maxar_product.MaxarProduct` | Standard & Ortho | Yes | 0.3 to 0.6 (PAN or pansharpened), 1.6 to 2.4m (MS)|
|WorldView-3* | {meth}`~eoreader.products.optical.maxar_product.MaxarProduct` | Standard & Ortho | Yes | 0.3 to 0.6 (PAN or pansharpened), 1.6 to 2.4m (MS)|
|WorldView-4* | {meth}`~eoreader.products.optical.maxar_product.MaxarProduct` | Standard & Ortho | Yes | 0.3 to 0.6 (PAN or pansharpened), 1.6 to 2.4m (MS)|

\* *Archived Landsat Collection-1 are not managed because of the tar.gz format, which is too slow to process. It is better to work on the extracted product.*
\* *Other Maxar satellites (such as WorldView-1, QuickBird...) with the same file format should be supported.*

```{warning}
Satellites products that cannot be used as archived have to be extracted before use.
```

The goal of **EOReader** is to implement every sensor that can be used in the [Copernicus Emergency Management Service](https://emergency.copernicus.eu/).  
The sensors that can be used as of 09/2021 are:  
![cems_sensors](https://www.esa.int/var/esa/storage/images/esa_multimedia/images/2021/09/copernicus_contributing_missions_overview/23461131-1-eng-GB/Copernicus_Contributing_Missions_overview_pillars.jpg)

## Optical bands

The following bands are available in **EOReader**, but may not be available for all sensors.

```{warning}
EOReader loads bands in UTM. VHR bands can be orthorectified but EOReader needs a DEM for that.
Be sure to position the environment variable `EOREADER_DEM_PATH` to the DEM you want.
```

### Satellite bands

```{note}
Optical bands are always loaded in reflectance. 
For Sentinel-3 SLSTR, radiances are converted to reflectance, 
expcept for brilliance temperature bands that are left as is.
```

#### Band names

These bands are mainly based on Sentinel-2 bands with some additions:

- {meth}`~eoreader.bands.bands.OpticalBandNames.CA`: Coastal Aerosol
- {meth}`~eoreader.bands.bands.OpticalBandNames.BLUE`
- {meth}`~eoreader.bands.bands.OpticalBandNames.GREEN`
- {meth}`~eoreader.bands.bands.OpticalBandNames.YELLOW`
- {meth}`~eoreader.bands.bands.OpticalBandNames.RED`
- {meth}`~eoreader.bands.bands.OpticalBandNames.VRE_1`: Vegetation Red Edge 1
- {meth}`~eoreader.bands.bands.OpticalBandNames.VRE_2`: Vegetation Red Edge 2
- {meth}`~eoreader.bands.bands.OpticalBandNames.VRE_3`: Vegetation Red Edge 3
- {meth}`~eoreader.bands.bands.OpticalBandNames.NIR`: Near Infrared
- {meth}`~eoreader.bands.bands.OpticalBandNames.NARROW_NIR`: Narrow Near Infrared (band `8A` for `Sentinel-2`)
- {meth}`~eoreader.bands.bands.OpticalBandNames.WV`: Water vapour
- {meth}`~eoreader.bands.bands.OpticalBandNames.SWIR_CIRRUS`
- {meth}`~eoreader.bands.bands.OpticalBandNames.SWIR_1`
- {meth}`~eoreader.bands.bands.OpticalBandNames.SWIR_2`
- {meth}`~eoreader.bands.bands.OpticalBandNames.PAN`: Panchromatic
- {meth}`~eoreader.bands.bands.OpticalBandNames.TIR_1`: Thermal Infrared 1
- {meth}`~eoreader.bands.bands.OpticalBandNames.TIR_2`: Thermal Infrared 2

```{note}
Note that bands that are not mapped can still be used (i.e. for Sentinel-3 OLCI and SLSTR). 
They will be called by their true name (i.e. `F1` or `Oa05`). However, 
the mapped band will have to be called with their mapped name, i.e. `BLUE` rather than `Oa04` for Sentinel-3 OLCI.
But the bands that are not present in the `alias` file won't be recognized.
```

#### Optical band mapping between sensors

|Bands (names) | Coastal aerosol | Blue | Green | Yellow | Red | Vegetation red edge | Vegetation red edge | Vegetation red edge | NIR | Narrow NIR | Water vapor | SWIR – Cirrus | SWIR | SWIR | Panchromatic | Thermal IR | Thermal IR|
|--- | --- | --- | --- | --- | --- | --- | --- | --- | --- |  --- | --- | --- | --- | --- | --- | --- | ---|
|**Bands (alias)** | `CA` | `BLUE` | `GREEN` | `YELLOW` | `RED` | `VRE_1` | `VRE_2` | `VRE_3` | `NIR` | `NARROW_NIR` | `WV` | `SWIR_CIRRUS` | `SWIR_1` | `SWIR_2` | `PAN` | `TIR_1` | `TIR_2`|
|Sentinel-2 | **1** (60m) | **2** (10m) | **3** (10m) | | **4** (10m) | **5** (20m) |**6** (20m) |**7** (20m) |**8** (10m) | **8A** (20m) |**9** (60m) |**10** (60m) |**11** (20m) |**12** (20m) |  |  | |
|Sentinel-2 Theia | *Not available* | **2** (10m) |**3** (10m)  | | **4** (10m) | **5** (20m) |**6** (20m) |**7** (20m) |**8** (10m) | **8A** (20m) | *Not available* |**10** (60m) |**11** (20m) |**12** (20m) |  |  | |
|Sentinel-3 OLCI* | **2** (300m) | **3** (300m) |**6** (300m)  |**7** (300m)  |**8** (300m) |**11** (300m) |**12** (300m) | **16** (300m) | **17** (300m) | **17** (300m) | **20** (300m) |  |  |  |  |  | |
|Sentinel-3 SLSTR* | | | **1** (500m)  | | **2** (500m) |  |  |  |**3** (500m) |**3** (500m) |  | **4** (500m) | **5** (500m) |**6** (500m) | |**8** (1km, not managed yet) |**9** (1km, not managed yet)|
|Landsat OLCI (8) | **1** (30m) | **2** (30m) | **3** (30m)  | | **4** (30m) |  |  |  | **5** (30m) | **5** (30m) |  |**9** (30m) |**6** (30m) |**7** (30m) |**8** (15m) |**10** (100m) |**11** (100m)|
|Landsat ETM (7)|  | **1** (30m) | **2** (30m)  | | **3** (30m) |  |  |  | **4** (30m) | **4** (30m) |  |  | **5** (30m) |**7** (30m) |**8** (15m) |**6** (60m) |**6** (60m)|
|Landsat TM (5-4)|  | **1** (30m) | **2** (30m) |  | **3** (30m) |  |  |  | **4**(30m) | **4** (30m) |  |  | **5** (30m) |**7** (30m) |  |**6** (120m) |**6** (120m)|
|Landsat MSS (5-4)|  |  | **1** (60m)  | | **2** (60m) | **3** (60m) | **3** (60m) | **3** (60m) | **4** (60m) | **4** (60m) |  |  |  |  |  |  | |
|Landsat MSS (1-3)|  |  | **4** (60m)  | | **5** (60m) | **6** (60m) | **6** (60m) | **6** (60m) | **7** (60m) | **7** (60m) |  |  |  |  |  |**8** (240m)<br>*only for Landsat 3* |**8** (240m)<br>*only for Landsat 3*|
|PlanetScope (4 band)|  | **1** (3m) | **2** (3m) |  | **3** (3m) | |  | | **4** (3m) | **4** (3m) |  |  |  |  |  | | |
|PlanetScope (5 band)|  | **1** (3m) | **2** (3m) |  | **3** (3m) |**4** (3m)|  || **5** (3m) | **5** (3m) |  |  |  |  |  | | |
|Pleiades** (PMS/MS)|  | **3** (0.5/2m) | **2** (0.5/2m)  | | **1** (0.5/2m) | | | | **4** (0.5/2m) | **4** (0.5/2m) |  |  |  |  |  | | |
|SPOT 6-7** (PMS/MS)|  | **3** (1.5/6m) | **2** (1.5/6m)  | | **1** (1.5/6m) | | | | **4** (1.5/6m) | **4** (1.5/6m) |  |  |  |  |  | | |

\* *Not all bands of this sensor are mapped in EOReader. However, they can still be used by using directly their name (i.e. `F1` or `Oa05`)*  
\*\* *P(panchro) have only one panchromatic band, P/MS-N have 3 bands (BGR), and P/MS-X also have 3 bands in false color (GRNIR)*

<div>                        <script type="text/javascript">window.PlotlyConfig = {MathJaxConfig: 'local'};</script>
        <script src="https://cdn.plot.ly/plotly-2.4.2.min.js"></script>                <div id="0fcc77fb-5a08-47de-9378-5dba483722fd" class="plotly-graph-div" style="height:700px; width:1100px;"></div>            <script type="text/javascript">                                    window.PLOTLYENV=window.PLOTLYENV || {};                                    if (document.getElementById("0fcc77fb-5a08-47de-9378-5dba483722fd")) {                    Plotly.newPlot(                        "0fcc77fb-5a08-47de-9378-5dba483722fd",                        [{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-2 MSI | SWIR_2</b><br>Central Wavelength: 2190nm<br>Bandwidth: 180nm<br>Resolution: 20m<br>Band Number: 12","line":{"color":"rgb(79,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-2 MSI | SWIR_1</b><br>Central Wavelength: 1612nm<br>Bandwidth: 92nm<br>Resolution: 20m<br>Band Number: 11","line":{"color":"rgb(98,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-2 MSI | CIRRUS</b><br>Central Wavelength: 1380nm<br>Bandwidth: 30nm<br>Resolution: 60m<br>Band Number: 10","line":{"color":"rgb(118,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-2 MSI | WATER_VAPOUR</b><br>Central Wavelength: 944nm<br>Bandwidth: 20nm<br>Resolution: 60m<br>Band Number: 09","line":{"color":"rgb(118,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.1,0.1,0.1,0.1,0.1,0.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-2 MSI | NIR</b><br>Central Wavelength: 833nm<br>Bandwidth: 106nm<br>Resolution: 10m<br>Band Number: 08","line":{"color":"rgb(157,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-2 MSI | NARROW_NIR</b><br>Central Wavelength: 864nm<br>Bandwidth: 21nm<br>Resolution: 20m<br>Band Number: 8a","line":{"color":"rgb(177,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.1,0.1,0.1,0.1,0.1,0.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-2 MSI | VEGETATION_RED_EDGE_3</b><br>Central Wavelength: 781nm<br>Bandwidth: 20nm<br>Resolution: 20m<br>Band Number: 07","line":{"color":"rgb(196,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.1,0.1,0.1,0.1,0.1,0.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-2 MSI | VEGETATION_RED_EDGE_2</b><br>Central Wavelength: 740nm<br>Bandwidth: 15nm<br>Resolution: 20m<br>Band Number: 06","line":{"color":"rgb(216,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.1,0.1,0.1,0.1,0.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-2 MSI | VEGETATION_RED_EDGE_1</b><br>Central Wavelength: 704nm<br>Bandwidth: 15nm<br>Resolution: 20m<br>Band Number: 05","line":{"color":"rgb(235,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.1,0.1,0.1,0.1,0.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-2 MSI | RED</b><br>Central Wavelength: 665nm<br>Bandwidth: 31nm<br>Resolution: 10m<br>Band Number: 04","line":{"color":"red","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-2 MSI | GREEN</b><br>Central Wavelength: 560nm<br>Bandwidth: 36nm<br>Resolution: 10m<br>Band Number: 03","line":{"color":"green","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-2 MSI | BLUE</b><br>Central Wavelength: 492nm<br>Bandwidth: 66nm<br>Resolution: 10m<br>Band Number: 02","line":{"color":"dodgerblue","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-2 MSI | COASTAL_AEROSOL</b><br>Central Wavelength: 442nm<br>Bandwidth: 21nm<br>Resolution: 60m<br>Band Number: 01","line":{"color":"lightskyblue","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.1,0.1,0.1,0.1,0.1,0.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 OLCI | WATER_VAPOUR</b><br>Central Wavelength: 940nm<br>Bandwidth: 20nm<br>Resolution: 300m<br>Band Number: 20","line":{"color":"rgb(118,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1.1,1.1,1.1,1.1,1.1,1.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 OLCI | NARROW_NIR</b><br>Central Wavelength: 865nm<br>Bandwidth: 20nm<br>Resolution: 300m<br>Band Number: 17","line":{"color":"rgb(177,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1.1,1.1,1.1,1.1,1.1,1.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 OLCI | VEGETATION_RED_EDGE_3</b><br>Central Wavelength: 778.75nm<br>Bandwidth: 15nm<br>Resolution: 300m<br>Band Number: 16","line":{"color":"rgb(196,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1.1,1.1,1.1,1.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 OLCI | VEGETATION_RED_EDGE_2</b><br>Central Wavelength: 753.75nm<br>Bandwidth: 7.5nm<br>Resolution: 300m<br>Band Number: 12","line":{"color":"rgb(216,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1.1,1.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 OLCI | VEGETATION_RED_EDGE_1</b><br>Central Wavelength: 708.75nm<br>Bandwidth: 10nm<br>Resolution: 300m<br>Band Number: 11","line":{"color":"rgb(235,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1.1,1.1,1.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 OLCI | RED</b><br>Central Wavelength: 665nm<br>Bandwidth: 10nm<br>Resolution: 300m<br>Band Number: 08","line":{"color":"red","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1.1,1.1,1.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 OLCI | YELLOW</b><br>Central Wavelength: 620nm<br>Bandwidth: 10nm<br>Resolution: 300m<br>Band Number: 07","line":{"color":"gold","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1.1,1.1,1.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 OLCI | GREEN</b><br>Central Wavelength: 560nm<br>Bandwidth: 10nm<br>Resolution: 300m<br>Band Number: 06","line":{"color":"green","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1.1,1.1,1.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 OLCI | BLUE</b><br>Central Wavelength: 490nm<br>Bandwidth: 10nm<br>Resolution: 300m<br>Band Number: 04","line":{"color":"dodgerblue","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1.1,1.1,1.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 OLCI | COASTAL_AEROSOL</b><br>Central Wavelength: 442.5nm<br>Bandwidth: 10nm<br>Resolution: 300m<br>Band Number: 03","line":{"color":"lightskyblue","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1.1,1.1,1.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 SLSTR | SWIR_2</b><br>Central Wavelength: 2255.7nm<br>Bandwidth: 50.15nm<br>Resolution: 500m<br>Band Number: 06","line":{"color":"rgb(79,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 SLSTR | SWIR_1</b><br>Central Wavelength: 1613.4nm<br>Bandwidth: 60.68nm<br>Resolution: 500m<br>Band Number: 05","line":{"color":"rgb(98,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,2.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 SLSTR | CIRRUS</b><br>Central Wavelength: 1374.8nm<br>Bandwidth: 20.8nm<br>Resolution: 500m<br>Band Number: 04","line":{"color":"rgb(118,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2.1,2.1,2.1,2.1,2.1,2.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 SLSTR | NARROW_NIR</b><br>Central Wavelength: 868.0nm<br>Bandwidth: 20.6nm<br>Resolution: 500m<br>Band Number: 03","line":{"color":"rgb(177,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2.1,2.1,2.1,2.1,2.1,2.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 SLSTR | RED</b><br>Central Wavelength: 659.47nm<br>Bandwidth: 19.25nm<br>Resolution: 500m<br>Band Number: 02","line":{"color":"red","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2.1,2.1,2.1,2.1,2.1,2.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Sentinel-3 SLSTR | GREEN</b><br>Central Wavelength: 554.27nm<br>Bandwidth: 19.26nm<br>Resolution: 500m<br>Band Number: 01","line":{"color":"green","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2.1,2.1,2.1,2.1,2.1,2.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat OLCI | PANCHROMATIC</b><br>Central Wavelength: 590.0nm<br>Bandwidth: 180nm<br>Resolution: 15m<br>Band Number: 08","line":{"color":"grey","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,3.0,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat OLCI | SWIR_2</b><br>Central Wavelength: 2200.0nm<br>Bandwidth: 180nm<br>Resolution: 30m<br>Band Number: 07","line":{"color":"rgb(79,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat OLCI | SWIR_1</b><br>Central Wavelength: 1610.0nm<br>Bandwidth: 80nm<br>Resolution: 30m<br>Band Number: 06","line":{"color":"rgb(98,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat OLCI | CIRRUS</b><br>Central Wavelength: 1370.0nm<br>Bandwidth: 20nm<br>Resolution: 30m<br>Band Number: 09","line":{"color":"rgb(118,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3.1,3.1,3.1,3.1,3.1,3.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat OLCI | NARROW_NIR</b><br>Central Wavelength: 865.0nm<br>Bandwidth: 30nm<br>Resolution: 30m<br>Band Number: 05","line":{"color":"rgb(177,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat OLCI | RED</b><br>Central Wavelength: 655.0nm<br>Bandwidth: 30nm<br>Resolution: 30m<br>Band Number: 04","line":{"color":"red","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat OLCI | GREEN</b><br>Central Wavelength: 560.0nm<br>Bandwidth: 60nm<br>Resolution: 30m<br>Band Number: 03","line":{"color":"green","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat OLCI | BLUE</b><br>Central Wavelength: 480.0nm<br>Bandwidth: 60nm<br>Resolution: 30m<br>Band Number: 02","line":{"color":"dodgerblue","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,3.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat OLCI | COASTAL_AEROSOL</b><br>Central Wavelength: 440.0nm<br>Bandwidth: 20nm<br>Resolution: 30m<br>Band Number: 01","line":{"color":"lightskyblue","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3.1,3.1,3.1,3.1,3.1,3.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat ETM+ | PANCHROMATIC</b><br>Central Wavelength: 710.0nm<br>Bandwidth: 380nm<br>Resolution: 15m<br>Band Number: 08","line":{"color":"grey","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,4.0,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat ETM+ | SWIR_2</b><br>Central Wavelength: 2220.0nm<br>Bandwidth: 260nm<br>Resolution: 30m<br>Band Number: 07","line":{"color":"rgb(79,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat ETM+ | SWIR_1</b><br>Central Wavelength: 1650.0nm<br>Bandwidth: 200nm<br>Resolution: 30m<br>Band Number: 05","line":{"color":"rgb(98,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat ETM+ | NIR</b><br>Central Wavelength: 835.0nm<br>Bandwidth: 130nm<br>Resolution: 30m<br>Band Number: 04","line":{"color":"rgb(157,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat ETM+ | RED</b><br>Central Wavelength: 660.0nm<br>Bandwidth: 60nm<br>Resolution: 30m<br>Band Number: 03","line":{"color":"red","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat ETM+ | GREEN</b><br>Central Wavelength: 560.0nm<br>Bandwidth: 80nm<br>Resolution: 30m<br>Band Number: 02","line":{"color":"green","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat ETM+ | BLUE</b><br>Central Wavelength: 485.0nm<br>Bandwidth: 70nm<br>Resolution: 30m<br>Band Number: 01","line":{"color":"dodgerblue","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,4.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat TM | SWIR_2</b><br>Central Wavelength: 2215.0nm<br>Bandwidth: 270nm<br>Resolution: 30m<br>Band Number: 07","line":{"color":"rgb(79,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat TM | SWIR_1</b><br>Central Wavelength: 1650.0nm<br>Bandwidth: 200nm<br>Resolution: 30m<br>Band Number: 05","line":{"color":"rgb(98,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat TM | NIR</b><br>Central Wavelength: 830.0nm<br>Bandwidth: 140nm<br>Resolution: 30m<br>Band Number: 04","line":{"color":"rgb(157,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat TM | RED</b><br>Central Wavelength: 660.0nm<br>Bandwidth: 60nm<br>Resolution: 30m<br>Band Number: 03","line":{"color":"red","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat TM | GREEN</b><br>Central Wavelength: 560.0nm<br>Bandwidth: 80nm<br>Resolution: 30m<br>Band Number: 02","line":{"color":"green","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat TM | BLUE</b><br>Central Wavelength: 485.0nm<br>Bandwidth: 70nm<br>Resolution: 30m<br>Band Number: 01","line":{"color":"dodgerblue","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,5.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat MSS (4/5) | NIR</b><br>Central Wavelength: 950.0nm<br>Bandwidth: 300nm<br>Resolution: 60m<br>Band Number: 04","line":{"color":"rgb(157,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat MSS (4/5) | VEGETATION_RED_EDGE_1</b><br>Central Wavelength: 750.0nm<br>Bandwidth: 100nm<br>Resolution: 60m<br>Band Number: 03","line":{"color":"rgb(235,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat MSS (4/5) | RED</b><br>Central Wavelength: 650.0nm<br>Bandwidth: 100nm<br>Resolution: 60m<br>Band Number: 02","line":{"color":"red","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat MSS (4/5) | GREEN</b><br>Central Wavelength: 550.0nm<br>Bandwidth: 100nm<br>Resolution: 60m<br>Band Number: 01","line":{"color":"green","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,6.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat MSS (1/2/3) | NIR</b><br>Central Wavelength: 950.0nm<br>Bandwidth: 300nm<br>Resolution: 60m<br>Band Number: 07","line":{"color":"rgb(157,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat MSS (1/2/3) | VEGETATION_RED_EDGE_1</b><br>Central Wavelength: 750.0nm<br>Bandwidth: 100nm<br>Resolution: 60m<br>Band Number: 06","line":{"color":"rgb(235,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat MSS (1/2/3) | RED</b><br>Central Wavelength: 650.0nm<br>Bandwidth: 100nm<br>Resolution: 60m<br>Band Number: 05","line":{"color":"red","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Landsat MSS (1/2/3) | GREEN</b><br>Central Wavelength: 550.0nm<br>Bandwidth: 100nm<br>Resolution: 60m<br>Band Number: 04","line":{"color":"green","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,7.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>PlanetScope | NIR</b><br>Central Wavelength: 820.0nm<br>Bandwidth: 80nm<br>Resolution: 3m<br>Band Number: 04","line":{"color":"rgb(157,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>PlanetScope | RED</b><br>Central Wavelength: 630.0nm<br>Bandwidth: 80nm<br>Resolution: 3m<br>Band Number: 03","line":{"color":"red","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>PlanetScope | GREEN</b><br>Central Wavelength: 545.0nm<br>Bandwidth: 90nm<br>Resolution: 3m<br>Band Number: 02","line":{"color":"green","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,8.2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>PlanetScope | BLUE</b><br>Central Wavelength: 485.0nm<br>Bandwidth: 60nm<br>Resolution: 3m<br>Band Number: 01","line":{"color":"dodgerblue","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,8.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Pleiades | PANCHROMATIC</b><br>Central Wavelength: 655.0nm<br>Bandwidth: 350nm<br>Resolution: 0.5m<br>Band Number: NA","line":{"color":"grey","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,9.0,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Pleiades | NIR</b><br>Central Wavelength: 790.0nm<br>Bandwidth: 80nm<br>Resolution: 3m<br>Band Number: 04","line":{"color":"rgb(157,0,0)","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Pleiades | RED</b><br>Central Wavelength: 660.0nm<br>Bandwidth: 120nm<br>Resolution: 3m<br>Band Number: 01","line":{"color":"red","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,9.1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Pleiades | GREEN</b><br>Central Wavelength: 550.0nm<br>Bandwidth: 120nm<br>Resolution: 3m<br>Band Number: 02","line":{"color":"green","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361563517,2126.2214983713357,2129.5602605863196,2132.899022801303,2136.2377850162866,2139.5765472312705,2142.9153094462545,2146.254071661238,2149.5928338762214,2152.9315960912054,2156.2703583061893,2159.609120521173,2162.9478827361563,2166.2866449511403,2169.6254071661238,2172.9641693811072,2176.302931596091,2179.641693811075,2182.9804560260586,2186.319218241042,2189.657980456026,2192.99674267101,2196.3355048859935,2199.674267100977,2203.013029315961,2206.351791530945,2209.6905537459284,2213.029315960912,2216.368078175896,2219.7068403908797,2223.045602605863,2226.3843648208467,2229.7231270358307,2233.0618892508146,2236.400651465798,2239.7394136807816,2243.0781758957655,2246.4169381107495,2249.755700325733,2253.0944625407164,2256.4332247557004,2259.7719869706843,2263.110749185668,2266.4495114006513,2269.7882736156353,2273.127035830619,2276.4657980456027,2279.804560260586,2283.14332247557,2286.482084690554,2289.8208469055376,2293.159609120521,2296.498371335505,2299.837133550489,2303.1758957654724,2306.514657980456,2309.85342019544,2313.192182410424,2316.5309446254073,2319.869706840391,2323.2084690553747,2326.5472312703587,2329.885993485342,2333.2247557003257,2336.5635179153096,2339.9022801302935,2343.241042345277,2346.5798045602605,2349.9185667752445,2353.2573289902284,2356.596091205212,2359.9348534201954,2363.2736156351793,2366.6123778501633,2369.951140065147,2373.2899022801303,2376.628664495114,2379.9674267100977,2383.306188925081,2386.644951140065,2389.983713355049,2393.3224755700326,2396.661237785016,2400.0],"y":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,9.2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]},{"hoverinfo":"x+text","hovertemplate":"<b>Pleiades | BLUE</b><br>Central Wavelength: 490.0nm<br>Bandwidth: 120nm<br>Resolution: 3m<br>Band Number: 03","line":{"color":"dodgerblue","width":20},"name":"","showlegend":false,"type":"scatter","x":[350.0,353.3387622149837,356.67752442996743,360.01628664495115,363.35504885993487,366.6938110749186,370.0325732899023,373.371335504886,376.71009771986974,380.0488599348534,383.3876221498371,386.72638436482083,390.06514657980455,393.40390879478826,396.742671009772,400.0814332247557,403.4201954397394,406.75895765472313,410.09771986970685,413.43648208469057,416.7752442996743,420.114006514658,423.45276872964166,426.7915309446254,430.1302931596091,433.4690553745928,436.80781758957653,440.14657980456025,443.48534201954396,446.8241042345277,450.1628664495114,453.5016286644951,456.84039087947883,460.17915309446255,463.51791530944627,466.85667752443,470.1954397394137,473.5342019543974,476.87296416938113,480.21172638436485,483.55048859934857,486.8892508143323,490.228013029316,493.5667752442997,496.9055374592834,500.2442996742671,503.5830618892508,506.92182410423453,510.26058631921825,513.5993485342019,516.9381107491856,520.2768729641693,523.6156351791531,526.9543973941368,530.2931596091205,533.6319218241042,536.9706840390879,540.3094462540716,543.6482084690554,546.9869706840391,550.3257328990228,553.6644951140065,557.0032573289902,560.342019543974,563.6807817589577,567.0195439739414,570.3583061889251,573.6970684039088,577.0358306188925,580.3745928338762,583.71335504886,587.0521172638437,590.3908794788274,593.7296416938111,597.0684039087948,600.4071661237786,603.7459283387623,607.084690553746,610.4234527687297,613.7622149837134,617.1009771986971,620.4397394136809,623.7785016286646,627.1172638436483,630.456026058632,633.7947882736157,637.1335504885994,640.4723127035832,643.8110749185668,647.1498371335505,650.4885993485342,653.8273615635179,657.1661237785016,660.5048859934853,663.8436482084691,667.1824104234528,670.5211726384365,673.8599348534202,677.1986970684039,680.5374592833876,683.8762214983714,687.2149837133551,690.5537459283388,693.8925081433225,697.2312703583062,700.5700325732898,703.9087947882736,707.2475570032573,710.586319218241,713.9250814332247,717.2638436482084,720.6026058631921,723.9413680781759,727.2801302931596,730.6188925081433,733.957654723127,737.2964169381107,740.6351791530944,743.9739413680782,747.3127035830619,750.6514657980456,753.9902280130293,757.328990228013,760.6677524429967,764.0065146579805,767.3452768729642,770.6840390879479,774.0228013029316,777.3615635179153,780.700325732899,784.0390879478828,787.3778501628665,790.7166123778502,794.0553745928339,797.3941368078176,800.7328990228013,804.0716612377851,807.4104234527688,810.7491856677525,814.0879478827362,817.4267100977199,820.7654723127037,824.1042345276874,827.4429967426711,830.7817589576548,834.1205211726385,837.4592833876222,840.798045602606,844.1368078175897,847.4755700325734,850.8143322475571,854.1530944625408,857.4918566775244,860.8306188925081,864.1693811074919,867.5081433224756,870.8469055374593,874.185667752443,877.5244299674267,880.8631921824104,884.2019543973942,887.5407166123779,890.8794788273616,894.2182410423453,897.557003257329,900.8957654723127,904.2345276872965,907.5732899022802,910.9120521172639,914.2508143322476,917.5895765472313,920.928338762215,924.2671009771988,927.6058631921825,930.9446254071662,934.2833876221499,937.6221498371335,940.9609120521172,944.299674267101,947.6384364820847,950.9771986970684,954.3159609120521,957.6547231270358,960.9934853420195,964.3322475570033,967.671009771987,971.0097719869707,974.3485342019544,977.6872964169381,981.0260586319218,984.3648208469056,987.7035830618893,991.042345276873,994.3811074918567,997.7198697068404,1001.0586319218241,1004.3973941368079,1007.7361563517916,1011.0749185667753,1014.413680781759,1017.7524429967427,1021.0912052117264,1024.4299674267102,1027.7687296416939,1031.1074918566776,1034.4462540716613,1037.785016286645,1041.1237785016287,1044.4625407166125,1047.8013029315962,1051.1400651465797,1054.4788273615636,1057.817589576547,1061.156351791531,1064.4951140065145,1067.8338762214985,1071.172638436482,1074.511400651466,1077.8501628664494,1081.1889250814334,1084.5276872964168,1087.8664495114008,1091.2052117263843,1094.5439739413682,1097.8827361563517,1101.2214983713357,1104.5602605863191,1107.899022801303,1111.2377850162866,1114.5765472312705,1117.915309446254,1121.254071661238,1124.5928338762214,1127.9315960912054,1131.2703583061889,1134.6091205211728,1137.9478827361563,1141.2866449511403,1144.6254071661238,1147.9641693811077,1151.3029315960912,1154.641693811075,1157.9804560260586,1161.3192182410423,1164.657980456026,1167.9967426710098,1171.3355048859935,1174.6742671009772,1178.013029315961,1181.3517915309446,1184.6905537459284,1188.029315960912,1191.3680781758958,1194.7068403908795,1198.0456026058632,1201.384364820847,1204.7231270358307,1208.0618892508144,1211.400651465798,1214.7394136807818,1218.0781758957655,1221.4169381107492,1224.755700325733,1228.0944625407167,1231.4332247557004,1234.771986970684,1238.1107491856678,1241.4495114006515,1244.7882736156353,1248.127035830619,1251.4657980456027,1254.8045602605864,1258.1433224755701,1261.4820846905536,1264.8208469055376,1268.159609120521,1271.498371335505,1274.8371335504885,1278.1758957654724,1281.514657980456,1284.8534201954399,1288.1921824104234,1291.5309446254073,1294.8697068403908,1298.2084690553747,1301.5472312703582,1304.8859934853422,1308.2247557003257,1311.5635179153096,1314.902280130293,1318.241042345277,1321.5798045602605,1324.9185667752445,1328.257328990228,1331.596091205212,1334.9348534201954,1338.2736156351793,1341.6123778501628,1344.9511400651468,1348.2899022801303,1351.6286644951142,1354.9674267100977,1358.3061889250816,1361.6449511400651,1364.9837133550488,1368.3224755700326,1371.6612377850163,1375.0,1378.3387622149837,1381.6775244299674,1385.0162866449512,1388.3550488599349,1391.6938110749186,1395.0325732899023,1398.371335504886,1401.7100977198697,1405.0488599348535,1408.3876221498372,1411.726384364821,1415.0651465798046,1418.4039087947883,1421.742671009772,1425.0814332247558,1428.4201954397395,1431.7589576547232,1435.097719869707,1438.4364820846906,1441.7752442996743,1445.114006514658,1448.4527687296418,1451.7915309446255,1455.1302931596092,1458.469055374593,1461.8078175895766,1465.1465798045604,1468.485342019544,1471.8241042345278,1475.1628664495115,1478.5016286644952,1481.840390879479,1485.1791530944627,1488.5179153094464,1491.85667752443,1495.1954397394138,1498.5342019543975,1501.8729641693812,1505.211726384365,1508.5504885993487,1511.8892508143324,1515.2280130293161,1518.5667752442998,1521.9055374592836,1525.244299674267,1528.5830618892508,1531.9218241042345,1535.2605863192182,1538.599348534202,1541.9381107491856,1545.2768729641693,1548.615635179153,1551.9543973941368,1555.2931596091205,1558.6319218241042,1561.970684039088,1565.3094462540716,1568.6482084690554,1571.986970684039,1575.3257328990228,1578.6644951140065,1582.0032573289902,1585.342019543974,1588.6807817589577,1592.0195439739414,1595.358306188925,1598.6970684039088,1602.0358306188925,1605.3745928338762,1608.71335504886,1612.0521172638437,1615.3908794788274,1618.7296416938111,1622.0684039087948,1625.4071661237786,1628.7459283387623,1632.084690553746,1635.4234527687297,1638.7622149837134,1642.1009771986971,1645.4397394136809,1648.7785016286646,1652.1172638436483,1655.456026058632,1658.7947882736157,1662.1335504885994,1665.4723127035832,1668.8110749185669,1672.1498371335506,1675.4885993485343,1678.827361563518,1682.1661237785017,1685.5048859934855,1688.8436482084692,1692.182410423453,1695.5211726384366,1698.8599348534203,1702.198697068404,1705.5374592833878,1708.8762214983715,1712.2149837133552,1715.553745928339,1718.8925081433226,1722.2312703583063,1725.57003257329,1728.9087947882738,1732.2475570032575,1735.5863192182412,1738.925081433225,1742.2638436482084,1745.6026058631921,1748.9413680781759,1752.2801302931596,1755.6188925081433,1758.957654723127,1762.2964169381107,1765.6351791530944,1768.9739413680782,1772.3127035830619,1775.6514657980456,1778.9902280130293,1782.328990228013,1785.6677524429967,1789.0065146579805,1792.3452768729642,1795.684039087948,1799.0228013029316,1802.3615635179153,1805.700325732899,1809.0390879478828,1812.3778501628665,1815.7166123778502,1819.055374592834,1822.3941368078176,1825.7328990228013,1829.071661237785,1832.4104234527688,1835.7491856677525,1839.0879478827362,1842.42671009772,1845.7654723127037,1849.1042345276874,1852.442996742671,1855.7817589576548,1859.1205211726385,1862.4592833876222,1865.798045602606,1869.1368078175897,1872.4755700325734,1875.814332247557,1879.1530944625408,1882.4918566775245,1885.8306188925083,1889.169381107492,1892.5081433224757,1895.8469055374594,1899.1856677524431,1902.5244299674268,1905.8631921824106,1909.2019543973943,1912.540716612378,1915.8794788273617,1919.2182410423454,1922.5570032573291,1925.8957654723129,1929.2345276872966,1932.5732899022803,1935.912052117264,1939.2508143322477,1942.5895765472314,1945.9283387622152,1949.2671009771989,1952.6058631921824,1955.944625407166,1959.2833876221498,1962.6221498371335,1965.9609120521172,1969.299674267101,1972.6384364820847,1975.9771986970684,1979.315960912052,1982.6547231270358,1985.9934853420195,1989.3322475570033,1992.671009771987,1996.0097719869707,1999.3485342019544,2002.6872964169381,2006.0260586319218,2009.3648208469056,2012.7035830618893,2016.042345276873,2019.3811074918567,2022.7198697068404,2026.0586319218241,2029.3973941368079,2032.7361563517916,2036.0749185667753,2039.413680781759,2042.7524429967427,2046.0912052117264,2049.4299674267104,2052.768729641694,2056.1074918566774,2059.4462540716613,2062.7850162866453,2066.1237785016287,2069.4625407166122,2072.801302931596,2076.14006514658,2079.4788273615636,2082.817589576547,2086.156351791531,2089.495114006515,2092.8338762214985,2096.172638436482,2099.511400651466,2102.85016286645,2106.1889250814334,2109.527687296417,2112.866449511401,2116.2052117263847,2119.543973941368,2122.8827361