#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.buffer',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20200517',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    ('Facilities to do with buffers, particularly CornuCopyBuffer, an '    
 'automatically refilling buffer to support parsing of data streams.'),
  long_description =
    ('Facilities to do with buffers, particularly CornuCopyBuffer,\n'    
 'an automatically refilling buffer to support parsing of data streams.\n'    
 '\n'    
 '*Latest release 20200517*:\n'    
 '* CornuCopyBuffer.skip: bugfix sanity check.\n'    
 '* FileIterator: do not close the supplied file, just set self.fp=None.\n'    
 '* Improve EOFError message text.\n'    
 '\n'    
 '## Function `chunky(bfr_func)`\n'    
 '\n'    
 'Decorator for a function accepting a leading `CornuCopyBuffer`\n'    
 'parameter.\n'    
 'Returns a function accepting a leading data chunks parameter\n'    
 "(bytes instances) and optional `offset` and 'copy_offsets`\n"    
 'keywords parameters.\n'    
 '\n'    
 'Example::\n'    
 '\n'    
 '    @chunky\n'    
 '    def func(bfr, ...):\n'    
 '\n'    
 '## Class `CopyingIterator`\n'    
 '\n'    
 'Wrapper for an iterator that copies every item retrieved to a callable.\n'    
 '\n'    
 '### Method `CopyingIterator.__init__(self, I, copy_to)`\n'    
 '\n'    
 'Initialise with the iterator `I` and the callable `copy_to`.\n'    
 '\n'    
 '## Class `CornuCopyBuffer`\n'    
 '\n'    
 'An automatically refilling buffer intended to support parsing\n'    
 'of data streams.\n'    
 '\n'    
 'Its purpose is to aid binary parsers\n'    
 'which do not themselves need to handle sources specially;\n'    
 '`CornuCopyBuffer`s are trivially made from `bytes`,\n'    
 'iterables of `bytes` and file-like objects.\n'    
 'See `cs.binary` for convenient parsing classes\n'    
 'which work against `CornuCopyBuffer`s.\n'    
 '\n'    
 'Attributes:\n'    
 '* `buf`: the first of any buffered leading chunks\n'    
 '  buffer of unparsed data from the input, available\n'    
 '  for direct inspection by parsers;\n'    
 '  normally however parsers will use `.extend` and `.take`.\n'    
 '* `offset`: the logical offset of the buffer; this excludes\n'    
 '  buffered data and unconsumed input data\n'    
 '\n'    
 'The primary methods supporting parsing of data streams are\n'    
 '`.extend()` and `take()`.\n'    
 'Calling `.extend(min_size)` arranges that `.buf` contains at least\n'    
 '`min_size` bytes.\n'    
 'Calling `.take(size)` fetches exactly `size` bytes from `.buf` and the\n'    
 'input source if necessary and returns them, adjusting `.buf`.\n'    
 '\n'    
 'len(`CornuCopyBuffer`) returns the length of any buffered data.\n'    
 '\n'    
 'bool(`CornuCopyBuffer`) tests whether len() > 0.\n'    
 '\n'    
 'Indexing a `CornuCopyBuffer` accesses the buffered data only,\n'    
 "returning an individual byte's value (an `int`).\n"    
 '\n'    
 'A `CornuCopyBuffer` is also iterable, yielding data in whatever\n'    
 'sizes come from its `input_data` source, preceeded by the\n'    
 'current `.buf` if not empty.\n'    
 '\n'    
 'A `CornuCopyBuffer` also supports the file methods `.read`,\n'    
 '`.tell` and `.seek` supporting drop in use of the buffer in\n'    
 'many file contexts. Backward seeks are not supported. `.seek`\n'    
 "will take advantage of the `input_data`'s .seek method if it\n"    
 'has one, otherwise it will use reads.\n'    
 '\n'    
 '### Method `CornuCopyBuffer.__init__(self, input_data, buf=None, offset=0, '    
 'seekable=None, copy_offsets=None, copy_chunks=None)`\n'    
 '\n'    
 'Prepare the buffer.\n'    
 '\n'    
 'Parameters:\n'    
 '* `input_data`: an iterable of data chunks (bytes-like instances);\n'    
 '  if your data source is a file see the .from_file factory;\n'    
 '  if your data source is a file descriptor see the .from_fd\n'    
 '  factory.\n'    
 '* `buf`: if not `None`, the initial state of the parse buffer\n'    
 '* `offset`: logical offset of the start of the buffer, default 0\n'    
 '* `seekable`: whether `input_data` has a working `.seek` method;\n'    
 '  the default is None meaning that it will be attempted on\n'    
 '  the first skip or seek\n'    
 '* `copy_offsets`: if not `None`, a callable for parsers to\n'    
 "  report pertinent offsets via the buffer's .report_offset\n"    
 '  method\n'    
 '* `copy_chunks`: if not `None`, every fetched data chunk is\n'    
 '  copied to this callable\n'    
 '\n'    
 'The `input_data` is an iterable whose iterator may have\n'    
 'some optional additional properties:\n'    
 '* `seek`: if present, this is a seek method after the fashion\n'    
 "  of `file.seek`; the buffer's `seek`, `skip` and `skipto`\n"    
 '  methods will take advantage of this if available.\n'    
 '* `offset`: the current byte offset of the iterator; this\n'    
 '  is used during the buffer initialisation to compute\n'    
 '  `input_data_displacement`, the difference between the\n'    
 "  buffer's logical offset and the input data's logical offset;\n"    
 '  if unavailable during initialisation this is presumed to\n'    
 '  be `0`.\n'    
 '* `end_offset`: the end offset of the iterator if known.\n'    
 '\n'    
 '## Class `FDIterator(_Iterator)`\n'    
 '\n'    
 'An iterator over the data of a file descriptor.\n'    
 '\n'    
 '*Note*: the iterator works with an os.dup() of the file\n'    
 'descriptor so that it can close it with impunity; this requires\n'    
 'the caller to close their descriptor.\n'    
 '\n'    
 '### Method `FDIterator.__init__(self, fd, offset=None, readsize=None, '    
 'align=True)`\n'    
 '\n'    
 'Initialise the iterator.\n'    
 '\n'    
 'Parameters:\n'    
 '* `fd`: file descriptor\n'    
 '* `offset`: the initial logical offset, kept up to date by\n'    
 '  iteration; the default is the current file position.\n'    
 '* `readsize`: a preferred read size; if omitted then\n'    
 '  `DEFAULT_READSIZE` will be stored\n'    
 '* `align`: whether to align reads by default: if true then\n'    
 '  the iterator will do a short read to bring the `offset`\n'    
 '  into alignment with `readsize`; the default is `True`\n'    
 '\n'    
 '## Class `FileIterator(_Iterator,SeekableIteratorMixin)`\n'    
 '\n'    
 'An iterator over the data of a file object.\n'    
 '\n'    
 '*Note*: the iterator closes the file on `__del__` or if its\n'    
 '`.close` method is called.\n'    
 '\n'    
 '### Method `FileIterator.__init__(self, fp, offset=None, readsize=None, '    
 'align=False)`\n'    
 '\n'    
 'Initialise the iterator.\n'    
 '\n'    
 'Parameters:\n'    
 '* `fp`: file object\n'    
 '* `offset`: the initial logical offset, kept up to date by\n'    
 '  iteration; the default is 0.\n'    
 '* `readsize`: a preferred read size; if omitted then\n'    
 '  `DEFAULT_READSIZE` will be stored\n'    
 '* `align`: whether to align reads by default: if true then\n'    
 '  the iterator will do a short read to bring the `offset`\n'    
 '  into alignment with `readsize`; the default is `False`\n'    
 '\n'    
 '## Class `SeekableFDIterator(FDIterator,_Iterator,SeekableIteratorMixin)`\n'    
 '\n'    
 'An iterator over the data of a seekable file descriptor.\n'    
 '\n'    
 '*Note*: the iterator works with an `os.dup()` of the file\n'    
 'descriptor so that it can close it with impunity; this requires\n'    
 'the caller to close their descriptor.\n'    
 '\n'    
 '## Class '    
 '`SeekableFileIterator(FileIterator,_Iterator,SeekableIteratorMixin)`\n'    
 '\n'    
 'An iterator over the data of a seekable file object.\n'    
 '\n'    
 '*Note*: the iterator closes the file on __del__ or if its\n'    
 '.close method is called.\n'    
 '\n'    
 '### Method `SeekableFileIterator.__init__(self, fp, offset=None, **kw)`\n'    
 '\n'    
 'Initialise the iterator.\n'    
 '\n'    
 'Parameters:\n'    
 '* `fp`: file object\n'    
 '* `offset`: the initial logical offset, kept up to date by\n'    
 '  iteration; the default is the current file position.\n'    
 '* `readsize`: a preferred read size; if omitted then\n'    
 '  `DEFAULT_READSIZE` will be stored\n'    
 '* `align`: whether to align reads by default: if true then\n'    
 '  the iterator will do a short read to bring the `offset`\n'    
 '  into alignment with `readsize`; the default is `False`\n'    
 '\n'    
 '## Class `SeekableIteratorMixin`\n'    
 '\n'    
 'Mixin supplying a logical with a `seek` method.\n'    
 '\n'    
 '## Class `SeekableMMapIterator(_Iterator,SeekableIteratorMixin)`\n'    
 '\n'    
 'An iterator over the data of a mappable file descriptor.\n'    
 '\n'    
 '*Note*: the iterator works with an `mmap` of an `os.dup()` of the\n'    
 'file descriptor so that it can close it with impunity; this\n'    
 'requires the caller to close their descriptor.\n'    
 '\n'    
 '### Method `SeekableMMapIterator.__init__(self, fd, offset=None, '    
 'readsize=None, align=True)`\n'    
 '\n'    
 'Initialise the iterator.\n'    
 '\n'    
 'Parameters:\n'    
 '* `offset`: the initial logical offset, kept up to date by\n'    
 '  iteration; the default is the current file position.\n'    
 '* `readsize`: a preferred read size; if omitted then\n'    
 '  `DEFAULT_READSIZE` will be stored\n'    
 '* `align`: whether to align reads by default: if true then\n'    
 '  the iterator will do a short read to bring the `offset`\n'    
 '  into alignment with `readsize`; the default is `True`\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20200517*:\n'    
 '* CornuCopyBuffer.skip: bugfix sanity check.\n'    
 '* FileIterator: do not close the supplied file, just set self.fp=None.\n'    
 '* Improve EOFError message text.\n'    
 '\n'    
 '*Release 20200328*:\n'    
 '* CornuCopyBuffer.takev: bugfix adjustment of buf.offset, was not always '    
 'done.\n'    
 '* CornuCopyBuffer.__getitem__: add slice support, note how expensive it is '    
 'to use.\n'    
 '\n'    
 '*Release 20200229*:\n'    
 '* New CornuCopyBuffer.byte0() method consuming the next byte and returning '    
 'it as an int.\n'    
 '* CornuCopyBuffer.takev: bugfix for size=0, logic refactor.\n'    
 '* CornuCopyBuffer: new .selfcheck method.\n'    
 '\n'    
 '*Release 20200130*:\n'    
 'CornuCopyBuffer.skip: bugfix adjustment of skipto for already buffered '    
 'data.\n'    
 '\n'    
 '*Release 20191230.1*:\n'    
 'Docstring updates. Semantic changes were in the previous release.\n'    
 '\n'    
 '*Release 20191230*:\n'    
 '* CornuCopyBuffer: accept a size of Ellipsis in .take and .extend methods, '    
 'indicating "all the remaining data".\n'    
 '* CornuCopyBuffer: refactor the buffering, replacing .buf with .bufs as an '    
 'array of chunks;\n'    
 '* this enables support for the new .push method and reduces memory copying.\n'    
 '\n'    
 '*Release 20181231*:\n'    
 'Small bugfix.\n'    
 '\n'    
 '*Release 20181108*:\n'    
 'New at_eof() method. Python 2 tweak to support incidental import by python 2 '    
 'even if unused.\n'    
 '\n'    
 '*Release 20180823*:\n'    
 'Better handling of seekable and unseekable input data. Tiny bugfix for '    
 'from_bytes sanity check.\n'    
 '\n'    
 '*Release 20180810*:\n'    
 '* Refactor SeekableFDIterator and SeekableFileIterator to subclass new '    
 'SeekableIterator.\n'    
 '* New SeekableMMapIterator to process a memory mapped file descriptor, '    
 'intended for large files.\n'    
 '* New CornuCopyBuffer.hint method to pass a length hint through to the '    
 'input_data iterator\n'    
 '* if it has a `hint` method, causing it possibly to make a differently sized '    
 'fetch.\n'    
 '* SeekableIterator: new __del__ method calling self.close() - subclasses '    
 'must provide\n'    
 '* a .close, which should be safe to call multiple times.\n'    
 '* CornuCopyBuffer: add support for .offset and .end_offset optional '    
 'attributes on the input_data iterator.\n'    
 '* _BoundedBufferIterator: add .offset property plumbed to the underlying '    
 'buffer offset.\n'    
 '* New CornuCopyBuffer.from_mmap to make a mmap backed buffer so that large '    
 'data can be returned without penalty.\n'    
 '* Assorted fixes and doc improvements.\n'    
 '\n'    
 '*Release 20180805*:\n'    
 'Bugfixes for at_eof method and end_offset initialisation.\n'    
 '\n'    
 '*Release 20180726.1*:\n'    
 'Improve docstrings and release with better long_description.\n'    
 '\n'    
 '*Release 20180726*:\n'    
 'First PyPI release: CornuCopyBuffer and friends.'),
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 3', 'Development Status :: 5 - Production/Stable', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  install_requires = ['cs.py3'],
  keywords = ['python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.buffer'],
)
