# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file 'LJ2D/LJ2D.ui'
#
# Created by: PyQt5 UI code generator 5.15.4
#
# WARNING: Any manual changes made to this file will be lost when pyuic5 is
# run again.  Do not edit this file unless you know what you are doing.


from PyQt5 import QtCore, QtGui, QtWidgets


class Ui_mainWindow(object):
    def setupUi(self, mainWindow):
        mainWindow.setObjectName("mainWindow")
        mainWindow.resize(806, 601)
        icon = QtGui.QIcon()
        icon.addPixmap(QtGui.QPixmap(":/welcome/icon/welcome/assets/icon.png"), QtGui.QIcon.Normal, QtGui.QIcon.Off)
        mainWindow.setWindowIcon(icon)
        self.centralwidget = QtWidgets.QWidget(mainWindow)
        self.centralwidget.setObjectName("centralwidget")
        self.verticalLayout = QtWidgets.QVBoxLayout(self.centralwidget)
        self.verticalLayout.setObjectName("verticalLayout")
        self.simulation_field = QtWidgets.QTabWidget(self.centralwidget)
        self.simulation_field.setEnabled(True)
        self.simulation_field.setTabShape(QtWidgets.QTabWidget.Rounded)
        self.simulation_field.setObjectName("simulation_field")
        self.initialization = QtWidgets.QWidget()
        self.initialization.setObjectName("initialization")
        self.horizontalLayout_2 = QtWidgets.QHBoxLayout(self.initialization)
        self.horizontalLayout_2.setObjectName("horizontalLayout_2")
        self.widget = QtWidgets.QWidget(self.initialization)
        self.widget.setObjectName("widget")
        self.gridLayout = QtWidgets.QGridLayout(self.widget)
        self.gridLayout.setObjectName("gridLayout")
        self.tabWidget = QtWidgets.QTabWidget(self.widget)
        self.tabWidget.setObjectName("tabWidget")
        self.tab_3 = QtWidgets.QWidget()
        self.tab_3.setObjectName("tab_3")
        self.gridLayout_12 = QtWidgets.QGridLayout(self.tab_3)
        self.gridLayout_12.setObjectName("gridLayout_12")
        self.espresso_image = QtWidgets.QLabel(self.tab_3)
        self.espresso_image.setText("")
        self.espresso_image.setPixmap(QtGui.QPixmap(":/LJ2D/logo/LJ2D/2D_design.png"))
        self.espresso_image.setObjectName("espresso_image")
        self.gridLayout_12.addWidget(self.espresso_image, 0, 1, 1, 2)
        self.run_button = QtWidgets.QPushButton(self.tab_3)
        self.run_button.setObjectName("run_button")
        self.gridLayout_12.addWidget(self.run_button, 2, 1, 1, 2)
        self.pause_button = QtWidgets.QPushButton(self.tab_3)
        self.pause_button.setObjectName("pause_button")
        self.gridLayout_12.addWidget(self.pause_button, 3, 1, 1, 2)
        spacerItem = QtWidgets.QSpacerItem(20, 80, QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Expanding)
        self.gridLayout_12.addItem(spacerItem, 1, 1, 1, 1)
        self.groupBox_2 = QtWidgets.QGroupBox(self.tab_3)
        self.groupBox_2.setObjectName("groupBox_2")
        self.gridLayout_7 = QtWidgets.QGridLayout(self.groupBox_2)
        self.gridLayout_7.setObjectName("gridLayout_7")
        self.label = QtWidgets.QLabel(self.groupBox_2)
        self.label.setObjectName("label")
        self.gridLayout_7.addWidget(self.label, 0, 0, 1, 1)
        self.particles_system_name = QtWidgets.QLineEdit(self.groupBox_2)
        self.particles_system_name.setObjectName("particles_system_name")
        self.gridLayout_7.addWidget(self.particles_system_name, 0, 1, 1, 2)
        spacerItem1 = QtWidgets.QSpacerItem(40, 20, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
        self.gridLayout_7.addItem(spacerItem1, 0, 3, 1, 1)
        self.label_2 = QtWidgets.QLabel(self.groupBox_2)
        self.label_2.setObjectName("label_2")
        self.gridLayout_7.addWidget(self.label_2, 1, 0, 1, 1)
        self.particles_np = QtWidgets.QSpinBox(self.groupBox_2)
        self.particles_np.setKeyboardTracking(False)
        self.particles_np.setMinimum(1)
        self.particles_np.setMaximum(500)
        self.particles_np.setProperty("value", 20)
        self.particles_np.setObjectName("particles_np")
        self.gridLayout_7.addWidget(self.particles_np, 1, 1, 1, 1)
        spacerItem2 = QtWidgets.QSpacerItem(40, 20, QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
        self.gridLayout_7.addItem(spacerItem2, 1, 3, 1, 1)
        self.frame_5 = QtWidgets.QFrame(self.groupBox_2)
        self.frame_5.setObjectName("frame_5")
        self.gridLayout_6 = QtWidgets.QGridLayout(self.frame_5)
        self.gridLayout_6.setObjectName("gridLayout_6")
        self.label_21 = QtWidgets.QLabel(self.frame_5)
        self.label_21.setObjectName("label_21")
        self.gridLayout_6.addWidget(self.label_21, 0, 0, 1, 1)
        self.label_22 = QtWidgets.QLabel(self.frame_5)
        self.label_22.setObjectName("label_22")
        self.gridLayout_6.addWidget(self.label_22, 0, 1, 1, 1)
        self.particles_density = QtWidgets.QDoubleSpinBox(self.frame_5)
        self.particles_density.setMaximumSize(QtCore.QSize(87, 26))
        self.particles_density.setKeyboardTracking(False)
        self.particles_density.setPrefix("")
        self.particles_density.setSuffix("")
        self.particles_density.setMinimum(0.01)
        self.particles_density.setMaximum(100.0)
        self.particles_density.setSingleStep(0.01)
        self.particles_density.setProperty("value", 0.8)
        self.particles_density.setObjectName("particles_density")
        self.gridLayout_6.addWidget(self.particles_density, 0, 2, 1, 1)
        self.label_3 = QtWidgets.QLabel(self.frame_5)
        self.label_3.setWordWrap(True)
        self.label_3.setObjectName("label_3")
        self.gridLayout_6.addWidget(self.label_3, 0, 3, 1, 1)
        self.red_density = QtWidgets.QDoubleSpinBox(self.frame_5)
        self.red_density.setKeyboardTracking(False)
        self.red_density.setPrefix("")
        self.red_density.setSuffix("")
        self.red_density.setDecimals(3)
        self.red_density.setMaximum(1.0)
        self.red_density.setSingleStep(0.001)
        self.red_density.setProperty("value", 0.105)
        self.red_density.setObjectName("red_density")
        self.gridLayout_6.addWidget(self.red_density, 0, 4, 1, 1)
        self.label_12 = QtWidgets.QLabel(self.frame_5)
        self.label_12.setLayoutDirection(QtCore.Qt.LeftToRight)
        self.label_12.setFrameShadow(QtWidgets.QFrame.Plain)
        self.label_12.setLineWidth(-3)
        self.label_12.setWordWrap(True)
        self.label_12.setObjectName("label_12")
        self.gridLayout_6.addWidget(self.label_12, 1, 0, 1, 5)
        self.label_16 = QtWidgets.QLabel(self.frame_5)
        self.label_16.setLayoutDirection(QtCore.Qt.LeftToRight)
        self.label_16.setFrameShadow(QtWidgets.QFrame.Plain)
        self.label_16.setLineWidth(-3)
        self.label_16.setWordWrap(True)
        self.label_16.setObjectName("label_16")
        self.gridLayout_6.addWidget(self.label_16, 2, 0, 1, 5)
        spacerItem3 = QtWidgets.QSpacerItem(20, 40, QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Expanding)
        self.gridLayout_6.addItem(spacerItem3, 3, 0, 1, 1)
        spacerItem4 = QtWidgets.QSpacerItem(20, 40, QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Expanding)
        self.gridLayout_6.addItem(spacerItem4, 3, 4, 1, 1)
        self.label_4 = QtWidgets.QLabel(self.frame_5)
        self.label_4.setObjectName("label_4")
        self.gridLayout_6.addWidget(self.label_4, 4, 0, 1, 2)
        self.box_length_auto = QtWidgets.QLineEdit(self.frame_5)
        self.box_length_auto.setEnabled(False)
        self.box_length_auto.setDragEnabled(True)
        self.box_length_auto.setReadOnly(True)
        self.box_length_auto.setClearButtonEnabled(False)
        self.box_length_auto.setObjectName("box_length_auto")
        self.gridLayout_6.addWidget(self.box_length_auto, 4, 2, 1, 2)
        self.pushButton = QtWidgets.QPushButton(self.frame_5)
        self.pushButton.setObjectName("pushButton")
        self.gridLayout_6.addWidget(self.pushButton, 4, 4, 1, 1)
        self.gridLayout_7.addWidget(self.frame_5, 2, 0, 1, 5)
        self.check_savingdata = QtWidgets.QCheckBox(self.groupBox_2)
        self.check_savingdata.setChecked(False)
        self.check_savingdata.setObjectName("check_savingdata")
        self.gridLayout_7.addWidget(self.check_savingdata, 3, 0, 1, 1)
        self.groupBox_4 = QtWidgets.QGroupBox(self.groupBox_2)
        self.groupBox_4.setObjectName("groupBox_4")
        self.gridLayout_9 = QtWidgets.QGridLayout(self.groupBox_4)
        self.gridLayout_9.setObjectName("gridLayout_9")
        self.periodic_y_check = QtWidgets.QCheckBox(self.groupBox_4)
        self.periodic_y_check.setObjectName("periodic_y_check")
        self.gridLayout_9.addWidget(self.periodic_y_check, 1, 1, 1, 1)
        self.periodic_x_check = QtWidgets.QCheckBox(self.groupBox_4)
        self.periodic_x_check.setObjectName("periodic_x_check")
        self.gridLayout_9.addWidget(self.periodic_x_check, 0, 1, 1, 1)
        self.periodic_z_check = QtWidgets.QCheckBox(self.groupBox_4)
        self.periodic_z_check.setObjectName("periodic_z_check")
        self.gridLayout_9.addWidget(self.periodic_z_check, 2, 1, 1, 1)
        self.gridLayout_7.addWidget(self.groupBox_4, 4, 2, 1, 3)
        spacerItem5 = QtWidgets.QSpacerItem(20, 40, QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Expanding)
        self.gridLayout_7.addItem(spacerItem5, 5, 0, 1, 1)
        spacerItem6 = QtWidgets.QSpacerItem(20, 40, QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Expanding)
        self.gridLayout_7.addItem(spacerItem6, 5, 4, 1, 1)
        self.groupbox_saveparameters = QtWidgets.QFrame(self.groupBox_2)
        self.groupbox_saveparameters.setEnabled(False)
        sizePolicy = QtWidgets.QSizePolicy(QtWidgets.QSizePolicy.MinimumExpanding, QtWidgets.QSizePolicy.MinimumExpanding)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.groupbox_saveparameters.sizePolicy().hasHeightForWidth())
        self.groupbox_saveparameters.setSizePolicy(sizePolicy)
        self.groupbox_saveparameters.setObjectName("groupbox_saveparameters")
        self.gridLayout_11 = QtWidgets.QGridLayout(self.groupbox_saveparameters)
        self.gridLayout_11.setObjectName("gridLayout_11")
        self.label_6 = QtWidgets.QLabel(self.groupbox_saveparameters)
        self.label_6.setObjectName("label_6")
        self.gridLayout_11.addWidget(self.label_6, 0, 0, 1, 1)
        self.select_directory = QtWidgets.QPushButton(self.groupbox_saveparameters)
        self.select_directory.setObjectName("select_directory")
        self.gridLayout_11.addWidget(self.select_directory, 0, 1, 1, 1)
        self.input_directory = QtWidgets.QLineEdit(self.groupbox_saveparameters)
        self.input_directory.setObjectName("input_directory")
        self.gridLayout_11.addWidget(self.input_directory, 1, 0, 1, 2)
        self.save_xyz = QtWidgets.QCheckBox(self.groupbox_saveparameters)
        self.save_xyz.setChecked(True)
        self.save_xyz.setObjectName("save_xyz")
        self.gridLayout_11.addWidget(self.save_xyz, 2, 0, 1, 2)
        self.save_energies = QtWidgets.QCheckBox(self.groupbox_saveparameters)
        self.save_energies.setChecked(True)
        self.save_energies.setObjectName("save_energies")
        self.gridLayout_11.addWidget(self.save_energies, 3, 0, 1, 2)
        self.save_pressure = QtWidgets.QCheckBox(self.groupbox_saveparameters)
        self.save_pressure.setChecked(True)
        self.save_pressure.setObjectName("save_pressure")
        self.gridLayout_11.addWidget(self.save_pressure, 4, 0, 1, 2)
        self.gridLayout_7.addWidget(self.groupbox_saveparameters, 4, 0, 1, 2)
        self.gridLayout_12.addWidget(self.groupBox_2, 0, 0, 4, 1)
        self.tabWidget.addTab(self.tab_3, "")
        self.gridLayout.addWidget(self.tabWidget, 0, 0, 1, 1)
        self.horizontalLayout_2.addWidget(self.widget)
        self.simulation_field.addTab(self.initialization, "")
        self.tab_2 = QtWidgets.QWidget()
        self.tab_2.setObjectName("tab_2")
        self.gridLayout_2 = QtWidgets.QGridLayout(self.tab_2)
        self.gridLayout_2.setObjectName("gridLayout_2")
        self.groupBox = QtWidgets.QGroupBox(self.tab_2)
        self.groupBox.setObjectName("groupBox")
        self.gridLayout_4 = QtWidgets.QGridLayout(self.groupBox)
        self.gridLayout_4.setObjectName("gridLayout_4")
        self.temperature_slide = QtWidgets.QSlider(self.groupBox)
        self.temperature_slide.setMinimum(1)
        self.temperature_slide.setMaximum(500)
        self.temperature_slide.setProperty("value", 273)
        self.temperature_slide.setOrientation(QtCore.Qt.Horizontal)
        self.temperature_slide.setObjectName("temperature_slide")
        self.gridLayout_4.addWidget(self.temperature_slide, 1, 2, 1, 1)
        self.temp_red_unit = QtWidgets.QDoubleSpinBox(self.groupBox)
        self.temp_red_unit.setEnabled(False)
        self.temp_red_unit.setDecimals(3)
        self.temp_red_unit.setProperty("value", 2.441)
        self.temp_red_unit.setObjectName("temp_red_unit")
        self.gridLayout_4.addWidget(self.temp_red_unit, 1, 4, 1, 1)
        self.label_5 = QtWidgets.QLabel(self.groupBox)
        self.label_5.setObjectName("label_5")
        self.gridLayout_4.addWidget(self.label_5, 1, 0, 1, 1)
        self.gravity_value = QtWidgets.QDoubleSpinBox(self.groupBox)
        self.gravity_value.setMaximum(5.0)
        self.gravity_value.setSingleStep(0.05)
        self.gravity_value.setObjectName("gravity_value")
        self.gravity_value.setVisible(False)
        self.gridLayout_4.addWidget(self.gravity_value, 4, 3, 1, 1)
        self.grav_red_unit = QtWidgets.QDoubleSpinBox(self.groupBox)
        self.grav_red_unit.setEnabled(False)
        self.grav_red_unit.setObjectName("grav_red_unit")
        self.gridLayout_4.addWidget(self.grav_red_unit, 4, 4, 1, 1)
        self.label_red_grav = QtWidgets.QLabel(self.groupBox)
        self.label_red_grav.setObjectName("label_red_grav")
        self.gridLayout_4.addWidget(self.label_red_grav, 3, 4, 1, 1)
        self.gravity_slide = QtWidgets.QSlider(self.groupBox)
        self.gravity_slide.setMaximum(500)
        self.gravity_slide.setOrientation(QtCore.Qt.Horizontal)
        self.gravity_slide.setObjectName("gravity_slide")
        self.gravity_slide.setVisible(False)
        self.gridLayout_4.addWidget(self.gravity_slide, 4, 2, 1, 1)
        self.temperature_change = QtWidgets.QSpinBox(self.groupBox)
        self.temperature_change.setMaximum(500)
        self.temperature_change.setProperty("value", 273)
        self.temperature_change.setObjectName("temperature_change")
        self.gridLayout_4.addWidget(self.temperature_change, 1, 3, 1, 1)
        self.label_9 = QtWidgets.QLabel(self.groupBox)
        self.label_9.setWordWrap(True)
        self.label_9.setObjectName("label_9")
        self.gridLayout_4.addWidget(self.label_9, 4, 0, 1, 1)
        self.label_10 = QtWidgets.QLabel(self.groupBox)
        self.label_10.setText("")
        self.label_10.setObjectName("label_10")
        self.gridLayout_4.addWidget(self.label_10, 5, 0, 1, 1)
        self.gravity_check = QtWidgets.QCheckBox(self.groupBox)
        self.gravity_check.setText("")
        self.gravity_check.setObjectName("gravity_check")
        self.gridLayout_4.addWidget(self.gravity_check, 4, 1, 1, 1)
        self.label_19 = QtWidgets.QLabel(self.groupBox)
        self.label_19.setObjectName("label_19")
        self.gridLayout_4.addWidget(self.label_19, 0, 4, 1, 1)
        spacerItem7 = QtWidgets.QSpacerItem(20, 40, QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Expanding)
        self.gridLayout_4.addItem(spacerItem7, 2, 4, 1, 1)
        self.gridLayout_2.addWidget(self.groupBox, 0, 0, 1, 1)
        self.apply_changes = QtWidgets.QPushButton(self.tab_2)
        self.apply_changes.setObjectName("apply_changes")
        self.gridLayout_2.addWidget(self.apply_changes, 1, 1, 1, 1)
        self.LJparams_2 = QtWidgets.QGroupBox(self.tab_2)
        self.LJparams_2.setMinimumSize(QtCore.QSize(280, 119))
        self.LJparams_2.setObjectName("LJparams_2")
        self.gridLayout_10 = QtWidgets.QGridLayout(self.LJparams_2)
        self.gridLayout_10.setObjectName("gridLayout_10")
        self.slider_timestep = QtWidgets.QSlider(self.LJparams_2)
        self.slider_timestep.setMinimum(1)
        self.slider_timestep.setMaximum(100)
        self.slider_timestep.setProperty("value", 10)
        self.slider_timestep.setOrientation(QtCore.Qt.Horizontal)
        self.slider_timestep.setObjectName("slider_timestep")
        self.gridLayout_10.addWidget(self.slider_timestep, 1, 0, 1, 1)
        self.thermostat_check = QtWidgets.QCheckBox(self.LJparams_2)
        self.thermostat_check.setMinimumSize(QtCore.QSize(57, 15))
        self.thermostat_check.setText("")
        self.thermostat_check.setChecked(True)
        self.thermostat_check.setObjectName("thermostat_check")
        self.gridLayout_10.addWidget(self.thermostat_check, 2, 1, 1, 1)
        self.label_18 = QtWidgets.QLabel(self.LJparams_2)
        sizePolicy = QtWidgets.QSizePolicy(QtWidgets.QSizePolicy.Preferred, QtWidgets.QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_18.sizePolicy().hasHeightForWidth())
        self.label_18.setSizePolicy(sizePolicy)
        self.label_18.setLayoutDirection(QtCore.Qt.LeftToRight)
        self.label_18.setInputMethodHints(QtCore.Qt.ImhNone)
        self.label_18.setFrameShadow(QtWidgets.QFrame.Plain)
        self.label_18.setAlignment(QtCore.Qt.AlignCenter)
        self.label_18.setWordWrap(False)
        self.label_18.setObjectName("label_18")
        self.gridLayout_10.addWidget(self.label_18, 2, 0, 1, 1)
        self.label_8 = QtWidgets.QLabel(self.LJparams_2)
        self.label_8.setTextInteractionFlags(QtCore.Qt.LinksAccessibleByMouse)
        self.label_8.setObjectName("label_8")
        self.gridLayout_10.addWidget(self.label_8, 0, 0, 1, 1)
        self.espresso_time_step = QtWidgets.QSpinBox(self.LJparams_2)
        self.espresso_time_step.setMinimum(1)
        self.espresso_time_step.setMaximum(100)
        self.espresso_time_step.setProperty("value", 10)
        self.espresso_time_step.setObjectName("espresso_time_step")
        self.gridLayout_10.addWidget(self.espresso_time_step, 0, 1, 1, 1)
        spacerItem8 = QtWidgets.QSpacerItem(20, 40, QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Expanding)
        self.gridLayout_10.addItem(spacerItem8, 3, 0, 1, 1)
        self.gridLayout_2.addWidget(self.LJparams_2, 0, 1, 1, 1)
        self.groupBox_3 = QtWidgets.QGroupBox(self.tab_2)
        self.groupBox_3.setObjectName("groupBox_3")
        self.gridLayout_3 = QtWidgets.QGridLayout(self.groupBox_3)
        self.gridLayout_3.setObjectName("gridLayout_3")
        self.label_13 = QtWidgets.QLabel(self.groupBox_3)
        self.label_13.setObjectName("label_13")
        self.gridLayout_3.addWidget(self.label_13, 0, 0, 1, 1)
        self.scrollArea = QtWidgets.QScrollArea(self.groupBox_3)
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setObjectName("scrollArea")
        self.scrollAreaWidgetContents = QtWidgets.QWidget()
        self.scrollAreaWidgetContents.setGeometry(QtCore.QRect(0, 0, 238, 128))
        self.scrollAreaWidgetContents.setObjectName("scrollAreaWidgetContents")
        self.gridLayout_5 = QtWidgets.QGridLayout(self.scrollAreaWidgetContents)
        self.gridLayout_5.setObjectName("gridLayout_5")
        self.radiobutton_argon = QtWidgets.QRadioButton(self.scrollAreaWidgetContents)
        self.radiobutton_argon.setChecked(True)
        self.radiobutton_argon.setObjectName("radiobutton_argon")
        self.gridLayout_5.addWidget(self.radiobutton_argon, 0, 0, 1, 1)
        self.radiobutton_oxygen = QtWidgets.QRadioButton(self.scrollAreaWidgetContents)
        self.radiobutton_oxygen.setObjectName("radiobutton_oxygen")
        self.gridLayout_5.addWidget(self.radiobutton_oxygen, 0, 1, 1, 1)
        self.radiobutton_chloride = QtWidgets.QRadioButton(self.scrollAreaWidgetContents)
        self.radiobutton_chloride.setObjectName("radiobutton_chloride")
        self.gridLayout_5.addWidget(self.radiobutton_chloride, 1, 0, 1, 1)
        self.radiobutton_nitrogen = QtWidgets.QRadioButton(self.scrollAreaWidgetContents)
        self.radiobutton_nitrogen.setObjectName("radiobutton_nitrogen")
        self.gridLayout_5.addWidget(self.radiobutton_nitrogen, 1, 1, 1, 1)
        self.radiobutton_carbondioxide = QtWidgets.QRadioButton(self.scrollAreaWidgetContents)
        self.radiobutton_carbondioxide.setObjectName("radiobutton_carbondioxide")
        self.gridLayout_5.addWidget(self.radiobutton_carbondioxide, 2, 0, 1, 1)
        self.radiobutton_xenon = QtWidgets.QRadioButton(self.scrollAreaWidgetContents)
        self.radiobutton_xenon.setObjectName("radiobutton_xenon")
        self.gridLayout_5.addWidget(self.radiobutton_xenon, 2, 1, 1, 1)
        self.radiobutton_krypton = QtWidgets.QRadioButton(self.scrollAreaWidgetContents)
        self.radiobutton_krypton.setObjectName("radiobutton_krypton")
        self.gridLayout_5.addWidget(self.radiobutton_krypton, 3, 0, 1, 1)
        self.radiobutton_other = QtWidgets.QRadioButton(self.scrollAreaWidgetContents)
        self.radiobutton_other.setObjectName("radiobutton_other")
        self.gridLayout_5.addWidget(self.radiobutton_other, 3, 1, 1, 1)
        self.scrollArea.setWidget(self.scrollAreaWidgetContents)
        self.gridLayout_3.addWidget(self.scrollArea, 1, 0, 1, 1)
        self.label_14 = QtWidgets.QLabel(self.groupBox_3)
        self.label_14.setObjectName("label_14")
        self.gridLayout_3.addWidget(self.label_14, 0, 1, 1, 1)
        self.scrollArea_2 = QtWidgets.QScrollArea(self.groupBox_3)
        self.scrollArea_2.setWidgetResizable(True)
        self.scrollArea_2.setObjectName("scrollArea_2")
        self.scrollAreaWidgetContents_2 = QtWidgets.QWidget()
        self.scrollAreaWidgetContents_2.setGeometry(QtCore.QRect(0, 0, 182, 130))
        self.scrollAreaWidgetContents_2.setObjectName("scrollAreaWidgetContents_2")
        self.gridLayout_8 = QtWidgets.QGridLayout(self.scrollAreaWidgetContents_2)
        self.gridLayout_8.setObjectName("gridLayout_8")
        spacerItem9 = QtWidgets.QSpacerItem(20, 40, QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Expanding)
        self.gridLayout_8.addItem(spacerItem9, 0, 1, 1, 1)
        spacerItem10 = QtWidgets.QSpacerItem(20, 40, QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Expanding)
        self.gridLayout_8.addItem(spacerItem10, 5, 1, 1, 1)
        self.epsilon_slider = QtWidgets.QSlider(self.scrollAreaWidgetContents_2)
        self.epsilon_slider.setEnabled(False)
        self.epsilon_slider.setMinimum(100)
        self.epsilon_slider.setMaximum(800)
        self.epsilon_slider.setSingleStep(1)
        self.epsilon_slider.setPageStep(1)
        self.epsilon_slider.setProperty("value", 112)
        self.epsilon_slider.setSliderPosition(112)
        self.epsilon_slider.setTracking(False)
        self.epsilon_slider.setOrientation(QtCore.Qt.Horizontal)
        self.epsilon_slider.setObjectName("epsilon_slider")
        self.gridLayout_8.addWidget(self.epsilon_slider, 2, 1, 1, 1, QtCore.Qt.AlignVCenter)
        self.sigma_slider = QtWidgets.QSlider(self.scrollAreaWidgetContents_2)
        self.sigma_slider.setEnabled(False)
        self.sigma_slider.setMinimum(10)
        self.sigma_slider.setMaximum(80)
        self.sigma_slider.setSingleStep(1)
        self.sigma_slider.setPageStep(1)
        self.sigma_slider.setProperty("value", 36)
        self.sigma_slider.setSliderPosition(36)
        self.sigma_slider.setOrientation(QtCore.Qt.Horizontal)
        self.sigma_slider.setObjectName("sigma_slider")
        self.gridLayout_8.addWidget(self.sigma_slider, 8, 1, 1, 1)
        self.label_15 = QtWidgets.QLabel(self.scrollAreaWidgetContents_2)
        self.label_15.setObjectName("label_15")
        self.gridLayout_8.addWidget(self.label_15, 1, 0, 1, 1)
        self.label_17 = QtWidgets.QLabel(self.scrollAreaWidgetContents_2)
        self.label_17.setObjectName("label_17")
        self.gridLayout_8.addWidget(self.label_17, 6, 0, 1, 1)
        self.value_epsilon = QtWidgets.QDoubleSpinBox(self.scrollAreaWidgetContents_2)
        self.value_epsilon.setEnabled(False)
        self.value_epsilon.setKeyboardTracking(False)
        self.value_epsilon.setMaximum(800.0)
        self.value_epsilon.setSingleStep(10.0)
        self.value_epsilon.setProperty("value", 111.84)
        self.value_epsilon.setObjectName("value_epsilon")
        self.gridLayout_8.addWidget(self.value_epsilon, 1, 1, 1, 1)
        self.value_sigma = QtWidgets.QDoubleSpinBox(self.scrollAreaWidgetContents_2)
        self.value_sigma.setEnabled(False)
        self.value_sigma.setKeyboardTracking(False)
        self.value_sigma.setDecimals(4)
        self.value_sigma.setMaximum(0.46)
        self.value_sigma.setSingleStep(0.1)
        self.value_sigma.setProperty("value", 0.3632)
        self.value_sigma.setObjectName("value_sigma")
        self.gridLayout_8.addWidget(self.value_sigma, 6, 1, 1, 1)
        self.scrollArea_2.setWidget(self.scrollAreaWidgetContents_2)
        self.gridLayout_3.addWidget(self.scrollArea_2, 1, 1, 1, 1)
        self.gridLayout_2.addWidget(self.groupBox_3, 1, 0, 1, 1)
        self.simulation_field.addTab(self.tab_2, "")
        self.life_plots = QtWidgets.QWidget()
        self.life_plots.setObjectName("life_plots")
        self.simulation_field.addTab(self.life_plots, "")
        self.verticalLayout.addWidget(self.simulation_field)
        mainWindow.setCentralWidget(self.centralwidget)
        self.label.setBuddy(self.particles_system_name)
        self.label_2.setBuddy(self.particles_np)
        self.label_4.setBuddy(self.box_length_auto)
        self.label_5.setBuddy(self.temperature_slide)

        self.retranslateUi(mainWindow)
        self.simulation_field.setCurrentIndex(0)
        self.tabWidget.setCurrentIndex(0)
        self.temperature_slide.valueChanged['int'].connect(self.temperature_change.setValue)
        self.temperature_change.valueChanged['int'].connect(self.temperature_slide.setValue)
        self.slider_timestep.valueChanged['int'].connect(self.espresso_time_step.setValue)
        self.espresso_time_step.valueChanged['int'].connect(self.slider_timestep.setValue)
        QtCore.QMetaObject.connectSlotsByName(mainWindow)
        self.check_savingdata.stateChanged.connect(self.enable_savingparameters)
        self.particles_np.valueChanged.connect(self.contribute_boxlength)
        self.particles_density.valueChanged.connect(self.contribute_boxlength)
        self.particles_density.valueChanged.connect(self.connect_red_density)
        self.red_density.valueChanged.connect(self.connect_density)
        self.gravity_check.stateChanged['int'].connect(self.enable_gravityslider)
        self.radiobutton_argon.toggled.connect(self.lennard_jones_params)
        self.radiobutton_carbondioxide.toggled.connect(self.lennard_jones_params)
        self.radiobutton_chloride.toggled.connect(self.lennard_jones_params)
        self.radiobutton_oxygen.toggled.connect(self.lennard_jones_params)
        self.radiobutton_nitrogen.toggled.connect(self.lennard_jones_params)
        self.radiobutton_krypton.toggled.connect(self.lennard_jones_params)
        self.radiobutton_xenon.toggled.connect(self.lennard_jones_params)
        self.radiobutton_other.toggled.connect(self.lennard_jones_params)
        self.thermostat_check.stateChanged.connect(self.thermostat_change)
        self.value_sigma.valueChanged.connect(self.lj_slider_connection_sig)
        self.value_sigma.valueChanged.connect(self.connect_red_density)
        self.value_epsilon.valueChanged.connect(self.lj_slider_connection_eps)
        self.value_epsilon.valueChanged.connect(self.reduce_temperature)
        self.epsilon_slider.valueChanged.connect(self.lj_value_connection_eps)
        self.sigma_slider.valueChanged.connect(self.lj_value_connection_sig)
        self.periodic_z_check.setVisible(False)
        self.label_red_grav.setVisible(False)
        self.grav_red_unit.setVisible(False)
        self.temperature_change.valueChanged.connect(self.reduce_temperature)
        self.gravity_value.valueChanged.connect(self.grav_slider_connection)
        self.gravity_slide.valueChanged.connect(self.grav_value_connection)

    def enable_savingparameters(self, state):
        """enables groupbox for saving parameter options, when checkBox is true
        """
        if state > 0:
           self.groupbox_saveparameters.setEnabled(True)
        else:
           self.groupbox_saveparameters.setEnabled(False)

    def reduce_temperature(self):
        """contributes the temperature in reduced unit
        """
        self.temp_red_unit.setValue(float(self.temperature_change.value()/self.value_epsilon.value()))

    def contribute_boxlength(self):
        """contributes boxlength by given number of particles and density
        """
        area = float(self.particles_np.value() / self.particles_density.value())
        box_l = str(round(area**0.5, 3))
        self.box_length_auto.setText(box_l+","+ box_l+",2")

    def connect_red_density(self):
        """when density is changed, reduced value is new contributed
        """
        self.red_density.setValue(max(0.001, self.particles_density.value()*(self.value_sigma.value()**2)))

    def connect_density(self):
        """when reduced density is changed, density value is new contributed
        """
        self.particles_density.setValue(self.red_density.value()*(self.value_sigma.value()**-2))

    def enable_gravityslider(self, state):
        """shows gravity slider and spinbox, when checkBox is true
        """
        if state > 0:
            self.gravity_slide.setVisible(True)
            self.gravity_value.setVisible(True)
            self.label_red_grav.setVisible(True)
            self.grav_red_unit.setVisible(True)
        else:
            self.gravity_slide.setVisible(False)
            self.gravity_value.setVisible(False)
            self.label_red_grav.setVisible(False)
            self.grav_red_unit.setVisible(False)

    def grav_value_connection(self):
        self.gravity_value.setValue(self.gravity_slide.value()*0.01)
        self.grav_red_unit.setValue(self.gravity_value.value()/2.477709)

    def grav_slider_connection(self):
        self.gravity_slide.setValue(int(self.gravity_value.value()*100))
        self.grav_red_unit.setValue(self.gravity_value.value()/2.477709)

    def lj_slider_connection_eps(self):
        """ changes value of slider, when epsilon value is changed
        """
        self.epsilon_slider.setValue(int(self.value_epsilon.value()))

    def lj_slider_connection_sig(self):
        """ changes value of slider, when sigma is changed
        """
        self.sigma_slider.setValue(int(100*self.value_sigma.value()))

    def lj_value_connection_eps(self):
        """ changes value of epsilon, when its slider is changed
        """
        self.value_epsilon.setValue(self.epsilon_slider.value())

    def lj_value_connection_sig(self):
        """ changes value of sigma, when its slider is changed
        """
        self.value_sigma.setValue(0.01*self.sigma_slider.value())

    def lennard_jones_params(self):
        self.epsilon_k = {'Argon':111.84,
                        'Chlorine':296.27,
                        'Carbon dioxide':201.71,
                        'Krypton':154.87,
                        'Oxygen':113.27,
                        'Nitrogen':91.85,
                        'Xenon':213.96} # epsilon/k_boltzmann in K
        self.sigma_ = {'Argon':0.3623,
                        'Chlorine':0.4485,
                        'Carbon dioxide':0.4444,
                        'Krypton':0.3895,
                        'Oxygen':0.3654,
                        'Nitrogen':0.3919,
                        'Xenon':0.4260} # sigma in nm

        if self.radiobutton_argon.isChecked():
            self.value_epsilon.setValue(self.epsilon_k['Argon'])
            self.value_sigma.setValue(self.sigma_['Argon'])

        if self.radiobutton_chloride.isChecked():
            self.value_epsilon.setValue(self.epsilon_k['Chlorine'])
            self.value_sigma.setValue(self.sigma_['Chlorine'])

        if self.radiobutton_carbondioxide.isChecked():
            self.value_epsilon.setValue(self.epsilon_k['Carbon dioxide'])
            self.value_sigma.setValue(self.sigma_['Carbon dioxide'])

        if self.radiobutton_krypton.isChecked():
            self.value_epsilon.setValue(self.epsilon_k['Krypton'])
            self.value_sigma.setValue(self.sigma_['Krypton'])

        if self.radiobutton_oxygen.isChecked():
            self.value_epsilon.setValue(self.epsilon_k['Oxygen'])
            self.value_sigma.setValue(self.sigma_['Oxygen'])

        if self.radiobutton_nitrogen.isChecked():
            self.value_epsilon.setValue(self.epsilon_k['Nitrogen'])
            self.value_sigma.setValue(self.sigma_['Nitrogen'])

        if self.radiobutton_xenon.isChecked():
            self.value_epsilon.setValue(self.epsilon_k['Xenon'])
            self.value_sigma.setValue(self.sigma_['Xenon'])

        if self.radiobutton_other.isChecked():
            self.value_epsilon.setEnabled(True)
            self.value_sigma.setEnabled(True)
            self.epsilon_slider.setEnabled(True)
            self.sigma_slider.setEnabled(True)
        else: 
            self.value_epsilon.setEnabled(False)
            self.value_sigma.setEnabled(False)
            self.epsilon_slider.setEnabled(False)
            self.sigma_slider.setEnabled(False)

    def thermostat_change(self, state):
        """enables switching temperature, when thermostat is turned off
        """
        if state > 0:
            self.temperature_change.setVisible(True)
            self.temperature_slide.setVisible(True)
            self.temperature_slide.setEnabled(True)

        else:
            self.temperature_change.setVisible(False)
            self.temperature_slide.setEnabled(False)

    def retranslateUi(self, mainWindow):
        _translate = QtCore.QCoreApplication.translate
        mainWindow.setWindowTitle(_translate("mainWindow", "PyStar"))
        self.run_button.setText(_translate("mainWindow", "Run Simulation"))
        self.pause_button.setText(_translate("mainWindow", "Pause"))
        self.groupBox_2.setTitle(_translate("mainWindow", "System parameters"))
        self.label.setText(_translate("mainWindow", "System name"))
        self.particles_system_name.setToolTip(_translate("mainWindow", "<html><head/><body><p>Please don\'t use spaces!</p></body></html>"))
        self.particles_system_name.setText(_translate("mainWindow", "LJ_Test_2D"))
        self.label_2.setText(_translate("mainWindow", "Number of particles"))
        self.label_21.setText(_translate("mainWindow", "<html><head/><body><p>Density ρ=N/A</p></body></html>"))
        self.label_22.setText(_translate("mainWindow", "<html><head/><body><p><span style=\" font-size:10pt;\">(in nm</span><span style=\" font-size:10pt; vertical-align:super;\">-2</span><span style=\" font-size:10pt;\">)</span></p></body></html>"))
        self.label_3.setText(_translate("mainWindow", "<html><head/><body><p align=\"center\">reduced ρ=N<span style=\" font-weight:600;\">·</span>σ<span style=\" vertical-align:super;\">2</span>/A</p></body></html>"))
        self.label_12.setText(_translate("mainWindow", "<html><head/><body><p>reduced ρ of a liquid is around 0.83</p></body></html>"))
        self.label_16.setText(_translate("mainWindow", "<html><head/><body><p>reduced ρ of a gas is around 0.001</p></body></html>"))
        self.label_4.setToolTip(_translate("mainWindow", "<html><head/><body><p>automatically calculated</p></body></html>"))
        self.label_4.setText(_translate("mainWindow", "Box Length (in nm)"))
        self.box_length_auto.setText(_translate("mainWindow", "5,5,2"))
        self.pushButton.setText(_translate("mainWindow", "Apply Changes"))
        self.check_savingdata.setText(_translate("mainWindow", "Saving Data"))
        self.groupBox_4.setTitle(_translate("mainWindow", "Periodic Boundary Conditions"))
        self.periodic_y_check.setText(_translate("mainWindow", "in y-direction"))
        self.periodic_x_check.setText(_translate("mainWindow", "in x-direction"))
        self.periodic_z_check.setText(_translate("mainWindow", "in z-direction"))
        self.label_6.setText(_translate("mainWindow", "Directory:"))
        self.select_directory.setText(_translate("mainWindow", "Select"))
        self.save_xyz.setText(_translate("mainWindow", "Positions x,y,z"))
        self.save_energies.setText(_translate("mainWindow", "Energies(total,kinetic,potential)"))
        self.save_pressure.setText(_translate("mainWindow", "Pressure"))
        self.tabWidget.setTabText(self.tabWidget.indexOf(self.tab_3), _translate("mainWindow", "Lennard-Jones Balls"))
        self.simulation_field.setTabText(self.simulation_field.indexOf(self.initialization), _translate("mainWindow", "Initialization"))
        self.groupBox.setTitle(_translate("mainWindow", "Kinetic properties"))
        self.label_5.setText(_translate("mainWindow", "Temperature (in K)"))
        self.label_red_grav.setText(_translate("mainWindow", "<html><head/><body><p><span style=\" font-size:9pt;\">in red. unit:</span></p></body></html>"))
        self.label_9.setText(_translate("mainWindow", "<html><head/><body><p align=\"center\">Gravitational Force (in kJ mol<span style=\" vertical-align:super;\">-1</span> nm<span style=\" vertical-align:super;\">-1</span>)</p></body></html>"))
        self.label_19.setText(_translate("mainWindow", "<html><head/><body><p><span style=\" font-size:9pt;\">in red. unit:</span></p></body></html>"))
        self.apply_changes.setText(_translate("mainWindow", "Apply"))
        self.LJparams_2.setTitle(_translate("mainWindow", "Simulation Settings"))
        self.label_18.setText(_translate("mainWindow", "<html><head/><body><p>Thermostat (NVT Ensemble)</p></body></html>"))
        self.label_8.setText(_translate("mainWindow", "Integrations per Frame"))
        self.groupBox_3.setTitle(_translate("mainWindow", "Lennard-Jones Parameters"))
        self.label_13.setText(_translate("mainWindow", "Choose your gas:"))
        self.radiobutton_argon.setText(_translate("mainWindow", "Argon"))
        self.radiobutton_oxygen.setText(_translate("mainWindow", "Oxygen"))
        self.radiobutton_chloride.setText(_translate("mainWindow", "Chlorine"))
        self.radiobutton_nitrogen.setText(_translate("mainWindow", "Nitrogen"))
        self.radiobutton_carbondioxide.setText(_translate("mainWindow", "Carbon dioxide"))
        self.radiobutton_xenon.setText(_translate("mainWindow", "Xenon"))
        self.radiobutton_krypton.setText(_translate("mainWindow", "Krypton"))
        self.radiobutton_other.setText(_translate("mainWindow", "Other"))
        self.label_14.setText(_translate("mainWindow", " Values of σ and ε"))
        self.label_15.setText(_translate("mainWindow", "ε/ k_B (in K)"))
        self.label_17.setText(_translate("mainWindow", "σ (in nm)"))
        self.simulation_field.setTabText(self.simulation_field.indexOf(self.tab_2), _translate("mainWindow", "Settings"))
        self.simulation_field.setTabText(self.simulation_field.indexOf(self.life_plots), _translate("mainWindow", "Live Plots"))
from . import resource_rc
