"""iMaps assets needed for normal operation."""

SPECIES = [
    "Drosophila melanogaster",
    "Danio rerio",
    "Escherichia coli",
    "Homo sapiens",
    "Mus musculus",
    "Rattus norvegicus",
    "Staphylococcus aureus",
    "Saccharomyces cerevisiae",
]

GENOME = {
    "Drosophila melanogaster": {"slug": "imaps-genome-dm", "name": "DEFAULT Drosophila melanogaster genome"},
    "Danio rerio": {"slug": "imaps-genome-dr", "name": "DEFAULT Danio rerio genome"},
    "Escherichia coli": {"slug": "imaps-genome-ec", "name": "DEFAULT Escherichia coli genome"},
    "Homo sapiens": {"slug": "imaps-genome-hs", "name": "DEFAULT Homo sapiens genome"},
    "Mus musculus": {"slug": "imaps-genome-mm", "name": "DEFAULT Mus musculus genome"},
    "Rattus norvegicus": {"slug": "imaps-genome-rn", "name": "DEFAULT Rattus norvegicus genome"},
    "Staphylococcus aureus": {"slug": "imaps-genome-sa", "name": "DEFAULT Staphylococcus aureus genome"},
    "Saccharomyces cerevisiae": {"slug": "imaps-genome-sc", "name": "DEFAULT Saccharomyces cerevisiae genome"},
}

ANNOTATION = {
    "Drosophila melanogaster": {"slug": "imaps-annotation-dm", "name": "DEFAULT Drosophila melanogaster annotation"},
    "Danio rerio": {"slug": "imaps-annotation-dr", "name": "DEFAULT Danio rerio annotation"},
    "Escherichia coli": {"slug": "imaps-annotation-ec", "name": "DEFAULT Escherichia coli annotation"},
    "Homo sapiens": {"slug": "imaps-annotation-hs", "name": "DEFAULT Homo sapiens annotation"},
    "Mus musculus": {"slug": "imaps-annotation-mm", "name": "DEFAULT Mus musculus annotation"},
    "Rattus norvegicus": {"slug": "imaps-annotation-rn", "name": "DEFAULT Rattus norvegicus annotation"},
    "Staphylococcus aureus": {"slug": "imaps-annotation-sa", "name": "DEFAULT Staphylococcus aureus annotation"},
    "Saccharomyces cerevisiae": {
        "slug": "imaps-annotation-sc",
        "name": "DEFAULT Saccharomyces cerevisiae annotation",
    },
}

SEGMENT = {
    "Drosophila melanogaster": {
        # TODO: imaps-segment-dm
        "slug": "segmentation-dm-ens92",
        "name": "DEFAULT Drosophila melanogaster segment",
    },
    "Danio rerio": {
        # TODO: imaps-segment-dr
        "slug": "segmentation-dr-ens92",
        "name": "DEFAULT Danio rerio segment",
    },
    "Escherichia coli": {
        # TODO: imaps-segment-ec
        "slug": "segmentation-ec-ens39",
        "name": "DEFAULT Escherichia coli segment",
    },
    "Homo sapiens": {
        # TODO: imaps-segment-hs
        "slug": "segmentation-hs-gen27",
        "name": "DEFAULT Homo sapiens segment",
    },
    "Mus musculus": {
        # TODO: imaps-segment-mm
        "slug": "segmentation-mm-gen16",
        "name": "DEFAULT Mus musculus segment",
    },
    "Rattus norvegicus": {
        # TODO: imaps-segment-rn
        "slug": "segmentation-rn-ens92",
        "name": "DEFAULT Rattus norvegicus segment",
    },
    "Staphylococcus aureus": {
        # TODO: imaps-segment-sa
        "slug": "segmentation-sa-ens39",
        "name": "DEFAULT Staphylococcus aureus segment",
    },
    "Saccharomyces cerevisiae": {
        # TODO: imaps-segment-sc
        "slug": "segmentation-sc-ens92",
        "name": "DEFAULT Saccharomyces cerevisiae segment",
    },
}

STAR_INDEX = {
    "Drosophila melanogaster": {
        # TODO: imaps-star-index-dm
        "slug": "star-index-dm-ens92",
        "name": "DEFAULT Drosophila melanogaster STAR index",
    },
    "Danio rerio": {
        # TODO: imaps-star-index-dr
        "slug": "star-index-dr-ens92",
        "name": "DEFAULT Danio rerio STAR index",
    },
    "Escherichia coli": {
        # TODO: imaps-star-index-ec
        "slug": "star-index-ec-ens39",
        "name": "DEFAULT Escherichia coli STAR index",
    },
    "Homo sapiens": {
        # TODO: imaps-star-index-hs
        "slug": "star-index-hs-gen27",
        "name": "DEFAULT Homo sapiens STAR index",
    },
    "Mus musculus": {
        # TODO: imaps-star-index-mm
        "slug": "star-index-mm-gen16",
        "name": "DEFAULT Mus musculus STAR index",
    },
    "Rattus norvegicus": {
        # TODO: imaps-star-index-rn
        "slug": "star-index-rn-ens92",
        "name": "DEFAULT Rattus norvegicus STAR index",
    },
    "Staphylococcus aureus": {
        # TODO: imaps-star-index-sa
        "slug": "star-index-sa-ens39",
        "name": "DEFAULT Staphylococcus aureus STAR index",
    },
    "Saccharomyces cerevisiae": {
        # TODO: imaps-star-index-sc
        "slug": "star-index-sc-ens92",
        "name": "DEFAULT Saccharomyces cerevisiae STAR index",
    },
}

TRNA_RRNA_SEQ = {
    "Drosophila melanogaster": {
        "slug": "imaps-trna-rrna-seq-dm",
        "name": "DEFAULT Drosophila melanogaster tRNA/rRNA sequences",
    },
    "Danio rerio": {"slug": "imaps-trna-rrna-seq-dr", "name": "DEFAULT Danio rerio tRNA/rRNA sequences"},
    "Escherichia coli": {"slug": "imaps-trna-rrna-seq-ec", "name": "DEFAULT Escherichia coli tRNA/rRNA sequences"},
    "Homo sapiens": {"slug": "imaps-trna-rrna-seq-hs", "name": "DEFAULT Homo sapiens tRNA/rRNA sequences"},
    "Mus musculus": {"slug": "imaps-trna-rrna-seq-mm", "name": "DEFAULT Mus musculus tRNA/rRNA sequences"},
    "Rattus norvegicus": {"slug": "imaps-trna-rrna-seq-rn", "name": "DEFAULT Rattus norvegicus tRNA/rRNA sequences"},
    "Staphylococcus aureus": {
        "slug": "imaps-trna-rrna-seq-sa",
        "name": "DEFAULT Staphylococcus aureus tRNA/rRNA sequences",
    },
    "Saccharomyces cerevisiae": {
        "slug": "imaps-trna-rrna-seq-sc",
        "name": "DEFAULT Saccharomyces cerevisiae tRNA/rRNA sequences",
    },
}

TRNA_RRNA_INDEX = {
    "Drosophila melanogaster": {
        # TODO: imaps-trna-rrna-star-index-dm
        "slug": "star-index-alter-dm-ens92",
        "name": "DEFAULT Drosophila melanogaster tRNA/rRNA STAR index",
    },
    "Danio rerio": {
        # TODO: imaps-trna-rrna-star-index-dr
        "slug": "star-index-alter-dr-ens92",
        "name": "DEFAULT Danio rerio tRNA/rRNA STAR index",
    },
    "Escherichia coli": {
        # TODO: imaps-trna-rrna-star-index-ec
        "slug": "star-index-alter-ec-ens39",
        "name": "DEFAULT Escherichia coli tRNA/rRNA STAR index",
    },
    "Homo sapiens": {
        # TODO: imaps-trna-rrna-star-index-hs
        "slug": "star-index-alter-hs-gen27",
        "name": "DEFAULT Homo sapiens tRNA/rRNA STAR index",
    },
    "Mus musculus": {
        # TODO: imaps-trna-rrna-star-index-mm
        "slug": "star-index-alter-mm-gen16",
        "name": "DEFAULT Mus musculus tRNA/rRNA STAR index",
    },
    "Rattus norvegicus": {
        # TODO: imaps-trna-rrna-star-index-rn
        "slug": "star-index-alter-rn-ens92",
        "name": "DEFAULT Rattus norvegicus tRNA/rRNA STAR index",
    },
    "Staphylococcus aureus": {
        # TODO: imaps-trna-rrna-star-index-sa
        "slug": "star-index-alter-sa-ens39",
        "name": "DEFAULT Staphylococcus aureus tRNA/rRNA STAR index",
    },
    "Saccharomyces cerevisiae": {
        # TODO: imaps-trna-rrna-star-index-sc
        "slug": "star-index-alter-sc-ens92",
        "name": "DEFAULT Saccharomyces cerevisiae tRNA/rRNA STAR index",
    },
}
