function [ parameters ] = airplane_parameters( )
% --------------------------------------------------------------
%       Значения по умолчанию для постоянных параметров.
% --------------------------------------------------------------
%Oy - высота над уровнем моря, м
%V - воздушная скорость, м/с
%q - скоростной напор, Па
%m - масса самолета, кг
%S - площадь крыла, м^2
%bA - САХ, м
%Jz - момент инерции относительно осей связанной системы координат, м/с^2
%rcgx - смещение от центра тяжести до аэродинамического фокуса по продольной оси, м
%Tstab - постоянная времени привода
%Xistab - коэффициент относительного демпфирования привода
%maxabsstab - ограничение на величину управляющего сигнала, рад
%maxabsdstab - ограничение на угловую скорость управляющей поверхности, рад/с
%lef - отклонение носков крыла, рад
%sb - отклонение воздушного тормоза, рад
%g - ускорение свободного падения на поверхности Земли, м/с^2
% --------------------------------------------------------------
parameters.m = 9295.44;%kg
parameters.S = 27.87;%m^2
parameters.bA = 3.45;%m
parameters.Jz = 75673.6;%m/sec^2
parameters.rcgx = -0.05 * parameters.bA;%m

parameters.Tstab = 0.03;
parameters.Xistab = 0.707;
parameters.maxabsstab = degtorad(25);
parameters.maxabsdstab = degtorad(60);

parameters.lef = 0;
parameters.sb = 0;
parameters.g = 9.80665;

parameters.Oy = 3000;
parameters.V = 150.0;%532.2935/3.6;
%Модель атмосферы ISA (для высоты до 11000 м над уровнем моря)
L = 0.0065;%скорость уменьшения температуры с увеличением высоты, К/м
R = 287.0531;%удельная газовая постоянная (для сухого воздуха), Дж/(кг К)
T0 = 288.15;%температура воздуха на уровне моря, К
T = T0 - L * parameters.Oy;%температура воздуха на текущей высоте, К
rho0 = 1.225;%плотность воздуха на уровне моря, кг/м^3
rho = rho0 * (T / T0).^(parameters.g / (L * R) - 1);%плотность воздуха на текущей высоте, кг/м^3
parameters.q = (rho.*(parameters.V.^2)) / 2;%скоростной напор, Па

end

