# coding: utf-8

"""
    Kill Bill

    Kill Bill is an open-source billing and payments platform  # noqa: E501

    OpenAPI spec version: 0.22.30
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from killbill.api_client import ApiClient


class BundleApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_bundle_blocking_state(self, body, x_killbill_created_by, bundle_id, **kwargs):  # noqa: E501
        """Block a bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_bundle_blocking_state(body, x_killbill_created_by, bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BlockingState body: (required)
        :param str x_killbill_created_by: (required)
        :param str bundle_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date requested_date:
        :param list[str] plugin_property:
        :return: list[BlockingState]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_bundle_blocking_state_with_http_info(body, x_killbill_created_by, bundle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_bundle_blocking_state_with_http_info(body, x_killbill_created_by, bundle_id, **kwargs)  # noqa: E501
            return data

    def add_bundle_blocking_state_with_http_info(self, body, x_killbill_created_by, bundle_id, **kwargs):  # noqa: E501
        """Block a bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_bundle_blocking_state_with_http_info(body, x_killbill_created_by, bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BlockingState body: (required)
        :param str x_killbill_created_by: (required)
        :param str bundle_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date requested_date:
        :param list[str] plugin_property:
        :return: list[BlockingState]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'bundle_id', 'x_killbill_reason', 'x_killbill_comment', 'requested_date', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_bundle_blocking_state" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_bundle_blocking_state`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `add_bundle_blocking_state`")  # noqa: E501
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params or
                params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `add_bundle_blocking_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']  # noqa: E501

        query_params = []
        if 'requested_date' in params:
            query_params.append(('requestedDate', params['requested_date']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/{bundleId}/block', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BlockingState]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_bundle_custom_fields(self, body, x_killbill_created_by, bundle_id, **kwargs):  # noqa: E501
        """Add custom fields to bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bundle_custom_fields(body, x_killbill_created_by, bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str bundle_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_bundle_custom_fields_with_http_info(body, x_killbill_created_by, bundle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_bundle_custom_fields_with_http_info(body, x_killbill_created_by, bundle_id, **kwargs)  # noqa: E501
            return data

    def create_bundle_custom_fields_with_http_info(self, body, x_killbill_created_by, bundle_id, **kwargs):  # noqa: E501
        """Add custom fields to bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bundle_custom_fields_with_http_info(body, x_killbill_created_by, bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str bundle_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'bundle_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bundle_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_bundle_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_bundle_custom_fields`")  # noqa: E501
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params or
                params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `create_bundle_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/{bundleId}/customFields', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CustomField]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_bundle_tags(self, body, x_killbill_created_by, bundle_id, **kwargs):  # noqa: E501
        """Add tags to bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bundle_tags(body, x_killbill_created_by, bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str x_killbill_created_by: (required)
        :param str bundle_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_bundle_tags_with_http_info(body, x_killbill_created_by, bundle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_bundle_tags_with_http_info(body, x_killbill_created_by, bundle_id, **kwargs)  # noqa: E501
            return data

    def create_bundle_tags_with_http_info(self, body, x_killbill_created_by, bundle_id, **kwargs):  # noqa: E501
        """Add tags to bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bundle_tags_with_http_info(body, x_killbill_created_by, bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] body: (required)
        :param str x_killbill_created_by: (required)
        :param str bundle_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'bundle_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bundle_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_bundle_tags`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `create_bundle_tags`")  # noqa: E501
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params or
                params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `create_bundle_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/{bundleId}/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Tag]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_bundle_custom_fields(self, bundle_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove custom fields from bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bundle_custom_fields(bundle_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] custom_field:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_bundle_custom_fields_with_http_info(bundle_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_bundle_custom_fields_with_http_info(bundle_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_bundle_custom_fields_with_http_info(self, bundle_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove custom fields from bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bundle_custom_fields_with_http_info(bundle_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] custom_field:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id', 'x_killbill_created_by', 'custom_field', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bundle_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params or
                params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `delete_bundle_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_bundle_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']  # noqa: E501

        query_params = []
        if 'custom_field' in params:
            query_params.append(('customField', params['custom_field']))  # noqa: E501
            collection_formats['customField'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/{bundleId}/customFields', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_bundle_tags(self, bundle_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove tags from bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bundle_tags(bundle_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] tag_def:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_bundle_tags_with_http_info(bundle_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_bundle_tags_with_http_info(bundle_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def delete_bundle_tags_with_http_info(self, bundle_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Remove tags from bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bundle_tags_with_http_info(bundle_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :param str x_killbill_created_by: (required)
        :param list[str] tag_def:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id', 'x_killbill_created_by', 'tag_def', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bundle_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params or
                params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `delete_bundle_tags`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `delete_bundle_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']  # noqa: E501

        query_params = []
        if 'tag_def' in params:
            query_params.append(('tagDef', params['tag_def']))  # noqa: E501
            collection_formats['tagDef'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/{bundleId}/tags', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bundle(self, bundle_id, **kwargs):  # noqa: E501
        """Retrieve a bundle by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bundle(bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :param str audit:
        :return: Bundle
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bundle_with_http_info(bundle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bundle_with_http_info(bundle_id, **kwargs)  # noqa: E501
            return data

    def get_bundle_with_http_info(self, bundle_id, **kwargs):  # noqa: E501
        """Retrieve a bundle by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bundle_with_http_info(bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :param str audit:
        :return: Bundle
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bundle" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params or
                params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `get_bundle`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']  # noqa: E501

        query_params = []
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/{bundleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Bundle',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bundle_audit_logs_with_history(self, bundle_id, **kwargs):  # noqa: E501
        """Retrieve bundle audit logs with history by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bundle_audit_logs_with_history(bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :return: list[AuditLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bundle_audit_logs_with_history_with_http_info(bundle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bundle_audit_logs_with_history_with_http_info(bundle_id, **kwargs)  # noqa: E501
            return data

    def get_bundle_audit_logs_with_history_with_http_info(self, bundle_id, **kwargs):  # noqa: E501
        """Retrieve bundle audit logs with history by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bundle_audit_logs_with_history_with_http_info(bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :return: list[AuditLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bundle_audit_logs_with_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params or
                params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `get_bundle_audit_logs_with_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/{bundleId}/auditLogsWithHistory', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditLog]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bundle_by_key(self, external_key, **kwargs):  # noqa: E501
        """Retrieve a bundle by external key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bundle_by_key(external_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str external_key: (required)
        :param bool included_deleted:
        :param str audit:
        :return: list[Bundle]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bundle_by_key_with_http_info(external_key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bundle_by_key_with_http_info(external_key, **kwargs)  # noqa: E501
            return data

    def get_bundle_by_key_with_http_info(self, external_key, **kwargs):  # noqa: E501
        """Retrieve a bundle by external key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bundle_by_key_with_http_info(external_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str external_key: (required)
        :param bool included_deleted:
        :param str audit:
        :return: list[Bundle]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_key', 'included_deleted', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bundle_by_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'external_key' is set
        if ('external_key' not in params or
                params['external_key'] is None):
            raise ValueError("Missing the required parameter `external_key` when calling `get_bundle_by_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'external_key' in params:
            query_params.append(('externalKey', params['external_key']))  # noqa: E501
        if 'included_deleted' in params:
            query_params.append(('includedDeleted', params['included_deleted']))  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Bundle]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bundle_custom_fields(self, bundle_id, **kwargs):  # noqa: E501
        """Retrieve bundle custom fields  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bundle_custom_fields(bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :param str audit:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bundle_custom_fields_with_http_info(bundle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bundle_custom_fields_with_http_info(bundle_id, **kwargs)  # noqa: E501
            return data

    def get_bundle_custom_fields_with_http_info(self, bundle_id, **kwargs):  # noqa: E501
        """Retrieve bundle custom fields  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bundle_custom_fields_with_http_info(bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :param str audit:
        :return: list[CustomField]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bundle_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params or
                params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `get_bundle_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']  # noqa: E501

        query_params = []
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/{bundleId}/customFields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CustomField]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bundle_tags(self, bundle_id, **kwargs):  # noqa: E501
        """Retrieve bundle tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bundle_tags(bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :param bool included_deleted:
        :param str audit:
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bundle_tags_with_http_info(bundle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bundle_tags_with_http_info(bundle_id, **kwargs)  # noqa: E501
            return data

    def get_bundle_tags_with_http_info(self, bundle_id, **kwargs):  # noqa: E501
        """Retrieve bundle tags  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bundle_tags_with_http_info(bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :param bool included_deleted:
        :param str audit:
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id', 'included_deleted', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bundle_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params or
                params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `get_bundle_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']  # noqa: E501

        query_params = []
        if 'included_deleted' in params:
            query_params.append(('includedDeleted', params['included_deleted']))  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/{bundleId}/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Tag]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bundles(self, **kwargs):  # noqa: E501
        """List bundles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bundles(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset:
        :param int limit:
        :param str audit:
        :return: list[Bundle]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bundles_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_bundles_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_bundles_with_http_info(self, **kwargs):  # noqa: E501
        """List bundles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bundles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int offset:
        :param int limit:
        :param str audit:
        :return: list[Bundle]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bundles" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/pagination', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Bundle]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_bundle_custom_fields(self, body, x_killbill_created_by, bundle_id, **kwargs):  # noqa: E501
        """Modify custom fields to bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_bundle_custom_fields(body, x_killbill_created_by, bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str bundle_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_bundle_custom_fields_with_http_info(body, x_killbill_created_by, bundle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_bundle_custom_fields_with_http_info(body, x_killbill_created_by, bundle_id, **kwargs)  # noqa: E501
            return data

    def modify_bundle_custom_fields_with_http_info(self, body, x_killbill_created_by, bundle_id, **kwargs):  # noqa: E501
        """Modify custom fields to bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_bundle_custom_fields_with_http_info(body, x_killbill_created_by, bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[CustomField] body: (required)
        :param str x_killbill_created_by: (required)
        :param str bundle_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'bundle_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_bundle_custom_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `modify_bundle_custom_fields`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `modify_bundle_custom_fields`")  # noqa: E501
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params or
                params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `modify_bundle_custom_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/{bundleId}/customFields', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pause_bundle(self, bundle_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Pause a bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pause_bundle(bundle_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :param str x_killbill_created_by: (required)
        :param date requested_date:
        :param list[str] plugin_property:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.pause_bundle_with_http_info(bundle_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.pause_bundle_with_http_info(bundle_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def pause_bundle_with_http_info(self, bundle_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Pause a bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pause_bundle_with_http_info(bundle_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :param str x_killbill_created_by: (required)
        :param date requested_date:
        :param list[str] plugin_property:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id', 'x_killbill_created_by', 'requested_date', 'plugin_property', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pause_bundle" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params or
                params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `pause_bundle`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `pause_bundle`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']  # noqa: E501

        query_params = []
        if 'requested_date' in params:
            query_params.append(('requestedDate', params['requested_date']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/{bundleId}/pause', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rename_external_key(self, body, x_killbill_created_by, bundle_id, **kwargs):  # noqa: E501
        """Update a bundle externalKey  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rename_external_key(body, x_killbill_created_by, bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Bundle body: (required)
        :param str x_killbill_created_by: (required)
        :param str bundle_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.rename_external_key_with_http_info(body, x_killbill_created_by, bundle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.rename_external_key_with_http_info(body, x_killbill_created_by, bundle_id, **kwargs)  # noqa: E501
            return data

    def rename_external_key_with_http_info(self, body, x_killbill_created_by, bundle_id, **kwargs):  # noqa: E501
        """Update a bundle externalKey  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rename_external_key_with_http_info(body, x_killbill_created_by, bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Bundle body: (required)
        :param str x_killbill_created_by: (required)
        :param str bundle_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'bundle_id', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rename_external_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `rename_external_key`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `rename_external_key`")  # noqa: E501
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params or
                params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `rename_external_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/{bundleId}/renameKey', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resume_bundle(self, bundle_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Resume a bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resume_bundle(bundle_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :param str x_killbill_created_by: (required)
        :param date requested_date:
        :param list[str] plugin_property:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resume_bundle_with_http_info(bundle_id, x_killbill_created_by, **kwargs)  # noqa: E501
        else:
            (data) = self.resume_bundle_with_http_info(bundle_id, x_killbill_created_by, **kwargs)  # noqa: E501
            return data

    def resume_bundle_with_http_info(self, bundle_id, x_killbill_created_by, **kwargs):  # noqa: E501
        """Resume a bundle  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resume_bundle_with_http_info(bundle_id, x_killbill_created_by, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bundle_id: (required)
        :param str x_killbill_created_by: (required)
        :param date requested_date:
        :param list[str] plugin_property:
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bundle_id', 'x_killbill_created_by', 'requested_date', 'plugin_property', 'x_killbill_reason', 'x_killbill_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resume_bundle" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params or
                params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `resume_bundle`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `resume_bundle`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']  # noqa: E501

        query_params = []
        if 'requested_date' in params:
            query_params.append(('requestedDate', params['requested_date']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/{bundleId}/resume', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_bundles(self, search_key, **kwargs):  # noqa: E501
        """Search bundles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_bundles(search_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str search_key: (required)
        :param int offset:
        :param int limit:
        :param str audit:
        :return: list[Bundle]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_bundles_with_http_info(search_key, **kwargs)  # noqa: E501
        else:
            (data) = self.search_bundles_with_http_info(search_key, **kwargs)  # noqa: E501
            return data

    def search_bundles_with_http_info(self, search_key, **kwargs):  # noqa: E501
        """Search bundles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_bundles_with_http_info(search_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str search_key: (required)
        :param int offset:
        :param int limit:
        :param str audit:
        :return: list[Bundle]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['search_key', 'offset', 'limit', 'audit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_bundles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'search_key' is set
        if ('search_key' not in params or
                params['search_key'] is None):
            raise ValueError("Missing the required parameter `search_key` when calling `search_bundles`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'search_key' in params:
            path_params['searchKey'] = params['search_key']  # noqa: E501

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'audit' in params:
            query_params.append(('audit', params['audit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/search/{searchKey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Bundle]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def transfer_bundle(self, body, x_killbill_created_by, bundle_id, **kwargs):  # noqa: E501
        """Transfer a bundle to another account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.transfer_bundle(body, x_killbill_created_by, bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Bundle body: (required)
        :param str x_killbill_created_by: (required)
        :param str bundle_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date requested_date:
        :param str billing_policy:
        :param list[str] plugin_property:
        :return: Bundle
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.transfer_bundle_with_http_info(body, x_killbill_created_by, bundle_id, **kwargs)  # noqa: E501
        else:
            (data) = self.transfer_bundle_with_http_info(body, x_killbill_created_by, bundle_id, **kwargs)  # noqa: E501
            return data

    def transfer_bundle_with_http_info(self, body, x_killbill_created_by, bundle_id, **kwargs):  # noqa: E501
        """Transfer a bundle to another account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.transfer_bundle_with_http_info(body, x_killbill_created_by, bundle_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Bundle body: (required)
        :param str x_killbill_created_by: (required)
        :param str bundle_id: (required)
        :param str x_killbill_reason:
        :param str x_killbill_comment:
        :param date requested_date:
        :param str billing_policy:
        :param list[str] plugin_property:
        :return: Bundle
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_killbill_created_by', 'bundle_id', 'x_killbill_reason', 'x_killbill_comment', 'requested_date', 'billing_policy', 'plugin_property']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method transfer_bundle" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `transfer_bundle`")  # noqa: E501
        # verify the required parameter 'x_killbill_created_by' is set
        if ('x_killbill_created_by' not in params or
                params['x_killbill_created_by'] is None):
            raise ValueError("Missing the required parameter `x_killbill_created_by` when calling `transfer_bundle`")  # noqa: E501
        # verify the required parameter 'bundle_id' is set
        if ('bundle_id' not in params or
                params['bundle_id'] is None):
            raise ValueError("Missing the required parameter `bundle_id` when calling `transfer_bundle`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bundle_id' in params:
            path_params['bundleId'] = params['bundle_id']  # noqa: E501

        query_params = []
        if 'requested_date' in params:
            query_params.append(('requestedDate', params['requested_date']))  # noqa: E501
        if 'billing_policy' in params:
            query_params.append(('billingPolicy', params['billing_policy']))  # noqa: E501
        if 'plugin_property' in params:
            query_params.append(('pluginProperty', params['plugin_property']))  # noqa: E501
            collection_formats['pluginProperty'] = 'multi'  # noqa: E501

        header_params = {}
        if 'x_killbill_created_by' in params:
            header_params['X-Killbill-CreatedBy'] = params['x_killbill_created_by']  # noqa: E501
        if 'x_killbill_reason' in params:
            header_params['X-Killbill-Reason'] = params['x_killbill_reason']  # noqa: E501
        if 'x_killbill_comment' in params:
            header_params['X-Killbill-Comment'] = params['x_killbill_comment']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Killbill Api Key', 'Killbill Api Secret', 'basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/1.0/kb/bundles/{bundleId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Bundle',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
