/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.debugging;

import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class DebuggerClassExpressionGenerator
implements OWLAxiomVisitor {
    private final OWLDataFactory dataFactory;
    @Nullable
    private OWLClassExpression desc;

    public DebuggerClassExpressionGenerator(OWLDataFactory dataFactory) {
        this.dataFactory = (OWLDataFactory)OWLAPIPreconditions.checkNotNull((Object)dataFactory, (String)"dataFactory cannot be null");
    }

    @Nullable
    public OWLClassExpression getDebuggerClassExpression() {
        return this.desc;
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        OWLObjectComplementOf complement = this.dataFactory.getOWLObjectComplementOf(axiom.getSuperClass());
        this.desc = this.dataFactory.getOWLObjectIntersectionOf((Collection)CollectionFactory.createSet((Object[])new OWLClassExpression[]{axiom.getSubClass(), complement}));
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        OWLDataSomeValuesFrom sub = this.dataFactory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)this.dataFactory.getTopDatatype());
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)sub, (OWLClassExpression)axiom.getDomain());
        ax.accept((OWLAxiomVisitor)this);
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        OWLObjectSomeValuesFrom sub = this.dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)this.dataFactory.getOWLThing());
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)sub, (OWLClassExpression)axiom.getDomain());
        ax.accept((OWLAxiomVisitor)this);
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        OWLObjectAllValuesFrom sup = this.dataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)axiom.getRange());
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)this.dataFactory.getOWLThing(), (OWLClassExpression)sup);
        ax.accept((OWLAxiomVisitor)this);
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        OWLNamedIndividual ind = this.dataFactory.getOWLNamedIndividual(IRI.getNextDocumentIRI((String)"http://debugger.com#A"));
        OWLObjectHasValue sub = this.dataFactory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getSubProperty(), (OWLIndividual)ind);
        OWLObjectHasValue sup = this.dataFactory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getSuperProperty(), (OWLIndividual)ind);
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)sub, (OWLClassExpression)sup);
        ax.accept((OWLAxiomVisitor)this);
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        OWLObjectOneOf sub = this.dataFactory.getOWLObjectOneOf(new OWLIndividual[]{axiom.getIndividual()});
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)sub, axiom.getClassExpression());
        ax.accept((OWLAxiomVisitor)this);
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (axiom.classExpressions().count() == 2L && OWLAPIStreamUtils.contains((Stream)axiom.classExpressions(), (Object)this.dataFactory.getOWLNothing())) {
            this.desc = axiom.classExpressions().filter(c -> !c.isOWLNothing()).findFirst().orElse(null);
            if (this.desc != null) {
                return;
            }
        }
        Iterator it = axiom.classExpressions().iterator();
        OWLClassExpression descC = (OWLClassExpression)it.next();
        OWLObjectComplementOf notC = this.dataFactory.getOWLObjectComplementOf(descC);
        OWLClassExpression descD = (OWLClassExpression)it.next();
        OWLObjectComplementOf notD = this.dataFactory.getOWLObjectComplementOf(descD);
        OWLObjectIntersectionOf left = this.dataFactory.getOWLObjectIntersectionOf((Collection)CollectionFactory.createSet((Object[])new OWLClassExpression[]{descC, notD}));
        OWLObjectIntersectionOf right = this.dataFactory.getOWLObjectIntersectionOf((Collection)CollectionFactory.createSet((Object[])new OWLClassExpression[]{notC, descD}));
        this.desc = this.dataFactory.getOWLObjectUnionOf((Collection)CollectionFactory.createSet((Object[])new OWLObjectIntersectionOf[]{left, right}));
    }
}

