/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.Converters;
import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.arq.querybuilder.clauses.PrologClause;
import org.apache.jena.arq.querybuilder.clauses.WhereClause;
import org.apache.jena.arq.querybuilder.handlers.WhereHandler;
import org.apache.jena.arq.querybuilder.updatebuilder.CollectionQuadHolder;
import org.apache.jena.arq.querybuilder.updatebuilder.ModelQuadHolder;
import org.apache.jena.arq.querybuilder.updatebuilder.PrefixHandler;
import org.apache.jena.arq.querybuilder.updatebuilder.QBQuadHolder;
import org.apache.jena.arq.querybuilder.updatebuilder.QuadCollectionHolder;
import org.apache.jena.arq.querybuilder.updatebuilder.QuadHolder;
import org.apache.jena.arq.querybuilder.updatebuilder.SingleQuadHolder;
import org.apache.jena.arq.querybuilder.updatebuilder.WhereQuadHolder;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.lang.sparql_11.ParseException;
import org.apache.jena.sparql.modify.request.QuadAcc;
import org.apache.jena.sparql.modify.request.QuadDataAcc;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.sparql.modify.request.UpdateDeleteWhere;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.vocabulary.RDF;

public class UpdateBuilder {
    private final PrefixHandler prefixHandler;
    private final WhereQuadHolder whereProcessor;
    private List<QuadHolder> inserts = new ArrayList<QuadHolder>();
    private List<QuadHolder> deletes = new ArrayList<QuadHolder>();
    private Map<Var, Node> values;
    private Node with;

    public UpdateBuilder() {
        this.prefixHandler = new PrefixHandler();
        this.whereProcessor = new WhereQuadHolder(this.prefixHandler);
        this.values = new HashMap<Var, Node>();
        this.with = null;
    }

    public UpdateBuilder(PrologClause<?> prologClause) {
        this(prologClause.getPrologHandler().getPrefixes());
    }

    public UpdateBuilder(PrefixMapping pMap) {
        this.prefixHandler = new PrefixHandler(pMap);
        this.whereProcessor = new WhereQuadHolder(this.prefixHandler);
    }

    private ExtendedIterator<Quad> getQuads(Collection<QuadHolder> holders) {
        ExtendedIterator result = NiceIterator.emptyIterator();
        for (QuadHolder holder : holders) {
            result = result.andThen(holder.setValues(this.values).getQuads());
        }
        return result;
    }

    public Update build() {
        if (this.deletes.isEmpty() && this.inserts.isEmpty()) {
            throw new IllegalStateException("At least one delete or insert must be specified");
        }
        if (this.whereProcessor.isEmpty()) {
            return this.buildNoWhere();
        }
        return this.buildWhere();
    }

    public UpdateRequest buildRequest() {
        UpdateRequest req = new UpdateRequest(this.build());
        req.setPrefixMapping(this.prefixHandler.getPrefixes());
        return req;
    }

    public UpdateRequest appendTo(UpdateRequest req) {
        req.add(this.build());
        for (Map.Entry entry : this.prefixHandler.getPrefixes().getNsPrefixMap().entrySet()) {
            req.setPrefix((String)entry.getKey(), (String)entry.getValue());
        }
        return req;
    }

    private Update buildNoWhere() {
        if (this.inserts.isEmpty()) {
            QuadDataAcc quadData = new QuadDataAcc(this.getQuads(this.deletes).mapWith((Function)new Function<Quad, Quad>(){

                @Override
                public Quad apply(Quad arg0) {
                    return UpdateBuilder.this.check(arg0);
                }
            }).toList());
            return new UpdateDataDelete(quadData);
        }
        if (this.deletes.isEmpty()) {
            QuadDataAcc quadData = new QuadDataAcc(this.getQuads(this.inserts).mapWith((Function)new Function<Quad, Quad>(){

                @Override
                public Quad apply(Quad t) {
                    return UpdateBuilder.this.check(t);
                }
            }).toList());
            return new UpdateDataInsert(quadData);
        }
        throw new IllegalStateException("Can not have both insert and delete without a where clause");
    }

    private Update buildWhere() {
        ExtendedIterator<Quad> iter;
        QuadAcc acc;
        UpdateModify retval = new UpdateModify();
        if (this.with != null) {
            Node graph = this.values.get(this.with);
            if (graph == null) {
                graph = this.with;
            }
            retval.setWithIRI(graph);
        }
        if (!this.inserts.isEmpty()) {
            retval.setHasInsertClause(true);
            acc = retval.getInsertAcc();
            iter = this.getQuads(this.inserts);
            while (iter.hasNext()) {
                acc.addQuad((Quad)iter.next());
            }
        }
        if (!this.deletes.isEmpty()) {
            retval.setHasDeleteClause(true);
            acc = retval.getDeleteAcc();
            iter = this.getQuads(this.deletes);
            while (iter.hasNext()) {
                acc.addQuad((Quad)iter.next());
            }
        }
        retval.setElement(this.whereProcessor.setVars(this.values).build());
        return retval;
    }

    public TriplePath makeTriplePath(Object s, Object p, Object o) {
        Object po = Converters.makeNodeOrPath(p, this.prefixHandler.getPrefixes());
        if (po instanceof Path) {
            return new TriplePath(this.makeNode(s), (Path)po, this.makeNode(o));
        }
        return new TriplePath(new Triple(this.makeNode(s), (Node)po, this.makeNode(o)));
    }

    public Node makeNode(Object o) {
        return Converters.makeNode(o, this.prefixHandler.getPrefixes());
    }

    @Deprecated
    public Var makeVar(Object o) {
        return Converters.makeVar(o);
    }

    @Deprecated
    public String quote(String s) {
        return Converters.quoted(s);
    }

    public UpdateBuilder addInsert(Object g, Object s, Object p, Object o) {
        return this.addInsert(new Quad(this.makeNode(g), this.makeNode(s), this.makeNode(p), this.makeNode(o)));
    }

    public UpdateBuilder addInsert(Quad quad) {
        this.inserts.add(new SingleQuadHolder(quad));
        return this;
    }

    public UpdateBuilder addInsert(Object s, Object p, Object o) {
        this.addInsert(new Triple(this.makeNode(s), this.makeNode(p), this.makeNode(o)));
        return this;
    }

    public UpdateBuilder addInsert(Triple t) {
        this.inserts.add(new SingleQuadHolder(t));
        return this;
    }

    public UpdateBuilder addInsert(Object g, Triple t) {
        Quad q = new Quad(this.makeNode(g), t);
        this.inserts.add(new SingleQuadHolder(q));
        return this;
    }

    public UpdateBuilder addInsert(Model model) {
        this.inserts.add(new ModelQuadHolder(model));
        return this;
    }

    public UpdateBuilder addInsert(Collection<Triple> collection) {
        this.inserts.add(new CollectionQuadHolder(collection));
        return this;
    }

    public UpdateBuilder addInsertQuads(Collection<Quad> collection) {
        this.inserts.add(new QuadCollectionHolder(collection));
        return this;
    }

    public UpdateBuilder addInsert(Iterator<Triple> iter) {
        this.inserts.add(new CollectionQuadHolder(iter));
        return this;
    }

    public UpdateBuilder addInsert(Object g, Model model) {
        this.inserts.add(new ModelQuadHolder(this.makeNode(g), model));
        return this;
    }

    public UpdateBuilder addInsert(Object g, Collection<Triple> collection) {
        this.inserts.add(new CollectionQuadHolder(this.makeNode(g), collection));
        return this;
    }

    public UpdateBuilder addInsert(Object g, Iterator<Triple> iter) {
        this.inserts.add(new CollectionQuadHolder(this.makeNode(g), iter));
        return this;
    }

    public UpdateBuilder addInsert(AbstractQueryBuilder<?> queryBuilder) {
        this.inserts.add(new QBQuadHolder(queryBuilder));
        return this;
    }

    public UpdateBuilder addInsert(Object graph, AbstractQueryBuilder<?> queryBuilder) {
        this.inserts.add(new QBQuadHolder(this.makeNode(graph), queryBuilder));
        return this;
    }

    public UpdateBuilder addDelete(Object g, Object s, Object p, Object o) {
        return this.addDelete(new Quad(this.makeNode(g), this.makeNode(s), this.makeNode(p), this.makeNode(o)));
    }

    public UpdateBuilder addDelete(Quad quad) {
        this.deletes.add(new SingleQuadHolder(quad));
        return this;
    }

    public UpdateBuilder addDeleteQuads(Collection<Quad> collection) {
        this.deletes.add(new QuadCollectionHolder(collection));
        return this;
    }

    public UpdateBuilder addDelete(Object s, Object p, Object o) {
        this.addDelete(new Triple(this.makeNode(s), this.makeNode(p), this.makeNode(o)));
        return this;
    }

    public UpdateBuilder addDelete(Triple t) {
        this.deletes.add(new SingleQuadHolder(t));
        return this;
    }

    public UpdateBuilder addDelete(Object g, Triple t) {
        Quad q = new Quad(this.makeNode(g), t);
        this.deletes.add(new SingleQuadHolder(q));
        return this;
    }

    public UpdateBuilder addDelete(Model model) {
        this.deletes.add(new ModelQuadHolder(model));
        return this;
    }

    public UpdateBuilder addDelete(Collection<Triple> collection) {
        this.deletes.add(new CollectionQuadHolder(collection));
        return this;
    }

    public UpdateBuilder addDelete(Iterator<Triple> iter) {
        this.deletes.add(new CollectionQuadHolder(iter));
        return this;
    }

    public UpdateBuilder addDelete(Object g, Model model) {
        this.deletes.add(new ModelQuadHolder(this.makeNode(g), model));
        return this;
    }

    public UpdateBuilder addDelete(Object g, Collection<Triple> collection) {
        this.deletes.add(new CollectionQuadHolder(this.makeNode(g), collection));
        return this;
    }

    public UpdateBuilder addDelete(Object g, Iterator<Triple> iter) {
        this.deletes.add(new CollectionQuadHolder(this.makeNode(g), iter));
        return this;
    }

    public UpdateBuilder addDelete(AbstractQueryBuilder<?> queryBuilder) {
        this.deletes.add(new QBQuadHolder(queryBuilder));
        return this;
    }

    public UpdateBuilder addDelete(Object graph, AbstractQueryBuilder<?> queryBuilder) {
        this.deletes.add(new QBQuadHolder(this.makeNode(graph), queryBuilder));
        return this;
    }

    public UpdateBuilder addPrefix(String pfx, Resource uri) {
        return this.addPrefix(pfx, uri.getURI());
    }

    public UpdateBuilder addPrefix(String pfx, Node uri) {
        return this.addPrefix(pfx, uri.getURI());
    }

    public UpdateBuilder addPrefix(String pfx, String uri) {
        this.prefixHandler.addPrefix(pfx, uri);
        return this;
    }

    public UpdateBuilder addPrefixes(Map<String, String> prefixes) {
        this.prefixHandler.addPrefixes(prefixes);
        return this;
    }

    public UpdateBuilder addPrefixes(PrefixMapping prefixes) {
        this.prefixHandler.addPrefixes(prefixes);
        return this;
    }

    public ExprFactory getExprFactory() {
        return this.prefixHandler.getExprFactory();
    }

    public void setVar(Var var, Node value) {
        if (value == null) {
            this.values.remove(var);
        } else {
            this.values.put(var, value);
        }
    }

    public void setVar(Object var, Object value) {
        if (value == null) {
            this.setVar(Converters.makeVar(var), null);
        } else {
            this.setVar(Converters.makeVar(var), this.makeNode(value));
        }
    }

    private Quad check(Quad q) {
        if (Var.isVar((Node)q.getGraph())) {
            throw new QueryParseException("Variables not permitted in data quad", -1, -1);
        }
        if (Var.isVar((Node)q.getSubject()) || Var.isVar((Node)q.getPredicate()) || Var.isVar((Node)q.getObject())) {
            throw new QueryParseException("Variables not permitted in data quad", -1, -1);
        }
        if (q.getSubject().isLiteral()) {
            throw new QueryParseException("Literals not allowed as subjects in data", -1, -1);
        }
        return q;
    }

    public UpdateBuilder addAll(WhereHandler whereHandler) {
        this.whereProcessor.addAll(whereHandler);
        return this;
    }

    public UpdateBuilder addWhere(TriplePath t) throws IllegalArgumentException {
        this.whereProcessor.addWhere(t);
        return this;
    }

    public UpdateBuilder addWhere(WhereClause<?> whereClause) throws IllegalArgumentException {
        this.whereProcessor.addAll(whereClause.getWhereHandler());
        return this;
    }

    public UpdateBuilder addOptional(TriplePath t) throws IllegalArgumentException {
        this.whereProcessor.addOptional(t);
        return this;
    }

    public UpdateBuilder addOptional(WhereHandler whereHandler) {
        this.whereProcessor.addOptional(whereHandler);
        return this;
    }

    public UpdateBuilder addFilter(String expression) throws ParseException {
        this.whereProcessor.addFilter(expression);
        return this;
    }

    public UpdateBuilder addSubQuery(AbstractQueryBuilder<?> subQuery) {
        this.whereProcessor.addSubQuery(subQuery);
        return this;
    }

    public UpdateBuilder addUnion(AbstractQueryBuilder<?> subQuery) {
        this.whereProcessor.addUnion(subQuery);
        return this;
    }

    public UpdateBuilder addGraph(Node graph, WhereHandler subQuery) {
        this.whereProcessor.addGraph(graph, subQuery);
        return this;
    }

    public UpdateBuilder addBind(Expr expr, Var var) {
        this.whereProcessor.addBind(expr, var);
        return this;
    }

    public UpdateBuilder addBind(String expression, Var var) throws ParseException {
        this.whereProcessor.addBind(expression, var);
        return this;
    }

    public Node list(Object ... objs) {
        Node retval;
        Node lastObject = retval = NodeFactory.createBlankNode();
        for (int i = 0; i < objs.length; ++i) {
            Node n = this.makeNode(objs[i]);
            this.addWhere(new TriplePath(new Triple(lastObject, RDF.first.asNode(), n)));
            if (i + 1 < objs.length) {
                Node nextObject = NodeFactory.createBlankNode();
                this.addWhere(new TriplePath(new Triple(lastObject, RDF.rest.asNode(), nextObject)));
                lastObject = nextObject;
                continue;
            }
            this.addWhere(new TriplePath(new Triple(lastObject, RDF.rest.asNode(), RDF.nil.asNode())));
        }
        return retval;
    }

    public UpdateBuilder addWhere(Triple t) {
        return this.addWhere(new TriplePath(t));
    }

    public UpdateBuilder addWhere(FrontsTriple t) {
        return this.addWhere(t.asTriple());
    }

    public UpdateBuilder addWhere(Object s, Object p, Object o) {
        return this.addWhere(this.makeTriplePath(s, p, o));
    }

    public UpdateBuilder addOptional(Triple t) {
        return this.addOptional(new TriplePath(t));
    }

    public UpdateBuilder addOptional(FrontsTriple t) {
        return this.addOptional(t.asTriple());
    }

    public UpdateBuilder addOptional(Object s, Object p, Object o) {
        return this.addOptional(this.makeTriplePath(s, p, o));
    }

    public UpdateBuilder addOptional(AbstractQueryBuilder<?> t) {
        this.whereProcessor.addOptional(t.getWhereHandler());
        return this;
    }

    public UpdateBuilder addFilter(Expr expression) {
        this.whereProcessor.addFilter(expression);
        return this;
    }

    public UpdateBuilder addGraph(Object graph, AbstractQueryBuilder<?> subQuery) {
        this.whereProcessor.addGraph(this.makeNode(graph), subQuery.getWhereHandler());
        return this;
    }

    public UpdateBuilder addBind(Expr expression, Object var) {
        this.whereProcessor.addBind(expression, this.makeVar(var));
        return this;
    }

    public UpdateBuilder addBind(String expression, Object var) throws ParseException {
        this.whereProcessor.addBind(expression, this.makeVar(var));
        return this;
    }

    public UpdateBuilder addMinus(AbstractQueryBuilder<?> t) {
        this.whereProcessor.addMinus(t);
        return this;
    }

    public UpdateBuilder with(Object iri) {
        Node n;
        if (iri == null) {
            this.with = null;
        }
        if ((n = this.makeNode(iri)).isLiteral()) {
            throw new IllegalArgumentException(String.format("IRI '%s' must not be a literal", iri));
        }
        this.with = n;
        return this;
    }

    public UpdateDeleteWhere buildDeleteWhere() {
        QuadAcc quadAcc = new QuadAcc(this.whereProcessor.getQuads().toList());
        return new UpdateDeleteWhere(quadAcc);
    }

    public UpdateDeleteWhere buildDeleteWhere(AbstractQueryBuilder<?> queryBuilder) {
        QuadAcc quadAcc = new QuadAcc(new QBQuadHolder(queryBuilder).getQuads().toList());
        return new UpdateDeleteWhere(quadAcc);
    }
}

