/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.util;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class Dialogs {
    private static File lastAccess = new File(System.getProperty("user.home"));
    private static int defaultWidth = 400;

    public static void setLastAccess(File f) {
        if (f != null) {
            lastAccess = f;
        }
    }

    public static void setDefaultWidth(int width) {
        if (width > 0) {
            defaultWidth = width;
        }
    }

    public static synchronized File[] selectFilesDialog(File dir, FileFilter[] fileFilter) {
        JFileChooser fChooser = Dialogs.getFileChooser(dir, fileFilter);
        fChooser.setCurrentDirectory(lastAccess);
        fChooser.setFileSelectionMode(0);
        fChooser.setAcceptAllFileFilterUsed(false);
        fChooser.setMultiSelectionEnabled(true);
        if (fChooser.showOpenDialog(null) == 0) {
            File[] files = fChooser.getSelectedFiles();
            if (files != null && files.length > 0) {
                lastAccess = files[0];
            }
            return files;
        }
        return null;
    }

    public static synchronized File[] selectDirectoriesDialog(File dir, FileFilter[] fileFilter, boolean save) {
        JFileChooser fChooser = Dialogs.getFileChooser(dir, fileFilter);
        fChooser.setCurrentDirectory(lastAccess);
        fChooser.setFileSelectionMode(1);
        fChooser.setAcceptAllFileFilterUsed(false);
        fChooser.setMultiSelectionEnabled(true);
        if (fChooser.showOpenDialog(null) == 0) {
            File[] files = fChooser.getSelectedFiles();
            if (files != null && files.length > 0) {
                lastAccess = files[0];
            }
            return files;
        }
        return null;
    }

    public static synchronized File selectDirectoryDialog(File dir, FileFilter[] fileFilter, boolean save) {
        JFileChooser fChooser = Dialogs.getFileChooser(dir, fileFilter);
        fChooser.setCurrentDirectory(lastAccess);
        fChooser.setFileSelectionMode(1);
        fChooser.setAcceptAllFileFilterUsed(false);
        File file = null;
        if (save) {
            if (fChooser.showSaveDialog(null) == 0) {
                file = fChooser.getSelectedFile();
            }
        } else if (fChooser.showOpenDialog(null) == 0) {
            file = fChooser.getSelectedFile();
        }
        if (file != null) {
            lastAccess = new File(file + File.separator);
        }
        return file;
    }

    public static synchronized File selectFileDialog(File dir, FileFilter[] fileFilter, boolean save) {
        if (dir.isFile()) {
            return Dialogs.selectFileDialog(dir, dir.getName(), fileFilter, save);
        }
        return Dialogs.selectFileDialog(dir, null, fileFilter, save);
    }

    public static synchronized File selectFileDialog(File dir, String name, FileFilter[] fileFilter, boolean save) {
        JFileChooser fChooser = Dialogs.getFileChooser(dir, fileFilter);
        fChooser.setDialogTitle("Select a TBox CSV template file.");
        fChooser.setCurrentDirectory(lastAccess);
        fChooser.setFileSelectionMode(0);
        fChooser.setAcceptAllFileFilterUsed(false);
        if (name != null) {
            fChooser.setSelectedFile(new File(dir.getAbsolutePath() + File.separator + name));
        }
        File file = null;
        if (save) {
            if (fChooser.showSaveDialog(null) == 0) {
                file = fChooser.getSelectedFile();
            }
        } else if (fChooser.showOpenDialog(null) == 0) {
            file = fChooser.getSelectedFile();
        }
        if (file != null) {
            lastAccess = file;
        }
        return file;
    }

    public static synchronized File showOpenDialog(File dir, FileFilter[] fileFilter) {
        JFileChooser fChooser = Dialogs.getFileChooser(dir, fileFilter);
        fChooser.setCurrentDirectory(lastAccess);
        if (fChooser.showOpenDialog(null) == 0) {
            File file = fChooser.getSelectedFile();
            if (file != null) {
                lastAccess = file;
            }
            return file;
        }
        return null;
    }

    public static int showYesNoConfirmDialog(String msg, String title, int msgType) {
        return JOptionPane.showConfirmDialog(null, "<html><p style='width: " + defaultWidth + "px;'>" + msg + "</html>", title, 0, msgType);
    }

    public static synchronized int showYesNoCancelConfirmDialog(String msg, String title, int msgType) {
        return JOptionPane.showConfirmDialog(null, "<html><p style='width: " + defaultWidth + "px;'>" + msg + "</html>", title, 1, msgType);
    }

    public static synchronized File showSaveDialog(FileFilter[] fileFilter, boolean checkOverwritting) {
        File file;
        block2: {
            do {
                if ((file = Dialogs.showSaveDialog(null, fileFilter)) == null) {
                    return null;
                }
                if (!file.exists()) break block2;
            } while (Dialogs.showYesNoConfirmDialog("File '" + file.getName() + "' already exists.<br>Do you want to choose another file name?", "File name", 2) != 1);
            return file;
        }
        return file;
    }

    public static synchronized File showSaveDialog(String defaultName, FileFilter[] fileFilter, boolean checkOverwritting) {
        File file;
        block2: {
            do {
                if ((file = Dialogs.showSaveDialog(defaultName, fileFilter)) == null) {
                    return null;
                }
                if (!file.exists()) break block2;
            } while (Dialogs.showYesNoConfirmDialog("File '" + file.getName() + "' already exists.<br>Do you want to choose another file name?", "File name", 2) != 1);
            return file;
        }
        return file;
    }

    public static synchronized File showSaveDialog(String defaultFileName, FileFilter[] fileFilter) {
        JFileChooser fChooser = Dialogs.getFileChooser(null, fileFilter);
        fChooser.setCurrentDirectory(lastAccess);
        if (defaultFileName != null) {
            fChooser.setSelectedFile(new File(defaultFileName));
        }
        if (fChooser.showSaveDialog(null) == 0) {
            File file = fChooser.getSelectedFile();
            if (file != null) {
                lastAccess = file;
            }
            return file;
        }
        return null;
    }

    public static synchronized void showInfoDialog(String msg, String title) {
        JOptionPane.showMessageDialog(null, msg, title, 1);
    }

    public static synchronized void showErrorDialog(String msg, String title) {
        JOptionPane.showMessageDialog(null, "<html><p style='width: " + defaultWidth + "px;'>" + msg + "</html>", title, 0);
    }

    public static synchronized void showWarningDialog(String msg, String title) {
        JOptionPane.showMessageDialog(null, "<html><p style='width: " + defaultWidth + "px;'>" + msg + "</html>", title, 2);
    }

    public static synchronized JFileChooser getFileChooser(File dir, FileFilter[] fileFilter) {
        JFileChooser fChooser = new JFileChooser();
        if (dir != null) {
            fChooser.setCurrentDirectory(dir);
        }
        if (fileFilter != null && fileFilter.length != 0) {
            for (FileFilter fFilter : fileFilter) {
                fChooser.addChoosableFileFilter(fFilter);
            }
        }
        return fChooser;
    }
}

