/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.timeseries;

import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.TripleStoreClientInterface;
import uk.ac.cam.cares.jps.base.query.RemoteStoreClient;
import uk.ac.cam.cares.jps.base.timeseries.TimeSeries;
import uk.ac.cam.cares.jps.base.timeseries.TimeSeriesRDBClient;
import uk.ac.cam.cares.jps.base.timeseries.TimeSeriesSparql;

public class TimeSeriesClient<T> {
    private TimeSeriesRDBClient<T> rdbClient;
    private TimeSeriesSparql rdfClient;
    private final String exceptionPrefix = this.getClass().getSimpleName() + ": ";

    public TimeSeriesClient(TripleStoreClientInterface kbClient, Class<T> timeClass) {
        this.rdfClient = new TimeSeriesSparql(kbClient);
        this.rdbClient = new TimeSeriesRDBClient<T>(timeClass);
    }

    public void setKBClient(TripleStoreClientInterface kbClient) {
        this.rdfClient.setKBClient(kbClient);
    }

    public void initTimeSeries(List<String> dataIRIs, List<Class<?>> dataClass, String timeUnit, Connection conn) {
        String tsIRI = "http://www.theworldavatar.com/kb/ontotimeseries/Timeseries_" + UUID.randomUUID();
        try {
            this.rdfClient.initTS(tsIRI, dataIRIs, conn.getMetaData().getURL(), timeUnit);
        }
        catch (Exception e_RdfCreate) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", e_RdfCreate);
        }
        try {
            this.rdbClient.initTimeSeriesTable(dataIRIs, dataClass, tsIRI, conn);
        }
        catch (JPSRuntimeException e_RdbCreate) {
            try {
                this.rdfClient.removeTimeSeries(tsIRI);
            }
            catch (Exception e_RdfDelete) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when initialising time series " + tsIRI + " , as database related instantiation failed but KG triples were created.");
            }
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", e_RdbCreate);
        }
    }

    public void bulkInitTimeSeries(List<List<String>> dataIRIs, List<List<Class<?>>> dataClass, List<String> timeUnit, Connection conn) {
        this.bulkInitTimeSeries(dataIRIs, dataClass, timeUnit, null, conn);
    }

    public void bulkInitTimeSeries(List<List<String>> dataIRIs, List<List<Class<?>>> dataClass, List<String> timeUnit, Integer srid, Connection conn) {
        int i;
        ArrayList<String> tsIRIs = new ArrayList<String>(dataIRIs.size());
        for (i = 0; i < dataIRIs.size(); ++i) {
            String tsIRI = "http://www.theworldavatar.com/kb/ontotimeseries/Timeseries_" + UUID.randomUUID();
            tsIRIs.add(i, tsIRI);
        }
        try {
            this.rdfClient.bulkInitTS(tsIRIs, dataIRIs, conn.getMetaData().getURL(), timeUnit);
        }
        catch (Exception e_RdfCreate) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", e_RdfCreate);
        }
        for (i = 0; i < dataIRIs.size(); ++i) {
            try {
                this.rdbClient.initTimeSeriesTable(dataIRIs.get(i), dataClass.get(i), (String)tsIRIs.get(i), srid, conn);
                continue;
            }
            catch (JPSRuntimeException e_RdbCreate) {
                try {
                    this.rdfClient.removeTimeSeries((String)tsIRIs.get(i));
                }
                catch (Exception e_RdfDelete) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when initialising time series " + (String)tsIRIs.get(i) + " , as database related instantiation failed but KG triples were created.");
                }
                throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", e_RdbCreate);
            }
        }
    }

    public void addTimeSeriesData(TimeSeries<T> ts, Connection conn) {
        ArrayList ts_list = new ArrayList();
        ts_list.add(ts);
        this.rdbClient.addTimeSeriesData(ts_list, conn);
    }

    public void bulkaddTimeSeriesData(List<TimeSeries<T>> ts_list, Connection conn) {
        this.rdbClient.addTimeSeriesData(ts_list, conn);
    }

    public void deleteTimeSeriesHistory(String dataIRI, T lowerBound, T upperBound, Connection conn) {
        this.rdbClient.deleteRows(dataIRI, lowerBound, upperBound, conn);
    }

    public void deleteIndividualTimeSeries(String dataIRI, Connection conn) {
        String tsIRI = this.rdfClient.getTimeSeries(dataIRI);
        if (tsIRI == null) {
            throw new JPSRuntimeException(this.exceptionPrefix + "DataIRI " + dataIRI + " not associated with any timeseries.");
        }
        if (this.rdfClient.getAssociatedData(tsIRI).size() == 1) {
            this.deleteTimeSeries(tsIRI, conn);
        } else {
            try {
                this.rdfClient.removeTimeSeriesAssociation(dataIRI);
            }
            catch (Exception e_RdfDelete) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries association for " + dataIRI + " was not deleted!", e_RdfDelete);
            }
            try {
                this.rdbClient.deleteTimeSeries(dataIRI, conn);
            }
            catch (JPSRuntimeException e_RdbDelete) {
                try {
                    this.rdfClient.insertTimeSeriesAssociation(dataIRI, tsIRI);
                }
                catch (Exception e_RdfCreate) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when deleting time series association for " + dataIRI + " , as database related deletion failed but KG triples were deleted.");
                }
                throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries association for " + dataIRI + " was not deleted!", e_RdbDelete);
            }
        }
    }

    public void deleteTimeSeries(String tsIRI, Connection conn) {
        if (!this.rdfClient.checkTimeSeriesExists(tsIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + tsIRI + " does not exist in KG");
        }
        List<String> dataIRIs = this.rdfClient.getAssociatedData(tsIRI);
        String timeUnit = this.rdfClient.getTimeUnit(tsIRI);
        try {
            this.rdfClient.removeTimeSeries(tsIRI);
        }
        catch (Exception e_RdfDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries " + tsIRI + " was not deleted!", e_RdfDelete);
        }
        try {
            this.rdbClient.deleteTimeSeriesTable(dataIRIs.get(0), conn);
        }
        catch (JPSRuntimeException e_RdbDelete) {
            try {
                String rdbUrl = conn.isClosed() ? "" : conn.getMetaData().getURL();
                this.rdfClient.initTS(tsIRI, dataIRIs, rdbUrl, timeUnit);
            }
            catch (Exception e_RdfCreate) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when deleting time series " + tsIRI + " , as database related deletion failed but KG triples were deleted.", e_RdfCreate);
            }
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries " + tsIRI + " was not deleted!", e_RdbDelete);
        }
    }

    public void deleteAll(Connection conn) {
        try {
            this.rdfClient.removeAllTimeSeries();
        }
        catch (Exception e_RdfDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Not all timeseries were deleted from KG! Potentially inconsistent state between KG and database", e_RdfDelete);
        }
        try {
            this.rdbClient.deleteAll(conn);
        }
        catch (JPSRuntimeException e_RdbDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Not all timeseries were deleted from database! Potentially inconsistent state between KG and database", e_RdbDelete);
        }
    }

    public TimeSeries<T> getLatestData(String dataIRI, Connection conn) {
        return this.rdbClient.getLatestData(dataIRI, conn);
    }

    public TimeSeries<T> getOldestData(String dataIRI, Connection conn) {
        return this.rdbClient.getOldestData(dataIRI, conn);
    }

    public TimeSeries<T> getTimeSeriesWithinBounds(List<String> dataIRIs, T lowerBound, T upperBound, Connection conn) {
        return this.rdbClient.getTimeSeriesWithinBounds(dataIRIs, lowerBound, upperBound, conn);
    }

    public TimeSeries<T> getTimeSeries(List<String> dataIRIs, Connection conn) {
        return this.getTimeSeriesWithinBounds(dataIRIs, null, null, conn);
    }

    public double getAverage(String dataIRI, Connection conn) {
        return this.rdbClient.getAverage(dataIRI, conn);
    }

    public double getMaxValue(String dataIRI, Connection conn) {
        return this.rdbClient.getMaxValue(dataIRI, conn);
    }

    public double getMinValue(String dataIRI, Connection conn) {
        return this.rdbClient.getMinValue(dataIRI, conn);
    }

    public T getMaxTime(String dataIRI, Connection conn) {
        return this.rdbClient.getMaxTime(dataIRI, conn);
    }

    public T getMinTime(String dataIRI, Connection conn) {
        return this.rdbClient.getMinTime(dataIRI, conn);
    }

    public boolean checkTimeSeriesExists(String tsIRI) {
        return this.rdfClient.checkTimeSeriesExists(tsIRI);
    }

    public boolean checkDataHasTimeSeries(String dataIRI, Connection conn) {
        return this.rdbClient.checkDataHasTimeSeries(dataIRI, conn);
    }

    public boolean checkTimeUnitExists(String tsIRI) {
        return this.rdfClient.checkTimeUnitExists(tsIRI);
    }

    public int countTimeSeries() {
        return this.rdfClient.countTS();
    }

    public String getTimeSeriesIRI(String dataIRI) {
        return this.rdfClient.getTimeSeries(dataIRI);
    }

    public String getDbUrl(String tsIRI) {
        return this.rdfClient.getDbUrl(tsIRI);
    }

    public String getTimeUnit(String tsIRI) {
        return this.rdfClient.getTimeUnit(tsIRI);
    }

    public List<String> getAssociatedData(String tsIRI) {
        return this.rdfClient.getAssociatedData(tsIRI);
    }

    public List<String> getAllTimeSeries() {
        return this.rdfClient.getAllTimeSeries();
    }

    public JSONArray convertToJSON(List<TimeSeries<T>> ts_list, List<Integer> id, List<Map<String, String>> units_map, List<Map<String, String>> table_header_map) {
        JSONArray ts_array = new JSONArray();
        for (int i = 0; i < ts_list.size(); ++i) {
            TimeSeries<T> ts = ts_list.get(i);
            JSONObject ts_jo = new JSONObject();
            List<String> dataIRIs = ts.getDataIRIs();
            ts_jo.put("id", id.get(i));
            if (ts.getTimes().size() > 0) {
                if (ts.getTimes().get(0) instanceof Number) {
                    ts_jo.put("timeClass", Number.class.getSimpleName());
                } else {
                    ts_jo.put("timeClass", ts.getTimes().get(0).getClass().getSimpleName());
                }
            }
            if (table_header_map != null) {
                ArrayList<String> table_header = new ArrayList<String>();
                for (String dataIRI : dataIRIs) {
                    table_header.add(table_header_map.get(i).get(dataIRI));
                }
                ts_jo.put("data", table_header);
            } else {
                ts_jo.put("data", dataIRIs);
            }
            ArrayList<String> units = new ArrayList<String>();
            for (String dataIRI : dataIRIs) {
                units.add(units_map.get(i).get(dataIRI));
            }
            ts_jo.put("units", units);
            ts_jo.put("time", ts.getTimes());
            JSONArray values = new JSONArray();
            JSONArray valuesClass = new JSONArray();
            for (int j = 0; j < dataIRIs.size(); ++j) {
                List<?> valueslist = ts.getValues(dataIRIs.get(j));
                values.put(valueslist);
                String vClass = "Unknown";
                for (Object value : valueslist) {
                    if (value == null) continue;
                    if (value instanceof Number) {
                        vClass = Number.class.getSimpleName();
                        break;
                    }
                    vClass = value.getClass().getSimpleName();
                    break;
                }
                valuesClass.put(vClass);
            }
            ts_jo.put("values", values);
            ts_jo.put("valuesClass", valuesClass);
            ts_array.put(ts_jo);
        }
        return ts_array;
    }

    @Deprecated
    public TimeSeriesClient(TripleStoreClientInterface kbClient, Class<T> timeClass, String rdbURL, String user, String password) {
        this.rdfClient = new TimeSeriesSparql(kbClient);
        this.rdbClient = new TimeSeriesRDBClient<T>(timeClass);
        this.rdbClient.setRdbURL(rdbURL);
        this.rdbClient.setRdbUser(user);
        this.rdbClient.setRdbPassword(password);
    }

    @Deprecated
    public TimeSeriesClient(TripleStoreClientInterface kbClient, Class<T> timeClass, String filepath) throws IOException {
        this.rdfClient = new TimeSeriesSparql(kbClient);
        this.rdbClient = new TimeSeriesRDBClient<T>(timeClass);
        this.loadRdbConfigs(filepath);
    }

    @Deprecated
    public TimeSeriesClient(Class<T> timeClass, String filepath) throws IOException {
        RemoteStoreClient kbClient = new RemoteStoreClient();
        this.rdfClient = new TimeSeriesSparql(kbClient);
        this.loadSparqlConfigs(filepath);
        this.rdbClient = new TimeSeriesRDBClient<T>(timeClass);
        this.loadRdbConfigs(filepath);
    }

    @Deprecated
    private void loadSparqlConfigs(String filepath) throws IOException {
        this.rdfClient.loadSparqlConfigs(filepath);
    }

    @Deprecated
    private void loadRdbConfigs(String filepath) throws IOException {
        this.rdbClient.loadRdbConfigs(filepath);
    }

    @Deprecated
    public void setRDBClient(String rdbURL, String user, String password) {
        this.rdbClient.setRdbURL(rdbURL);
        this.rdbClient.setRdbUser(user);
        this.rdbClient.setRdbPassword(password);
    }

    @Deprecated
    public void initTimeSeries(List<String> dataIRIs, List<Class<?>> dataClass, String timeUnit) {
        String tsIRI = "http://www.theworldavatar.com/kb/ontotimeseries/Timeseries_" + UUID.randomUUID();
        try {
            this.rdfClient.initTS(tsIRI, dataIRIs, this.rdbClient.getRdbURL(), timeUnit);
        }
        catch (Exception e_RdfCreate) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", e_RdfCreate);
        }
        try {
            this.rdbClient.initTimeSeriesTable(dataIRIs, dataClass, tsIRI);
        }
        catch (JPSRuntimeException e_RdbCreate) {
            try {
                this.rdfClient.removeTimeSeries(tsIRI);
            }
            catch (Exception e_RdfDelete) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when initialising time series " + tsIRI + " , as database related instantiation failed but KG triples were created.");
            }
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", e_RdbCreate);
        }
    }

    @Deprecated
    public void bulkInitTimeSeries(List<List<String>> dataIRIs, List<List<Class<?>>> dataClass, List<String> timeUnit) {
        this.bulkInitTimeSeries(dataIRIs, dataClass, timeUnit, (Integer)null);
    }

    @Deprecated
    public void bulkInitTimeSeries(List<List<String>> dataIRIs, List<List<Class<?>>> dataClass, List<String> timeUnit, Integer srid) {
        int i;
        ArrayList<String> tsIRIs = new ArrayList<String>(dataIRIs.size());
        for (i = 0; i < dataIRIs.size(); ++i) {
            String tsIRI = "http://www.theworldavatar.com/kb/ontotimeseries/Timeseries_" + UUID.randomUUID();
            tsIRIs.add(i, tsIRI);
        }
        try {
            this.rdfClient.bulkInitTS(tsIRIs, dataIRIs, this.rdbClient.getRdbURL(), timeUnit);
        }
        catch (Exception e_RdfCreate) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", e_RdfCreate);
        }
        for (i = 0; i < dataIRIs.size(); ++i) {
            try {
                this.rdbClient.initTimeSeriesTable(dataIRIs.get(i), dataClass.get(i), (String)tsIRIs.get(i), srid);
                continue;
            }
            catch (JPSRuntimeException e_RdbCreate) {
                try {
                    this.rdfClient.removeTimeSeries((String)tsIRIs.get(i));
                }
                catch (Exception e_RdfDelete) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when initialising time series " + (String)tsIRIs.get(i) + " , as database related instantiation failed but KG triples were created.");
                }
                throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", e_RdbCreate);
            }
        }
    }

    @Deprecated
    public void addTimeSeriesData(TimeSeries<T> ts) {
        ArrayList ts_list = new ArrayList();
        ts_list.add(ts);
        this.rdbClient.addTimeSeriesData(ts_list);
    }

    @Deprecated
    public void bulkaddTimeSeriesData(List<TimeSeries<T>> ts_list) {
        this.rdbClient.addTimeSeriesData(ts_list);
    }

    @Deprecated
    public void deleteTimeSeriesHistory(String dataIRI, T lowerBound, T upperBound) {
        this.rdbClient.deleteRows(dataIRI, lowerBound, upperBound);
    }

    @Deprecated
    public void deleteIndividualTimeSeries(String dataIRI) {
        String tsIRI = this.rdfClient.getTimeSeries(dataIRI);
        if (tsIRI == null) {
            throw new JPSRuntimeException(this.exceptionPrefix + "DataIRI " + dataIRI + " not associated with any timeseries.");
        }
        if (this.rdfClient.getAssociatedData(tsIRI).size() == 1) {
            this.deleteTimeSeries(tsIRI);
        } else {
            try {
                this.rdfClient.removeTimeSeriesAssociation(dataIRI);
            }
            catch (Exception e_RdfDelete) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries association for " + dataIRI + " was not deleted!", e_RdfDelete);
            }
            try {
                this.rdbClient.deleteTimeSeries(dataIRI);
            }
            catch (JPSRuntimeException e_RdbDelete) {
                try {
                    this.rdfClient.insertTimeSeriesAssociation(dataIRI, tsIRI);
                }
                catch (Exception e_RdfCreate) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when deleting time series association for " + dataIRI + " , as database related deletion failed but KG triples were deleted.");
                }
                throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries association for " + dataIRI + " was not deleted!", e_RdbDelete);
            }
        }
    }

    @Deprecated
    public void deleteTimeSeries(String tsIRI) {
        if (!this.rdfClient.checkTimeSeriesExists(tsIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + tsIRI + " does not exist in KG");
        }
        List<String> dataIRIs = this.rdfClient.getAssociatedData(tsIRI);
        String timeUnit = this.rdfClient.getTimeUnit(tsIRI);
        try {
            this.rdfClient.removeTimeSeries(tsIRI);
        }
        catch (Exception e_RdfDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries " + tsIRI + " was not deleted!", e_RdfDelete);
        }
        try {
            this.rdbClient.deleteTimeSeriesTable(dataIRIs.get(0));
        }
        catch (JPSRuntimeException e_RdbDelete) {
            try {
                this.rdfClient.initTS(tsIRI, dataIRIs, this.rdbClient.getRdbURL(), timeUnit);
            }
            catch (Exception e_RdfCreate) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when deleting time series " + tsIRI + " , as database related deletion failed but KG triples were deleted.");
            }
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries " + tsIRI + " was not deleted!", e_RdbDelete);
        }
    }

    @Deprecated
    public void deleteAll() {
        try {
            this.rdfClient.removeAllTimeSeries();
        }
        catch (Exception e_RdfDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Not all timeseries were deleted from KG! Potentially inconsistent state between KG and database", e_RdfDelete);
        }
        try {
            this.rdbClient.deleteAll();
        }
        catch (JPSRuntimeException e_RdbDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Not all timeseries were deleted from database! Potentially inconsistent state between KG and database", e_RdbDelete);
        }
    }

    @Deprecated
    public TimeSeries<T> getLatestData(String dataIRI) {
        return this.rdbClient.getLatestData(dataIRI);
    }

    @Deprecated
    public TimeSeries<T> getOldestData(String dataIRI) {
        return this.rdbClient.getOldestData(dataIRI);
    }

    @Deprecated
    public TimeSeries<T> getTimeSeriesWithinBounds(List<String> dataIRIs, T lowerBound, T upperBound) {
        return this.rdbClient.getTimeSeriesWithinBounds(dataIRIs, lowerBound, upperBound);
    }

    @Deprecated
    public TimeSeries<T> getTimeSeries(List<String> dataIRIs) {
        return this.getTimeSeriesWithinBounds(dataIRIs, null, null);
    }

    @Deprecated
    public double getAverage(String dataIRI) {
        return this.rdbClient.getAverage(dataIRI);
    }

    @Deprecated
    public double getMaxValue(String dataIRI) {
        return this.rdbClient.getMaxValue(dataIRI);
    }

    @Deprecated
    public double getMinValue(String dataIRI) {
        return this.rdbClient.getMinValue(dataIRI);
    }

    @Deprecated
    public T getMaxTime(String dataIRI) {
        return this.rdbClient.getMaxTime(dataIRI);
    }

    @Deprecated
    public T getMinTime(String dataIRI) {
        return this.rdbClient.getMinTime(dataIRI);
    }

    @Deprecated
    public boolean checkDataHasTimeSeries(String dataIRI) {
        return this.rdbClient.checkDataHasTimeSeries(dataIRI);
    }

    @Deprecated
    public void disconnectRDB() {
        this.rdbClient.disconnect();
    }
}

