/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query.fed;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.rdf4j.federated.FedXConfig;
import org.eclipse.rdf4j.federated.FedXFactory;
import org.eclipse.rdf4j.federated.monitoring.MonitoringUtil;
import org.eclipse.rdf4j.federated.monitoring.QueryPlanLog;
import org.eclipse.rdf4j.federated.repository.FedXRepository;
import org.eclipse.rdf4j.federated.repository.FedXRepositoryConnection;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.resultio.sparqljson.SPARQLResultsJSONWriter;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.query.JenaResultSetFormatter;
import uk.ac.cam.cares.jps.base.query.RemoteStoreClient;
import uk.ac.cam.cares.jps.base.query.fed.BlazegraphRepositoryWrapper;
import uk.ac.cam.cares.jps.base.query.fed.DataSourceSelector;
import uk.ac.cam.cares.jps.base.query.fed.FederatedQueryInterface;
import uk.ac.cam.cares.jps.base.query.fed.ServiceDescriptionIndexer;

public class FederatedQueryFactory {
    static final Logger LOGGER = LogManager.getLogger(FederatedQueryFactory.class);
    private static ServiceDescriptionIndexer indexer = null;

    public static FederatedQueryInterface createFedX(List<String> federationMembers) {
        LOGGER.debug("create FedX with federation members=" + federationMembers.size());
        FedXConfig config = new FedXConfig().withEnableMonitoring(true).withLogQueryPlan(true).withDebugQueryPlan(true).withLogQueries(true);
        final FedXRepository repository = FedXFactory.newFederation().withSparqlEndpoints(federationMembers).withConfig(config).create();
        FederatedQueryInterface impl = new FederatedQueryInterface(){

            @Override
            public String executeFederatedQuery(String sparql) {
                LOGGER.debug("FedX executeQuery=\n" + sparql);
                String resultJson = null;
                try (FedXRepositoryConnection conn = repository.getConnection();){
                    TupleQuery query = conn.prepareTupleQuery(sparql);
                    try (TupleQueryResult result = query.evaluate();){
                        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                            SPARQLResultsJSONWriter writer = new SPARQLResultsJSONWriter(out);
                            LinkedList<String> columnHeaders = new LinkedList<String>();
                            columnHeaders.addAll(result.getBindingNames());
                            writer.startQueryResult(columnHeaders);
                            while (result.hasNext()) {
                                BindingSet b = (BindingSet)result.next();
                                writer.handleSolution(b);
                            }
                            writer.endQueryResult();
                            resultJson = ((Object)out).toString();
                            resultJson = JenaResultSetFormatter.convertToSimplifiedJsonArray(resultJson).toString();
                        }
                        catch (IOException exc) {
                            throw new JPSRuntimeException(exc);
                        }
                    }
                }
                LOGGER.debug(QueryPlanLog.getQueryPlan());
                MonitoringUtil.printMonitoringInformation(repository.getFederationContext());
                repository.shutDown();
                return resultJson;
            }
        };
        return impl;
    }

    public static FederatedQueryInterface createForQueriesWithGivenEndpoints(String fedEngineUrl) {
        return FederatedQueryFactory.create(fedEngineUrl, null);
    }

    public static FederatedQueryInterface createWithEndpointSelection(String fedEngineUrl, ServiceDescriptionIndexer servDescrIndexer, Map<String, String> host2host) {
        DataSourceSelector selector = new DataSourceSelector(servDescrIndexer, host2host);
        return FederatedQueryFactory.create(fedEngineUrl, selector);
    }

    private static FederatedQueryInterface create(String fedEngineUrl, final DataSourceSelector selector) {
        boolean rdf4j = fedEngineUrl.contains("rdf4j");
        final RemoteStoreClient client = rdf4j ? new RemoteStoreClient(fedEngineUrl) : null;
        final BlazegraphRepositoryWrapper wrapper = rdf4j ? null : new BlazegraphRepositoryWrapper(fedEngineUrl);
        FederatedQueryInterface impl = new FederatedQueryInterface(){

            @Override
            public String executeFederatedQuery(String sparql) {
                LOGGER.debug("executeQuery=\n" + sparql);
                if (selector != null) {
                    sparql = selector.addValuesClauses(sparql);
                    LOGGER.debug("executeQuery after data source selection=\n" + sparql);
                }
                if (wrapper != null) {
                    return wrapper.query(sparql, null);
                }
                return client.executeQuery(sparql).toString();
            }
        };
        return impl;
    }

    public static ServiceDescriptionIndexer getIndexer(boolean cached, List<String> serviceUrls, List<String> endpointUrls) {
        if (cached && indexer != null) {
            return indexer;
        }
        ArrayList<String> allEndpoints = new ArrayList<String>();
        if (serviceUrls != null) {
            for (String serviceUrl : serviceUrls) {
                BlazegraphRepositoryWrapper wrapper = new BlazegraphRepositoryWrapper(serviceUrl);
                List<String> endpoints = wrapper.queryNamespaces(true);
                allEndpoints.addAll(endpoints);
            }
        }
        if (endpointUrls != null) {
            allEndpoints.addAll(endpointUrls);
        }
        if (allEndpoints.isEmpty()) {
            throw new JPSRuntimeException("At least one endpoint is required, serviceUrls=" + serviceUrls + ", endpointUrls=" + endpointUrls);
        }
        indexer = new ServiceDescriptionIndexer();
        for (String url : allEndpoints) {
            indexer.addServiceDescription(url);
        }
        return indexer;
    }
}

