/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query.fed;

import com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONWriter;
import com.bigdata.rdf.sail.webapp.client.IPreparedTupleQuery;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.http.client.methods.HttpGet;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.ResultSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResult;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.http.Http;
import uk.ac.cam.cares.jps.base.query.JenaHelper;
import uk.ac.cam.cares.jps.base.query.JenaResultSetFormatter;

public class BlazegraphRepositoryWrapper {
    static final Logger LOGGER = LogManager.getLogger(BlazegraphRepositoryWrapper.class);
    public static final String BLAZEGRAPH_DEFAULT_NAMESPACE = "kb";
    private String defaultNamespace = null;
    private RemoteRepositoryManager manager = null;

    public BlazegraphRepositoryWrapper(String serviceUrl, String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
        this.manager = new RemoteRepositoryManager(serviceUrl);
        LOGGER.info("initialized with serviceUrl=" + serviceUrl + ", defaultNamespace=" + defaultNamespace);
    }

    public BlazegraphRepositoryWrapper(String serviceOrEndpointUrl) {
        this(BlazegraphRepositoryWrapper.getParts(serviceOrEndpointUrl)[0], BlazegraphRepositoryWrapper.getParts(serviceOrEndpointUrl)[1]);
    }

    public RemoteRepositoryManager getManager() {
        return this.manager;
    }

    public static String[] getParts(String serviceOrEndpointUrl) {
        String serviceUrl = serviceOrEndpointUrl;
        String defaultNamespace = null;
        int i1 = serviceUrl.lastIndexOf("/namespace/");
        int i2 = serviceUrl.lastIndexOf("/sparql");
        if (i1 >= 0 && i2 >= 0) {
            defaultNamespace = serviceUrl.substring(i1 + "/namespace/".length(), i2);
            serviceUrl = serviceUrl.substring(0, i1);
        }
        return new String[]{serviceUrl, defaultNamespace};
    }

    public static String getPathForBlazegraph(String namespace) {
        return "/namespace/" + namespace + "/sparql";
    }

    public Properties getRepositoryProperties(String namespace) {
        try {
            return this.manager.getRepositoryProperties(namespace);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    private RemoteRepository getRepository(String namespace) {
        try {
            return this.manager.getRepositoryForNamespace(namespace);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public void createNamespace(String namespace, Properties props) {
        if (props == null) {
            props = this.getRepositoryProperties(BLAZEGRAPH_DEFAULT_NAMESPACE);
        }
        try {
            this.manager.createRepository(namespace, props);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public String query(String sparql, String namespace) {
        if (namespace == null && (namespace = this.defaultNamespace) == null) {
            throw new JPSRuntimeException("namespace and default namespace are null");
        }
        String resultAsJsonString = null;
        try {
            RemoteRepository repo = this.getRepository(namespace);
            IPreparedTupleQuery query = repo.prepareTupleQuery(sparql);
            TupleQueryResult result = query.evaluate();
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                BigdataSPARQLResultsJSONWriter writer = new BigdataSPARQLResultsJSONWriter(out);
                LinkedList<String> columnHeaders = new LinkedList<String>();
                columnHeaders.addAll(result.getBindingNames());
                writer.startQueryResult(columnHeaders);
                while (result.hasNext()) {
                    BindingSet b = (BindingSet)result.next();
                    writer.handleSolution(b);
                }
                writer.endQueryResult();
                resultAsJsonString = ((Object)out).toString();
                result.close();
            }
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        return JenaResultSetFormatter.convertToSimplifiedJsonArray(resultAsJsonString).toString();
    }

    private String queryNamespacesFull() {
        String url = this.manager.getBaseServiceURL() + "/namespace";
        LOGGER.debug("querying namespaces: " + url);
        String accept = "application/rdf+xml";
        HttpGet request = Http.get(url, accept, new Object[0]);
        return Http.execute(request);
    }

    public List<String> queryNamespaces(boolean asEndpointUrl) {
        String full = this.queryNamespacesFull();
        return this.queryNamespaces(asEndpointUrl, full);
    }

    public List<String> queryNamespaces(boolean asEndpointUrl, String rdfgraphWithNamespaces) {
        OntModel model = JenaHelper.createModel();
        JenaHelper.readFromString(rdfgraphWithNamespaces, model);
        String sparql = "SELECT ?endpoint WHERE { ?dataset a <http://rdfs.org/ns/void#Dataset> . ?dataset <http://rdfs.org/ns/void#sparqlEndpoint> ?endpoint . }";
        ResultSet result = JenaHelper.query(model, sparql);
        String json = JenaResultSetFormatter.convertToJSONW3CStandard(result);
        HashSet<String> endpoints = new HashSet<String>();
        for (String[] row : JenaResultSetFormatter.convertToListofStringArrays(json, "endpoint")) {
            String namespace = row[0];
            if (!asEndpointUrl) {
                namespace = namespace.replaceFirst("/sparql", "");
                int i = namespace.lastIndexOf("/");
                namespace = namespace.substring(i + 1);
            } else {
                for (String s : new String[]{"localhost:9999/blazegraph", "localhost:9999/bigdata/LBS"}) {
                    if (!namespace.contains(s)) continue;
                    String old = namespace;
                    namespace = namespace.replace(s, "www.theworldavatar.com:83/citieskg");
                    LOGGER.warn("changed endpoint url from " + old + " to " + namespace);
                }
            }
            endpoints.add(namespace);
        }
        return new ArrayList<String>(endpoints);
    }

    public void close() {
        try {
            this.manager.close();
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        finally {
            this.manager = null;
        }
    }
}

