/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.listener;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContextEvent;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.ResultSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.cares.jps.base.config.AgentLocator;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.listener.BaseOntologyModelManager;

public class BaseChimneyOntologyModelManager
extends BaseOntologyModelManager {
    private static final String CHIMNEY = "Chimney-1";
    public static final String OWL_CHIMNEY = "Chimney-1.owl";
    protected static final String OWL_CHIMNEY_TEMP = "Chimney-1-temp.owl";
    public static final String CPT_NUMVAL = "#numericalValue";
    public static final String CPT_HASPROP = "#hasProperty";
    public static final String CPT_HASVAL = "#hasValue";
    public static final String CPT_HASUOM = "#hasUnitOfMeasure";
    public static final String CPT_SCLVAL = "#ScalarValue";
    public static final String CPT_CONTAINS = "#contains";
    public static final String CPT_PMAMT = "#ParticulateMaterialAmount";
    public static final String CPT_CONVMFLR = "#ConvectiveMassFlowrate";
    public static final String CPT_SINGPART = "#SingleParticle";
    public static final String CPT_HASREPRPART = "#hasRepresentativeParticle";
    public static final String CPT_SI_M = "SI_unit.owl#m";
    public static final String CPT_SI_GPS = "derived_SI_units.owl#g_per_s";
    public static final String CPT_SI_KGPCM = "derived_SI_units.owl#kg_per_cubic_m";
    public static final String CPT_DIAM = "#Diameter";
    public static final String CPT_HASLEN = "#has_length";
    public static final String CPT_DENS = "#Density";
    public static final String CPT_MASSFR = "#MassFraction";
    public static final String CPT_HASDENS = "#has_density";
    private static final String IRI_ONTOLOGY = "http://www.theworldavatar.com/ontology/";
    private static final String IRI_ONTOCAPE = "http://www.theworldavatar.com/ontology/ontocape/";
    private static final String OWL_ONTOCAPE_UPPER = "http://www.theworldavatar.com/ontology/ontocape/upper_level/";
    private static final String OWL_ONTOCAPE_UPPER_SYSTEM = "http://www.theworldavatar.com/ontology/ontocape/upper_level/system.owl";
    private static final String OWL_ONTOCAPE_CPS_BEHAVIOR = "http://www.theworldavatar.com/ontology/ontocape/chemical_process_system/CPS_behavior/behavior.owl";
    private static final String OWL_ONTOCAPE_SUP_CONCEPTS_SI = "http://www.theworldavatar.com/ontology/ontocape/supporting_concepts/SI_unit/";
    private static final String OWL_ONTOCAPE_SUP_CONCEPTS_GEOM = "http://www.theworldavatar.com/ontology/ontocape/supporting_concepts/geometry/geometry.owl";
    private static final String OWL_ONTOCAPE_MAT_PS = "http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl";
    public static final String SPQ_WASTE = "PREFIX j4:<http://www.theworldavatar.com/ontology/ontocape/chemical_process_system/CPS_function/process.owl#> PREFIX j7:<http://www.theworldavatar.com/ontology/meta_model/topology/topology.owl#> SELECT ?wasteStream \r\nWHERE { ?chimney j7:hasOutput ?wasteStream .  ?wasteStream a j4:NonReusableWasteProduct .}";
    private static final String PATH_KB_BASE = "C://TOMCAT/webapps/ROOT/kb/base/";
    public static final String PATH_KB_BASE_TEST = ABSDIR_ROOT_TEST + "/kb/base/";
    public static final String PATH_BASE_CHIMNEY = "C://TOMCAT/webapps/ROOT/kb/base/Chimney-1-temp.owl";
    public static final String PATH_BASE_CHIMNEY_TEST = PATH_KB_BASE_TEST + "Chimney-1-temp.owl";
    public static final String IRI_KB_BASE = "http://www.theworldavatar.com/kb/base/";
    private static ConcurrentHashMap<String, String> speciesMap = new ConcurrentHashMap();
    private static final Logger LOGGER = LogManager.getLogger(BaseChimneyOntologyModelManager.class);

    public void contextInitialized(ServletContextEvent sce) {
        LOGGER.info("initializing the local ontology manager");
        try {
            baseEntityModel = this.createBaseChimneyModel();
            LOGGER.info("createbase chimney is successful");
        }
        catch (IOException e) {
            LOGGER.error("initializing the local ontology manager failed");
            throw new JPSRuntimeException("Could not create base model for chimney: C://TOMCAT/webapps/ROOT/kb/base/Chimney-1-temp.owl");
        }
        finally {
            this.setConcepts();
            this.setSpecies();
            LOGGER.info("setspecies is finishedspecies map size= " + String.valueOf(speciesMap.size()));
        }
    }

    private OntModel createBaseChimneyModel() throws IOException {
        String content = BaseChimneyOntologyModelManager.getBaseChimneyContent();
        return BaseChimneyOntologyModelManager.createModelFromString(content);
    }

    private void setConcepts() {
        try {
            conceptMap.put(CPT_NUMVAL, baseEntityModel.getDatatypeProperty("http://www.theworldavatar.com/ontology/ontocape/upper_level/system.owl#numericalValue"));
            conceptMap.put(CPT_HASPROP, baseEntityModel.getObjectProperty("http://www.theworldavatar.com/ontology/ontocape/upper_level/system.owl#hasProperty"));
            conceptMap.put(CPT_HASVAL, baseEntityModel.getObjectProperty("http://www.theworldavatar.com/ontology/ontocape/upper_level/system.owl#hasValue"));
            conceptMap.put(CPT_HASUOM, baseEntityModel.getObjectProperty("http://www.theworldavatar.com/ontology/ontocape/upper_level/system.owl#hasUnitOfMeasure"));
            conceptMap.put(CPT_SCLVAL, baseEntityModel.getOntClass("http://www.theworldavatar.com/ontology/ontocape/upper_level/system.owl#ScalarValue"));
            conceptMap.put(CPT_CONTAINS, baseEntityModel.getObjectProperty("http://www.theworldavatar.com/ontology/ontocape/upper_level/system.owl#contains"));
            conceptMap.put(CPT_PMAMT, baseEntityModel.getOntClass("http://www.theworldavatar.com/ontology/ontocape/chemical_process_system/CPS_behavior/behavior.owl#ParticulateMaterialAmount"));
            conceptMap.put(CPT_CONVMFLR, baseEntityModel.getOntClass("http://www.theworldavatar.com/ontology/ontocape/chemical_process_system/CPS_behavior/behavior.owl#ConvectiveMassFlowrate"));
            conceptMap.put(CPT_SINGPART, baseEntityModel.getOntClass("http://www.theworldavatar.com/ontology/ontocape/chemical_process_system/CPS_behavior/behavior.owl#SingleParticle"));
            conceptMap.put(CPT_HASREPRPART, baseEntityModel.getObjectProperty("http://www.theworldavatar.com/ontology/ontocape/chemical_process_system/CPS_behavior/behavior.owl#hasRepresentativeParticle"));
            conceptMap.put(CPT_SI_M, baseEntityModel.getIndividual("http://www.theworldavatar.com/ontology/ontocape/supporting_concepts/SI_unit/SI_unit.owl#m"));
            conceptMap.put(CPT_SI_GPS, baseEntityModel.getIndividual("http://www.theworldavatar.com/ontology/ontocape/supporting_concepts/SI_unit/derived_SI_units.owl#g_per_s"));
            conceptMap.put(CPT_SI_KGPCM, baseEntityModel.getIndividual("http://www.theworldavatar.com/ontology/ontocape/supporting_concepts/SI_unit/derived_SI_units.owl#kg_per_cubic_m"));
            conceptMap.put(CPT_DIAM, baseEntityModel.getOntClass("http://www.theworldavatar.com/ontology/ontocape/supporting_concepts/geometry/geometry.owl#Diameter"));
            conceptMap.put(CPT_HASLEN, baseEntityModel.getObjectProperty("http://www.theworldavatar.com/ontology/ontocape/supporting_concepts/geometry/geometry.owl#has_length"));
            conceptMap.put(CPT_DENS, baseEntityModel.getOntClass("http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#Density"));
            conceptMap.put(CPT_MASSFR, baseEntityModel.getOntClass("http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#MassFraction"));
            conceptMap.put(CPT_HASDENS, baseEntityModel.getObjectProperty("http://www.theworldavatar.com/ontology/ontocape/material/phase_system/phase_system.owl#has_density"));
        }
        catch (Exception e) {
            throw new JPSRuntimeException("Could not load required http://www.theworldavatar.com/ontology/ontocape/ concepts using C://TOMCAT/webapps/ROOT/kb/base/Chimney-1-temp.owl model.");
        }
    }

    private void setSpecies() {
        speciesMap.put("CO", "ChemSpecies_Carbon__monoxide");
        speciesMap.put("CO2", "ChemSpecies_Carbon__dioxide");
        speciesMap.put("NO2", "ChemSpecies_Nitrogen__dioxide");
        speciesMap.put("HC", "PseudoComponent_Unburned_Hydrocarbon");
        speciesMap.put("NOx", "PseudoComponent_Nitrogen__oxides");
        speciesMap.put("SO2", "ChemSpecies_Sulfur__dioxide");
        speciesMap.put("O3", "ChemSpecies_Ozone");
    }

    public static String getBaseChimneyContent() throws IOException {
        File source = !AgentLocator.isJPSRunningForTest() ? new File(PATH_BASE_CHIMNEY) : new File(PATH_BASE_CHIMNEY_TEST);
        return new String(Files.readAllBytes(source.toPath()), StandardCharsets.UTF_8);
    }

    public static Map getSpeciesMap() {
        return speciesMap;
    }

    public static ResultSet getWasteStreamInfo(OntModel jenaOwlModel) {
        return BaseChimneyOntologyModelManager.query(SPQ_WASTE, jenaOwlModel);
    }
}

