/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.derivation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.derivation.Entity;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;

public class DerivationInputs {
    private Map<String, List<String>> inputs;
    public static final String DERIVATIONINPUTS_SERIALISE_ERROR = "Serialise the given JSONObject to DerivationInputs is not supported: ";

    public DerivationInputs(JSONObject mappedInputs) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Iterator<String> keys = mappedInputs.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            Object val = mappedInputs.get(key);
            if (val instanceof JSONArray) {
                map.put(key, ((JSONArray)val).toList().stream().map(iri -> this.trimIRI((String)iri)).collect(Collectors.toList()));
                continue;
            }
            if (val instanceof String) {
                map.put(key, new ArrayList<String>(Arrays.asList(this.trimIRI((String)val))));
                continue;
            }
            throw new JPSRuntimeException(DERIVATIONINPUTS_SERIALISE_ERROR + mappedInputs.toString());
        }
        this.inputs = map;
    }

    public DerivationInputs(List<Entity> entities) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Entity entity : entities) {
            if (map.containsKey(entity.getRdfType())) {
                ((List)map.get(entity.getRdfType())).add(entity.getIri());
                continue;
            }
            map.put(entity.getRdfType(), new ArrayList<String>(Arrays.asList(entity.getIri())));
        }
        this.inputs = map;
    }

    public DerivationInputs(Map<String, List<String>> inputs) {
        this.inputs = inputs;
    }

    public Map<String, List<String>> getInputs() {
        return this.inputs;
    }

    public List<String> getIris(String rdfType) {
        return this.getInputs().get(rdfType);
    }

    public List<String> getAllIris() {
        return this.getInputs().values().stream().flatMap(i -> i.stream()).collect(Collectors.toList());
    }

    public void addToInputs(String rdfType, List<String> iris) {
        rdfType = this.trimIRI(rdfType);
        iris = this.trimIRI(iris);
        if (!this.inputs.containsKey(rdfType)) {
            this.inputs.put(rdfType, new ArrayList<String>(iris));
        } else {
            this.inputs.get(rdfType).addAll(iris);
        }
    }

    public void addToInputs(String rdfType, String iri) {
        this.addToInputs(rdfType, Arrays.asList(iri));
    }

    public String toString() {
        return this.getInputs().toString();
    }

    String trimIRI(String iri) {
        if (iri.startsWith("<")) {
            iri = iri.substring(1);
        }
        if (iri.endsWith(">")) {
            iri = iri.substring(0, iri.length() - 1);
        }
        return iri;
    }

    List<String> trimIRI(List<String> iris) {
        return iris.stream().map(iri -> this.trimIRI((String)iri)).collect(Collectors.toList());
    }
}

