/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.derivation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.derivation.DerivationSparql;
import uk.ac.cam.cares.jps.base.derivation.Entity;

public class Derivation {
    private String iri;
    private List<Entity> inputs;
    private List<Derivation> directedUpstreams;
    private boolean hasDirectedUpstreams = false;
    private List<Derivation> directedDownstreams;
    private boolean hasDirectedDownstreams = false;
    private Long timestamp;
    private String agentURL;
    private List<Entity> entities;
    private String rdfType;
    private boolean updated = false;
    private Status status;

    public Derivation(String iri, String rdfType) {
        this.iri = iri;
        this.rdfType = rdfType;
        this.entities = new ArrayList<Entity>();
        this.inputs = new ArrayList<Entity>();
        this.directedUpstreams = new ArrayList<Derivation>();
        this.directedDownstreams = new ArrayList<Derivation>();
    }

    public String getIri() {
        return this.iri;
    }

    public String getRdfType() {
        return this.rdfType;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void setAgentURL(String agentURL) {
        this.agentURL = agentURL;
    }

    public void addEntity(Entity entity) {
        if (!this.entities.stream().anyMatch(e -> e.getIri().equals(entity.getIri()))) {
            this.entities.add(entity);
            entity.setBelongsTo(this);
        }
    }

    public void replaceEntities(List<Entity> entities) {
        this.entities = new ArrayList<Entity>();
        for (Entity entity : entities) {
            this.entities.add(entity);
            entity.setBelongsTo(this);
        }
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public List<String> getEntitiesIri() {
        return this.entities.stream().map(e -> e.getIri()).collect(Collectors.toList());
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(String statusIri, String statusRdfType) {
        this.status = new Status(statusIri, statusRdfType);
    }

    public void addInput(Entity input) {
        if (!this.inputs.stream().anyMatch(i -> i.getIri().equals(input.getIri()))) {
            this.inputs.add(input);
            input.setAsInput(this);
        }
    }

    public void removeInput(Entity input) {
        this.inputs.remove(input);
    }

    public List<Entity> getInputs() {
        return this.inputs;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public List<Derivation> getInputsWithBelongsTo() {
        List<Entity> inputs = this.getInputs();
        ArrayList<Derivation> inputsWithBelongsTo = new ArrayList<Derivation>();
        for (Entity input : inputs) {
            if (!input.hasBelongsTo()) continue;
            inputsWithBelongsTo.add(input.getBelongsTo());
        }
        return inputsWithBelongsTo;
    }

    public List<String> getAgentInputs() {
        return this.getInputs().stream().map(i -> i.getIri()).collect(Collectors.toList());
    }

    public JSONObject getAgentInputsMap() {
        HashMap inputsMap = new HashMap();
        this.getInputs().stream().forEach(i -> {
            if (!inputsMap.containsKey(i.getRdfType())) {
                inputsMap.put(i.getRdfType(), new ArrayList<String>(Arrays.asList(i.getIri())));
            } else {
                ((List)inputsMap.get(i.getRdfType())).add(i.getIri());
            }
        });
        return new JSONObject(inputsMap);
    }

    public JSONObject getBelongsToMap() {
        HashMap belongsToMap = new HashMap();
        this.getEntities().stream().forEach(e -> belongsToMap.put(e.getIri(), e.getRdfType()));
        return new JSONObject(belongsToMap);
    }

    public List<String> getBelongsToIris(String rdfType) {
        return this.getEntities().stream().filter(e -> e.getRdfType().equals(rdfType)).map(e -> e.getIri()).collect(Collectors.toList());
    }

    public JSONObject getDownstreamDerivationMap() {
        HashMap downstreamDerivationMap = new HashMap();
        this.getEntities().stream().filter(e -> e.isInputToDerivation()).forEach(e -> downstreamDerivationMap.put(e.getIri(), e.getInputOf().stream().map(dd -> dd.getIri()).collect(Collectors.toList())));
        return new JSONObject(downstreamDerivationMap);
    }

    public boolean isOutOfDate() {
        boolean outOfDate = false;
        List<Entity> inputs = this.getInputs();
        for (Entity input : inputs) {
            long input_timestamp = input.hasBelongsTo() ? input.getBelongsTo().getTimestamp().longValue() : input.getTimestamp().longValue();
            if (input_timestamp <= this.timestamp) continue;
            outOfDate = true;
            return outOfDate;
        }
        return outOfDate;
    }

    public String getAgentURL() {
        return this.agentURL;
    }

    public boolean isDerivationWithTimeSeries() {
        return this.rdfType.equals(DerivationSparql.ONTODERIVATION_DERIVATIONWITHTIMESERIES);
    }

    public boolean isDerivationAsyn() {
        return this.rdfType.equals(DerivationSparql.ONTODERIVATION_DERIVATIONASYN);
    }

    public void setUpdateStatus(boolean status) {
        this.updated = status;
    }

    public boolean getUpdateStatus() {
        return this.updated;
    }

    public List<Derivation> getDirectedUpstreams() {
        return this.directedUpstreams;
    }

    public void setDirectedUpstreams(Derivation directedUpstream) {
        if (this.hasDirectedUpstreams) {
            if (this.directedUpstreams.stream().allMatch(d -> d.getIri() != directedUpstream.getIri())) {
                this.directedUpstreams.add(directedUpstream);
            }
        } else {
            this.directedUpstreams.add(directedUpstream);
            this.hasDirectedUpstreams = true;
        }
        directedUpstream.setDirectedDownstreams(this);
    }

    public void setDirectedUpstreams(List<Derivation> directedUpstreams) {
        directedUpstreams.forEach(d -> this.setDirectedUpstreams((Derivation)d));
    }

    public List<Derivation> getDirectedDownstreams() {
        return this.directedDownstreams;
    }

    public void setDirectedDownstreams(Derivation directedDownstream) {
        if (this.hasDirectedDownstreams) {
            if (this.directedDownstreams.stream().allMatch(d -> d.getIri() != directedDownstream.getIri())) {
                this.directedDownstreams.add(directedDownstream);
            }
        } else {
            this.directedDownstreams.add(directedDownstream);
            this.hasDirectedDownstreams = true;
        }
    }

    public void setDirectedDownstreams(List<Derivation> directedDownstreams) {
        directedDownstreams.forEach(d -> this.setDirectedDownstreams((Derivation)d));
    }

    class Status {
        private String statusIri;
        private String statusRdfType;
        private List<Entity> newDerivedIRI;

        public Status(String statusIri, String statusRdfType) {
            this.statusIri = statusIri;
            this.statusRdfType = statusRdfType;
            this.newDerivedIRI = new ArrayList<Entity>();
        }

        public String getStatusIri() {
            return this.statusIri;
        }

        public String getStatusRdfType() {
            return this.statusRdfType;
        }

        public void addNewDerivedIRI(Entity newEntity) {
            if (!this.newDerivedIRI.stream().anyMatch(e -> e.getIri().equals(newEntity.getIri()))) {
                this.newDerivedIRI.add(newEntity);
            }
        }

        public List<Entity> getNewDerivedIRI() {
            return this.newDerivedIRI;
        }
    }
}

