/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.config;

import java.net.URL;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.cares.jps.base.config.KeyValueMap;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;

public class AgentLocator {
    private static final Logger LOGGER = LogManager.getLogger(AgentLocator.class);
    private static AgentLocator instance = null;
    private String jpsBaseDirectory = null;
    private String url = null;
    private static String JPS_CONFIG_ENVIRONMENT_TEST_KEY = "test";
    private static String REL_DIR_PYTHON = "reldir.python";
    private static String REL_DIR_WORKINGDIR = "reldir.workingdir";
    private static String ABS_JPSDATA_WORKINGDIR = "absdir.jpsdata.workingdir";
    private static String INVALID_PATH = "Path could not be constructed.";
    private static String INVALID_URL = "URL could not be constructed.";
    private static final String[] SUBDIRECTORIES = new String[]{"WEB-INF", "bin", "build", "target"};

    public static synchronized AgentLocator getSingleton() {
        if (instance == null) {
            instance = new AgentLocator();
        }
        return instance;
    }

    private AgentLocator() {
        this.init();
    }

    private void init() {
        this.jpsBaseDirectory = AgentLocator.getCurrentJpsAppDirectory(this);
        LOGGER.info("JPS_BASE directory = " + this.jpsBaseDirectory);
        this.url = this.getUrl(AgentLocator.getProperty("host"), AgentLocator.getProperty("port"));
    }

    public static String getCurrentJpsAppDirectory(Object thisObject) {
        String path;
        try {
            path = Paths.get(thisObject.getClass().getClassLoader().getResource("").toURI()).toString();
        }
        catch (Exception e) {
            throw new JPSRuntimeException(INVALID_PATH);
        }
        for (String subDir : SUBDIRECTORIES) {
            while (path.contains(subDir)) {
                path = Paths.get(path, new String[0]).getParent().toString();
            }
        }
        return path;
    }

    public static String getJPSBaseDirectory() {
        return AgentLocator.getSingleton().jpsBaseDirectory;
    }

    public static boolean isJPSRunningForTest() {
        Boolean testMode = false;
        testMode = Boolean.valueOf(AgentLocator.getProperty(JPS_CONFIG_ENVIRONMENT_TEST_KEY));
        return testMode;
    }

    public static String getNewPathToPythonScript(String pythonScriptName, Object thisObject) {
        String pathToPy;
        String relativePath = AgentLocator.getProperty(REL_DIR_PYTHON);
        try {
            pathToPy = Paths.get(AgentLocator.getCurrentJpsAppDirectory(thisObject), relativePath, pythonScriptName).toString();
        }
        catch (Exception e) {
            throw new JPSRuntimeException(INVALID_PATH);
        }
        return pathToPy;
    }

    public static String getPathToWorkingDir(Object thisObject) {
        String pathToPyDir;
        String relativePath = AgentLocator.getProperty(REL_DIR_WORKINGDIR);
        try {
            pathToPyDir = Paths.get(AgentLocator.getCurrentJpsAppDirectory(thisObject), relativePath).toString();
        }
        catch (Exception e) {
            throw new JPSRuntimeException(INVALID_PATH);
        }
        return pathToPyDir;
    }

    public static String getPathToJpsWorkingDir() {
        String absPath = AgentLocator.getProperty(ABS_JPSDATA_WORKINGDIR);
        String pathToJpsDir = Paths.get(absPath, new String[0]).toString();
        return pathToJpsDir;
    }

    public static String getProperty(String key) {
        String property = KeyValueMap.getInstance().get(key);
        return property;
    }

    private String getUrl(String host, String port) {
        String url;
        String protocol = "http";
        String path = "";
        try {
            url = new URL(protocol, host, Integer.valueOf(port), path).toString();
            LOGGER.info("created url from properties: " + url);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(INVALID_URL);
        }
        return url;
    }
}

