/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLAnnotationPropertyTransformer
implements OWLObjectVisitor,
SWRLObjectVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OWLAnnotationPropertyTransformer.class);
    private final OWLDataFactory df;
    private final Map<OWLEntity, OWLEntity> replacementMap;
    @Nullable
    private Object obj;

    public OWLAnnotationPropertyTransformer(OWLDataFactory dataFactory) {
        this(new HashMap<OWLEntity, OWLEntity>(), dataFactory);
    }

    public OWLAnnotationPropertyTransformer(OWLDataFactory dataFactory, Map<OWLEntity, OWLEntity> iriReplacementMap) {
        this.df = OWLAPIPreconditions.checkNotNull(dataFactory, "dataFactory cannot be null");
        OWLAPIPreconditions.checkNotNull(iriReplacementMap, "iriReplacementMap cannot be null");
        this.replacementMap = new HashMap<OWLEntity, OWLEntity>(iriReplacementMap);
    }

    public OWLAnnotationPropertyTransformer(Map<OWLEntity, OWLEntity> entityIRIReplacementMap, OWLDataFactory dataFactory) {
        this.df = OWLAPIPreconditions.checkNotNull(dataFactory, "dataFactory cannot be null");
        this.replacementMap = new HashMap<OWLEntity, OWLEntity>(OWLAPIPreconditions.checkNotNull(entityIRIReplacementMap, "entityIRIReplacementMap cannot be null"));
    }

    public <O extends OWLObject> O transformObject(O object) {
        OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
        try {
            return this.dup(object);
        }
        catch (ClassCastException e) {
            LOGGER.error("Attempt to transform an axiom to correct misuse of properties failed. Property replacement: {}, axiom: {}, error: {}", new Object[]{this.replacementMap, object, e.getMessage()});
            this.obj = object;
            return object;
        }
    }

    protected void setLastObject(Object obj) {
        this.obj = obj;
    }

    protected <O extends OWLObject> O dup(O o) {
        o.accept(this);
        return (O)((OWLObject)OWLAPIPreconditions.verifyNotNull(this.obj));
    }

    private OWLEntity getIRI(OWLEntity entity) {
        OWLEntity replacement = this.replacementMap.get(entity);
        if (replacement != null) {
            return replacement;
        }
        return entity;
    }

    private Collection<OWLAnnotation> anns(OWLAxiom ax) {
        return this.set(ax.annotations());
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom ax) {
        this.obj = this.df.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.dup((OWLObject)ax.getProperty()), this.anns(ax));
    }

    @Override
    public void visit(OWLClassAssertionAxiom ax) {
        this.obj = this.df.getOWLClassAssertionAxiom(this.dup(ax.getClassExpression()), this.dup(ax.getIndividual()), this.anns(ax));
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom ax) {
        this.obj = this.df.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.dup(ax.getProperty()), this.dup(ax.getSubject()), (OWLLiteral)this.dup(ax.getObject()), this.anns(ax));
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom ax) {
        this.obj = this.df.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)this.dup((OWLObject)ax.getProperty()), (OWLClassExpression)this.dup((OWLObject)ax.getDomain()), this.anns(ax));
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom ax) {
        this.obj = this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)this.dup((OWLObject)ax.getProperty()), (OWLDataRange)this.dup((OWLObject)ax.getRange()), this.anns(ax));
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom ax) {
        this.obj = this.df.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)this.dup((OWLObject)ax.getSubProperty()), (OWLDataPropertyExpression)this.dup((OWLObject)ax.getSuperProperty()), this.anns(ax));
    }

    @Override
    public void visit(OWLDeclarationAxiom ax) {
        this.obj = this.df.getOWLDeclarationAxiom(this.dup(ax.getEntity()), this.anns(ax));
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom ax) {
        this.obj = this.df.getOWLDifferentIndividualsAxiom(this.set(ax.individuals()), this.anns(ax));
    }

    @Override
    public void visit(OWLDisjointClassesAxiom ax) {
        this.obj = this.df.getOWLDisjointClassesAxiom(this.set(ax.classExpressions()), this.anns(ax));
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom ax) {
        this.obj = this.df.getOWLDisjointDataPropertiesAxiom(this.set(ax.properties()), this.anns(ax));
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom ax) {
        this.obj = this.df.getOWLDisjointObjectPropertiesAxiom(this.set(ax.properties()), this.anns(ax));
    }

    @Override
    public void visit(OWLDisjointUnionAxiom ax) {
        this.obj = this.df.getOWLDisjointUnionAxiom(this.dup(ax.getOWLClass()), this.set(ax.classExpressions()), this.anns(ax));
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom ax) {
        OWLAnnotationSubject subject = (OWLAnnotationSubject)this.dup((OWLObject)ax.getSubject());
        OWLProperty prop = (OWLProperty)this.dup((OWLObject)ax.getProperty());
        OWLAnnotationValue value = this.dup(ax.getValue());
        if (prop.isObjectPropertyExpression()) {
            OWLIndividual individual = subject instanceof OWLAnonymousIndividual ? (OWLIndividual)((Object)subject) : this.df.getOWLNamedIndividual((IRI)subject);
            OWLIndividual relatedIndividual = value instanceof OWLIndividual ? (OWLIndividual)((Object)value) : this.df.getOWLNamedIndividual((IRI)value);
            this.obj = this.df.getOWLObjectPropertyAssertionAxiom(prop.asOWLObjectProperty(), individual, relatedIndividual, OWLAPIStreamUtils.asList(ax.annotations()));
            return;
        }
        if (prop.isDataPropertyExpression()) {
            OWLIndividual individual = subject instanceof OWLAnonymousIndividual ? (OWLIndividual)((Object)subject) : this.df.getOWLNamedIndividual((IRI)subject);
            this.obj = this.df.getOWLDataPropertyAssertionAxiom(prop.asOWLDataProperty(), individual, (OWLLiteral)value, OWLAPIStreamUtils.asList(ax.annotations()));
            return;
        }
        this.obj = this.df.getOWLAnnotationAssertionAxiom(prop.asOWLAnnotationProperty(), subject, value, this.anns(ax));
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom ax) {
        this.obj = this.df.getOWLEquivalentClassesAxiom(this.set(ax.classExpressions()), this.anns(ax));
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom ax) {
        this.obj = this.df.getOWLEquivalentDataPropertiesAxiom(this.set(ax.properties()), this.anns(ax));
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom ax) {
        this.obj = this.df.getOWLEquivalentObjectPropertiesAxiom(this.set(ax.properties()), this.anns(ax));
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom ax) {
        this.obj = this.df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)this.dup((OWLObject)ax.getProperty()), this.anns(ax));
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom ax) {
        this.obj = this.df.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.dup((OWLObject)ax.getProperty()), this.anns(ax));
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom ax) {
        this.obj = this.df.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.dup((OWLObject)ax.getProperty()), this.anns(ax));
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom ax) {
        this.obj = this.df.getOWLInverseObjectPropertiesAxiom(this.dup(ax.getFirstProperty()), this.dup(ax.getSecondProperty()), this.anns(ax));
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom ax) {
        this.obj = this.df.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.dup((OWLObject)ax.getProperty()), this.anns(ax));
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom ax) {
        this.obj = this.df.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.dup(ax.getProperty()), this.dup(ax.getSubject()), (OWLLiteral)this.dup(ax.getObject()), this.anns(ax));
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom ax) {
        this.obj = this.df.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.dup(ax.getProperty()), this.dup(ax.getSubject()), (OWLIndividual)this.dup(ax.getObject()), this.anns(ax));
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom ax) {
        this.obj = this.df.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.dup(ax.getProperty()), this.dup(ax.getSubject()), (OWLIndividual)this.dup(ax.getObject()), this.anns(ax));
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom ax) {
        this.obj = this.df.getOWLSubPropertyChainOfAxiom(OWLAPIStreamUtils.asList(ax.getPropertyChain().stream().map(this::dup)), this.dup(ax.getSuperProperty()), this.anns(ax));
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom ax) {
        this.obj = this.df.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)this.dup((OWLObject)ax.getProperty()), (OWLClassExpression)this.dup((OWLObject)ax.getDomain()), this.anns(ax));
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom ax) {
        this.obj = this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)this.dup((OWLObject)ax.getProperty()), (OWLClassExpression)this.dup((OWLObject)ax.getRange()), this.anns(ax));
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom ax) {
        this.obj = this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.dup((OWLObject)ax.getSubProperty()), (OWLObjectPropertyExpression)this.dup((OWLObject)ax.getSuperProperty()), this.anns(ax));
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom ax) {
        this.obj = this.df.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.dup((OWLObject)ax.getProperty()), this.anns(ax));
    }

    @Override
    public void visit(OWLSameIndividualAxiom ax) {
        this.obj = this.df.getOWLSameIndividualAxiom(this.set(ax.individuals()), this.anns(ax));
    }

    @Override
    public void visit(OWLSubClassOfAxiom ax) {
        this.obj = this.df.getOWLSubClassOfAxiom(this.dup(ax.getSubClass()), this.dup(ax.getSuperClass()), this.anns(ax));
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom ax) {
        this.obj = this.df.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.dup((OWLObject)ax.getProperty()), this.anns(ax));
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom ax) {
        this.obj = this.df.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.dup((OWLObject)ax.getProperty()), this.anns(ax));
    }

    @Override
    public void visit(OWLClass ce) {
        this.obj = this.getIRI(ce);
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        this.obj = this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)this.dup(ce.getProperty()), (OWLDataRange)this.dup((OWLObject)ce.getFiller()));
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        this.obj = this.df.getOWLDataExactCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.dup(ce.getProperty()), (OWLDataRange)this.dup((OWLObject)ce.getFiller()));
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        this.obj = this.df.getOWLDataMaxCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.dup(ce.getProperty()), (OWLDataRange)this.dup((OWLObject)ce.getFiller()));
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        this.obj = this.df.getOWLDataMinCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.dup(ce.getProperty()), (OWLDataRange)this.dup((OWLObject)ce.getFiller()));
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.obj = this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)this.dup(ce.getProperty()), (OWLDataRange)this.dup((OWLObject)ce.getFiller()));
    }

    @Override
    public void visit(OWLDataHasValue ce) {
        this.obj = this.df.getOWLDataHasValue((OWLDataPropertyExpression)this.dup(ce.getProperty()), (OWLLiteral)this.dup((OWLObject)ce.getFiller()));
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.obj = this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)this.dup(ce.getProperty()), (OWLClassExpression)this.dup((OWLObject)ce.getFiller()));
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        this.obj = this.df.getOWLObjectComplementOf(this.dup(ce.getOperand()));
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        this.obj = this.df.getOWLObjectExactCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)this.dup(ce.getProperty()), (OWLClassExpression)this.dup((OWLObject)ce.getFiller()));
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        this.obj = this.df.getOWLObjectIntersectionOf(this.set(ce.operands()));
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        this.obj = this.df.getOWLObjectMaxCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)this.dup(ce.getProperty()), (OWLClassExpression)this.dup((OWLObject)ce.getFiller()));
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        this.obj = this.df.getOWLObjectMinCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)this.dup(ce.getProperty()), (OWLClassExpression)this.dup((OWLObject)ce.getFiller()));
    }

    @Override
    public void visit(OWLObjectOneOf ce) {
        this.obj = this.df.getOWLObjectOneOf(this.set(ce.individuals()));
    }

    @Override
    public void visit(OWLObjectHasSelf ce) {
        this.obj = this.df.getOWLObjectHasSelf((OWLObjectPropertyExpression)this.dup(ce.getProperty()));
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        this.obj = this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.dup(ce.getProperty()), (OWLClassExpression)this.dup((OWLObject)ce.getFiller()));
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        this.obj = this.df.getOWLObjectUnionOf(this.set(ce.operands()));
    }

    @Override
    public void visit(OWLObjectHasValue ce) {
        this.obj = this.df.getOWLObjectHasValue((OWLObjectPropertyExpression)this.dup(ce.getProperty()), (OWLIndividual)this.dup((OWLObject)ce.getFiller()));
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.obj = this.df.getOWLDataComplementOf(this.dup(node.getDataRange()));
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.obj = this.df.getOWLDataOneOf(this.set(node.values()));
    }

    @Override
    public void visit(OWLDatatype node) {
        this.obj = this.getIRI(node);
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        this.obj = this.df.getOWLDatatypeRestriction(this.dup(node.getDatatype()), OWLAPIStreamUtils.asList(node.facetRestrictions().map(this::dup)));
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.obj = this.df.getOWLFacetRestriction(node.getFacet(), this.dup(node.getFacetValue()));
    }

    @Override
    public void visit(OWLLiteral node) {
        this.obj = node.hasLang() ? this.df.getOWLLiteral(node.getLiteral(), node.getLang()) : this.df.getOWLLiteral(node.getLiteral(), this.dup(node.getDatatype()));
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.obj = this.getIRI(property);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.obj = this.getIRI(property);
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.obj = this.df.getOWLObjectInverseOf(this.dup(property.getInverse()).asOWLObjectProperty());
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.obj = this.getIRI(individual);
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.obj = ontology;
    }

    @Override
    public void visit(SWRLRule rule) {
        this.obj = this.df.getSWRLRule(OWLAPIStreamUtils.asList(rule.body().map(this::dup)), OWLAPIStreamUtils.asList(rule.head().map(this::dup)));
    }

    @Override
    public void visit(SWRLClassAtom node) {
        this.obj = this.df.getSWRLClassAtom(this.dup(node.getPredicate()), (SWRLIArgument)this.dup((OWLObject)node.getArgument()));
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        this.obj = this.df.getSWRLDataRangeAtom(this.dup(node.getPredicate()), (SWRLDArgument)this.dup((OWLObject)node.getArgument()));
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        this.obj = this.df.getSWRLObjectPropertyAtom(this.dup(node.getPredicate()), (SWRLIArgument)this.dup((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.dup((OWLObject)node.getSecondArgument()));
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        this.obj = this.df.getSWRLDataPropertyAtom(this.dup(node.getPredicate()), (SWRLIArgument)this.dup((OWLObject)node.getFirstArgument()), (SWRLDArgument)this.dup((OWLObject)node.getSecondArgument()));
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.obj = this.df.getSWRLBuiltInAtom(node.getPredicate(), OWLAPIStreamUtils.asList(node.arguments().map(this::dup)));
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        this.obj = this.df.getSWRLDifferentIndividualsAtom((SWRLIArgument)this.dup((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.dup((OWLObject)node.getSecondArgument()));
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        this.obj = this.df.getSWRLSameIndividualAtom((SWRLIArgument)this.dup((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.dup((OWLObject)node.getSecondArgument()));
    }

    @Override
    public void visit(SWRLVariable node) {
        this.obj = this.df.getSWRLVariable(this.dup(node.getIRI()));
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
        this.obj = this.df.getSWRLIndividualArgument(this.dup(node.getIndividual()));
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
        this.obj = this.df.getSWRLLiteralArgument(this.dup(node.getLiteral()));
    }

    @Override
    public void visit(OWLHasKeyAxiom ax) {
        this.obj = this.df.getOWLHasKeyAxiom(this.dup(ax.getClassExpression()), this.set(ax.propertyExpressions()), this.anns(ax));
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        this.obj = this.df.getOWLDataIntersectionOf(this.set(node.operands()));
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        this.obj = this.df.getOWLDataUnionOf(this.set(node.operands()));
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.obj = this.getIRI(property);
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom ax) {
        OWLProperty prop = (OWLProperty)this.dup((OWLObject)ax.getProperty());
        IRI domain = (IRI)this.dup((OWLObject)ax.getDomain());
        if (prop.isObjectPropertyExpression()) {
            OWLClass d = this.df.getOWLClass(domain);
            LOGGER.warn("Annotation property domain axiom turned to object property domain after parsing. This could introduce errors if the original domain was an anonymous expression: {} is the new domain.", (Object)domain);
            this.obj = this.df.getOWLObjectPropertyDomainAxiom(prop.asOWLObjectProperty(), d, OWLAPIStreamUtils.asList(ax.annotations()));
            return;
        }
        if (prop.isDataPropertyExpression()) {
            OWLClass d = this.df.getOWLClass(domain);
            LOGGER.warn("Annotation property domain axiom turned to data property domain after parsing. This could introduce errors if the original domain was an anonymous expression: {} is the new domain.", (Object)domain);
            this.obj = this.df.getOWLDataPropertyDomainAxiom(prop.asOWLDataProperty(), d, OWLAPIStreamUtils.asList(ax.annotations()));
            return;
        }
        this.obj = this.df.getOWLAnnotationPropertyDomainAxiom(prop.asOWLAnnotationProperty(), domain, this.anns(ax));
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom ax) {
        OWLProperty prop = (OWLProperty)this.dup((OWLObject)ax.getProperty());
        IRI range = (IRI)this.dup((OWLObject)ax.getRange());
        if (prop.isObjectPropertyExpression()) {
            OWLClass d = this.df.getOWLClass(range);
            LOGGER.warn("Annotation property range axiom turned to object property range after parsing. This could introduce errors if the original range was an anonymous expression: {} is the new domain.", (Object)range);
            this.obj = this.df.getOWLObjectPropertyRangeAxiom(prop.asOWLObjectProperty(), d, OWLAPIStreamUtils.asList(ax.annotations()));
            return;
        }
        if (prop.isDataPropertyExpression()) {
            OWLDatatype d = this.df.getOWLDatatype(range);
            LOGGER.warn("Annotation property range axiom turned to data property range after parsing. This could introduce errors if the original range was an anonymous expression: {} is the new domain.", (Object)range);
            this.obj = this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)prop.asOWLDataProperty(), d, OWLAPIStreamUtils.asList(ax.annotations()));
            return;
        }
        this.obj = this.df.getOWLAnnotationPropertyRangeAxiom(prop.asOWLAnnotationProperty(), range, this.anns(ax));
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom ax) {
        OWLProperty sub = this.dup(ax.getSubProperty());
        OWLProperty sup = this.dup(ax.getSuperProperty());
        if (sub.isObjectPropertyExpression() || sup.isObjectPropertyExpression()) {
            this.obj = sub.isOWLObjectProperty() && sup.isOWLObjectProperty() ? this.df.getOWLSubObjectPropertyOfAxiom(sub.asOWLObjectProperty(), sup.asOWLObjectProperty(), OWLAPIStreamUtils.asList(ax.annotations())) : ax;
            return;
        }
        if (sub.isDataPropertyExpression() || sup.isDataPropertyExpression()) {
            this.obj = sub.isOWLDataProperty() && sup.isOWLDataProperty() ? this.df.getOWLSubDataPropertyOfAxiom(sub.asOWLDataProperty(), sup.asOWLDataProperty(), OWLAPIStreamUtils.asList(ax.annotations())) : ax;
            return;
        }
        this.obj = sub.isOWLAnnotationProperty() && sup.isOWLAnnotationProperty() ? this.df.getOWLSubAnnotationPropertyOfAxiom(sub.asOWLAnnotationProperty(), sup.asOWLAnnotationProperty(), this.anns(ax)) : ax;
    }

    @Override
    public void visit(OWLAnnotation node) {
        this.obj = this.df.getOWLAnnotation(this.dup(node.getProperty()), this.dup(node.getValue()));
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.obj = individual;
    }

    @Override
    public void visit(IRI iri) {
        this.obj = iri;
        for (EntityType<?> entityType : EntityType.values()) {
            assert (entityType != null);
            Object entity = this.df.getOWLEntity(entityType, iri);
            OWLEntity replacementIRI = this.replacementMap.get(entity);
            if (replacementIRI == null) continue;
            this.obj = replacementIRI.getIRI();
            break;
        }
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom ax) {
        this.obj = this.df.getOWLDatatypeDefinitionAxiom(this.dup(ax.getDatatype()), this.dup(ax.getDataRange()), this.anns(ax));
    }

    private <O extends OWLObject> Collection<O> set(Stream<O> objects) {
        return OWLAPIStreamUtils.asList(objects.map(this::dup));
    }
}

