/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class NamedConjunctChecker {
    final Set<OWLClass> conjuncts = new HashSet<OWLClass>();
    private final NamedConjunctCheckerVisitor visitor = new NamedConjunctCheckerVisitor();
    @Nullable
    protected OWLClass conjunct;
    boolean found;
    boolean collect;

    public boolean isNamedConjunct(OWLClass conj, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull(conj, "conj cannot be null");
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        this.reset();
        this.conjunct = conj;
        classExpression.accept(this.visitor);
        return this.found;
    }

    public boolean hasNamedConjunct(OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        this.reset();
        this.conjunct = null;
        classExpression.accept(this.visitor);
        return this.found;
    }

    private void reset() {
        this.found = false;
        this.collect = false;
    }

    public Set<OWLClass> getNamedConjuncts(OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        this.conjuncts.clear();
        this.reset();
        this.collect = true;
        classExpression.accept(this.visitor);
        return this.conjuncts;
    }

    private class NamedConjunctCheckerVisitor
    implements OWLClassExpressionVisitor {
        NamedConjunctCheckerVisitor() {
        }

        @Override
        public void visit(OWLClass ce) {
            if (NamedConjunctChecker.this.conjunct == null) {
                NamedConjunctChecker.this.found = true;
                if (NamedConjunctChecker.this.collect) {
                    NamedConjunctChecker.this.conjuncts.add(ce);
                }
            } else if (ce.equals(NamedConjunctChecker.this.conjunct)) {
                NamedConjunctChecker.this.found = true;
                if (NamedConjunctChecker.this.collect) {
                    NamedConjunctChecker.this.conjuncts.add(ce);
                }
            }
        }

        @Override
        public void visit(OWLObjectIntersectionOf ce) {
            Iterator it = ce.operands().iterator();
            while (it.hasNext()) {
                ((OWLClassExpression)it.next()).accept(this);
                if (!NamedConjunctChecker.this.found || NamedConjunctChecker.this.collect) continue;
                return;
            }
        }
    }
}

