/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.utils;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.vocabulary.XSD;

public class JdbcNodeUtils {
    private static Set<String> numericTypes = new HashSet<String>();

    private JdbcNodeUtils() {
    }

    public static boolean toBoolean(Node n) throws SQLException {
        try {
            if (n == null) {
                return false;
            }
            if (n.isLiteral()) {
                if (n.getLiteralDatatypeURI().equals(XSD.xboolean.getURI())) {
                    return Boolean.parseBoolean(n.getLiteralLexicalForm());
                }
                if (JdbcNodeUtils.hasNumericDatatype(n)) {
                    return JdbcNodeUtils.parseAsInteger(n) != 0L;
                }
                throw new SQLException("Unable to marshal the given literal to a boolean");
            }
            throw new SQLException("Unable to marshal a non-literal to a boolean");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unable to marshal the value to a boolean", e);
        }
    }

    public static byte toByte(Node n) throws SQLException {
        try {
            if (n == null) {
                return 0;
            }
            if (n.isLiteral()) {
                return Byte.decode(n.getLiteralLexicalForm());
            }
            throw new SQLException("Unable to marshal a non-literal to a byte");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unable to marshal the value to a byte", e);
        }
    }

    public static short toShort(Node n) throws SQLException {
        try {
            if (n == null) {
                return 0;
            }
            if (n.isLiteral()) {
                return Short.parseShort(n.getLiteralLexicalForm());
            }
            throw new SQLException("Unable to marshal a non-literal to an integer");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unable to marshal the value to an integer", e);
        }
    }

    public static int toInt(Node n) throws SQLException {
        try {
            if (n == null) {
                return 0;
            }
            if (n.isLiteral()) {
                return NodeFactoryExtra.nodeToInt((Node)n);
            }
            throw new SQLException("Unable to marshal a non-literal to an integer");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unable to marshal the value to an integer", e);
        }
    }

    public static long toLong(Node n) throws SQLException {
        try {
            if (n == null) {
                return 0L;
            }
            if (n.isLiteral()) {
                return NodeFactoryExtra.nodeToLong((Node)n);
            }
            throw new SQLException("Unable to marshal a non-literal to a long integer");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unable to marshal the value to a long integer", e);
        }
    }

    public static float toFloat(Node n) throws SQLException {
        try {
            if (n == null) {
                return 0.0f;
            }
            if (n.isLiteral()) {
                return NodeFactoryExtra.nodeToFloat((Node)n);
            }
            throw new SQLException("Unable to marshal a non-literal to a float");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unable to marshal the value to a float", e);
        }
    }

    public static double toDouble(Node n) throws SQLException {
        try {
            if (n == null) {
                return 0.0;
            }
            if (n.isLiteral()) {
                return NodeFactoryExtra.nodeToDouble((Node)n);
            }
            throw new SQLException("Unable to marshal a non-literal to a double");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unable to marshal the value to a double", e);
        }
    }

    public static BigDecimal toDecimal(Node n) throws SQLException {
        try {
            if (n == null) {
                return null;
            }
            if (n.isLiteral()) {
                return new BigDecimal(n.getLiteralLexicalForm());
            }
            throw new SQLException("Unable to marshal a non-literal to a decimal");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unable to marshal the value to a decimal", e);
        }
    }

    public static Date toDate(Node n) throws SQLException {
        try {
            if (n == null) {
                return null;
            }
            if (n.isLiteral()) {
                return new Date(NodeValue.xmlDatatypeFactory.newXMLGregorianCalendar(n.getLiteralLexicalForm()).toGregorianCalendar().getTimeInMillis());
            }
            throw new SQLException("Unable to marshal a non-literal to a date");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unable to marshal the value to a date", e);
        }
    }

    public static Time toTime(Node n) throws SQLException {
        try {
            if (n == null) {
                return null;
            }
            if (n.isLiteral()) {
                return new Time(NodeValue.xmlDatatypeFactory.newXMLGregorianCalendar(n.getLiteralLexicalForm()).toGregorianCalendar().getTimeInMillis());
            }
            throw new SQLException("Unable to marshal a non-literal to a time");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unable to marshal the value to a time", e);
        }
    }

    public static Timestamp toTimestamp(Node n) throws SQLException {
        try {
            if (n == null) {
                return null;
            }
            if (n.isLiteral()) {
                return new Timestamp(NodeValue.xmlDatatypeFactory.newXMLGregorianCalendar(n.getLiteralLexicalForm()).toGregorianCalendar().getTimeInMillis());
            }
            throw new SQLException("Unable to marshal a non-literal to a timestamp");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unable to marshal the value to a timestamp", e);
        }
    }

    public static String toString(Node n) throws SQLException {
        try {
            if (n == null) {
                return null;
            }
            if (n.isURI()) {
                return n.getURI();
            }
            if (n.isLiteral()) {
                return n.getLiteralLexicalForm();
            }
            if (n.isBlank()) {
                return n.getBlankNodeLabel();
            }
            if (n.isVariable()) {
                return n.getName();
            }
            throw new SQLException("Unable to marshal unknown node types to a string");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unable to marshal the value to a string", e);
        }
    }

    public static URL toURL(Node n) throws SQLException {
        try {
            if (n == null) {
                return null;
            }
            if (n.isURI()) {
                return new URL(n.getURI());
            }
            throw new SQLException("Unable to marshal a non-uri to a URL");
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unable to marshal the value to a URL", e);
        }
    }

    private static long parseAsInteger(Node n) throws SQLException {
        if (n == null) {
            throw new SQLException("Unable to marshal a null to an integer");
        }
        if (n.isLiteral()) {
            try {
                String lex = n.getLiteralLexicalForm();
                if (lex.contains(".")) {
                    return Long.parseLong(lex.substring(0, lex.indexOf(46)));
                }
                return Long.parseLong(lex);
            }
            catch (Exception e) {
                throw new SQLException("Unable to marshal an invalid numeric representation to an integer", e);
            }
        }
        throw new SQLException("Unable to marshal a non-literal to an integer");
    }

    private static boolean hasNumericDatatype(Node n) {
        if (n == null) {
            return false;
        }
        if (!n.isLiteral()) {
            return false;
        }
        return numericTypes.contains(n.getLiteralDatatypeURI());
    }

    static {
        numericTypes.add(XSD.decimal.getURI());
        numericTypes.add(XSD.integer.getURI());
        numericTypes.add(XSD.negativeInteger.getURI());
        numericTypes.add(XSD.nonNegativeInteger.getURI());
        numericTypes.add(XSD.nonPositiveInteger.getURI());
        numericTypes.add(XSD.unsignedByte.getURI());
        numericTypes.add(XSD.unsignedInt.getURI());
        numericTypes.add(XSD.unsignedLong.getURI());
        numericTypes.add(XSD.unsignedShort.getURI());
        numericTypes.add(XSD.xbyte.getURI());
        numericTypes.add(XSD.xdouble.getURI());
        numericTypes.add(XSD.xfloat.getURI());
        numericTypes.add(XSD.xint.getURI());
        numericTypes.add(XSD.xlong.getURI());
        numericTypes.add(XSD.xshort.getURI());
    }
}

