/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.results.metadata.columns;

import java.sql.SQLException;
import org.apache.jena.graph.Node;

public abstract class ColumnInfo {
    private String label;
    private String className = Object.class.getCanonicalName();
    private String typeName = Node.class.getCanonicalName();
    private int displaySize = Integer.MAX_VALUE;
    private int type = 2000;
    private int precision = 0;
    private int scale = 0;
    private int nullable = 0;
    private boolean signed = false;

    public ColumnInfo(String label, int type) throws SQLException {
        if (label == null) {
            throw new SQLException("Column label cannot be null");
        }
        this.label = label;
        this.type = type;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getClassName() {
        return this.className;
    }

    protected void setClassName(String className) {
        this.className = className;
    }

    public final int getDisplaySize() {
        return this.displaySize;
    }

    protected final void setDisplaySize(int size) {
        this.displaySize = size;
    }

    public final int getType() {
        return this.type;
    }

    public final String getTypeName() {
        return this.typeName;
    }

    protected final void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public final int getPrecision() {
        return this.precision;
    }

    protected final void setPrecision(int precision) {
        this.precision = precision;
    }

    public final int getScale() {
        return this.scale;
    }

    protected final void setScale(int scale) {
        this.scale = scale;
    }

    public final int getNullability() {
        return this.nullable;
    }

    protected final void setNullable(int nullable) {
        this.nullable = nullable;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public boolean isCurrency() {
        return false;
    }

    public boolean isAutoIncrement() {
        return false;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isSearchable() {
        return true;
    }

    public final boolean isSigned() {
        return this.signed;
    }

    protected final void setSigned(boolean signed) {
        this.signed = signed;
    }
}

