/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.connections;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.jena.jdbc.connections.JenaConnection;
import org.apache.jena.jdbc.statements.DatasetPreparedStatement;
import org.apache.jena.jdbc.statements.DatasetStatement;
import org.apache.jena.jdbc.statements.JenaPreparedStatement;
import org.apache.jena.jdbc.statements.JenaStatement;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ReadWrite;

public abstract class DatasetConnection
extends JenaConnection {
    protected Dataset ds;
    private boolean readonly = false;
    private ThreadLocal<ReadWrite> transactionType = new ThreadLocal();
    private ThreadLocal<Integer> transactionParticipants = new ThreadLocal();

    public DatasetConnection(Dataset ds, int holdability, boolean autoCommit, int transactionLevel, int compatibilityLevel) throws SQLException {
        super(holdability, autoCommit, transactionLevel, compatibilityLevel);
        this.ds = ds;
    }

    public final Dataset getJenaDataset() {
        return this.ds;
    }

    @Override
    protected void closeInternal() throws SQLException {
        try {
            if (this.ds != null) {
                this.ds.close();
                this.ds = null;
            }
        }
        catch (Exception e) {
            throw new SQLException("Unexpected error closing a dataset backed connection", e);
        }
        finally {
            this.ds = null;
        }
    }

    @Override
    protected JenaStatement createStatementInternal(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType == 1005) {
            throw new SQLFeatureNotSupportedException("Dataset backed connections do not support scroll sensitive result sets");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Dataset backed connections only supports read-only result sets");
        }
        return new DatasetStatement(this, resultSetType, 1000, 0, resultSetHoldability, this.getAutoCommit(), this.getTransactionIsolation());
    }

    @Override
    protected JenaPreparedStatement createPreparedStatementInternal(String sparql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType == 1005) {
            throw new SQLFeatureNotSupportedException("Dataset backed connections do not support scroll sensitive result sets");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Dataset backed connections only supports read-only result sets");
        }
        return new DatasetPreparedStatement(sparql, this, resultSetType, 1000, 0, resultSetHoldability, this.getAutoCommit(), this.getTransactionIsolation());
    }

    @Override
    public boolean isClosed() {
        return this.ds == null;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public boolean isValid(int timeout) {
        return !this.isClosed();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot set read-only mode on a closed connection");
        }
        this.readonly = readOnly;
    }

    @Override
    protected void checkTransactionIsolation(int level) throws SQLException {
        switch (level) {
            case 0: {
                return;
            }
            case 8: {
                if (this.ds == null || !this.ds.supportsTransactions()) break;
                return;
            }
        }
        throw new SQLException(String.format("The Transaction level %d is not supported by this connection", level));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void begin(ReadWrite type) throws SQLException {
        try {
            if (this.isClosed()) {
                throw new SQLException("Cannot start a transaction on a closed connection");
            }
            if (this.getTransactionIsolation() == 0) {
                throw new SQLException("Cannot start a transaction when transaction isolation is set to NONE");
            }
            if (!this.ds.supportsTransactions()) return;
            if (this.ds.isInTransaction()) {
                ReadWrite currType = this.transactionType.get();
                if (!currType.equals((Object)type)) throw new SQLException("Unable to start a transaction of a different type on the same thread as an existing transaction, please retry your operation on a different thread");
                this.transactionParticipants.set(this.transactionParticipants.get() + 1);
                return;
            } else {
                this.transactionType.set(type);
                this.transactionParticipants.set(1);
                this.ds.begin(type);
            }
            return;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unexpected error starting a transaction", e);
        }
    }

    @Override
    protected synchronized void commitInternal() throws SQLException {
        block6: {
            try {
                if (!this.ds.supportsTransactions()) break block6;
                if (this.ds.isInTransaction()) {
                    int participants = this.transactionParticipants.get();
                    if (participants > 1) {
                        this.transactionParticipants.set(participants - 1);
                    } else {
                        this.ds.commit();
                        this.ds.end();
                        this.transactionParticipants.remove();
                        this.transactionType.remove();
                    }
                    break block6;
                }
                throw new SQLException("Attempted to commit a transaction when there was no active transaction");
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Unexpected error committing the transaction", e);
            }
        }
    }

    @Override
    protected synchronized void rollbackInternal() throws SQLException {
        block4: {
            try {
                if (!this.ds.supportsTransactions()) break block4;
                if (this.ds.isInTransaction()) {
                    this.ds.abort();
                    this.ds.end();
                    this.transactionType.remove();
                    this.transactionParticipants.remove();
                    break block4;
                }
                throw new SQLException("Attempted to rollback a transaction when there was no active transaction");
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Unexpected error rolling back the transaction", e);
            }
        }
    }
}

