/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.httpd;

import com.bigdata.util.httpd.HTTPGetHandler;
import com.bigdata.util.httpd.NanoHTTPD;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;

public abstract class AbstractHTTPD
extends NanoHTTPD
implements HTTPGetHandler {
    private static final Logger log = Logger.getLogger(AbstractHTTPD.class);

    public AbstractHTTPD(int port) throws IOException {
        super(port);
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.Request req) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("uri=" + req.uri));
            log.debug((Object)("method=" + req.method));
            log.debug((Object)("headers=" + req.headers));
            log.debug((Object)("params=" + req.params));
        } else if (log.isInfoEnabled()) {
            log.info((Object)(req.method + " '" + req.uri + "' "));
        }
        try {
            if ("GET".equalsIgnoreCase(req.method)) {
                return this.doGet(req);
            }
            if ("POST".equalsIgnoreCase(req.method)) {
                return this.doPost(req);
            }
            if ("PUT".equalsIgnoreCase(req.method)) {
                return this.doPut(req);
            }
            if ("DELETE".equalsIgnoreCase(req.method)) {
                return this.doDelete(req);
            }
            return new NanoHTTPD.Response("405 Method Not Allowed", "text/plain", "" + req.method);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            return new NanoHTTPD.Response("200 OK", "text/plain", w.toString());
        }
    }

    @Override
    public NanoHTTPD.Response doGet(NanoHTTPD.Request req) throws Exception {
        return new NanoHTTPD.Response("405 Method Not Allowed", "text/plain", req.method);
    }

    public NanoHTTPD.Response doPost(NanoHTTPD.Request req) throws Exception {
        return new NanoHTTPD.Response("405 Method Not Allowed", "text/plain", req.method);
    }

    public NanoHTTPD.Response doPut(NanoHTTPD.Request req) throws Exception {
        return new NanoHTTPD.Response("405 Method Not Allowed", "text/plain", req.method);
    }

    public NanoHTTPD.Response doDelete(NanoHTTPD.Request req) throws Exception {
        return new NanoHTTPD.Response("405 Method Not Allowed", "text/plain", req.method);
    }
}

