/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public class LatchedExecutor
implements Executor {
    private static final transient Logger log = Logger.getLogger(LatchedExecutor.class);
    private final Executor executor;
    private final Semaphore semaphore;
    private final BlockingQueue<Runnable> queue = new LinkedBlockingDeque<Runnable>();
    private final int nparallel;

    public int getNParallel() {
        return this.nparallel;
    }

    public LatchedExecutor(Executor executor, int nparallel) {
        if (executor == null) {
            throw new IllegalArgumentException();
        }
        if (nparallel < 1) {
            throw new IllegalArgumentException();
        }
        this.executor = executor;
        this.nparallel = nparallel;
        this.semaphore = new Semaphore(nparallel);
    }

    @Override
    public void execute(final Runnable r) {
        if (!this.queue.offer(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    r.run();
                }
                finally {
                    LatchedExecutor.this.scheduleNext();
                }
            }
        })) {
            throw new RejectedExecutionException();
        }
        if (this.semaphore.tryAcquire()) {
            this.scheduleNext();
        }
    }

    private void scheduleNext() {
        while (true) {
            Runnable next = null;
            next = (Runnable)this.queue.poll();
            if (next != null) {
                try {
                    this.executor.execute(next);
                    return;
                }
                catch (RejectedExecutionException ex) {
                    log.error((Object)ex, (Throwable)ex);
                }
                continue;
            }
            this.semaphore.release();
            if (this.queue.isEmpty() || !this.semaphore.tryAcquire()) break;
        }
    }
}

