/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.mdi.IPartitionMetadata;

public class Split {
    public final IPartitionMetadata pmd;
    public final int fromIndex;
    public final int toIndex;
    public final int ntuples;

    public Split(IPartitionMetadata pmd) {
        this(pmd, 0, 0);
    }

    public Split(IPartitionMetadata pmd, int fromIndex, int toIndex) {
        this.pmd = pmd;
        if (fromIndex < 0) {
            throw new IllegalArgumentException("fromIndex=" + fromIndex);
        }
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException("fromIndex=" + fromIndex + ", toIndex=" + toIndex);
        }
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.ntuples = toIndex - fromIndex;
    }

    public int hashCode() {
        if (this.pmd != null) {
            return this.pmd.hashCode();
        }
        return this.fromIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Split) {
            return this.equals((Split)o);
        }
        return false;
    }

    public boolean equals(Split o) {
        if (this.fromIndex != o.fromIndex) {
            return false;
        }
        if (this.toIndex != o.toIndex) {
            return false;
        }
        if (this.ntuples != o.ntuples) {
            return false;
        }
        return this.pmd.equals(o.pmd);
    }

    public String toString() {
        return "Split{ ntuples=" + this.ntuples + ", fromIndex=" + this.fromIndex + ", toIndex=" + this.toIndex + ", pmd=" + this.pmd + "}";
    }
}

