/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IParallelizableIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.proc.LongAggregator;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ModifiedEnum;
import com.bigdata.rdf.spo.SPOTupleSerializer;
import com.bigdata.relation.IMutableRelationIndexWriteProcedure;
import com.bigdata.util.BytesUtil;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.log4j.Logger;

public class SPOIndexWriteProc
extends AbstractKeyArrayIndexProcedure<Object>
implements IParallelizableIndexProcedure<Object>,
IMutableRelationIndexWriteProcedure<Object> {
    private static final transient Logger log = Logger.getLogger(SPOIndexWriteProc.class);
    private final transient boolean INFO = log.isInfoEnabled();
    private final transient boolean DEBUG = log.isDebugEnabled();
    private static final long serialVersionUID = 3969394126242598370L;
    private transient boolean reportMutation;

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    public SPOIndexWriteProc() {
    }

    protected SPOIndexWriteProc(IRabaCoder keySer, IRabaCoder valSer, int fromIndex, int toIndex, byte[][] keys, byte[][] vals, boolean reportMutation) {
        super(keySer, valSer, fromIndex, toIndex, keys, vals);
        assert (vals != null);
        this.reportMutation = reportMutation;
    }

    @Override
    public Object applyOnce(IIndex ndx, IRaba keys, IRaba vals) {
        int i;
        ModifiedEnum[] modified;
        int writeCount = 0;
        int n = keys.size();
        SPOTupleSerializer tupleSer = (SPOTupleSerializer)ndx.getIndexMetadata().getTupleSerializer();
        boolean isPrimaryIndex = this.INFO ? tupleSer.getKeyOrder().isPrimaryIndex() : false;
        ModifiedEnum[] modifiedEnumArray = modified = this.reportMutation ? new ModifiedEnum[n] : null;
        if (this.reportMutation) {
            for (i = 0; i < n; ++i) {
                modified[i] = ModifiedEnum.NONE;
            }
        }
        for (i = 0; i < n; ++i) {
            byte[] key = keys.get(i);
            assert (key != null);
            byte[] val = vals.get(i);
            assert (val != null);
            assert (val.length == 1);
            boolean override = StatementEnum.isOverride(val[0]);
            boolean userFlag = StatementEnum.isUserFlag(val[0]);
            StatementEnum newType = StatementEnum.decode(val[0]);
            byte[] oldval = ndx.lookup(key);
            if (oldval == null) {
                ndx.insert(key, tupleSer.serializeVal(false, userFlag, newType));
                if (isPrimaryIndex && this.DEBUG) {
                    log.debug((Object)("new SPO: key=" + BytesUtil.toString((byte[])key)));
                }
                ++writeCount;
                if (!this.reportMutation) continue;
                modified[i] = ModifiedEnum.INSERTED;
                continue;
            }
            StatementEnum oldType = StatementEnum.deserialize(oldval);
            if (oldType == StatementEnum.History || newType == StatementEnum.History) {
                if (oldType == newType) continue;
                ndx.insert(key, tupleSer.serializeVal(false, userFlag, newType));
                if (isPrimaryIndex && this.DEBUG) {
                    log.debug((Object)("Changing statement type: key=" + BytesUtil.toString((byte[])key) + ", oldType=" + (Object)((Object)oldType) + ", newType=" + (Object)((Object)newType)));
                }
                ++writeCount;
                if (!this.reportMutation) continue;
                modified[i] = newType == StatementEnum.History ? ModifiedEnum.REMOVED : ModifiedEnum.INSERTED;
                continue;
            }
            if (override) {
                if (oldType == newType) continue;
                assert (newType != StatementEnum.Explicit);
                ndx.insert(key, tupleSer.serializeVal(false, userFlag, newType));
                if (isPrimaryIndex && this.DEBUG) {
                    log.debug((Object)("Downgrading SPO: key=" + BytesUtil.toString((byte[])key) + ", oldType=" + (Object)((Object)oldType) + ", newType=" + (Object)((Object)newType)));
                }
                ++writeCount;
                if (!this.reportMutation) continue;
                modified[i] = ModifiedEnum.UPDATED;
                continue;
            }
            StatementEnum maxType = StatementEnum.max(oldType, newType);
            if (oldType == maxType) continue;
            ndx.insert(key, tupleSer.serializeVal(false, userFlag, maxType));
            if (isPrimaryIndex && this.DEBUG) {
                log.debug((Object)("Changing statement type: key=" + BytesUtil.toString((byte[])key) + ", oldType=" + (Object)((Object)oldType) + ", newType=" + (Object)((Object)newType) + ", maxType=" + (Object)((Object)maxType)));
            }
            ++writeCount;
            if (!this.reportMutation) continue;
            modified[i] = ModifiedEnum.UPDATED;
        }
        if (isPrimaryIndex && this.INFO) {
            log.info((Object)("Wrote " + writeCount + " SPOs on ndx=" + ndx.getIndexMetadata().getName()));
        }
        if (this.reportMutation) {
            boolean[] b = ModifiedEnum.toBooleans(modified, n);
            int onCount = 0;
            for (int i2 = 0; i2 < b.length; ++i2) {
                if (!b[i2]) continue;
                ++onCount;
            }
            AbstractKeyArrayIndexProcedure.ResultBitBuffer rbb = new AbstractKeyArrayIndexProcedure.ResultBitBuffer(b.length, b, onCount);
            return rbb;
        }
        return (long)writeCount;
    }

    @Override
    protected void writeMetadata(ObjectOutput out) throws IOException {
        super.writeMetadata(out);
        out.writeBoolean(this.reportMutation);
    }

    @Override
    protected void readMetadata(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readMetadata(in);
        this.reportMutation = in.readBoolean();
    }

    @Override
    protected IResultHandler<Object, Object> newAggregator() {
        if (this.reportMutation) {
            return new AbstractKeyArrayIndexProcedure.ResultBitBufferHandler(this.getKeys().size(), 2);
        }
        return new LongAggregator();
    }

    public static class IndexWriteProcConstructor
    extends AbstractKeyArrayIndexProcedureConstructor<SPOIndexWriteProc> {
        final boolean reportMutation;
        public static IndexWriteProcConstructor REPORT_MUTATION = new IndexWriteProcConstructor(true);
        public static IndexWriteProcConstructor INSTANCE = new IndexWriteProcConstructor(false);

        private IndexWriteProcConstructor(boolean reportMutation) {
            this.reportMutation = reportMutation;
        }

        @Override
        public final boolean sendValues() {
            return true;
        }

        @Override
        public SPOIndexWriteProc newInstance(IRabaCoder keySer, IRabaCoder valSer, int fromIndex, int toIndex, byte[][] keys, byte[][] vals) {
            return new SPOIndexWriteProc(keySer, valSer, fromIndex, toIndex, keys, vals, this.reportMutation);
        }
    }
}

