/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.PipelineOp;
import com.bigdata.rdf.sparql.ast.ASTBase;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AST2BOpBase {
    private static final Logger log = Logger.getLogger(AST2BOpBase.class);

    protected AST2BOpBase() {
    }

    protected static BOp[] leftOrEmpty(PipelineOp left) {
        BOp[] bOpArray;
        if (left == null) {
            bOpArray = BOp.NOARGS;
        } else {
            BOp[] bOpArray2 = new BOp[1];
            bOpArray = bOpArray2;
            bOpArray2[0] = left;
        }
        return bOpArray;
    }

    protected static PipelineOp applyQueryHints(PipelineOp op, ASTBase node, AST2BOpContext ctx) {
        op = AST2BOpBase._applyQueryHints(op, node.getQueryHints());
        return op;
    }

    protected static PipelineOp applyQueryHints(PipelineOp op, Properties nodeQueryHints, AST2BOpContext ctx) {
        op = AST2BOpBase._applyQueryHints(op, nodeQueryHints);
        return op;
    }

    private static PipelineOp _applyQueryHints(PipelineOp op, Properties queryHints) {
        if (queryHints == null) {
            return op;
        }
        Enumeration<?> pnames = queryHints.propertyNames();
        while (pnames.hasMoreElements()) {
            String name = (String)pnames.nextElement();
            String value = queryHints.getProperty(name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Query hint: op=" + op.getClass().getSimpleName() + " [" + name + "=" + value + "]"));
            }
            op = (PipelineOp)op.setProperty(name, value);
        }
        return op;
    }

    public static interface Annotations {
        public static final String QUADS = AST2BOpBase.class.getName() + ".quads";
        public static final boolean DEFAULT_QUADS = false;
        public static final String DATASET = AST2BOpBase.class.getName() + ".dataset";
        public static final String SCOPE = AST2BOpBase.class.getName() + ".scope";
        public static final String SIMPLE_JOIN = AST2BOpBase.class.getName() + ".simpleJoin";
        public static final String ORIGINAL_INDEX = AST2BOpBase.class.getName() + ".originalIndex";
        public static final String ESTIMATED_CARDINALITY = AST2BOpBase.class.getName() + ".estimatedCardinality";
        public static final String COST_SCAN = AST2BOpBase.class.getName() + ".cost.scan";
        public static final String COST_SUBQUERY = AST2BOpBase.class.getName() + ".cost.subquery";
        public static final String NKNOWN = AST2BOpBase.class.getName() + ".nknown";
        public static final String AUTO_COMMIT = AST2BOpBase.class.getName() + "AUTO_COMMIT";
    }
}

