/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.webapp.BigdataRDFContext;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.ConnegUtil;
import com.bigdata.rdf.sparql.ast.cache.CacheConnectionFactory;
import com.bigdata.rdf.sparql.ast.cache.ICacheConnection;
import com.bigdata.rdf.sparql.ast.cache.IDescribeCache;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.util.NV;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.model.Graph;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;

public class DescribeCacheServlet
extends BigdataRDFServlet {
    private static final transient Logger log = Logger.getLogger(DescribeCacheServlet.class);
    private static final long serialVersionUID = 1L;
    static final transient String ATTR_DESCRIBE_URIS = "describeUris";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        IDescribeCache describeCache;
        Set externalURIs = (Set)req.getAttribute(ATTR_DESCRIBE_URIS);
        if (externalURIs == null) {
            DescribeCacheServlet.buildAndCommitResponse(resp, 400, "text/plain", "Request attribute not found: describeUris", new NV[0]);
            return;
        }
        int nvalues = externalURIs.size();
        if (nvalues == 0) {
            DescribeCacheServlet.buildAndCommitResponse(resp, 400, "text/plain", "No URIs", new NV[0]);
            return;
        }
        BigdataRDFContext context = this.getBigdataRDFContext();
        QueryEngine queryEngine = QueryEngineFactory.getInstance().getQueryController(context.getIndexManager());
        ICacheConnection cacheConn = CacheConnectionFactory.getExistingCacheConnection(queryEngine);
        String namespace = this.getNamespace(req);
        long timestamp = this.getTimestamp(req);
        IDescribeCache iDescribeCache = describeCache = cacheConn == null ? null : cacheConn.getDescribeCache(namespace, timestamp);
        if (describeCache == null) {
            resp.setStatus(404);
            return;
        }
        AbstractTripleStore tripleStore = context.getTripleStore(namespace, timestamp);
        if (tripleStore == null) {
            this.buildAndCommitNamespaceNotFoundResponse(req, resp);
            return;
        }
        LinkedHashSet<BigdataURI> internalURIs = new LinkedHashSet<BigdataURI>();
        BigdataValueFactory valueFactory = tripleStore.getValueFactory();
        for (URI uRI : externalURIs) {
            internalURIs.add(valueFactory.asValue(uRI));
        }
        BigdataValue[] values = internalURIs.toArray(new BigdataValue[nvalues]);
        long numNotFound = tripleStore.getLexiconRelation().addTerms(values, nvalues, true);
        if (log.isInfoEnabled()) {
            log.info((Object)("Not found: " + numNotFound + " out of " + values.length));
        }
        Graph g = null;
        for (BigdataURI bigdataURI : internalURIs) {
            IV iv = bigdataURI.getIV();
            Graph x = describeCache.lookup(iv);
            if (x == null || g != null) continue;
            if (nvalues == 1) {
                g = x;
                continue;
            }
            g = new GraphImpl();
            g.addAll((Collection)x);
        }
        if (g == null) {
            resp.setStatus(404);
            return;
        }
        String string = req.getHeader("Accept");
        ConnegUtil util = new ConnegUtil(string);
        RDFFormat format = util.getRDFFormat(RDFFormat.RDFXML);
        try {
            String string2 = format.getDefaultMIMEType();
            resp.setContentType(string2);
            if (DescribeCacheServlet.isAttachment(string2)) {
                resp.setHeader("Content-disposition", "attachment; filename=query" + UUID.randomUUID() + "." + format.getDefaultFileExtension());
            }
            if (format.hasCharset()) {
                resp.setCharacterEncoding(format.getCharset().name());
            }
            ServletOutputStream os = resp.getOutputStream();
            RDFWriter w = ((RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format)).getWriter((OutputStream)os);
            w.startRDF();
            for (Statement s : g) {
                w.handleStatement(s);
            }
            w.endRDF();
            os.flush();
        }
        catch (Throwable throwable) {
            BigdataRDFServlet.launderThrowable(throwable, resp, "DESCRIBE: uris=" + internalURIs);
        }
    }
}

