/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.Banner;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.btree.BaseIndexStats;
import com.bigdata.cache.SynchronizedHardReferenceQueueWithTimeout;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.ITransactionService;
import com.bigdata.journal.Journal;
import com.bigdata.journal.WarmUpTask;
import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.CreateKBTask;
import com.bigdata.rdf.sail.webapp.BigdataRDFContext;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.BigdataServlet;
import com.bigdata.rdf.sail.webapp.ConfigParams;
import com.bigdata.rdf.sail.webapp.SparqlEndpointConfig;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.task.AbstractApiTask;
import com.bigdata.service.AbstractDistributedFederation;
import com.bigdata.service.AbstractScaleOutClient;
import com.bigdata.service.DefaultClientDelegate;
import com.bigdata.service.IBigdataClient;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.ScaleOutClientFactory;
import com.bigdata.util.httpd.AbstractHTTPD;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class BigdataRDFServletContextListener
implements ServletContextListener {
    private static final transient Logger log = Logger.getLogger(BigdataRDFServletContextListener.class);
    private Journal jnl = null;
    private AbstractScaleOutClient<?> jiniClient = null;
    private ITransactionService txs = null;
    private Long readLock = null;
    private long readLockTx;
    private BigdataRDFContext rdfContext;
    private Map<String, String> effectiveInitParams;
    private boolean closeIndexManager;
    public static final String INIT_PARAM_OVERRIDES = "INIT_PARAMS_OVERRIDES";

    protected String getInitParameter(String key) {
        return this.effectiveInitParams.get(key);
    }

    protected BigdataRDFContext getBigdataRDFContext() {
        return this.rdfContext;
    }

    public void contextInitialized(ServletContextEvent e) {
        String serviceWhitelist;
        boolean forceOverflow;
        IIndexManager indexManager;
        block38: {
            String s;
            long warmupTimeoutMillis;
            String s2;
            long queryTimeout;
            String s3;
            boolean readOnly;
            String s4;
            boolean describeEachNamedGraph;
            int queryThreadPoolSize;
            long timestamp;
            String s5;
            String s6;
            if (log.isInfoEnabled()) {
                log.info((Object)"");
            }
            Banner.banner();
            ServletContext context = e.getServletContext();
            this.effectiveInitParams = new LinkedHashMap<String, String>();
            Enumeration names = context.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = context.getInitParameter(name);
                this.effectiveInitParams.put(name, value);
            }
            Map initParamOverrides = (Map)context.getAttribute(INIT_PARAM_OVERRIDES);
            if (initParamOverrides != null) {
                this.effectiveInitParams.putAll(initParamOverrides);
            }
            if ((s6 = this.getInitParameter("namespace")) == null) {
                s6 = "kb";
            }
            String namespace = s6;
            if (log.isInfoEnabled()) {
                log.info((Object)("namespace=" + namespace));
            }
            boolean create = (s5 = this.getInitParameter("create")) != null ? Boolean.valueOf(s5) : true;
            if (log.isInfoEnabled()) {
                log.info((Object)("create=" + create));
            }
            if (context.getAttribute(IIndexManager.class.getName()) != null) {
                indexManager = (IIndexManager)context.getAttribute(IIndexManager.class.getName());
                this.closeIndexManager = false;
            } else {
                String defaultValue;
                String FQN_PROPERTY_FILE = ConfigParams.class.getName() + "." + "propertyFile";
                String propertyFile = System.getProperty(FQN_PROPERTY_FILE, defaultValue = this.getInitParameter("propertyFile"));
                if (propertyFile == null) {
                    throw new RuntimeException("Required config-param: propertyFile");
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("propertyFile=" + propertyFile));
                }
                indexManager = this.openIndexManager(propertyFile);
                this.closeIndexManager = true;
            }
            if (create) {
                Properties properties = indexManager instanceof IBigdataFederation ? ((IBigdataFederation)indexManager).getClient().getProperties() : ((Journal)indexManager).getProperties();
                AbstractApiTask.submitApiTask(indexManager, new CreateKBTask(namespace, properties));
            }
            this.txs = indexManager instanceof Journal ? ((Journal)indexManager).getTransactionManager().getTransactionService() : ((IBigdataFederation)indexManager).getTransactionService();
            String s7 = this.getInitParameter("readLock");
            Long l = this.readLock = s7 == null ? null : Long.valueOf(s7);
            if (this.readLock != null) {
                try {
                    timestamp = this.txs.newTx(this.readLock);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                log.warn((Object)("Holding read lock: readLock=" + this.readLock + ", tx: " + timestamp));
            } else {
                timestamp = -1L;
            }
            String s8 = this.getInitParameter("queryThreadPoolSize");
            int n = queryThreadPoolSize = s8 == null ? 16 : Integer.valueOf(s8);
            if (queryThreadPoolSize < 0) {
                throw new RuntimeException("queryThreadPoolSize : Must be non-negative, not: " + s8);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("queryThreadPoolSize=" + queryThreadPoolSize));
            }
            boolean bl = describeEachNamedGraph = (s4 = this.getInitParameter("describeEachNamedGraph")) == null ? false : Boolean.valueOf(s4);
            if (log.isInfoEnabled()) {
                log.info((Object)("describeEachNamedGraph=" + describeEachNamedGraph));
            }
            boolean bl2 = readOnly = (s3 = this.getInitParameter("readOnly")) == null ? false : Boolean.valueOf(s3);
            if (log.isInfoEnabled()) {
                log.info((Object)("readOnly=" + readOnly));
            }
            long l2 = queryTimeout = (s2 = this.getInitParameter("queryTimeout")) == null ? 0L : Long.valueOf(s2);
            if (queryTimeout < 0L) {
                throw new RuntimeException("queryTimeout : Must be non-negative, not: " + s2);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("queryTimeout=" + queryTimeout));
            }
            long l3 = warmupTimeoutMillis = (s = this.getInitParameter("warmupTimeout")) == null ? 0L : Long.valueOf(s);
            if (warmupTimeoutMillis < 0L) {
                throw new RuntimeException("warmupTimeout : Must be non-negative, not: " + s);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("warmupTimeout=" + warmupTimeoutMillis));
            }
            SparqlEndpointConfig config = new SparqlEndpointConfig(namespace, timestamp, queryThreadPoolSize, describeEachNamedGraph, readOnly, queryTimeout);
            this.rdfContext = new BigdataRDFContext(config, indexManager);
            context.setAttribute(BigdataServlet.ATTRIBUTE_INDEX_MANAGER, (Object)indexManager);
            context.setAttribute(BigdataRDFServlet.ATTRIBUTE_RDF_CONTEXT, (Object)this.rdfContext);
            if (indexManager instanceof Journal && warmupTimeoutMillis > 0L) {
                String s9;
                int warmupThreadPoolSize;
                LinkedList<String> warmupNamespaceList = new LinkedList<String>();
                String s10 = this.getInitParameter("warmupNamespaceList");
                if (s10 == null) {
                    s10 = "";
                }
                if (s10 != null) {
                    String[] a;
                    for (String t : a = s10.split(",")) {
                        if ((t = t.trim()).isEmpty()) continue;
                        warmupNamespaceList.add(t);
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("warmupNamespaceList=" + warmupNamespaceList));
                }
                int n2 = warmupThreadPoolSize = (s9 = this.getInitParameter("warmupThreadPoolSize")) == null ? 20 : Integer.valueOf(s9);
                if (warmupThreadPoolSize <= 0) {
                    throw new RuntimeException("warmupThreadPoolSize : Must be positive, not: " + s9);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("warmupThreadPoolSize=" + warmupThreadPoolSize));
                }
                boolean visitLeaves = false;
                log.warn((Object)("Warming up the journal: namespaces=" + (warmupNamespaceList == null || warmupNamespaceList.isEmpty() ? "ALL" : warmupNamespaceList) + ", warmupTheads=" + warmupThreadPoolSize + ", timeout=" + TimeUnit.MILLISECONDS.toSeconds(warmupTimeoutMillis) + "s"));
                Future<Map<String, BaseIndexStats>> ft = indexManager.getExecutorService().submit(new WarmUpTask((Journal)indexManager, warmupNamespaceList, timestamp, warmupThreadPoolSize, false));
                try {
                    Map<String, BaseIndexStats> statsMap = ft.get(warmupTimeoutMillis, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e1) {
                    throw new RuntimeException("Warmup failure: " + e1, e1);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
                catch (TimeoutException e1) {
                    if (!log.isInfoEnabled()) break block38;
                    log.info((Object)"Warmup terminated by timeout.");
                }
            }
        }
        if ((forceOverflow = Boolean.valueOf(this.getInitParameter("forceOverflow")).booleanValue()) && indexManager instanceof IBigdataFederation) {
            log.warn((Object)("Forcing compacting merge of all data services: " + new Date()));
            ((AbstractDistributedFederation)indexManager).forceOverflow(true, false);
            log.warn((Object)("Did compacting merge of all data services: " + new Date()));
        }
        if ((serviceWhitelist = this.getInitParameter("serviceWhitelist")) != null) {
            log.info((Object)("Service whitelist: " + serviceWhitelist));
            ServiceRegistry reg = ServiceRegistry.getInstance();
            reg.setWhitelistEnabled(true);
            for (String url : serviceWhitelist.split("\\s*,\\s*")) {
                reg.addWhitelistURL(url);
            }
        }
        ServiceProviderHook.forceLoad();
        if (log.isInfoEnabled()) {
            log.info((Object)"done");
        }
    }

    public void contextDestroyed(ServletContextEvent e) {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        if (this.rdfContext != null) {
            this.rdfContext.shutdownNow();
            this.rdfContext = null;
        }
        if (this.txs != null && this.readLock != null && this.readLock != -1L) {
            try {
                this.txs.abort(this.readLockTx);
            }
            catch (IOException ex) {
                log.error((Object)("Could not release transaction: tx=" + this.readLockTx), (Throwable)ex);
            }
            this.txs = null;
            this.readLock = null;
        }
        if (this.jnl != null) {
            if (this.closeIndexManager) {
                this.jnl.close();
            }
            this.jnl = null;
        }
        if (this.jiniClient != null) {
            if (this.closeIndexManager) {
                this.jiniClient.disconnect(true);
            }
            this.jiniClient = null;
        }
        this.effectiveInitParams = null;
        SynchronizedHardReferenceQueueWithTimeout.stopStaleReferenceCleaner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IIndexManager openIndexManager(String propertyFile) {
        IIndexManager indexManager;
        block17: {
            URL propertyFileUrl;
            if (new File(propertyFile).exists()) {
                try {
                    propertyFileUrl = new URL("file:" + propertyFile);
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                propertyFileUrl = BigdataRDFServletContextListener.class.getClassLoader().getResource(propertyFile);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("bigdata configuration: propertyFile=" + propertyFile + ", propertyFileUrl=" + propertyFileUrl));
            }
            if (propertyFileUrl == null) {
                throw new RuntimeException("Could not find file: file=" + propertyFile + ", user.dir=" + System.getProperty("user.dir"));
            }
            boolean isJini = false;
            if (propertyFile.endsWith(".config")) {
                isJini = true;
            } else if (propertyFile.endsWith(".properties")) {
                isJini = false;
            } else {
                throw new RuntimeException("File must have '.config' or '.properties' extension: " + propertyFile);
            }
            try {
                if (isJini) {
                    this.jiniClient = ScaleOutClientFactory.getJiniClient(new String[]{propertyFile});
                    this.jiniClient.setDelegate(new NanoSparqlServerFederationDelegate((IBigdataClient<?>)this.jiniClient, this));
                    indexManager = this.jiniClient.connect();
                    break block17;
                }
                Properties properties = new Properties();
                try (BufferedInputStream is = new BufferedInputStream(propertyFileUrl.openStream());){
                    properties.load(is);
                }
                if (System.getProperty(BigdataSail.Options.FILE) != null) {
                    properties.setProperty(BigdataSail.Options.FILE, System.getProperty(BigdataSail.Options.FILE));
                }
                this.jnl = new Journal(properties);
                indexManager = this.jnl;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return indexManager;
    }

    private static class NanoSparqlServerFederationDelegate<T>
    extends DefaultClientDelegate<T> {
        private final IBigdataClient<?> client;
        private final BigdataRDFServletContextListener servletContextListener;
        private static final String QUERY_ENGINE = "Query Engine";

        public NanoSparqlServerFederationDelegate(IBigdataClient<?> client, BigdataRDFServletContextListener servletContextListener) {
            super(client, null);
            this.client = client;
            if (servletContextListener == null) {
                throw new IllegalArgumentException();
            }
            this.servletContextListener = servletContextListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reattachDynamicCounters() {
            CounterSet tmp;
            CounterSet tmp2;
            IBigdataFederation<?> fed;
            try {
                fed = this.client.getFederation();
                assert (fed != null);
            }
            catch (IllegalStateException ex) {
                log.warn((Object)("Closed: " + ex));
                return;
            }
            CounterSet serviceRoot = fed.getServiceCounterSet();
            CounterSet counterSet = tmp2 = serviceRoot.makePath("Memory");
            synchronized (counterSet) {
                tmp2.detach("DirectBufferPool");
                tmp2.makePath("DirectBufferPool").attach(DirectBufferPool.getCounters());
            }
            QueryEngine queryEngine = QueryEngineFactory.getInstance().getQueryController(fed);
            CounterSet counterSet2 = tmp = serviceRoot;
            synchronized (counterSet2) {
                tmp.detach(QUERY_ENGINE);
                tmp.makePath(QUERY_ENGINE).attach(queryEngine.getCounters());
            }
        }

        @Override
        public AbstractHTTPD newHttpd(int httpdPort, ICounterSetAccess access) throws IOException {
            return null;
        }
    }
}

