/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.NV;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.RDRHistory;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.CustomServiceFactory;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCall;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.striterator.ChunkedWrappedIterator;
import cutthecrap.utils.striterators.Expander;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RDRHistoryServiceFactory
implements CustomServiceFactory {
    private static final transient Logger log = Logger.getLogger(RDRHistoryServiceFactory.class);
    private final BigdataNativeServiceOptions serviceOptions = new BigdataNativeServiceOptions();

    public RDRHistoryServiceFactory() {
        this.serviceOptions.setRunFirst(true);
    }

    @Override
    public IServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    @Override
    public ServiceCall<?> create(ServiceCallCreateParams params) {
        throw new UnsupportedOperationException("deprecated");
    }

    private void verifyGroup(GraphPatternGroup<IGroupMemberNode> group) {
        if (log.isDebugEnabled()) {
            log.debug(group);
        }
    }

    @Override
    public void startConnection(BigdataSail.BigdataSailConnection conn) {
        AbstractTripleStore database = conn.getTripleStore();
        if (database.isRDRHistory()) {
            RDRHistory history = database.getRDRHistoryInstance();
            history.init();
            conn.addChangeLog(history);
        }
    }

    @Override
    public Set<IVariable<?>> getRequiredBound(ServiceNode serviceNode) {
        throw new RuntimeException("Method not yet implemented.");
    }

    @Override
    public Set<IVariable<?>> getDesiredBound(ServiceNode serviceNode) {
        throw new RuntimeException("Method not yet implemented.");
    }

    private static class RDRHistoryServiceCall
    implements BigdataServiceCall {
        private final AbstractTripleStore database;
        private final IServiceOptions options;
        private final GraphPatternGroup<IGroupMemberNode> subgroup;
        private final StatementPatternNode sidNode;
        private final StatementPatternNode historyNode;

        public RDRHistoryServiceCall(AbstractTripleStore database, IServiceOptions options, GraphPatternGroup<IGroupMemberNode> subgroup) {
            this.database = database;
            this.options = options;
            this.subgroup = subgroup;
            List<StatementPatternNode> spNodes = subgroup.getChildren(StatementPatternNode.class);
            if (spNodes.size() != 2) {
                throw new IllegalArgumentException();
            }
            if (spNodes.get(0).sid() != null) {
                this.sidNode = spNodes.get(0);
                this.historyNode = spNodes.get(1);
            } else {
                this.sidNode = spNodes.get(1);
                this.historyNode = spNodes.get(0);
            }
        }

        @Override
        public IServiceOptions getServiceOptions() {
            return this.options;
        }

        public ICloseableIterator<IBindingSet> call(IBindingSet[] bindingSets) throws Exception {
            Predicate pred = new Predicate(new BOp[]{this.sidNode.s().getValueExpression(), this.sidNode.p().getValueExpression(), this.sidNode.o().getValueExpression(), this.historyNode.p().getValueExpression(), this.historyNode.o().getValueExpression()}, new NV[0]);
            byte flags = SidIV.toFlags();
            Striterator results = new Striterator(Collections.emptyIterator());
            LinkedHashMap<IPredicate, LinkedList<IBindingSet>> coalesced = new LinkedHashMap<IPredicate, LinkedList<IBindingSet>>();
            for (IBindingSet bs : bindingSets) {
                LinkedList<IBindingSet> values;
                IPredicate asBound = pred.asBound(bs);
                if (coalesced.containsKey(asBound)) {
                    values = (LinkedList<IBindingSet>)coalesced.get(asBound);
                } else {
                    values = new LinkedList<IBindingSet>();
                    coalesced.put(asBound, values);
                }
                values.add(bs);
            }
            final IV[] ivs = new IV[5];
            for (final Map.Entry entry : coalesced.entrySet()) {
                IVariableOrConstant term;
                final Predicate asBound = (Predicate)entry.getKey();
                SPOKeyOrder keyOrder = SPOKeyOrder.SPO;
                IIndex ndx = this.database.getSPORelation().getIndex(keyOrder);
                IKeyBuilder keyBuilder = ndx.getIndexMetadata().getKeyBuilder();
                keyBuilder.reset();
                keyBuilder.appendSigned(flags);
                for (int i = 0; i < 5 && (term = asBound.get(i)).isConstant(); ++i) {
                    IV iv = (IV)((Constant)term).get();
                    IVUtility.encode(keyBuilder, iv);
                }
                byte[] fromKey = keyBuilder.getKey();
                byte[] toKey = SuccessorUtil.successor((byte[])fromKey.clone());
                ITupleIterator titr = ndx.rangeIterator(fromKey, toKey, 0, 3, null);
                Striterator sitr = new Striterator((Iterator)titr);
                sitr.addFilter((IFilter)new Resolver(){
                    private static final long serialVersionUID = 1L;

                    protected Object resolve(Object e) {
                        ITuple t = (ITuple)e;
                        return t.getObject();
                    }
                });
                sitr.addFilter((IFilter)new Filter(){
                    private static final long serialVersionUID = 1L;

                    public boolean isValid(Object e) {
                        RDRHistoryServiceCall.this.toIVs((ISPO)e, ivs);
                        for (int i = 0; i < 5; ++i) {
                            IV iv;
                            IVariableOrConstant term = asBound.get(i);
                            if (!term.isConstant() || (iv = (IV)((Constant)term).get()).equals(ivs[i])) continue;
                            return false;
                        }
                        return true;
                    }
                });
                sitr.addFilter((IFilter)new Expander(){
                    private static final long serialVersionUID = 1L;

                    protected Iterator expand(Object e) {
                        RDRHistoryServiceCall.this.toIVs((ISPO)e, ivs);
                        Striterator it = new Striterator(((List)entry.getValue()).iterator());
                        it.addFilter((IFilter)new Resolver(){
                            private static final long serialVersionUID = 1L;

                            protected Object resolve(Object e) {
                                IBindingSet bs = ((IBindingSet)e).clone();
                                for (int i = 0; i < 5; ++i) {
                                    IVariableOrConstant term = asBound.get(i);
                                    if (!term.isVar()) continue;
                                    IVariable var = (IVariable)term;
                                    bs.set(var, new Constant<IV>(ivs[i]));
                                }
                                return bs;
                            }
                        });
                        return it;
                    }
                });
                results.append((Iterator)sitr);
            }
            return new ChunkedWrappedIterator<IBindingSet>((Iterator<IBindingSet>)results);
        }

        private void toIVs(ISPO spo, IV[] ivs) {
            ISPO sid = ((SidIV)spo.s()).getInlineValue();
            ivs[0] = sid.s();
            ivs[1] = sid.p();
            ivs[2] = sid.o();
            ivs[3] = spo.p();
            ivs[4] = spo.o();
        }
    }
}

