/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.load;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.rdf.load.AbstractRDFTaskFactory;
import com.bigdata.rdf.load.IStatementBufferFactory;
import com.bigdata.rdf.load.LoadStatementBufferFactory;
import com.bigdata.rdf.rio.IAsynchronousWriteStatementBufferFactory;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.store.AbstractTripleStore;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;

public class RDFLoadTaskFactory<S extends Statement, T extends Runnable>
extends AbstractRDFTaskFactory<S, T> {
    public RDFLoadTaskFactory(AbstractTripleStore db, int bufferCapacity, RDFParserOptions parserOptions, boolean deleteafter, RDFFormat fallback) {
        this(db, parserOptions, deleteafter, fallback, new LoadStatementBufferFactory(db, bufferCapacity));
    }

    public RDFLoadTaskFactory(AbstractTripleStore db, RDFParserOptions parserOptions, boolean deleteafter, RDFFormat fallback, IStatementBufferFactory factory) {
        super(db, parserOptions, deleteafter, fallback, factory);
    }

    public CounterSet getCounters() {
        CounterSet counterSet = new CounterSet();
        counterSet.addCounter("elapsed", new Instrument<Long>(){

            @Override
            protected void sample() {
                long elapsed = RDFLoadTaskFactory.this.elapsed();
                this.setValue(elapsed);
            }
        });
        counterSet.addCounter("toldTriplesLoaded", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(RDFLoadTaskFactory.this.toldTriples.get());
            }
        });
        counterSet.addCounter("toldTriplesPerSec", new Instrument<Long>(){

            @Override
            protected void sample() {
                long elapsed = RDFLoadTaskFactory.this.elapsed();
                double tps = (long)((double)RDFLoadTaskFactory.this.toldTriples.get() / (double)elapsed * 1000.0);
                this.setValue((long)tps);
            }
        });
        if (this.bufferFactory instanceof IAsynchronousWriteStatementBufferFactory) {
            counterSet.attach(((IAsynchronousWriteStatementBufferFactory)this.bufferFactory).getCounters());
        }
        return counterSet;
    }

    public String reportTotals() {
        long elapsed = this.elapsed();
        long nterms = this.db.getTermCount();
        long nstmts = this.db.getStatementCount();
        double tps = (long)((double)nstmts / (double)elapsed * 1000.0);
        return "Database: #terms=" + nterms + ", #stmts=" + nstmts + ", rate=" + tps + " in " + elapsed + " ms.";
    }
}

