/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.InlineSignedIntegerURIHandler;

public abstract class InlineLocalNameIntegerURIHandler
extends InlineSignedIntegerURIHandler {
    protected int packedId = 0;
    private static final int MAX_IDS = 31;
    private static final long ID_MASK = Long.MIN_VALUE;
    private static final long MAX_VALUE = 0x200000000000080L;

    public InlineLocalNameIntegerURIHandler(String namespace) {
        super(namespace);
    }

    public InlineLocalNameIntegerURIHandler(String namespace, int packedId) {
        super(namespace);
        if (packedId > 31) {
            throw new RuntimeException(packedId + " is greater than the max ids value:  " + 31);
        }
        if (packedId < 0) {
            throw new RuntimeException(packedId + " is a negative value.");
        }
        this.packedId = packedId;
    }

    public long packValue(long value) {
        if (value >= 0x200000000000080L) {
            throw new RuntimeException(value + " exceeds " + 0x200000000000080L + ".");
        }
        if (value < 0L) {
            throw new RuntimeException(value + " is less than zero.");
        }
        long idVal = (long)this.packedId << 58;
        long packedVal = idVal | value;
        return packedVal;
    }

    public String getPackedValueString(String intVal) {
        String longVal = null;
        try {
            longVal = Long.toString(this.packValue(Long.parseLong(intVal)));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return longVal;
    }

    public String getUnpackedValueString(String s) {
        return Long.toString(this.unpackValue(Long.parseLong(s)));
    }

    public long getUnpackedValueFromString(String s) {
        return this.unpackValue(Long.parseLong(s));
    }

    public long unpackValue(long packedVal) {
        long idVal = (long)this.packedId << 58;
        long unpackedVal = packedVal & (idVal ^ 0xFFFFFFFFFFFFFFFFL);
        return unpackedVal;
    }

    public int unpackId(String s) {
        return this.unpackId(Long.parseLong(s));
    }

    public int unpackId(long packedVal) {
        long unpackedId = (packedVal & Long.MAX_VALUE) >> 58;
        return (int)unpackedId;
    }
}

