/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.quorum;

import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumClient;
import com.bigdata.quorum.QuorumEvent;
import java.rmi.Remote;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public abstract class AbstractQuorumClient<S extends Remote>
implements QuorumClient<S> {
    protected static final transient Logger log = Logger.getLogger(AbstractQuorumClient.class);
    private final AtomicReference<Quorum<?, ?>> quorum = new AtomicReference();
    private final String logicalServiceZPath;

    @Override
    public final String getLogicalServiceZPath() {
        return this.logicalServiceZPath;
    }

    protected AbstractQuorumClient(String logicalServiceZPath) {
        if (logicalServiceZPath == null) {
            throw new IllegalArgumentException();
        }
        this.logicalServiceZPath = logicalServiceZPath;
    }

    @Override
    public Quorum<?, ?> getQuorum() {
        Quorum<?, ?> tmp = this.quorum.get();
        if (tmp == null) {
            throw new IllegalStateException();
        }
        return tmp;
    }

    @Override
    public void start(Quorum<?, ?> quorum) {
        if (quorum == null) {
            throw new IllegalArgumentException();
        }
        if (!this.quorum.compareAndSet(null, quorum)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void terminate() {
        this.quorum.set(null);
    }

    @Override
    public void disconnected() {
    }

    @Override
    public S getLeader(long token) {
        Quorum<?, ?> q = this.getQuorum();
        q.assertQuorum(token);
        UUID leaderId = q.getLeaderId();
        if (leaderId == null) {
            q.assertQuorum(token);
            throw new AssertionError();
        }
        return this.getService(leaderId);
    }

    @Override
    public abstract S getService(UUID var1);

    @Override
    public void notify(QuorumEvent e) {
    }
}

