/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InetAddressUtil {
    private static final Pattern ipv4 = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)$");

    public static InetAddress getByName(String s) throws UnknownHostException {
        if (s == null) {
            throw new NullPointerException();
        }
        Matcher m = ipv4.matcher(s);
        if (m.matches()) {
            byte a = InetAddressUtil.encodeByte(Integer.parseInt(m.group(1)) - 128);
            byte b = InetAddressUtil.encodeByte(Integer.parseInt(m.group(2)) - 128);
            byte c = InetAddressUtil.encodeByte(Integer.parseInt(m.group(3)) - 128);
            byte d = InetAddressUtil.encodeByte(Integer.parseInt(m.group(4)) - 128);
            return InetAddress.getByAddress(s, new byte[]{a, b, c, d});
        }
        return InetAddress.getByName(s);
    }

    static final byte decodeByte(int v) {
        int i = v;
        i = i < 0 ? (i += 128) : (i -= 128);
        return (byte)(i & 0xFF);
    }

    static final byte encodeByte(int v) {
        if (v > 127 || v < -128) {
            throw new IllegalArgumentException("v=" + v);
        }
        int i = v;
        i = i < 0 ? (i -= 128) : (i += 128);
        return (byte)(i & 0xFF);
    }
}

