/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.btree.BaseIndexStats;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.journal.ICommitRecord;
import com.bigdata.journal.Journal;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.LatchedExecutor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class WarmUpTask
implements Callable<Map<String, BaseIndexStats>> {
    private static final Logger log = Logger.getLogger(WarmUpTask.class);
    private final Journal journal;
    private final List<String> namespaces;
    private final long timestamp;
    private final int nparallel;
    private final boolean visitLeaves;
    private final Map<String, BaseIndexStats> statsMap = new TreeMap<String, BaseIndexStats>();

    public WarmUpTask(Journal journal, List<String> namespaces, long timestamp, int nparallel, boolean visitLeaves) {
        if (journal == null) {
            throw new IllegalArgumentException();
        }
        if (nparallel < 1) {
            throw new IllegalArgumentException();
        }
        this.journal = journal;
        this.namespaces = namespaces;
        this.timestamp = timestamp;
        this.nparallel = nparallel;
        this.visitLeaves = visitLeaves;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, BaseIndexStats> call() throws Exception {
        long begin = System.nanoTime();
        long tx = this.journal.newTx(this.timestamp);
        try {
            long readOnCommitTime = this.journal.getLocalTransactionManager().getTx(tx).getReadsOnCommitTime();
            final ICommitRecord commitRecord = this.journal.getCommitRecord(readOnCommitTime);
            LinkedList<FutureTask<BaseIndexStats>> tasks = new LinkedList<FutureTask<BaseIndexStats>>();
            Iterator<String> nitr = this.journal.indexNameScan(null, this.timestamp);
            while (nitr.hasNext()) {
                final String string = nitr.next();
                if (this.namespaces != null && !this.namespaces.isEmpty()) {
                    boolean bl = false;
                    for (String namespace : this.namespaces) {
                        if (!string.startsWith(namespace)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will warm up index: name=" + string));
                }
                tasks.add(new FutureTask<BaseIndexStats>(new Callable<BaseIndexStats>(){

                    @Override
                    public BaseIndexStats call() throws Exception {
                        return WarmUpTask.this.warmUpIndex(string, commitRecord);
                    }
                }));
            }
            try {
                LatchedExecutor executor = new LatchedExecutor(this.journal.getExecutorService(), this.nparallel);
                for (FutureTask futureTask : tasks) {
                    executor.execute(futureTask);
                }
                for (FutureTask futureTask : tasks) {
                    BaseIndexStats stats = (BaseIndexStats)futureTask.get();
                    this.statsMap.put(stats.name, stats);
                }
            }
            finally {
                for (FutureTask futureTask : tasks) {
                    futureTask.cancel(true);
                }
            }
            long elapsed = System.nanoTime() - begin;
            if (log.isInfoEnabled()) {
                StringWriter stringWriter = new StringWriter(this.statsMap.size() * 1024);
                stringWriter.append("Warmed up: " + this.statsMap.size() + " indices in " + TimeUnit.NANOSECONDS.toMillis(elapsed) + "ms using up to " + this.nparallel + " threads.\n");
                PrintWriter w = new PrintWriter(stringWriter);
                BaseIndexStats.writeOn(w, this.statsMap);
                w.flush();
                log.info((Object)stringWriter.toString());
            }
            Map<String, BaseIndexStats> map = Collections.unmodifiableMap(this.statsMap);
            return map;
        }
        finally {
            this.journal.abort(tx);
        }
    }

    private BaseIndexStats warmUpIndex(String name, ICommitRecord commitRecord) {
        ICheckpointProtocol ndx;
        try {
            ndx = this.journal.getIndexWithCommitRecord(name, commitRecord);
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause((Throwable)t, ClassNotFoundException.class)) {
                log.warn((Object)("Could not load index: " + InnerCause.getInnerCause((Throwable)t, ClassNotFoundException.class)));
                return null;
            }
            throw new RuntimeException(t);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)ndx.getCheckpoint());
        }
        BaseIndexStats stats = ndx.dumpPages(true, this.visitLeaves);
        if (log.isInfoEnabled()) {
            log.info((Object)("name=" + name + ", stats=" + stats));
        }
        return stats;
    }
}

