/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ByteCountOutputStream
extends FilterOutputStream {
    private final OutputStream out;
    private int nwritten = 0;

    public int getNWritten() {
        return this.nwritten;
    }

    public ByteCountOutputStream(OutputStream out) {
        super(out);
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        ++this.nwritten;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.nwritten += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.nwritten += len;
    }
}

