/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.data.ILeafData;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.htree.raba.MutableKeyBuffer;
import com.bigdata.htree.raba.MutableValueBuffer;
import com.bigdata.io.AbstractFixedByteArrayBuffer;

public class MutableBucketData
implements ILeafData {
    final MutableKeyBuffer keys;
    final MutableValueBuffer vals;
    final boolean[] deleteMarkers;
    final long[] versionTimestamps;
    long minimumVersionTimestamp;
    long maximumVersionTimestamp;
    final boolean[] rawRecords;

    public MutableBucketData(int branchingFactor, boolean hasVersionTimestamps, boolean hasDeleteMarkers, boolean hasRawRecords) {
        this.keys = new MutableKeyBuffer(branchingFactor);
        this.vals = new MutableValueBuffer(branchingFactor);
        this.versionTimestamps = hasVersionTimestamps ? new long[branchingFactor] : null;
        this.minimumVersionTimestamp = Long.MAX_VALUE;
        this.maximumVersionTimestamp = Long.MIN_VALUE;
        this.deleteMarkers = hasDeleteMarkers ? new boolean[branchingFactor] : null;
        this.rawRecords = hasRawRecords ? new boolean[branchingFactor] : null;
    }

    public MutableBucketData(int branchingFactor, ILeafData src) {
        int i;
        this.keys = new MutableKeyBuffer(branchingFactor, src.getKeys());
        this.vals = new MutableValueBuffer(branchingFactor, src.getValues());
        this.versionTimestamps = src.hasVersionTimestamps() ? new long[branchingFactor] : null;
        this.deleteMarkers = src.hasDeleteMarkers() ? new boolean[branchingFactor] : null;
        this.rawRecords = src.hasRawRecords() ? new boolean[branchingFactor] : null;
        int dataslots = this.keys.nkeys;
        if (this.versionTimestamps != null) {
            for (i = 0; i < dataslots; ++i) {
                this.versionTimestamps[i] = src.getVersionTimestamp(i);
            }
            this.minimumVersionTimestamp = src.getMinimumVersionTimestamp();
            this.maximumVersionTimestamp = src.getMaximumVersionTimestamp();
        } else {
            this.minimumVersionTimestamp = Long.MAX_VALUE;
            this.maximumVersionTimestamp = Long.MIN_VALUE;
        }
        if (this.deleteMarkers != null) {
            for (i = 0; i < dataslots; ++i) {
                this.deleteMarkers[i] = src.getDeleteMarker(i);
            }
        }
        if (this.rawRecords != null) {
            for (i = 0; i < dataslots; ++i) {
                this.rawRecords[i] = src.getRawRecord(i) != 0L;
            }
        }
    }

    MutableBucketData(MutableKeyBuffer keys, MutableValueBuffer values, long[] versionTimestamps, boolean[] deleteMarkers, boolean[] rawRecords) {
        assert (keys != null);
        assert (values != null);
        assert (keys.capacity() == values.capacity());
        if (versionTimestamps != null) assert (versionTimestamps.length == keys.capacity());
        if (deleteMarkers != null) assert (deleteMarkers.length == keys.capacity());
        if (rawRecords != null) assert (rawRecords.length == keys.capacity());
        this.keys = keys;
        this.vals = values;
        this.versionTimestamps = versionTimestamps;
        this.deleteMarkers = deleteMarkers;
        this.rawRecords = rawRecords;
        if (versionTimestamps != null) {
            this.recalcMinMaxVersionTimestamp();
        }
    }

    public final int capacity() {
        return this.keys.capacity();
    }

    protected final boolean rangeCheckTupleIndex(int index) {
        if (index < 0 || index > this.keys.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        return true;
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public final boolean isCoded() {
        return false;
    }

    @Override
    public final AbstractFixedByteArrayBuffer data() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getVersionTimestamp(int index) {
        if (this.versionTimestamps == null) {
            throw new UnsupportedOperationException();
        }
        assert (this.rangeCheckTupleIndex(index));
        return this.versionTimestamps[index];
    }

    @Override
    public final long getMinimumVersionTimestamp() {
        if (this.versionTimestamps == null) {
            throw new UnsupportedOperationException();
        }
        return this.minimumVersionTimestamp;
    }

    @Override
    public final long getMaximumVersionTimestamp() {
        if (this.versionTimestamps == null) {
            throw new UnsupportedOperationException();
        }
        return this.maximumVersionTimestamp;
    }

    @Override
    public final boolean getDeleteMarker(int index) {
        if (this.deleteMarkers == null) {
            throw new UnsupportedOperationException();
        }
        assert (this.rangeCheckTupleIndex(index));
        return this.deleteMarkers[index];
    }

    @Override
    public final long getRawRecord(int index) {
        if (this.rawRecords == null) {
            throw new UnsupportedOperationException();
        }
        assert (this.rangeCheckTupleIndex(index));
        if (!this.rawRecords[index]) {
            return 0L;
        }
        byte[] val = this.vals.get(index);
        long addr = AbstractBTree.decodeRecordAddr(val);
        return addr;
    }

    @Override
    public final IRaba getValues() {
        return this.vals;
    }

    @Override
    public final IRaba getKeys() {
        return this.keys;
    }

    @Override
    public final boolean isLeaf() {
        return true;
    }

    @Override
    public final int getValueCount() {
        return this.vals.size();
    }

    @Override
    public final boolean hasRawRecords() {
        return this.rawRecords != null;
    }

    @Override
    public final boolean hasDeleteMarkers() {
        return this.deleteMarkers != null;
    }

    @Override
    public final boolean hasVersionTimestamps() {
        return this.versionTimestamps != null;
    }

    @Override
    public final int getKeyCount() {
        return this.keys.size();
    }

    @Override
    public final boolean isDoubleLinked() {
        return false;
    }

    @Override
    public final long getNextAddr() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getPriorAddr() {
        throw new UnsupportedOperationException();
    }

    void recalcMinMaxVersionTimestamp() {
        if (this.versionTimestamps == null) {
            throw new UnsupportedOperationException();
        }
        int nkeys = this.keys.nkeys;
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (int i = 0; i < nkeys; ++i) {
            long t = this.versionTimestamps[i];
            if (t < min) {
                min = t;
            }
            if (t <= max) continue;
            max = t;
        }
        this.minimumVersionTimestamp = min;
        this.maximumVersionTimestamp = max;
    }

    public void insert(int insIndex, byte[] key, byte[] val, boolean rawRecord) {
        this.keys.insert(insIndex, key);
        this.vals.insert(insIndex, val);
        if (this.hasRawRecords()) {
            System.arraycopy(this.rawRecords, insIndex, this.rawRecords, insIndex + 1, this.vals.nvalues - insIndex - 1);
            this.rawRecords[insIndex] = rawRecord;
        } else assert (!rawRecord);
        if (this.hasDeleteMarkers()) {
            System.arraycopy(this.deleteMarkers, insIndex, this.deleteMarkers, insIndex + 1, this.vals.nvalues - insIndex - 1);
            this.deleteMarkers[insIndex] = false;
        }
        if (this.hasVersionTimestamps()) {
            System.arraycopy(this.versionTimestamps, insIndex, this.versionTimestamps, insIndex + 1, this.vals.nvalues - insIndex - 1);
            this.versionTimestamps[insIndex] = 0L;
        }
    }

    public void remove(int index) {
        if (this.hasDeleteMarkers()) {
            this.deleteMarkers[index] = true;
        } else {
            this.keys.remove(index);
            this.vals.remove(index);
            if (this.hasRawRecords()) {
                System.arraycopy(this.rawRecords, index + 1, this.rawRecords, index, this.vals.nvalues - index);
                this.rawRecords[this.vals.nvalues] = false;
            }
            if (this.hasVersionTimestamps()) {
                System.arraycopy(this.versionTimestamps, index + 1, this.versionTimestamps, index, this.vals.nvalues - index);
                this.versionTimestamps[this.vals.nvalues] = 0L;
            }
        }
    }
}

