/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.concurrent;

import com.bigdata.concurrent.DeadlockException;
import com.bigdata.concurrent.TimeoutException;
import com.bigdata.concurrent.TxDag;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class ResourceQueue<R, T> {
    protected static final Logger log = Logger.getLogger(ResourceQueue.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    private static final long serialVersionUID = 6759702404466026405L;
    private final R resource;
    final BlockingQueue<T> queue = new LinkedBlockingQueue<T>();
    final Lock lock = new ReentrantLock();
    final Condition available = this.lock.newCondition();
    final AtomicBoolean dead = new AtomicBoolean(false);
    final TxDag waitsFor;

    public R getResource() {
        return this.resource;
    }

    public boolean isLocked() {
        return !this.queue.isEmpty();
    }

    public int getQueueSize() {
        return Math.max(0, this.queue.size() - 1);
    }

    public boolean isGranted(T tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        return this.queue.peek() == tx;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{resource=" + this.resource + ", queue=" + this.queue.toString() + "}";
    }

    public ResourceQueue(R resource, TxDag waitsFor) {
        if (resource == null) {
            throw new NullPointerException();
        }
        this.resource = resource;
        this.waitsFor = waitsFor;
    }

    private final void assertNotDead() {
        if (this.dead.get()) {
            throw new IllegalStateException("Dead");
        }
    }

    private final void assertOwnsLock(Object tx) {
        if (this.queue.peek() != tx) {
            throw new IllegalStateException("Does not hold lock: " + tx);
        }
    }

    public void lock(T tx) throws InterruptedException, DeadlockException {
        this.lock(tx, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lock(T tx, long timeout) throws InterruptedException, DeadlockException {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (DEBUG) {
            log.debug((Object)("enter: tx=" + tx + ", queue=" + this));
        }
        this.lock.lock();
        if (DEBUG) {
            log.debug((Object)("have private lock: tx=" + tx + ", queue=" + this));
        }
        long begin = System.currentTimeMillis();
        try {
            this.assertNotDead();
            if (this.queue.peek() == tx) {
                if (!INFO) return;
                log.info((Object)("Already owns lock: tx=" + tx + ", queue=" + this));
                return;
            }
            if (this.queue.isEmpty()) {
                this.queue.add(tx);
                if (!INFO) return;
                log.info((Object)("Granted lock with empty queue: tx=" + tx + ", queue=" + this));
                return;
            }
            if (this.waitsFor != null) {
                Object[] predecessors = this.queue.toArray();
                try {
                    this.waitsFor.addEdges(tx, predecessors);
                }
                catch (DeadlockException ex) {
                    log.warn((Object)("Deadlock: tx=" + tx + ", queue=" + this));
                    throw ex;
                }
            }
            this.queue.add(tx);
            try {
                do {
                    long elapsed = System.currentTimeMillis() - begin;
                    if (timeout != 0L && elapsed >= timeout) {
                        throw new TimeoutException("After " + elapsed + " ms: tx=" + tx + ", queue=" + this);
                    }
                    if (INFO) {
                        log.info((Object)("Awaiting resource: tx=" + tx + ", queue=" + this));
                    }
                    long remaining = timeout - elapsed;
                    if (timeout == 0L) {
                        this.available.await();
                    } else if (!this.available.await(remaining, TimeUnit.MILLISECONDS)) {
                        throw new TimeoutException("After " + elapsed + " ms: tx=" + tx + ", queue=" + this);
                    }
                    if (INFO) {
                        log.info((Object)("Continuing after wait: tx=" + tx + ", queue=" + this));
                    }
                    if (!this.dead.get()) continue;
                    throw new InterruptedException("Resource is dead: " + this.resource);
                } while (this.queue.peek() != tx);
                if (!INFO) return;
                log.info((Object)("Lock granted after wait: tx=" + tx + ", queue=" + this));
                return;
            }
            catch (Throwable t) {
                if (this.waitsFor != null) {
                    TxDag txDag = this.waitsFor;
                    synchronized (txDag) {
                        try {
                            boolean waiting = true;
                            this.waitsFor.removeEdges(tx, true);
                        }
                        catch (Throwable t2) {
                            log.warn((Object)t2);
                        }
                    }
                }
                this.queue.remove(tx);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (!(t instanceof InterruptedException)) throw new RuntimeException(t);
                throw (InterruptedException)t;
            }
        }
        finally {
            this.lock.unlock();
            if (DEBUG) {
                log.debug((Object)("released private lock: tx=" + tx + ", queue=" + this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unlock(T tx) {
        if (DEBUG) {
            log.debug((Object)"enter");
        }
        this.lock.lock();
        if (DEBUG) {
            log.debug((Object)"have private lock");
        }
        try {
            this.assertNotDead();
            this.assertOwnsLock(tx);
            if (this.queue.remove() != tx) {
                throw new AssertionError();
            }
            if (this.waitsFor != null) {
                Iterator itr = this.queue.iterator();
                TxDag txDag = this.waitsFor;
                synchronized (txDag) {
                    while (itr.hasNext()) {
                        Object pendingTx = itr.next();
                        try {
                            this.waitsFor.removeEdge(pendingTx, tx);
                        }
                        catch (Throwable t) {
                            log.warn((Object)t.getMessage(), t);
                        }
                    }
                }
            }
            if (this.queue.isEmpty()) {
                if (!INFO) return;
                log.info((Object)"Nothing pending");
                return;
            }
            if (INFO) {
                log.info((Object)"Signaling blocked requestors");
            }
            this.available.signalAll();
            return;
        }
        finally {
            this.lock.unlock();
            if (DEBUG) {
                log.debug((Object)"released private lock");
            }
        }
    }

    public void clear(T tx) {
        this.lock.lock();
        try {
            this.assertNotDead();
            this.assertOwnsLock(tx);
            throw new UnsupportedOperationException();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }
}

