/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.BigdataStatics;
import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.AbstractNode;
import com.bigdata.btree.BTree;
import com.bigdata.btree.ChildIterator;
import com.bigdata.btree.DirtyChildIterator;
import com.bigdata.btree.IAbstractNode;
import com.bigdata.btree.Leaf;
import com.bigdata.btree.MutableNodeData;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.data.DefaultNodeCoder;
import com.bigdata.btree.data.INodeData;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.MutableKeyBuffer;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.journal.Journal;
import com.bigdata.util.BytesUtil;
import com.bigdata.util.concurrent.LatchedExecutor;
import cutthecrap.utils.striterators.EmptyIterator;
import cutthecrap.utils.striterators.Expander;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.SingleValueIterator;
import cutthecrap.utils.striterators.Striterator;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Level;

public class Node
extends AbstractNode<Node>
implements INodeData {
    INodeData data;
    transient Reference<AbstractNode<?>>[] childRefs;

    @Override
    protected final int minKeys() {
        return this.btree.minChildren - 1;
    }

    @Override
    protected final int maxKeys() {
        return this.btree.branchingFactor - 1;
    }

    protected final boolean rangeCheckChildIndex(int index) {
        if (index < 0 || index > this.data.getKeyCount() + 1) {
            throw new IndexOutOfBoundsException();
        }
        return true;
    }

    public final Reference<AbstractNode<?>> getChildRef(int index) {
        assert (this.rangeCheckChildIndex(index));
        return this.childRefs[index];
    }

    @Override
    public final INodeData getDelegate() {
        return this.data;
    }

    @Override
    public final boolean isLeaf() {
        return false;
    }

    @Override
    public final boolean isReadOnly() {
        return this.data.isReadOnly();
    }

    @Override
    public final boolean isCoded() {
        return this.data.isCoded();
    }

    @Override
    public final AbstractFixedByteArrayBuffer data() {
        return this.data.data();
    }

    @Override
    public final int getKeyCount() {
        return this.data.getKeyCount();
    }

    @Override
    public final IRaba getKeys() {
        return this.data.getKeys();
    }

    @Override
    public final int getChildCount() {
        return this.data.getChildCount();
    }

    @Override
    public final long getSpannedTupleCount() {
        return this.data.getSpannedTupleCount();
    }

    @Override
    public final long getChildAddr(int index) {
        return this.data.getChildAddr(index);
    }

    @Override
    public final long getChildEntryCount(int index) {
        return this.data.getChildEntryCount(index);
    }

    @Override
    public final long getMaximumVersionTimestamp() {
        return this.data.getMaximumVersionTimestamp();
    }

    @Override
    public long getMinimumVersionTimestamp() {
        return this.data.getMinimumVersionTimestamp();
    }

    @Override
    public final boolean hasVersionTimestamps() {
        return this.data.hasVersionTimestamps();
    }

    protected final void updateEntryCount(AbstractNode<?> child, long delta) {
        int index = this.getIndexOf(child);
        assert (!this.isReadOnly());
        MutableNodeData data = (MutableNodeData)this.data;
        int n = index;
        data.childEntryCounts[n] = data.childEntryCounts[n] + delta;
        data.nentries += delta;
        if (data.childEntryCounts[index] <= 0L) {
            throw new RuntimeException();
        }
        if (data.nentries <= 0L) {
            throw new RuntimeException();
        }
        if (child.hasVersionTimestamps()) {
            long cmin = child.getMinimumVersionTimestamp();
            long cmax = child.getMaximumVersionTimestamp();
            if (cmin < data.minimumVersionTimestamp) {
                data.minimumVersionTimestamp = cmin;
            }
            if (cmax > data.maximumVersionTimestamp) {
                data.maximumVersionTimestamp = cmax;
            }
        }
        if (this.parent != null) {
            ((Node)this.parent.get()).updateEntryCount(this, delta);
        }
    }

    protected final void updateMinMaxVersionTimestamp(AbstractNode<?> child) {
        assert (!this.isReadOnly());
        MutableNodeData data = (MutableNodeData)this.data;
        long cmin = child.getMinimumVersionTimestamp();
        long cmax = child.getMaximumVersionTimestamp();
        if (cmin < data.minimumVersionTimestamp) {
            data.minimumVersionTimestamp = cmin;
        }
        if (cmax > data.maximumVersionTimestamp) {
            data.maximumVersionTimestamp = cmax;
        }
        if (this.parent != null) {
            ((Node)this.parent.get()).updateMinMaxVersionTimestamp(child);
        }
    }

    protected Node(AbstractBTree btree, long addr, INodeData data) {
        super(btree, false);
        int branchingFactor = btree.branchingFactor;
        assert (data != null);
        this.setIdentity(addr);
        this.data = data;
        this.childRefs = new Reference[branchingFactor + 1];
    }

    protected Node(BTree btree) {
        super(btree, true);
        int branchingFactor = btree.branchingFactor;
        this.data = new MutableNodeData(branchingFactor, btree.getIndexMetadata().getVersionTimestamps());
        this.childRefs = new Reference[branchingFactor + 1];
    }

    protected Node(BTree btree, AbstractNode oldRoot, long nentries) {
        super(btree, true);
        assert (oldRoot == btree.root);
        assert (oldRoot.isDirty());
        int branchingFactor = btree.branchingFactor;
        this.childRefs = new Reference[branchingFactor + 1];
        assert (!btree.isReadOnly());
        MutableNodeData data = new MutableNodeData(branchingFactor, btree.getIndexMetadata().getVersionTimestamps());
        this.data = data;
        data.nentries = nentries;
        boolean wasDirty = btree.root.dirty;
        btree.root = this;
        if (!wasDirty) {
            btree.fireDirtyEvent();
        }
        this.childRefs[0] = oldRoot.self;
        data.childEntryCounts[0] = oldRoot.isLeaf() ? (long)((Leaf)oldRoot).getKeyCount() : ((Node)oldRoot).getSpannedTupleCount();
        oldRoot.parent = this.self;
        ++btree.height;
        int requiredQueueCapacity = 2 * (btree.height + 2);
        if (requiredQueueCapacity > btree.writeRetentionQueue.capacity()) {
            throw new UnsupportedOperationException("writeRetentionQueue: capacity=" + btree.writeRetentionQueue.capacity() + ", but height=" + btree.height);
        }
        ++btree.nnodes;
        ++btree.getBtreeCounters().rootsSplit;
        if (BTree.INFO || BigdataStatics.debug) {
            String msg = "BTree: increasing height: name=" + btree.metadata.getName() + ", height=" + btree.height + ", m=" + btree.getBranchingFactor() + ", nentries=" + btree.nentries;
            if (BTree.INFO) {
                BTree.log.info((Object)msg);
            }
            if (BigdataStatics.debug) {
                System.err.println(msg);
            }
        }
    }

    protected Node(Node src, long triggeredByChildId) {
        super(src);
        assert (!src.isDirty());
        assert (src.isReadOnly());
        assert (src.data != null);
        INodeData iNodeData = this.data = src.isReadOnly() ? new MutableNodeData(src.getBranchingFactor(), src.data) : src.data;
        assert (this.data != null);
        src.data = null;
        this.childRefs = src.childRefs;
        src.childRefs = null;
        int nkeys = this.data.getKeyCount();
        for (int i = 0; i <= nkeys; ++i) {
            AbstractNode<?> child;
            AbstractNode<?> abstractNode = child = this.childRefs[i] == null ? null : this.childRefs[i].get();
            if (child == null || this.btree.store != null && child.identity == triggeredByChildId) continue;
            assert (!child.isDirty());
            child.parent = this.self;
        }
    }

    @Override
    public void delete() {
        super.delete();
        this.childRefs = null;
        this.data = null;
    }

    void setChildAddr(AbstractNode<?> child) {
        if (!child.isPersistent()) {
            throw new IllegalStateException();
        }
        int i = this.getIndexOf(child);
        assert (!this.isReadOnly());
        ((MutableNodeData)this.data).childAddr[i] = child.getIdentity();
    }

    void replaceChildRef(long oldChildAddr, AbstractNode newChild) {
        assert (oldChildAddr != 0L || this.btree.store == null);
        assert (newChild != null);
        assert (!this.isPersistent());
        assert (!this.isReadOnly());
        assert (!newChild.isPersistent());
        assert (!this.isReadOnly());
        MutableNodeData data = (MutableNodeData)this.data;
        int nkeys = this.getKeyCount();
        for (int i = 0; i <= nkeys; ++i) {
            if (data.childAddr[i] != oldChildAddr) continue;
            data.childAddr[i] = 0L;
            if (this.btree.storeCache != null) {
                this.btree.storeCache.remove(oldChildAddr);
            }
            this.btree.deleteNodeOrLeaf(oldChildAddr);
            this.childRefs[i] = newChild.self;
            newChild.parent = this.self;
            return;
        }
        throw new IllegalArgumentException("Not our child : oldChildAddr=" + oldChildAddr);
    }

    @Override
    public Tuple insert(byte[] key, byte[] value, boolean delete, boolean putIfAbsent, long timestamp, Tuple tuple) {
        assert (!this.deleted);
        if (this.btree.debug) {
            this.assertInvariants();
        }
        this.btree.touch(this);
        int childIndex = this.findChild(key);
        AbstractNode child = this.getChild(childIndex);
        return child.insert(key, value, delete, putIfAbsent, timestamp, tuple);
    }

    @Override
    public Tuple lookup(byte[] key, Tuple tuple) {
        assert (!this.deleted);
        if (this.btree.debug) {
            this.assertInvariants();
        }
        this.btree.touch(this);
        int childIndex = this.findChild(key);
        AbstractNode child = this.getChild(childIndex);
        return child.lookup(key, tuple);
    }

    @Override
    public Tuple remove(byte[] key, Tuple tuple) {
        assert (!this.deleted);
        if (this.btree.debug) {
            this.assertInvariants();
        }
        this.btree.touch(this);
        int childIndex = this.findChild(key);
        AbstractNode child = this.getChild(childIndex);
        return child.remove(key, tuple);
    }

    @Override
    public long indexOf(byte[] key) {
        assert (!this.deleted);
        this.btree.touch(this);
        int childIndex = this.findChild(key);
        AbstractNode child = this.getChild(childIndex);
        long offset = 0L;
        for (int i = 0; i < childIndex; ++i) {
            offset += this.getChildEntryCount(i);
        }
        long ret = child.indexOf(key);
        if (ret < 0L) {
            ret = -ret - 1L;
            return -(ret += offset) - 1L;
        }
        return ret += offset;
    }

    protected boolean rangeCheckSpannedTupleIndex(long entryIndex) {
        long nentries = this.data.getSpannedTupleCount();
        if (entryIndex < 0L) {
            throw new IndexOutOfBoundsException("negative: " + entryIndex);
        }
        if (entryIndex >= nentries) {
            throw new IndexOutOfBoundsException("too large: entryIndex=" + entryIndex + ", but nentries=" + nentries);
        }
        return true;
    }

    @Override
    public final byte[] keyAt(long entryIndex) {
        long nspanned;
        int childIndex;
        this.rangeCheckSpannedTupleIndex(entryIndex);
        long remaining = entryIndex;
        int nkeys = this.getKeyCount();
        for (childIndex = 0; childIndex <= nkeys && remaining >= (nspanned = this.getChildEntryCount(childIndex)); ++childIndex) {
            assert ((remaining -= nspanned) >= 0L);
        }
        AbstractNode child = this.getChild(childIndex);
        return child.keyAt(remaining);
    }

    @Override
    public final void valueAt(long entryIndex, Tuple tuple) {
        long nspanned;
        int childIndex;
        this.rangeCheckSpannedTupleIndex(entryIndex);
        long remaining = entryIndex;
        int nkeys = this.getKeyCount();
        for (childIndex = 0; childIndex <= nkeys && remaining >= (nspanned = this.getChildEntryCount(childIndex)); ++childIndex) {
            assert ((remaining -= nspanned) >= 0L);
        }
        AbstractNode child = this.getChild(childIndex);
        child.valueAt(remaining, tuple);
    }

    protected final int findChild(byte[] searchKey) {
        int childIndex = this.getKeys().search(searchKey);
        if (childIndex >= 0) {
            return childIndex + 1;
        }
        childIndex = -childIndex - 1;
        return childIndex;
    }

    @Override
    protected IAbstractNode split() {
        assert (this.isDirty());
        assert (this.getKeyCount() == this.maxKeys() + 1);
        BTree btree = (BTree)this.btree;
        ++btree.getBtreeCounters().nodesSplit;
        long nentriesBeforeSplit = this.getSpannedTupleCount();
        int nchildren = btree.branchingFactor + 1;
        int splitIndex = btree.branchingFactor >>> 1;
        byte[] separatorKey = this.getKeys().get(splitIndex);
        Node rightSibling = new Node(btree);
        MutableNodeData data = (MutableNodeData)this.data;
        MutableNodeData sdata = (MutableNodeData)rightSibling.data;
        MutableKeyBuffer keys = data.keys;
        MutableKeyBuffer skeys = sdata.keys;
        if (DEBUG) {
            log.debug((Object)("this=" + this + ", nkeys=" + this.getKeyCount() + ", splitIndex=" + splitIndex + ", separatorKey=" + Node.keyAsString(separatorKey)));
        }
        int j = 0;
        int i = splitIndex + 1;
        while (i < nchildren) {
            AbstractNode<?> tmp;
            long childEntryCount;
            if (i + 1 < nchildren) {
                rightSibling.copyKey(j, this.getKeys(), i);
            }
            rightSibling.childRefs[j] = this.childRefs[i];
            sdata.childAddr[j] = data.childAddr[i];
            sdata.childEntryCounts[j] = childEntryCount = data.childEntryCounts[i];
            sdata.nentries += childEntryCount;
            data.nentries -= childEntryCount;
            AbstractNode<?> abstractNode = tmp = this.childRefs[i] == null ? null : this.childRefs[i].get();
            if (tmp != null) {
                tmp.parent = rightSibling.self;
            }
            if (i + 1 < nchildren) {
                keys.keys[i] = null;
                --keys.nkeys;
                ++skeys.nkeys;
            }
            this.childRefs[i] = null;
            data.childAddr[i] = 0L;
            data.childEntryCounts[i] = 0L;
            ++i;
            ++j;
        }
        keys.keys[splitIndex] = null;
        --keys.nkeys;
        Node p = this.getParent();
        if (p == null) {
            p = new Node(btree, this, nentriesBeforeSplit);
        } else {
            assert (!p.isReadOnly());
            int n = p.getIndexOf(this);
            ((MutableNodeData)p.data).childEntryCounts[n] = ((MutableNodeData)p.data).childEntryCounts[n] - sdata.nentries;
        }
        p.insertChild(separatorKey, rightSibling);
        ++btree.nnodes;
        return rightSibling;
    }

    @Override
    protected void redistributeKeys(AbstractNode sibling, boolean isRightSibling) {
        Node s = (Node)sibling;
        assert (s != null);
        int nkeys = this.getKeyCount();
        int snkeys = s.getKeyCount();
        assert (this.dirty);
        assert (!this.deleted);
        assert (!this.isPersistent());
        assert (nkeys < this.minKeys());
        assert (nkeys == this.minKeys() - 1);
        assert (snkeys > this.minKeys());
        assert (s.dirty);
        assert (!s.deleted);
        assert (!s.isPersistent());
        Node p = this.getParent();
        assert (s.getParent() == p);
        if (DEBUG) {
            log.debug((Object)("this=" + this + ", sibling=" + sibling + ", rightSibling=" + isRightSibling));
        }
        int index = p.getIndexOf(this);
        MutableKeyBuffer keys = (MutableKeyBuffer)this.getKeys();
        MutableKeyBuffer skeys = (MutableKeyBuffer)s.getKeys();
        MutableNodeData data = (MutableNodeData)this.data;
        MutableNodeData sdata = (MutableNodeData)s.data;
        MutableNodeData pdata = (MutableNodeData)p.data;
        if (isRightSibling) {
            AbstractNode<?> child;
            long siblingChildCount;
            this.copyKey(nkeys, p.getKeys(), index);
            p.copyKey(index, s.getKeys(), 0);
            this.childRefs[nkeys + 1] = s.childRefs[0];
            data.childAddr[nkeys + 1] = sdata.childAddr[0];
            data.childEntryCounts[nkeys + 1] = siblingChildCount = sdata.childEntryCounts[0];
            AbstractNode<?> abstractNode = child = this.childRefs[nkeys + 1] == null ? null : this.childRefs[nkeys + 1].get();
            if (child != null) {
                child.parent = this.self;
            }
            System.arraycopy(skeys.keys, 1, skeys.keys, 0, snkeys - 1);
            System.arraycopy(s.childRefs, 1, s.childRefs, 0, snkeys);
            System.arraycopy(sdata.childAddr, 1, sdata.childAddr, 0, snkeys);
            System.arraycopy(sdata.childEntryCounts, 1, sdata.childEntryCounts, 0, snkeys);
            skeys.keys[snkeys - 1] = null;
            s.childRefs[snkeys] = null;
            sdata.childAddr[snkeys] = 0L;
            sdata.childEntryCounts[snkeys] = 0L;
            int n = index;
            pdata.childEntryCounts[n] = pdata.childEntryCounts[n] + siblingChildCount;
            int n2 = index + 1;
            pdata.childEntryCounts[n2] = pdata.childEntryCounts[n2] - siblingChildCount;
            data.nentries += siblingChildCount;
            sdata.nentries -= siblingChildCount;
            --skeys.nkeys;
            ++keys.nkeys;
            if (this.btree.debug) {
                this.assertInvariants();
                s.assertInvariants();
            }
        } else {
            AbstractNode<?> child;
            long siblingChildCount;
            System.arraycopy(keys.keys, 0, keys.keys, 1, nkeys);
            System.arraycopy(this.childRefs, 0, this.childRefs, 1, nkeys + 1);
            System.arraycopy(data.childAddr, 0, data.childAddr, 1, nkeys + 1);
            System.arraycopy(data.childEntryCounts, 0, data.childEntryCounts, 1, nkeys + 1);
            this.copyKey(0, p.getKeys(), index - 1);
            p.copyKey(index - 1, s.getKeys(), snkeys - 1);
            this.childRefs[0] = s.childRefs[snkeys];
            data.childAddr[0] = sdata.childAddr[snkeys];
            data.childEntryCounts[0] = siblingChildCount = sdata.childEntryCounts[snkeys];
            AbstractNode<?> abstractNode = child = this.childRefs[0] == null ? null : this.childRefs[0].get();
            if (child != null) {
                child.parent = this.self;
            }
            skeys.keys[snkeys - 1] = null;
            s.childRefs[snkeys] = null;
            sdata.childAddr[snkeys] = 0L;
            sdata.childEntryCounts[snkeys] = 0L;
            --skeys.nkeys;
            ++keys.nkeys;
            int n = index;
            pdata.childEntryCounts[n] = pdata.childEntryCounts[n] + siblingChildCount;
            int n3 = index - 1;
            pdata.childEntryCounts[n3] = pdata.childEntryCounts[n3] - siblingChildCount;
            data.nentries += siblingChildCount;
            sdata.nentries -= siblingChildCount;
            if (this.btree.debug) {
                this.assertInvariants();
                s.assertInvariants();
            }
        }
    }

    @Override
    protected void merge(AbstractNode sibling, boolean isRightSibling) {
        Node s = (Node)sibling;
        assert (s != null);
        assert (!s.deleted);
        int nkeys = this.getKeyCount();
        int snkeys = s.getKeyCount();
        assert (nkeys < this.minKeys());
        assert (nkeys == this.minKeys() - 1);
        assert (snkeys == s.minKeys());
        Node p = this.getParent();
        assert (s.getParent() == p);
        if (DEBUG) {
            log.debug((Object)("this=" + this + ", sibling=" + sibling + ", rightSibling=" + isRightSibling));
        }
        long siblingEntryCount = s.getSpannedTupleCount();
        int index = p.getIndexOf(this);
        MutableNodeData data = (MutableNodeData)this.data;
        MutableNodeData sdata = s.isReadOnly() ? new MutableNodeData(this.getBranchingFactor(), s.data) : (MutableNodeData)s.data;
        MutableNodeData pdata = (MutableNodeData)p.data;
        MutableKeyBuffer keys = data.keys;
        MutableKeyBuffer skeys = sdata.keys;
        if (isRightSibling) {
            this.copyKey(nkeys, p.getKeys(), index);
            ++keys.nkeys;
            System.arraycopy(skeys.keys, 0, keys.keys, ++nkeys, snkeys);
            System.arraycopy(s.childRefs, 0, this.childRefs, nkeys, snkeys + 1);
            System.arraycopy(sdata.childAddr, 0, data.childAddr, nkeys, snkeys + 1);
            System.arraycopy(sdata.childEntryCounts, 0, data.childEntryCounts, nkeys, snkeys + 1);
            Reference ref = this.self;
            for (int i = 0; i < snkeys + 1; ++i) {
                AbstractNode<?> child;
                AbstractNode<?> abstractNode = child = s.childRefs[i] == null ? null : s.childRefs[i].get();
                if (child == null) continue;
                child.parent = ref;
            }
            keys.nkeys += snkeys;
            p.copyKey(index, p.getKeys(), index + 1);
            int n = index;
            pdata.childEntryCounts[n] = pdata.childEntryCounts[n] + siblingEntryCount;
            data.nentries += siblingEntryCount;
            if (this.btree.debug) {
                this.assertInvariants();
            }
        } else {
            System.arraycopy(keys.keys, 0, keys.keys, snkeys + 1, nkeys);
            System.arraycopy(this.childRefs, 0, this.childRefs, snkeys + 1, nkeys + 1);
            System.arraycopy(data.childAddr, 0, data.childAddr, snkeys + 1, nkeys + 1);
            System.arraycopy(data.childEntryCounts, 0, data.childEntryCounts, snkeys + 1, nkeys + 1);
            System.arraycopy(skeys.keys, 0, keys.keys, 0, snkeys);
            System.arraycopy(s.childRefs, 0, this.childRefs, 0, snkeys + 1);
            System.arraycopy(sdata.childAddr, 0, data.childAddr, 0, snkeys + 1);
            System.arraycopy(sdata.childEntryCounts, 0, data.childEntryCounts, 0, snkeys + 1);
            this.copyKey(snkeys, p.getKeys(), index - 1);
            Reference ref = this.self;
            for (int i = 0; i < snkeys + 1; ++i) {
                AbstractNode<?> child;
                AbstractNode<?> abstractNode = child = s.childRefs[i] == null ? null : s.childRefs[i].get();
                if (child == null) continue;
                child.parent = ref;
            }
            keys.nkeys += snkeys + 1;
            int n = index;
            pdata.childEntryCounts[n] = pdata.childEntryCounts[n] + s.getSpannedTupleCount();
            data.nentries += siblingEntryCount;
            if (this.btree.debug) {
                this.assertInvariants();
            }
        }
        p.removeChild(s);
    }

    protected void insertChild(byte[] key, AbstractNode child) {
        long childEntryCount;
        if (this.btree.debug) {
            this.assertInvariants();
        }
        assert (child != null);
        assert (child.isDirty()) : "child not dirty";
        assert (this.isDirty()) : "not dirty";
        int childIndex = this.getKeys().search(key);
        if (childIndex >= 0) {
            throw new AssertionError((Object)("Split on existing key: childIndex=" + childIndex + ", key=" + Node.keyAsString(key) + "\nthis=" + this + "\nchild=" + child));
        }
        int nkeys = this.getKeyCount();
        childIndex = -childIndex - 1;
        assert (childIndex >= 0 && childIndex <= nkeys);
        assert (!this.isReadOnly());
        MutableNodeData data = (MutableNodeData)this.data;
        MutableKeyBuffer keys = (MutableKeyBuffer)this.getKeys();
        int length = nkeys - childIndex;
        if (length > 0) {
            System.arraycopy(keys.keys, childIndex, keys.keys, childIndex + 1, length);
        }
        System.arraycopy(this.childRefs, childIndex + 1, this.childRefs, childIndex + 2, length);
        System.arraycopy(data.childAddr, childIndex + 1, data.childAddr, childIndex + 2, length);
        System.arraycopy(data.childEntryCounts, childIndex + 1, data.childEntryCounts, childIndex + 2, length);
        keys.keys[childIndex] = key;
        this.childRefs[childIndex + 1] = child.self;
        data.childAddr[childIndex + 1] = 0L;
        data.childEntryCounts[childIndex + 1] = childEntryCount = child.isLeaf() ? (long)((Leaf)child).getKeyCount() : ((Node)child).getSpannedTupleCount();
        child.parent = this.self;
        ++keys.nkeys;
        if (keys.nkeys == this.maxKeys() + 1) {
            Node rightSibling = (Node)this.split();
            if (this.btree.debug) {
                this.getParent().assertInvariants();
                rightSibling.assertInvariants();
            }
            return;
        }
        if (this.btree.debug) {
            this.assertInvariants();
        }
    }

    protected AbstractNode getLeftSibling(AbstractNode child, boolean materialize) {
        AbstractNode sibling;
        int i = this.getIndexOf(child);
        if (i == 0) {
            return null;
        }
        int index = i - 1;
        AbstractNode abstractNode = sibling = this.childRefs[index] == null ? null : this.childRefs[index].get();
        if (sibling == null) {
            if (materialize) {
                sibling = this.getChild(index);
            }
        } else {
            this.btree.touch(sibling);
        }
        return sibling;
    }

    protected AbstractNode getRightSibling(AbstractNode child, boolean materialize) {
        AbstractNode sibling;
        int i = this.getIndexOf(child);
        if (i == this.getKeyCount()) {
            return null;
        }
        int index = i + 1;
        AbstractNode abstractNode = sibling = this.childRefs[index] == null ? null : this.childRefs[index].get();
        if (sibling == null) {
            if (materialize) {
                sibling = this.getChild(index);
            }
        } else {
            this.btree.touch(sibling);
        }
        return sibling;
    }

    protected int getIndexOf(AbstractNode child) {
        assert (child != null);
        assert (child.parent.get() == this);
        int nkeys = this.getKeyCount();
        for (int i = 0; i <= nkeys; ++i) {
            if (this.childRefs[i] == null || this.childRefs[i].get() != child) continue;
            return i;
        }
        throw new IllegalArgumentException("Not our child : child=" + child);
    }

    protected void removeChild(AbstractNode child) {
        int i;
        assert (child != null);
        assert (!child.deleted);
        assert (child.parent.get() == this);
        assert (this.dirty);
        assert (!this.deleted);
        assert (!this.isPersistent());
        assert (!this.isReadOnly());
        BTree btree = (BTree)this.btree;
        if (btree.debug) {
            this.assertInvariants();
        }
        if (DEBUG) {
            log.debug((Object)("this=" + this + ", child=" + child));
        }
        int index = i = this.getIndexOf(child);
        int nkeys = this.getKeyCount();
        int lengthChildCopy = nkeys - index;
        int lengthKeyCopy = lengthChildCopy - 1;
        MutableKeyBuffer keys = (MutableKeyBuffer)this.getKeys();
        MutableNodeData data = (MutableNodeData)this.data;
        if (data.childAddr[index] != 0L) {
            btree.recycle(data.childAddr[index]);
        }
        if (lengthKeyCopy > 0) {
            System.arraycopy(keys.keys, index + 1, keys.keys, index, lengthKeyCopy);
        }
        if (lengthChildCopy > 0) {
            System.arraycopy(this.childRefs, index + 1, this.childRefs, index, lengthChildCopy);
            System.arraycopy(data.childAddr, index + 1, data.childAddr, index, lengthChildCopy);
            System.arraycopy(data.childEntryCounts, index + 1, data.childEntryCounts, index, lengthChildCopy);
        }
        if (nkeys > 0) {
            keys.keys[nkeys - 1] = null;
        }
        this.childRefs[nkeys] = null;
        data.childAddr[nkeys] = 0L;
        data.childEntryCounts[nkeys] = 0L;
        child.parent = null;
        --keys.nkeys;
        if (child.isLeaf()) {
            --btree.nleaves;
        } else {
            --btree.nnodes;
        }
        child.delete();
        if (btree.root == this) {
            if (this.getKeyCount() == 0 && !this.isLeaf()) {
                AbstractNode lastChild = this.getChild(0);
                if (btree.debug) {
                    lastChild.assertInvariants();
                }
                if (DEBUG) {
                    log.debug((Object)("replacing root: root=" + btree.root + ", node=" + this + ", lastChild=" + lastChild));
                }
                boolean wasDirty = btree.root.dirty;
                assert (lastChild != null);
                btree.root = lastChild;
                if (!wasDirty) {
                    btree.fireDirtyEvent();
                }
                lastChild.parent = null;
                --btree.height;
                this.delete();
                --btree.nnodes;
                if (BTree.INFO) {
                    BTree.log.info((Object)("reduced tree height: height=" + btree.height + ", newRoot=" + btree.root));
                }
                ++btree.getBtreeCounters().rootsJoined;
            }
        } else if (this.data.getKeyCount() < this.minKeys()) {
            this.join();
        }
    }

    public final AbstractNode getChild(int index) {
        AbstractNode<?> child;
        this.btree.getBtreeCounters().cacheTests.increment();
        if (index < 0 || index > this.data.getKeyCount()) {
            throw new IndexOutOfBoundsException("index=" + index + ", nkeys=" + this.data.getKeyCount());
        }
        if (this.btree.memo == null) {
            this.btree.getBtreeCounters().cacheMisses.increment();
            return this._getChild(index, null);
        }
        Reference<AbstractNode<?>> childRef = this.childRefs[index];
        AbstractNode<?> abstractNode = child = childRef == null ? null : childRef.get();
        if (child != null) {
            return child;
        }
        this.btree.getBtreeCounters().cacheMisses.increment();
        return this.btree.loadChild(this, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractNode _getChild(int index, AbstractBTree.LoadChildRequest req) {
        Reference<AbstractNode<?>>[] referenceArray = this.childRefs;
        synchronized (this.childRefs) {
            AbstractNode<?> child;
            Reference<AbstractNode<?>> childRef = this.childRefs[index];
            AbstractNode<?> abstractNode = child = childRef == null ? null : childRef.get();
            if (child != null) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return child;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            this.btree.getBtreeCounters().cacheMisses.increment();
            long addr = this.data.getChildAddr(index);
            if (addr == 0L) {
                throw new AssertionError((Object)("Child does not have persistent identity: this=" + this + ", index=" + index));
            }
            child = this.btree.readNodeOrLeaf(addr);
            Reference<AbstractNode<?>>[] referenceArray2 = this.childRefs;
            synchronized (this.childRefs) {
                assert (this.childRefs[index] == null || this.childRefs[index].get() == null) : "Child is already set: this=" + this + ", index=" + index;
                child.parent = this.self;
                this.childRefs[index] = child.self;
                // ** MonitorExit[var6_8] (shouldn't be in output)
                if (req != null) {
                    this.btree.memo.removeFromCache(req);
                }
                return child;
            }
        }
    }

    protected AbstractNode getRightMostChild(boolean nodesOnly) {
        AbstractNode child = this.getChild(this.getKeyCount());
        assert (child != null);
        if (child.isLeaf()) {
            if (nodesOnly) {
                return this;
            }
            return child;
        }
        return ((Node)child).getRightMostChild(nodesOnly);
    }

    @Override
    public Iterator<AbstractNode> postOrderNodeIterator(boolean dirtyNodesOnly, boolean nodesOnly) {
        if (dirtyNodesOnly && !this.dirty) {
            return EmptyIterator.DEFAULT;
        }
        return new Striterator(this.postOrderIterator1(dirtyNodesOnly, nodesOnly)).append((Iterator)new SingleValueIterator((Object)this));
    }

    @Override
    public Iterator<AbstractNode> postOrderIterator(byte[] fromKey, byte[] toKey) {
        return new Striterator(this.postOrderIterator2(fromKey, toKey)).append((Iterator)new SingleValueIterator((Object)this));
    }

    private Iterator<AbstractNode> postOrderIterator1(final boolean dirtyNodesOnly, final boolean nodesOnly) {
        return new Striterator(this.childIterator(dirtyNodesOnly)).addFilter((IFilter)new Expander(){
            private static final long serialVersionUID = 1L;

            protected Iterator expand(Object childObj) {
                AbstractNode child = (AbstractNode)childObj;
                if (dirtyNodesOnly && !child.dirty) {
                    return EmptyIterator.DEFAULT;
                }
                if (child instanceof Node) {
                    Striterator itr = new Striterator(((Node)child).postOrderIterator1(dirtyNodesOnly, nodesOnly));
                    itr.append((Iterator)new SingleValueIterator((Object)child));
                    return itr;
                }
                if (nodesOnly) {
                    return EmptyIterator.DEFAULT;
                }
                return new SingleValueIterator((Object)child);
            }
        });
    }

    private Iterator<AbstractNode> postOrderIterator2(final byte[] fromKey, final byte[] toKey) {
        return new Striterator(this.childIterator(fromKey, toKey)).addFilter((IFilter)new Expander(){
            private static final long serialVersionUID = 1L;

            protected Iterator expand(Object childObj) {
                AbstractNode child = (AbstractNode)childObj;
                if (child instanceof Node) {
                    Striterator itr = new Striterator(((Node)child).postOrderIterator2(fromKey, toKey));
                    itr.append((Iterator)new SingleValueIterator((Object)child));
                    if (Node.this.btree.store instanceof Journal && ((Journal)Node.this.btree.store).getReadExecutor() != null) {
                        Node.this.prefetchChildLeaves((Node)child, fromKey, toKey);
                    }
                    return itr;
                }
                return new SingleValueIterator((Object)child);
            }
        });
    }

    protected void prefetchChildLeaves(final Node node, byte[] fromKey, byte[] toKey) {
        int index;
        int index2;
        int nkeys = node.getKeyCount();
        if (fromKey != null) {
            index2 = node.getKeys().search(fromKey);
            if (index2 < 0) {
                index2 = -index2 - 1;
            }
        } else {
            index2 = 0;
        }
        int fromIndex = index2;
        if (toKey != null) {
            index = node.getKeys().search(toKey);
            if (index < 0) {
                index = -index - 1;
            }
        } else {
            index = nkeys;
        }
        int toIndex = index;
        LatchedExecutor s = ((Journal)this.btree.store).getReadExecutor();
        int i = fromIndex;
        while (i < toIndex) {
            final int index3 = i++;
            s.execute(new Runnable(){

                @Override
                public void run() {
                    if (!node.btree.isOpen()) {
                        return;
                    }
                    node.getChild(index3);
                }
            });
        }
        if (toIndex == nkeys - 1) {
            this.prefetchRightSibling(node, toKey);
        }
    }

    protected void prefetchRightSibling(final Node node, byte[] toKey) {
        int nkeys = node.getKeyCount();
        byte[] lastSeparatorKey = node.getKeys().get(nkeys - 1);
        if (BytesUtil.compareBytes((byte[])toKey, (byte[])lastSeparatorKey) <= 0) {
            return;
        }
        final Node p = (Node)node.parent.get();
        LatchedExecutor s = ((Journal)this.btree.store).getReadExecutor();
        s.execute(new Runnable(){

            @Override
            public void run() {
                if (!p.btree.isOpen()) {
                    return;
                }
                p.getRightSibling(node, true);
            }
        });
    }

    public Iterator<AbstractNode> childIterator(boolean dirtyNodesOnly) {
        if (dirtyNodesOnly) {
            return new DirtyChildIterator(this);
        }
        return new ChildIterator(this);
    }

    public Iterator<AbstractNode> childIterator(byte[] fromKey, byte[] toKey) {
        return new ChildIterator(this, fromKey, toKey);
    }

    @Override
    public boolean dump(Level level, PrintStream out, int height, boolean recursive) {
        boolean debug = level.toInt() <= Level.DEBUG.toInt();
        boolean ok = true;
        int branchingFactor = this.getBranchingFactor();
        int nkeys = this.getKeyCount();
        int minKeys = this.minKeys();
        int maxKeys = this.maxKeys();
        if (this.parent != null && nkeys < minKeys) {
            out.println(Node.indent(height) + "ERROR: too few keys: m=" + branchingFactor + ", minKeys=" + minKeys + ", nkeys=" + nkeys + ", isLeaf=" + this.isLeaf());
            ok = false;
        }
        if (nkeys > maxKeys) {
            out.println(Node.indent(height) + "ERROR: too many keys: m=" + branchingFactor + ", maxKeys=" + maxKeys + ", nkeys=" + nkeys + ", isLeaf=" + this.isLeaf());
            ok = false;
        }
        if (this == this.btree.root && this.getSpannedTupleCount() != this.btree.getEntryCount()) {
            out.println(Node.indent(height) + "ERROR: root node has nentries=" + this.getSpannedTupleCount() + ", but btree has nentries=" + this.btree.getEntryCount());
            ok = false;
        }
        int nentries = 0;
        for (int i = 0; i <= nkeys; ++i) {
            if ((nentries = (int)((long)nentries + this.getChildEntryCount(i))) > 0) continue;
            out.println(Node.indent(height) + "ERROR: childEntryCount[" + i + "] is non-positive");
            ok = false;
        }
        if ((long)nentries != this.getSpannedTupleCount()) {
            out.println(Node.indent(height) + "ERROR: nentries(" + this.getSpannedTupleCount() + ") does not agree with sum of per-child counts(" + nentries + ")");
            ok = false;
        }
        if (this == this.btree.root) {
            if (this.parent != null) {
                out.println(Node.indent(height) + "ERROR: this is the root, but the parent is not null.");
                ok = false;
            }
        } else if (this.parent == null) {
            out.println(Node.indent(height) + "ERROR: the parent reference MUST be defined for a non-root node.");
            ok = false;
        } else if (this.parent.get() == null) {
            out.println(Node.indent(height) + "ERROR: the parent is not strongly reachable.");
            ok = false;
        }
        try {
            this.assertKeysMonotonic();
        }
        catch (AssertionError ex) {
            out.println(Node.indent(height) + "  ERROR: " + ex);
            ok = false;
        }
        if (debug) {
            out.println(Node.indent(height) + this.toString());
        }
        for (int i = 0; i < branchingFactor + 1; ++i) {
            long childSpannedEntryCount;
            AbstractNode<?> child;
            if (i > nkeys) {
                if (!this.isReadOnly() && ((MutableNodeData)this.data).childAddr[i] != 0L) {
                    out.println(Node.indent(height) + "  ERROR childAddr[" + i + "] should be " + 0L + ", not " + ((MutableNodeData)this.data).childAddr[i]);
                    ok = false;
                }
                if (this.childRefs[i] == null) continue;
                out.println(Node.indent(height) + "  ERROR childRefs[" + i + "] should be null, not " + this.childRefs[i]);
                ok = false;
                continue;
            }
            AbstractNode<?> abstractNode = child = this.childRefs[i] == null ? null : this.childRefs[i].get();
            if (child == null) continue;
            if (child.parent == null || child.parent.get() == null) {
                out.println(Node.indent(height) + "  ERROR child[" + i + "] does not have parent reference.");
                ok = false;
            }
            if (child.parent.get() != this) {
                out.println(Node.indent(height) + "  ERROR child[" + i + "] has wrong parent.");
                ok = false;
                if (!ok) {
                    if (level == Level.DEBUG) {
                        System.err.println("child");
                        child.dump(Level.DEBUG, System.err);
                        throw new AssertionError();
                    }
                    System.err.println("this");
                    this.dump(Level.DEBUG, System.err);
                }
            }
            long l = childSpannedEntryCount = child.isLeaf() ? (long)((Leaf)child).getKeyCount() : ((Node)child).getSpannedTupleCount();
            if (this.getChildEntryCount(i) != childSpannedEntryCount) {
                out.println(Node.indent(height) + "  ERROR child[" + i + "] spans " + childSpannedEntryCount + " entries, but childEntryCount[" + i + "]=" + this.getChildEntryCount(i));
                ok = false;
            }
            if (child.isDirty()) {
                if (!this.isDirty()) {
                    out.println(Node.indent(height) + "  ERROR child[" + i + "] is dirty, but its parent is clean");
                    ok = false;
                }
                if (this.childRefs[i] == null) {
                    out.println(Node.indent(height) + "  ERROR childRefs[" + i + "] is null, but the child is dirty");
                    ok = false;
                }
                if (this.getChildAddr(i) == 0L) continue;
                out.println(Node.indent(height) + "  ERROR childAddr[" + i + "]=" + this.getChildAddr(i) + ", but MUST be " + 0L + " since the child is dirty");
                ok = false;
                continue;
            }
            if (this.getChildAddr(i) != 0L) continue;
            out.println(Node.indent(height) + "  ERROR childKey[" + i + "] is " + 0L + ", but child is not dirty");
            ok = false;
        }
        if (ok || !debug) {
            // empty if block
        }
        if (recursive) {
            HashSet dirty = new HashSet();
            for (int i = 0; i <= branchingFactor; ++i) {
                AbstractNode<?> child;
                if (this.childRefs[i] == null && !this.isReadOnly() && ((MutableNodeData)this.data).childAddr[i] == 0L) {
                    if (i > nkeys) continue;
                    out.println(Node.indent(height + 1) + "ERROR can not find child at index=" + i + ", skipping this index.");
                    ok = false;
                    continue;
                }
                AbstractNode<?> abstractNode = child = this.childRefs[i] == null ? null : this.childRefs[i].get();
                if (child == null) continue;
                if (child.parent == null) {
                    out.println(Node.indent(height + 1) + "ERROR child does not have parent reference at index=" + i);
                    ok = false;
                }
                if (child.parent.get() != this) {
                    out.println(Node.indent(height + 1) + "ERROR child has incorrect parent reference at index=" + i);
                    ok = false;
                }
                if (child.isDirty()) {
                    dirty.add(child);
                }
                if (i == 0) {
                    if (nkeys != 0) {
                        byte[] ckn;
                        byte[] k0 = this.getKeys().get(0);
                        byte[] ck0 = child.getKeys().get(0);
                        if (BytesUtil.compareBytes((byte[])ck0, (byte[])k0) >= 0) {
                            out.println(Node.indent(height + 1) + "ERROR first key on first child must be LT " + Node.keyAsString(k0) + ", but found " + Node.keyAsString(ck0));
                            ok = false;
                        }
                        if (child.getKeyCount() >= 1 && BytesUtil.compareBytes((byte[])(ckn = child.getKeys().get(child.getKeyCount() - 1)), (byte[])k0) >= 0) {
                            out.println(Node.indent(height + 1) + "ERROR last key on first child must be LT " + Node.keyAsString(k0) + ", but found " + Node.keyAsString(ckn));
                            ok = false;
                        }
                    }
                } else if (i < nkeys) {
                    // empty if block
                }
                if (child.dump(level, out, height + 1, true)) continue;
                ok = false;
            }
        }
        return ok;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("{ isDirty=" + this.isDirty());
        sb.append(", isDeleted=" + this.isDeleted());
        sb.append(", addr=" + this.identity);
        Node p = this.parent == null ? null : (Node)this.parent.get();
        sb.append(", parent=" + (p == null ? "N/A" : p.toShortString()));
        if (this.data == null) {
            sb.append(", data=NA}");
            return sb.toString();
        }
        sb.append(", nkeys=" + this.getKeyCount());
        sb.append(", minKeys=" + this.minKeys());
        sb.append(", maxKeys=" + this.maxKeys());
        DefaultNodeCoder.toString(this, sb);
        int nchildren = this.getChildCount();
        sb.append(", children=[");
        for (int i = 0; i < nchildren; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            AbstractNode<?> child = this.childRefs[i] == null ? null : this.childRefs[i].get();
            sb.append(child == null ? "U" : "L");
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }
}

