/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.Banner;
import com.bigdata.BigdataStatics;
import com.bigdata.btree.AbstractBTreeTupleCursor;
import com.bigdata.btree.AbstractNode;
import com.bigdata.btree.BTree;
import com.bigdata.btree.BTreeCounters;
import com.bigdata.btree.BTreePageStats;
import com.bigdata.btree.BTreeStatistics;
import com.bigdata.btree.BTreeUtilizationReport;
import com.bigdata.btree.BaseIndexStats;
import com.bigdata.btree.BloomFilter;
import com.bigdata.btree.DefaultEvictionListener;
import com.bigdata.btree.EntryScanIterator;
import com.bigdata.btree.IAutoboxBTree;
import com.bigdata.btree.IBTreeStatistics;
import com.bigdata.btree.IBTreeUtilizationReport;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ILeafCursor;
import com.bigdata.btree.ILinearList;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.INodeFactory;
import com.bigdata.btree.IOverflowHandler;
import com.bigdata.btree.IReadWriteLockManager;
import com.bigdata.btree.ISimpleTreeIndexAccess;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexInconsistentError;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.IndexSegmentMultiBlockIterator;
import com.bigdata.btree.Leaf;
import com.bigdata.btree.Node;
import com.bigdata.btree.NodeSerializer;
import com.bigdata.btree.NotChildException;
import com.bigdata.btree.PO;
import com.bigdata.btree.ReadWriteLockManager;
import com.bigdata.btree.SeekEnum;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.data.IAbstractNodeData;
import com.bigdata.btree.filter.Reverserator;
import com.bigdata.btree.filter.TupleRemover;
import com.bigdata.btree.filter.WrappedTupleIterator;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IKeyRangeIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.proc.ISimpleIndexProcedure;
import com.bigdata.cache.HardReferenceQueue;
import com.bigdata.cache.HardReferenceQueueEvictionListener;
import com.bigdata.cache.HardReferenceQueueWithBatchingUpdates;
import com.bigdata.cache.IHardReferenceQueue;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.compression.IRecordCompressorFactory;
import com.bigdata.journal.IIndexManager;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.rawstore.TransientResourceMetadata;
import com.bigdata.service.Split;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.Computable;
import com.bigdata.util.concurrent.Memoizer;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IFilter;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractBTree
implements IIndex,
IAutoboxBTree,
ILinearList,
IBTreeStatistics,
ILocalBTreeView,
ISimpleTreeIndexAccess,
ICheckpointProtocol {
    protected static final String ERROR_CLOSED = "Closed";
    protected static final String ERROR_LESS_THAN_ZERO = "Less than zero";
    protected static final String ERROR_TOO_LARGE = "Too large";
    protected static final String ERROR_READ_ONLY = "Read-only";
    protected static final String ERROR_TRANSIENT = "Transient";
    protected static final String ERROR_ERROR_STATE = "Index is in error state";
    protected static final Logger log = Logger.getLogger(AbstractBTree.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    public static final Logger dumpLog = Logger.getLogger((String)(BTree.class.getName() + "#dump"));
    protected final boolean debug = DEBUG;
    private volatile BTreeCounters btreeCounters = new BTreeCounters();
    protected final IRawStore store;
    protected final boolean readOnly;
    @Deprecated
    protected final ConcurrentMap<Long, Object> storeCache;
    private final IReadWriteLockManager lockManager;
    protected final int branchingFactor;
    private static final Computable<LoadChildRequest, AbstractNode<?>> loadChild = new Computable<LoadChildRequest, AbstractNode<?>>(){

        @Override
        public AbstractNode<?> compute(LoadChildRequest req) throws InterruptedException {
            return req.parent._getChild(req.index, req);
        }
    };
    final ChildMemoizer memo;
    protected volatile AbstractNode<?> root;
    protected volatile Throwable error;
    volatile BloomFilter bloomFilter;
    protected final NodeSerializer nodeSer;
    protected final IHardReferenceQueue<PO> writeRetentionQueue;
    protected int ndistinctOnWriteRetentionQueue;
    private final int maxParallelEvictThreads;
    private final int minDirtyListSizeForParallelEvict;
    private volatile IndexMetadata metadata2;
    protected IndexMetadata metadata;
    final int minChildren;
    private final Tuple writeTuple;
    private final ThreadLocal<Tuple> lookupTuple = new ThreadLocal<Tuple>(){

        @Override
        protected Tuple initialValue() {
            return new Tuple(AbstractBTree.this, 2);
        }
    };
    private final ThreadLocal<Tuple> containsTuple = new ThreadLocal<Tuple>(){

        @Override
        protected Tuple initialValue() {
            return new Tuple(AbstractBTree.this, 0);
        }
    };

    public final BTreeCounters getBtreeCounters() {
        return this.btreeCounters;
    }

    public final void setBTreeCounters(BTreeCounters btreeCounters) {
        if (btreeCounters == null) {
            throw new IllegalArgumentException();
        }
        this.btreeCounters = btreeCounters;
    }

    AbstractNode<?> loadChild(Node parent, int index) {
        try {
            return (AbstractNode)this.memo.compute(new LoadChildRequest(parent, index));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public abstract BloomFilter getBloomFilter();

    @Override
    public final CounterSet getCounters() {
        CounterSet counterSet = new CounterSet();
        counterSet.addCounter("index UUID", new OneShotInstrument<String>(this.getIndexMetadata().getIndexUUID().toString()));
        counterSet.addCounter("class", new OneShotInstrument<String>(this.getClass().getName()));
        CounterSet tmp = counterSet.makePath("WriteRetentionQueue");
        tmp.addCounter("Capacity", new OneShotInstrument<Integer>(this.writeRetentionQueue.capacity()));
        tmp.addCounter("Size", new OneShotInstrument<Integer>(this.writeRetentionQueue.size()));
        tmp.addCounter("Distinct", new OneShotInstrument<Integer>(this.ndistinctOnWriteRetentionQueue));
        tmp = counterSet.makePath("Statistics");
        tmp.addCounter("branchingFactor", new OneShotInstrument<Integer>(this.branchingFactor));
        tmp.addCounter("height", new OneShotInstrument<Integer>(this.getHeight()));
        tmp.addCounter("nodeCount", new OneShotInstrument<Long>(this.getNodeCount()));
        tmp.addCounter("leafCount", new OneShotInstrument<Long>(this.getLeafCount()));
        tmp.addCounter("tupleCount", new OneShotInstrument<Long>(this.getEntryCount()));
        IBTreeUtilizationReport r = this.getUtilization();
        tmp.addCounter("%nodeUtilization", new OneShotInstrument<Integer>(r.getNodeUtilization()));
        tmp.addCounter("%leafUtilization", new OneShotInstrument<Integer>(r.getLeafUtilization()));
        tmp.addCounter("%totalUtilization", new OneShotInstrument<Integer>(r.getTotalUtilization()));
        long entryCount = this.getEntryCount();
        long bytes = this.btreeCounters.bytesOnStore_nodesAndLeaves.get() + this.btreeCounters.bytesOnStore_rawRecords.get();
        long bytesPerTuple = (long)(entryCount == 0L ? 0.0 : (double)(bytes / entryCount));
        tmp.addCounter("bytesPerTuple", new OneShotInstrument<Long>(bytesPerTuple));
        counterSet.attach(this.btreeCounters.getCounters());
        return counterSet;
    }

    protected AbstractBTree(IRawStore store, INodeFactory nodeFactory, boolean readOnly, IndexMetadata metadata, IRecordCompressorFactory<?> recordCompressorFactory) {
        Banner.banner();
        if (metadata == null) {
            throw new IllegalArgumentException();
        }
        this.metadata = metadata;
        this.writeTuple = new Tuple(this, 3);
        this.branchingFactor = metadata.getBranchingFactor();
        if (this.branchingFactor < 3) {
            throw new IllegalArgumentException();
        }
        this.minChildren = this.branchingFactor + 1 >> 1;
        if (nodeFactory == null) {
            throw new IllegalArgumentException();
        }
        this.store = store;
        this.readOnly = readOnly;
        this.memo = new ChildMemoizer(loadChild);
        this.writeRetentionQueue = this.newWriteRetentionQueue(readOnly);
        this.nodeSer = new NodeSerializer(store, nodeFactory, this.branchingFactor, 0, metadata, readOnly, recordCompressorFactory);
        this.storeCache = store == null ? null : null;
        this.lockManager = ReadWriteLockManager.getLockManager(this);
        this.maxParallelEvictThreads = Integer.parseInt(System.getProperty(IndexMetadata.Options.MAX_PARALLEL_EVICT_THREADS, "10"));
        this.minDirtyListSizeForParallelEvict = Integer.parseInt(System.getProperty(IndexMetadata.Options.MIN_DIRTY_LIST_SIZE_FOR_PARALLEL_EVICT, "5"));
    }

    IHardReferenceQueue<PO> newWriteRetentionQueue(boolean readOnly) {
        if (readOnly) {
            return new HardReferenceQueueWithBatchingUpdates(BigdataStatics.threadLocalBuffers, 16, (IHardReferenceQueue)new HardReferenceQueue((HardReferenceQueueEvictionListener)new DefaultEvictionListener(), this.metadata.getWriteRetentionQueueCapacity(), 0), this.metadata.getWriteRetentionQueueScan(), 128, 64, null);
        }
        return new HardReferenceQueue((HardReferenceQueueEvictionListener)new DefaultEvictionListener(), this.metadata.getWriteRetentionQueueCapacity(), this.metadata.getWriteRetentionQueueScan());
    }

    @Override
    public synchronized void close() {
        if (this.root == null) {
            throw new IllegalStateException(ERROR_CLOSED);
        }
        if (INFO || BigdataStatics.debug) {
            String msg = "BTree close: name=" + this.metadata.getName() + ", dirty=" + this.root.dirty + ", height=" + this.getHeight() + ", nentries=" + this.getEntryCount() + ", impl=" + (this instanceof BTree ? ((BTree)this).getCheckpoint().toString() : this.getClass().getSimpleName());
            if (INFO) {
                log.info((Object)msg);
            }
            if (BigdataStatics.debug) {
                System.err.println(msg);
            }
        }
        if (this.nodeSer != null) {
            this.nodeSer.close();
        }
        this.writeRetentionQueue.clear(true);
        this.ndistinctOnWriteRetentionQueue = 0;
        this.root = null;
        this.bloomFilter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reopen() {
        if (this.root == null) {
            AbstractBTree abstractBTree = this;
            synchronized (abstractBTree) {
                if (this.root == null) {
                    this._reopen();
                }
            }
        }
    }

    protected abstract void _reopen();

    @Override
    public final boolean isOpen() {
        return this.root != null;
    }

    public final boolean isTransient() {
        return this.store == null;
    }

    protected final void assertNotTransient() {
        if (this.isTransient()) {
            throw new UnsupportedOperationException(ERROR_TRANSIENT);
        }
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    protected final void assertNotReadOnly() {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException(ERROR_READ_ONLY);
        }
        if (this.error != null) {
            throw new IndexInconsistentError("Index is in error state: " + this.getIndexMetadata().getName() + ", store: " + this.store, this.error);
        }
    }

    @Override
    public abstract long getLastCommitTime();

    public abstract long getRevisionTimestamp();

    @Override
    public final IResourceMetadata[] getResourceMetadata() {
        if (this.store == null) {
            return new IResourceMetadata[]{new TransientResourceMetadata(this.metadata.getIndexUUID())};
        }
        return new IResourceMetadata[]{this.store.getResourceMetadata()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexMetadata getIndexMetadata() {
        if (this.isReadOnly()) {
            if (this.metadata2 == null) {
                AbstractBTree abstractBTree = this;
                synchronized (abstractBTree) {
                    if (this.metadata2 == null) {
                        this.metadata2 = this.metadata.clone();
                    }
                }
            }
            return this.metadata2;
        }
        return this.metadata;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{ ");
        if (this.metadata.getName() != null) {
            sb.append("name=" + this.metadata.getName());
        } else {
            sb.append("uuid=" + this.metadata.getIndexUUID());
        }
        sb.append(", m=" + this.getBranchingFactor());
        sb.append(", height=" + this.getHeight());
        sb.append(", entryCount=" + this.getEntryCount());
        sb.append(", nodeCount=" + this.getNodeCount());
        sb.append(", leafCount=" + this.getLeafCount());
        sb.append(", lastCommitTime=" + this.getLastCommitTime());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public BaseIndexStats dumpPages(boolean recursive, boolean visitLeaves) {
        if (!recursive) {
            return new BaseIndexStats(this);
        }
        BTreePageStats stats = new BTreePageStats();
        AbstractBTree.dumpPages(this, this.getRoot(), visitLeaves, stats);
        return stats;
    }

    private static void dumpPages(AbstractBTree ndx, AbstractNode<?> node, boolean visitLeaves, BTreePageStats stats) {
        stats.visit(ndx, node);
        if (!node.isLeaf()) {
            int nkeys = node.getKeyCount();
            for (int i = 0; i <= nkeys; ++i) {
                try {
                    AbstractNode child = ((Node)node).getChild(i);
                    AbstractBTree.dumpPages(ndx, child, visitLeaves, stats);
                    continue;
                }
                catch (Throwable t) {
                    if (InnerCause.isInnerCause((Throwable)t, InterruptedException.class) || InnerCause.isInnerCause((Throwable)t, InterruptedException.class)) {
                        throw new RuntimeException(t);
                    }
                    ++stats.nerrors;
                    log.error((Object)("Error reading child[i=" + i + "]: " + t), t);
                }
            }
        }
    }

    protected final boolean rangeCheck(byte[] key, boolean allowUpperBound) {
        return true;
    }

    @Override
    public final int getBranchingFactor() {
        return this.branchingFactor;
    }

    @Override
    public final boolean isBalanced() {
        return true;
    }

    @Override
    public abstract long getEntryCount();

    public IBTreeStatistics getStatistics() {
        return new BTreeStatistics(this);
    }

    @Override
    public IBTreeUtilizationReport getUtilization() {
        return new BTreeUtilizationReport(this);
    }

    public final NodeSerializer getNodeSerializer() {
        return this.nodeSer;
    }

    protected final AbstractNode<?> getRoot() {
        if (this.root == null) {
            this.reopen();
        }
        return this.root;
    }

    protected AbstractNode<?> getRootOrFinger(byte[] key) {
        return this.getRoot();
    }

    public final Tuple getWriteTuple() {
        return this.writeTuple;
    }

    public final Tuple getLookupTuple() {
        return this.lookupTuple.get();
    }

    public final Tuple getContainsTuple() {
        return this.containsTuple.get();
    }

    @Override
    public final Object insert(Object key, Object value) {
        key = this.metadata.getTupleSerializer().serializeKey(key);
        Tuple tuple = this.insert((byte[])key, (byte[])(value = (Object)this.metadata.getTupleSerializer().serializeVal(value)), false, false, this.getRevisionTimestamp(), this.getWriteTuple());
        if (tuple == null || tuple.isDeletedVersion()) {
            return null;
        }
        return tuple.getObject();
    }

    @Override
    public final byte[] insert(byte[] key, byte[] value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Tuple tuple = this.insert(key, value, false, false, this.getRevisionTimestamp(), this.getWriteTuple());
        return tuple == null || tuple.isDeletedVersion() ? null : tuple.getValue();
    }

    @Override
    public final byte[] putIfAbsent(byte[] key, byte[] value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Tuple tuple = this.insert(key, value, false, true, this.getRevisionTimestamp(), this.getWriteTuple());
        return tuple == null || tuple.isDeletedVersion() ? null : tuple.getValue();
    }

    public final Tuple insert(byte[] key, byte[] value, boolean delete, boolean putIfAbsent, long timestamp, Tuple tuple) {
        BloomFilter filter;
        assert (!delete || this.getIndexMetadata().getDeleteMarkers());
        assert (!delete || value == null);
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.assertNotReadOnly();
        assert (this.rangeCheck(key, false));
        this.btreeCounters.ninserts.incrementAndGet();
        Tuple oldTuple = this.getRootOrFinger(key).insert(key, value, delete, putIfAbsent, timestamp, tuple);
        if (oldTuple == null && (filter = this.getBloomFilter()) != null) {
            if (this.getEntryCount() > (long)filter.getMaxN()) {
                this.recycle(filter.disable());
                if (INFO) {
                    log.info((Object)("Bloom filter disabled - maximum error rate would be exceeded: entryCount=" + this.getEntryCount() + ", factory=" + this.getIndexMetadata().getBloomFilterFactory()));
                }
            } else {
                filter.add(key);
            }
        }
        return oldTuple;
    }

    @Override
    public final Object remove(Object key) {
        key = this.metadata.getTupleSerializer().serializeKey(key);
        Tuple tuple = this.getIndexMetadata().getDeleteMarkers() ? this.insert((byte[])key, null, true, false, this.getRevisionTimestamp(), this.getWriteTuple()) : this.remove((byte[])key, this.getWriteTuple());
        return tuple == null || tuple.isDeletedVersion() ? null : tuple.getObject();
    }

    @Override
    public final byte[] remove(byte[] key) {
        Tuple tuple = this.getIndexMetadata().getDeleteMarkers() ? this.insert(key, null, true, false, this.getRevisionTimestamp(), this.getWriteTuple()) : this.remove(key, this.getWriteTuple());
        return tuple == null || tuple.isDeletedVersion() ? null : tuple.getValue();
    }

    public final Tuple remove(byte[] key, Tuple tuple) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this.getIndexMetadata().getDeleteMarkers()) {
            throw new UnsupportedOperationException();
        }
        this.assertNotReadOnly();
        assert (this.rangeCheck(key, false));
        this.btreeCounters.nremoves.incrementAndGet();
        return this.getRootOrFinger(key).remove(key, tuple);
    }

    @Override
    public abstract void removeAll();

    @Override
    public Object lookup(Object key) {
        key = this.metadata.getTupleSerializer().serializeKey(key);
        Tuple tuple = this.lookup((byte[])key, this.getLookupTuple());
        if (tuple == null || tuple.isDeletedVersion()) {
            return null;
        }
        return tuple.getObject();
    }

    @Override
    public byte[] lookup(byte[] key) {
        Tuple tuple = this.lookup(key, this.getLookupTuple());
        return tuple == null || tuple.isDeletedVersion() ? null : tuple.getValue();
    }

    public Tuple lookup(byte[] key, Tuple tuple) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (tuple == null) {
            throw new IllegalArgumentException();
        }
        assert (this.rangeCheck(key, false));
        boolean bloomHit = false;
        BloomFilter filter = this.getBloomFilter();
        if (filter != null) {
            if (!filter.contains(key)) {
                return null;
            }
            bloomHit = true;
        }
        tuple = this.getRootOrFinger(key).lookup(key, tuple);
        if (bloomHit && (tuple == null || tuple.isDeletedVersion()) && bloomHit) {
            filter.falsePos();
        }
        return tuple;
    }

    @Override
    public boolean contains(Object key) {
        key = this.metadata.getTupleSerializer().serializeKey(key);
        return this.contains((byte[])key);
    }

    @Override
    public boolean contains(byte[] key) {
        Tuple tuple;
        if (key == null) {
            throw new IllegalArgumentException();
        }
        assert (this.rangeCheck(key, false));
        boolean bloomHit = false;
        BloomFilter filter = this.getBloomFilter();
        if (filter != null) {
            if (!filter.contains(key)) {
                return false;
            }
            bloomHit = true;
        }
        if ((tuple = this.getRootOrFinger(key).lookup(key, this.getContainsTuple())) == null || tuple.isDeletedVersion()) {
            if (bloomHit) {
                filter.falsePos();
            }
            return false;
        }
        return true;
    }

    @Override
    public long indexOf(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        assert (this.rangeCheck(key, false));
        this.btreeCounters.nindexOf.increment();
        return this.getRootOrFinger(key).indexOf(key);
    }

    @Override
    public byte[] keyAt(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException(ERROR_LESS_THAN_ZERO);
        }
        if (index >= this.getEntryCount()) {
            throw new IndexOutOfBoundsException(ERROR_TOO_LARGE);
        }
        this.btreeCounters.ngetKey.increment();
        return this.getRoot().keyAt(index);
    }

    @Override
    public byte[] valueAt(long index) {
        Tuple tuple = this.getLookupTuple();
        this.getRoot().valueAt(index, tuple);
        return tuple.isDeletedVersion() ? null : tuple.getValue();
    }

    public final Tuple valueAt(long index, Tuple tuple) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException(ERROR_LESS_THAN_ZERO);
        }
        if (index >= this.getEntryCount()) {
            throw new IndexOutOfBoundsException(ERROR_TOO_LARGE);
        }
        if (tuple == null || !tuple.getValuesRequested()) {
            throw new IllegalArgumentException();
        }
        this.btreeCounters.ngetKey.increment();
        this.getRoot().valueAt(index, tuple);
        return tuple.isDeletedVersion() ? null : tuple;
    }

    @Override
    public final long rangeCountExact(byte[] fromKey, byte[] toKey) {
        if (!this.metadata.getDeleteMarkers()) {
            return this.rangeCount(fromKey, toKey);
        }
        long n = 0L;
        ITupleIterator itr = this.rangeIterator(fromKey, toKey, 0, 0, (IFilter)null);
        while (itr.hasNext()) {
            itr.next();
            ++n;
        }
        return n;
    }

    @Override
    public final long rangeCount() {
        return this.rangeCount(null, null);
    }

    public final long rangeCount(Object fromKey, Object toKey) {
        fromKey = fromKey == null ? null : this.metadata.getTupleSerializer().serializeKey(fromKey);
        toKey = toKey == null ? null : this.metadata.getTupleSerializer().serializeKey(toKey);
        return this.rangeCount((byte[])fromKey, (byte[])toKey);
    }

    @Override
    public final long rangeCount(byte[] fromKey, byte[] toKey) {
        long toIndex;
        if (fromKey == null && toKey == null) {
            return this.getEntryCount();
        }
        this.btreeCounters.nrangeCount.increment();
        AbstractNode<?> root = this.getRoot();
        if (fromKey != null) assert (this.rangeCheck(fromKey, false));
        if (toKey != null) assert (this.rangeCheck(toKey, true));
        long fromIndex = fromKey == null ? 0L : root.indexOf(fromKey);
        long l = toIndex = toKey == null ? this.getEntryCount() : root.indexOf(toKey);
        if (fromIndex < 0L) {
            fromIndex = -fromIndex - 1L;
        }
        if (toIndex < 0L) {
            toIndex = -toIndex - 1L;
        }
        if (toIndex <= fromIndex) {
            return 0L;
        }
        return toIndex - fromIndex;
    }

    @Override
    public long rangeCountExactWithDeleted(byte[] fromKey, byte[] toKey) {
        return this.rangeCount(fromKey, toKey);
    }

    @Override
    public final ICloseableIterator<?> scan() {
        return new EntryScanIterator(this.rangeIterator());
    }

    @Override
    public final ITupleIterator rangeIterator() {
        return this.rangeIterator(null, null);
    }

    public final ITupleIterator rangeIterator(Object fromKey, Object toKey) {
        fromKey = fromKey == null ? null : this.metadata.getTupleSerializer().serializeKey(fromKey);
        toKey = toKey == null ? null : this.metadata.getTupleSerializer().serializeKey(toKey);
        return this.rangeIterator((byte[])fromKey, (byte[])toKey);
    }

    @Override
    public final ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey) {
        return this.rangeIterator(fromKey, toKey, 0, 3, (IFilter)null);
    }

    public final ITupleIterator rangeIterator(Object fromKey, Object toKey, int capacity, int flags, IFilter filter) {
        fromKey = fromKey == null ? null : this.metadata.getTupleSerializer().serializeKey(fromKey);
        toKey = toKey == null ? null : this.metadata.getTupleSerializer().serializeKey(toKey);
        return this.rangeIterator((byte[])fromKey, (byte[])toKey, capacity, flags, filter);
    }

    @Override
    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey, int capacityIsIgnored, int flags, IFilter filter) {
        Iterator src;
        boolean readOnly;
        this.btreeCounters.nrangeIterator.increment();
        boolean bl = readOnly = (flags & 8) != 0;
        if (readOnly && (flags & 0x10) != 0) {
            throw new IllegalArgumentException();
        }
        if (this instanceof BTree && (flags & 0x40) == 0 && (flags & 0x10) == 0 && (flags & 0x20) == 0) {
            src = this.getRoot().rangeIterator(fromKey, toKey, flags);
        } else {
            Tuple tuple = new Tuple(this, flags);
            if (this instanceof IndexSegment) {
                IndexSegment seg = (IndexSegment)this;
                DirectBufferPool pool = DirectBufferPool.INSTANCE;
                src = (flags & 0x40) == 0 && (flags & 0x20) == 0 && seg.getStore().getCheckpoint().maxNodeOrLeafLength <= pool.getBufferCapacity() && this.rangeCount(fromKey, toKey) / (long)this.branchingFactor > 2L ? new IndexSegmentMultiBlockIterator(seg, pool, fromKey, toKey, flags) : new IndexSegment.IndexSegmentTupleCursor(seg, tuple, fromKey, toKey);
            } else if (this instanceof BTree) {
                src = this.isReadOnly() ? new AbstractBTreeTupleCursor.ReadOnlyBTreeTupleCursor((BTree)this, tuple, fromKey, toKey) : new AbstractBTreeTupleCursor.MutableBTreeTupleCursor((BTree)this, tuple, fromKey, toKey);
            } else {
                throw new UnsupportedOperationException("Unknown B+Tree implementation: " + this.getClass().getName());
            }
            if ((flags & 0x40) != 0) {
                src = new Reverserator(src);
            }
        }
        if (filter != null) {
            src = new WrappedTupleIterator(filter.filter(src, null));
        }
        if ((flags & 0x10) != 0) {
            this.assertNotReadOnly();
            src = new TupleRemover(){

                protected boolean remove(ITuple e) {
                    return true;
                }
            }.filterOnce(src, null);
        }
        return src;
    }

    public long rangeCopy(IIndex src, byte[] fromKey, byte[] toKey, boolean overflow) {
        this.assertNotReadOnly();
        ITupleIterator itr = src.rangeIterator(fromKey, toKey, 0, 7, null);
        IndexMetadata thisMetadata = this.getIndexMetadata();
        IndexMetadata sourceMetadata = src.getIndexMetadata();
        boolean deleteMarkers = thisMetadata.getDeleteMarkers();
        boolean versionTimestamps = thisMetadata.getVersionTimestamps();
        if (sourceMetadata.getDeleteMarkers() != deleteMarkers) {
            throw new UnsupportedOperationException("Support for delete markers not consistent");
        }
        if (sourceMetadata.getVersionTimestamps() != versionTimestamps) {
            throw new UnsupportedOperationException("Support for version timestamps not consistent");
        }
        IOverflowHandler overflowHandler = overflow ? sourceMetadata.getOverflowHandler() : null;
        ITuple tuple = null;
        while (itr.hasNext()) {
            boolean deletedVersion;
            tuple = itr.next();
            byte[] key = tuple.getKey();
            boolean bl = deletedVersion = deleteMarkers && tuple.isDeletedVersion();
            byte[] val = deletedVersion ? null : (overflowHandler != null ? overflowHandler.handle(tuple, this.getStore()) : tuple.getValue());
            if (versionTimestamps) {
                long timestamp = tuple.getVersionTimestamp();
                if (deletedVersion) {
                    this.insert(key, null, true, false, timestamp, null);
                    continue;
                }
                this.insert(key, val, false, false, timestamp, null);
                continue;
            }
            if (deletedVersion) {
                this.remove(key);
                continue;
            }
            this.insert(key, val);
        }
        return tuple == null ? 0L : tuple.getVisitCount();
    }

    @Override
    public <T> T submit(byte[] key, ISimpleIndexProcedure<T> proc) {
        if (key != null) assert (this.rangeCheck(key, false));
        return proc.apply(this);
    }

    @Override
    public void submit(byte[] fromKey, byte[] toKey, IKeyRangeIndexProcedure proc, IResultHandler handler) {
        if (fromKey != null) assert (this.rangeCheck(fromKey, false));
        if (toKey != null) assert (this.rangeCheck(toKey, true));
        Object result = proc.apply(this);
        if (handler != null) {
            handler.aggregate(result, new Split(null, 0, 0));
        }
    }

    @Override
    public void submit(int fromIndex, int toIndex, byte[][] keys, byte[][] vals, AbstractKeyArrayIndexProcedureConstructor ctor, IResultHandler aggregator) {
        Object result = ctor.newInstance(this, fromIndex, toIndex, keys, vals).apply(this);
        if (aggregator != null) {
            aggregator.aggregate(result, new Split(null, fromIndex, toIndex));
        }
    }

    public AbstractNode getRightMostNode(boolean nodesOnly) {
        AbstractNode<?> root = this.getRoot();
        if (root.isLeaf()) {
            return null;
        }
        return ((Node)root).getRightMostChild(nodesOnly);
    }

    public abstract ILeafCursor newLeafCursor(SeekEnum var1);

    public abstract ILeafCursor newLeafCursor(byte[] var1);

    public boolean dump(PrintStream out) {
        return this.dump(BTree.dumpLog.getEffectiveLevel(), out);
    }

    public boolean dump(Level level, PrintStream out) {
        boolean info = level.toInt() <= Level.INFO.toInt();
        IBTreeUtilizationReport utils = this.getUtilization();
        if (info) {
            int branchingFactor = this.getBranchingFactor();
            int height = this.getHeight();
            long nnodes = this.getNodeCount();
            long nleaves = this.getLeafCount();
            long nentries = this.getEntryCount();
            out.println("branchingFactor=" + branchingFactor + ", height=" + height + ", #nodes=" + nnodes + ", #leaves=" + nleaves + ", #entries=" + nentries + ", nodeUtil=" + utils.getNodeUtilization() + "%, leafUtil=" + utils.getLeafUtilization() + "%, utilization=" + utils.getTotalUtilization() + "%");
        }
        if (this.root != null) {
            return this.root.dump(level, out, 0, true);
        }
        return true;
    }

    public int getLevel(AbstractNode t) {
        return this.getLevel(t, this.getRoot());
    }

    public int getLevel(AbstractNode t, AbstractNode node) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        if (t.btree != this) {
            throw new IllegalArgumentException();
        }
        int level = AbstractBTree._getLevel(t, node, 0);
        if (level == -1) {
            throw new NotChildException("Not a child of the given node: t=" + t.toShortString() + ", node=" + node);
        }
        return level;
    }

    private static int _getLevel(AbstractNode t, AbstractNode node, int level) {
        if (t == node) {
            return level;
        }
        Node p = t.getParent();
        if (p == null) {
            return -1;
        }
        return AbstractBTree._getLevel(p, node, level + 1);
    }

    protected void touch(AbstractNode<?> node) {
        assert (node != null);
        if (this.readOnly) {
            this.doTouch(node);
            return;
        }
        int rcount = this.lockManager.getReadLockCount();
        if (rcount <= 0) {
            this.doSyncTouch(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doSyncTouch(AbstractNode<?> node) {
        AbstractBTree abstractBTree = this;
        synchronized (abstractBTree) {
            this.doTouch(node);
        }
    }

    private final void doTouch(AbstractNode<?> node) {
        ++node.referenceCount;
        if (!this.writeRetentionQueue.add(node)) {
            --node.referenceCount;
        } else if (node.referenceCount == 1) {
            ++this.ndistinctOnWriteRetentionQueue;
        }
    }

    protected final void writeNodeRecursive(AbstractNode<?> node) {
        if (node instanceof Node && this.getStore() instanceof IIndexManager) {
            this.writeNodeRecursiveConcurrent(node);
        } else {
            this.writeNodeRecursiveCallersThread(node);
        }
    }

    protected final void writeNodeRecursiveCallersThread(AbstractNode<?> node) {
        assert (this.root != null);
        assert (node != null);
        assert (node.dirty);
        assert (!node.deleted);
        assert (!node.isPersistent());
        assert (node.referenceCount >= 0);
        int ndirty = 0;
        int nleaves = 0;
        Iterator<AbstractNode> itr = node.postOrderNodeIterator(true, false);
        while (itr.hasNext()) {
            AbstractNode t = itr.next();
            assert (t.dirty);
            if (t != this.root) {
                assert (t.parent != null);
                assert (t.parent.get() != null);
            }
            this.writeNodeOrLeaf(t);
            ++ndirty;
            if (!(t instanceof Leaf)) continue;
            ++nleaves;
        }
    }

    /*
     * Exception decompiling
     */
    protected final void writeNodeRecursiveConcurrent(AbstractNode<?> node) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long writeNodeOrLeaf(AbstractNode<?> node) {
        return this.writeNodeOrLeaf(node, this.nodeSer);
    }

    private long writeNodeOrLeaf(AbstractNode<?> node, NodeSerializer nodeSer) {
        AbstractFixedByteArrayBuffer slice;
        if (this.error != null) {
            throw new IllegalStateException(ERROR_ERROR_STATE, this.error);
        }
        assert (this.root != null);
        assert (node != null);
        assert (node.btree == this);
        assert (node.dirty);
        assert (!node.deleted);
        assert (!node.isPersistent());
        assert (!node.isReadOnly());
        this.assertNotReadOnly();
        assert (node.referenceCount >= 0);
        Node parent = node.getParent();
        if (parent == null) {
            assert (node == this.root);
        } else {
            assert (parent.isDirty());
            assert (!parent.isPersistent());
        }
        if (this.debug) {
            node.assertInvariants();
        }
        long beginNanos = System.nanoTime();
        if (node.isLeaf()) {
            ((Leaf)node).data = nodeSer.encodeLive(((Leaf)node).data);
            slice = ((Leaf)node).data();
            this.btreeCounters.leavesWritten.increment();
        } else {
            ((Node)node).data = nodeSer.encodeLive(((Node)node).data);
            slice = ((Node)node).data();
            this.btreeCounters.nodesWritten.increment();
        }
        this.btreeCounters.serializeNanos.add(System.nanoTime() - beginNanos);
        if (this.store == null) {
            node.setDirty(false);
            return 0L;
        }
        long beginNanos2 = System.nanoTime();
        long addr = this.store.write(slice.asByteBuffer());
        long oldAddr = node.isPersistent() ? node.getIdentity() : 0L;
        int nbytes = this.store.getByteCount(addr);
        this.btreeCounters.writeNanos.add(System.nanoTime() - beginNanos2);
        this.btreeCounters.bytesWritten.add(nbytes);
        this.btreeCounters.bytesOnStore_nodesAndLeaves.addAndGet(nbytes);
        node.setIdentity(addr);
        if (oldAddr != 0L) {
            if (this.storeCache != null) {
                this.storeCache.remove(oldAddr);
            }
            this.deleteNodeOrLeaf(oldAddr);
        }
        node.setDirty(false);
        if (parent != null) {
            parent.setChildAddr(node);
        }
        if (this.storeCache != null && null != this.storeCache.putIfAbsent(addr, node.getDelegate())) {
            throw new AssertionError((Object)("addr already in cache: " + addr + " for " + this.store.getFile()));
        }
        return addr;
    }

    protected AbstractNode<?> readNodeOrLeaf(long addr) {
        if (addr == 0L) {
            throw new IllegalArgumentException();
        }
        long begin = System.nanoTime();
        ByteBuffer tmp = this.store.read(addr);
        assert (tmp.position() == 0);
        this.btreeCounters.readNanos.add(System.nanoTime() - begin);
        int bytesRead = tmp.limit();
        this.btreeCounters.bytesRead.add(bytesRead);
        try {
            long begin2 = System.nanoTime();
            IAbstractNodeData data = this.nodeSer.decode(tmp);
            this.btreeCounters.deserializeNanos.add(System.nanoTime() - begin2);
            if (data.isLeaf()) {
                this.btreeCounters.leavesRead.increment();
            } else {
                this.btreeCounters.nodesRead.increment();
            }
            AbstractNode<?> node = this.nodeSer.wrap(this, addr, data);
            return node;
        }
        catch (Throwable t) {
            throw new RuntimeException("De-serialization problem: addr=" + this.store.toString(addr) + " from store=" + this.store.getFile() + " : cause=" + t, t);
        }
    }

    final <T extends AbstractNode<T>> Reference<AbstractNode<T>> newRef(AbstractNode<T> child) {
        if (this.store == null) {
            return new HardReference<AbstractNode<T>>(child);
        }
        return new WeakReference<AbstractNode<T>>(child);
    }

    public static byte[] encodeRecordAddr(ByteArrayBuffer recordAddrBuf, long addr) {
        recordAddrBuf.reset().putLong(addr);
        return recordAddrBuf.toByteArray();
    }

    public static long decodeRecordAddr(byte[] buf) {
        long v = 0L;
        v += (0xFFL & (long)buf[0]) << 56;
        v += (0xFFL & (long)buf[1]) << 48;
        v += (0xFFL & (long)buf[2]) << 40;
        v += (0xFFL & (long)buf[3]) << 32;
        v += (0xFFL & (long)buf[4]) << 24;
        v += (0xFFL & (long)buf[5]) << 16;
        v += (0xFFL & (long)buf[6]) << 8;
        return v += (0xFFL & (long)buf[7]) << 0;
    }

    int getMaxRecLen() {
        return this.metadata.getMaxRecLen();
    }

    ByteBuffer readRawRecord(long addr) {
        ByteBuffer b = this.getStore().read(addr);
        int nbytes = this.getStore().getByteCount(addr);
        this.btreeCounters.rawRecordsRead.increment();
        this.btreeCounters.rawRecordsBytesRead.add(nbytes);
        return b;
    }

    long writeRawRecord(byte[] b) {
        if (this.isReadOnly()) {
            throw new IllegalStateException(ERROR_READ_ONLY);
        }
        long addr = this.getStore().write(ByteBuffer.wrap(b));
        int nbytes = b.length;
        this.btreeCounters.rawRecordsWritten.increment();
        this.btreeCounters.rawRecordsBytesWritten.add(nbytes);
        this.btreeCounters.bytesOnStore_rawRecords.addAndGet(nbytes);
        return addr;
    }

    void deleteRawRecord(long addr) {
        if (this.isReadOnly()) {
            throw new IllegalStateException(ERROR_READ_ONLY);
        }
        this.btreeCounters.bytesOnStore_rawRecords.addAndGet(-this.recycle(addr));
    }

    void deleteNodeOrLeaf(long addr) {
        if (addr == 0L) {
            throw new IllegalArgumentException();
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException(ERROR_READ_ONLY);
        }
        if (this instanceof BTree && ((BTree)this).getCheckpoint().getRootAddr() == addr) {
            return;
        }
        this.btreeCounters.bytesOnStore_nodesAndLeaves.addAndGet(-this.recycle(addr));
    }

    protected int recycle(long addr) {
        if (addr == 0L) {
            return 0;
        }
        int nbytes = this.store.getByteCount(addr);
        this.getBtreeCounters().bytesReleased.add(nbytes);
        this.store.delete(addr);
        return nbytes;
    }

    @Override
    public final Lock readLock() {
        return this.lockManager.readLock();
    }

    @Override
    public final Lock writeLock() {
        return this.lockManager.writeLock();
    }

    @Override
    public final int getReadLockCount() {
        return this.lockManager.getReadLockCount();
    }

    static class HardReference<T>
    extends WeakReference<T> {
        private final T ref;

        HardReference(T ref) {
            super(null);
            this.ref = ref;
        }

        @Override
        public T get() {
            return this.ref;
        }

        @Override
        public void clear() {
        }
    }

    public static interface IBTreeCounters {
        public static final String Statistics = "Statistics";
        public static final String WriteRetentionQueue = "WriteRetentionQueue";
        public static final String KeySearch = "KeySearch";
        public static final String RangeQuery = "RangeQuery";
        public static final String LinearList = "LinearList";
        public static final String Structure = "Structure";
        public static final String Tuples = "Tuples";
        public static final String IO = "IO";
    }

    static class ChildMemoizer
    extends Memoizer<LoadChildRequest, AbstractNode<?>> {
        public ChildMemoizer(Computable<LoadChildRequest, AbstractNode<?>> c) {
            super(c);
        }

        void removeFromCache(LoadChildRequest req) {
            if (this.cache.remove(req) == null) {
                throw new AssertionError();
            }
        }
    }

    static class LoadChildRequest {
        final Node parent;
        final int index;

        public LoadChildRequest(Node parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LoadChildRequest)) {
                return false;
            }
            LoadChildRequest r = (LoadChildRequest)o;
            return this.parent == r.parent && this.index == r.index;
        }

        public int hashCode() {
            return this.parent.hashCode() + this.index;
        }
    }
}

