/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.update;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.ILocatableResourceAnnotations;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.rdf.update.ParserStats;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.rio.IRDFParserOptions;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.sail.webapp.client.MiniMime;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.DataLoader;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class ParseOp
extends PipelineOp {
    private static final transient Logger log = Logger.getLogger(ParseOp.class);
    private static final long serialVersionUID = 1L;
    protected static final Var<?> s = Var.var("s");
    protected static final Var<?> p = Var.var("p");
    protected static final Var<?> o = Var.var("o");
    protected static final Var<?> c = Var.var("c");

    public ParseOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        this.getRequiredProperty(Annotations.SOURCE_URI);
        this.getRequiredProperty(Annotations.RELATION_NAME);
        this.getRequiredProperty(Annotations.TIMESTAMP);
    }

    public ParseOp(ParseOp op) {
        super(op);
    }

    @Override
    public ParserStats newStats() {
        return new ParserStats();
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(context, this));
    }

    private static class ChunkTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final ParserStats stats;
        private final URI sourceUri;
        private final String uriStr;
        private final String baseUri;
        private final URI targetUri;
        private final boolean allowClassPath = true;
        private final RDFFormat fallback;
        private final boolean sids;
        private final boolean quads;
        private final boolean silent;
        private final boolean stripContext;
        private final int timeout;
        private final boolean usesCache;
        private final int readBufferSize;
        private final int chunkCapacity;
        private final IRDFParserOptions parserOptions;
        private final AbstractTripleStore database;

        public ChunkTask(BOpContext<IBindingSet> context, ParseOp op) {
            this.context = context;
            this.stats = (ParserStats)context.getStats();
            this.sourceUri = (URI)op.getRequiredProperty(Annotations.SOURCE_URI);
            this.uriStr = this.sourceUri.stringValue();
            this.baseUri = op.getProperty(Annotations.BASE_URI, this.sourceUri.stringValue());
            String namespace = ((String[])op.getRequiredProperty(Annotations.RELATION_NAME))[0];
            long timestamp = (Long)op.getRequiredProperty(Annotations.TIMESTAMP);
            this.database = (AbstractTripleStore)context.getResource(namespace, timestamp);
            this.sids = this.database.isStatementIdentifiers();
            this.quads = this.database.isQuads();
            this.silent = op.getProperty(Annotations.SILENT, false);
            this.targetUri = (URI)this.database.asValue((Value)((URI)op.getProperty(Annotations.TARGET_URI)));
            this.chunkCapacity = op.getChunkCapacity();
            this.fallback = RDFFormat.valueOf((String)op.getProperty(Annotations.FALLBACK, Annotations.DEFAULT_FALLBACK));
            this.stripContext = op.getProperty(Annotations.STRIP_CONTEXT, false);
            this.timeout = op.getProperty(Annotations.TIMEOUT, 0);
            this.usesCache = op.getProperty(Annotations.USES_CACHE, true);
            this.readBufferSize = op.getProperty(Annotations.READ_BUFFER_SIZE, 8192);
            Properties properties = this.database.getProperties();
            this.parserOptions = new RDFParserOptions(properties);
            if (op.getProperty(DataLoader.Options.VERIFY_DATA) != null) {
                this.parserOptions.setVerifyData((Boolean)op.getProperty(DataLoader.Options.VERIFY_DATA));
            }
            if (op.getProperty(DataLoader.Options.STOP_AT_FIRST_ERROR) != null) {
                this.parserOptions.setStopAtFirstError((Boolean)op.getProperty(DataLoader.Options.STOP_AT_FIRST_ERROR));
            }
            if (op.getProperty(DataLoader.Options.DATATYPE_HANDLING) != null) {
                this.parserOptions.setDatatypeHandling((RDFParser.DatatypeHandling)op.getProperty(DataLoader.Options.DATATYPE_HANDLING));
            }
            if (op.getProperty(DataLoader.Options.PRESERVE_BNODE_IDS) != null) {
                this.parserOptions.setPreserveBNodeIDs((Boolean)op.getProperty(DataLoader.Options.PRESERVE_BNODE_IDS));
            }
            if (properties.getProperty(DataLoader.Options.PRESERVE_BNODE_IDS) == null && op.getProperty(DataLoader.Options.PRESERVE_BNODE_IDS) == null && this.database.getLexiconRelation().isStoreBlankNodes()) {
                this.parserOptions.setPreserveBNodeIDs(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            block16: {
                InputStream is = null;
                Reader reader = null;
                RDFFormat fmt = null;
                try {
                    fmt = RDFFormat.forFileName((String)this.uriStr, (RDFFormat)this.fallback);
                    String contentEncoding = null;
                    is = this.getClass().getResourceAsStream(this.uriStr);
                    if (is == null) {
                        is = this.getClass().getClassLoader().getResourceAsStream(this.uriStr);
                    }
                    if (is == null) {
                        HttpURLConnection conn2;
                        URLConnection conn = null;
                        URL url = new URL(this.uriStr);
                        conn = url.openConnection();
                        HttpURLConnection httpURLConnection = conn2 = conn instanceof HttpURLConnection ? (HttpURLConnection)conn : null;
                        if (conn2 != null) {
                            conn2.setRequestMethod("GET");
                            StringBuilder sb = new StringBuilder();
                            List acceptParams = RDFFormat.getAcceptParams((Iterable)RDFFormat.values(), (boolean)this.quads, (RDFFormat)fmt);
                            for (String acceptParam : acceptParams) {
                                if (sb.length() > 0) {
                                    sb.append(",");
                                }
                                sb.append(acceptParam);
                            }
                            String acceptHeader = sb.toString();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Accept: " + acceptHeader));
                            }
                            conn2.setRequestProperty("Accept", acceptHeader);
                            conn.setUseCaches(this.usesCache);
                            conn.setReadTimeout(this.timeout);
                        }
                        conn.setDoInput(true);
                        conn.connect();
                        if (conn2 != null) {
                            String mimeType = new MiniMime(conn.getContentType()).getMimeType();
                            fmt = RDFFormat.forMIMEType((String)mimeType, (RDFFormat)this.fallback);
                            contentEncoding = conn2.getContentEncoding();
                        }
                        is = conn.getInputStream();
                    }
                    if (contentEncoding == null) {
                        contentEncoding = fmt.getCharset().name();
                    }
                    reader = new BufferedReader(new InputStreamReader(is, contentEncoding), this.readBufferSize);
                    this.parse(reader, this.baseUri, fmt, this.targetUri);
                }
                catch (Exception ex) {
                    String msg = "While loading: " + this.uriStr + (fmt != null ? ", fmt=" + fmt : "");
                    if (this.silent) {
                        log.warn((Object)msg);
                        break block16;
                    }
                    throw new RuntimeException(msg, ex);
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
            }
            return null;
        }

        private void parse(Reader source, String baseURL, RDFFormat fmt, URI defaultGraph) throws RDFParseException, RDFHandlerException, IOException {
            RDFParserFactory rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)fmt);
            if (rdfParserFactory == null) {
                throw new RuntimeException("Parser factory not found: source=" + this.uriStr + ", fmt=" + fmt);
            }
            RDFParser rdfParser = rdfParserFactory.getParser();
            rdfParser.setValueFactory((ValueFactory)this.database.getValueFactory());
            rdfParser.setVerifyData(this.parserOptions.getVerifyData());
            rdfParser.setStopAtFirstError(this.parserOptions.getStopAtFirstError());
            rdfParser.setDatatypeHandling(this.parserOptions.getDatatypeHandling());
            rdfParser.setPreserveBNodeIDs(this.parserOptions.getPreserveBNodeIDs());
            UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer = new UnsyncLocalOutputBuffer<IBindingSet>(this.chunkCapacity, this.context.getSink());
            rdfParser.setRDFHandler((RDFHandler)new AddStatementHandler(unsyncBuffer));
            rdfParser.parse(source, this.baseUri);
            unsyncBuffer.flush();
        }

        private class AddStatementHandler
        extends RDFHandlerBase {
            private final UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer;

            public AddStatementHandler(UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer) {
                this.unsyncBuffer = unsyncBuffer;
            }

            private final IConstant<IV> asConst(Value v) {
                TermId<?> iv = TermId.mockIV(VTE.valueOf(v));
                iv.setValue((BigdataValue)v);
                return new Constant<IV>(iv);
            }

            public void handleStatement(Statement stmt) throws RDFHandlerException {
                ListBindingSet bset = new ListBindingSet();
                bset.set(s, this.asConst((Value)stmt.getSubject()));
                bset.set(p, this.asConst((Value)stmt.getPredicate()));
                bset.set(o, this.asConst(stmt.getObject()));
                Resource context = stmt.getContext();
                if (ChunkTask.this.stripContext) {
                    context = null;
                }
                if (ChunkTask.this.quads && context == null) {
                    context = ChunkTask.this.targetUri;
                }
                if (ChunkTask.this.quads && context == null) {
                    throw new RuntimeException("Quads mode, but data are triples and the target graph was not specified: " + ChunkTask.this.uriStr);
                }
                if (context != null) {
                    bset.set(c, this.asConst((Value)context));
                }
                this.unsyncBuffer.add(bset);
                ((ChunkTask)ChunkTask.this).stats.toldTriples.increment();
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations,
    ILocatableResourceAnnotations,
    RDFParserOptions.Options {
        public static final String SOURCE_URI = ParseOp.class.getName() + ".sourceUri";
        public static final String BASE_URI = ParseOp.class.getName() + ".baseUri";
        public static final String TARGET_URI = ParseOp.class.getName() + ".targetUri";
        public static final String SILENT = ParseOp.class.getName() + ".silent";
        public static final boolean DEFAULT_SILENT = false;
        public static final String FALLBACK = ParseOp.class.getName() + ".fallback";
        public static final String DEFAULT_FALLBACK = RDFFormat.RDFXML.getName();
        public static final String STRIP_CONTEXT = ParseOp.class.getName() + ".stripContext";
        public static final boolean DEFAULT_STRIP_CONTEXT = false;
        public static final String USES_CACHE = ParseOp.class.getName() + ".usesCache";
        public static final boolean DEFAULT_USES_CACHE = true;
        public static final String READ_BUFFER_SIZE = ParseOp.class.getName() + ".readBufferSize";
        public static final int DEFAULT_READ_BUFFER_SIZE = 8192;
    }
}

