/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.ap.filter;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IElement;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.io.LongPacker;
import cutthecrap.utils.striterators.IFilterTest;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class SameVariableConstraint<E>
implements IFilterTest,
Externalizable {
    private IPredicate<E> p;
    protected int[] indices;
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION = 0;

    public SameVariableConstraint() {
    }

    public SameVariableConstraint(IPredicate<E> p, int[] indices) {
        if (p == null) {
            throw new IllegalArgumentException();
        }
        if (indices == null) {
            throw new IllegalArgumentException();
        }
        this.p = p;
        this.indices = indices;
    }

    public boolean isValid(Object obj) {
        return this.accept(obj);
    }

    public int[] getIndices() {
        return this.indices;
    }

    private boolean accept(E e) {
        int i = 0;
        while (i < this.indices.length) {
            int nslots = this.indices[i];
            assert (nslots >= 2) : "i=" + i + ", nslots=" + nslots + ", indices=" + Arrays.toString(this.indices);
            assert (i + nslots < this.indices.length);
            int firstIndex = this.indices[++i];
            Constant<Object> c0 = new Constant<Object>(((IElement)e).get(firstIndex));
            int j = 0;
            while (j < nslots) {
                int thisIndex;
                Constant<Object> c1;
                if (j != firstIndex && c0 != (c1 = new Constant<Object>(((IElement)e).get(thisIndex = this.indices[i])))) {
                    if (c0 != null && c1 == null) {
                        return false;
                    }
                    if (c1 == null && c0 != null) {
                        return false;
                    }
                    if (!((Object)c0).equals(c1)) {
                        return false;
                    }
                }
                ++j;
                ++i;
            }
        }
        return true;
    }

    public String toString() {
        return super.toString() + "{p=" + this.p + ", indices=" + Arrays.toString(this.indices) + "}";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
        this.p = (IPredicate)in.readObject();
        int len = (int)LongPacker.unpackLong(in);
        this.indices = new int[len];
        for (int i = 0; i < len; ++i) {
            this.indices[i] = (int)LongPacker.unpackLong(in);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeObject(this.p);
        LongPacker.packLong(out, (long)this.indices.length);
        for (int i = 0; i < this.indices.length; ++i) {
            LongPacker.packLong(out, (long)this.indices[i]);
        }
    }

    public static <E> SameVariableConstraint<E> newInstance(IPredicate<E> p) {
        int arity = p.arity();
        LinkedHashMap<IVariableOrConstant, Integer> vars = null;
        int noccurs = 0;
        int nreused = 0;
        for (int i = 0; i < arity; ++i) {
            Integer cnt;
            IVariableOrConstant t = p.get(i);
            if (t == null || !t.isVar()) continue;
            if (vars == null) {
                vars = new LinkedHashMap<IVariableOrConstant, Integer>();
            }
            if ((cnt = (Integer)vars.get(t)) == null) {
                cnt = 1;
                vars.put(t, cnt);
                continue;
            }
            int tmp = cnt + 1;
            cnt = tmp;
            vars.put(t, cnt);
            noccurs += tmp == 2 ? 2 : 1;
            if (tmp != 2) continue;
            ++nreused;
        }
        if (nreused == 0) {
            return null;
        }
        assert (vars != null);
        int[] indices = new int[nreused + noccurs];
        int i = 0;
        for (Map.Entry e : vars.entrySet()) {
            int nused = (Integer)e.getValue();
            if (nused < 2) continue;
            IVariable var = (IVariable)e.getKey();
            indices[i++] = nused;
            for (int j = 0; j < arity; ++j) {
                IVariableOrConstant t = p.get(j);
                if (t != var) continue;
                indices[i++] = j;
            }
        }
        assert (i == indices.length);
        return new SameVariableConstraint<E>(p, indices);
    }
}

