/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.LookAheadIteration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.impl.EmptyBindingSet;

public class BottomUpJoinIterator
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private volatile CloseableIteration<BindingSet, QueryEvaluationException> rightIter;
    private List<BindingSet> scanList;
    private CloseableIteration<BindingSet, QueryEvaluationException> restIter;
    private Map<BindingSet, List<BindingSet>> hashTable;
    private Set<String> joinAttributes;
    private BindingSet currentScanElem;
    private List<BindingSet> hashTableValues;

    public BottomUpJoinIterator(EvaluationStrategy strategy, Join join, BindingSet bindings) throws QueryEvaluationException {
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
        this.rightIter = strategy.evaluate(join.getRightArg(), bindings);
        this.joinAttributes = join.getLeftArg().getBindingNames();
        this.joinAttributes.retainAll(join.getRightArg().getBindingNames());
        this.hashTable = null;
    }

    protected BindingSet getNextElement() throws QueryEvaluationException {
        if (this.hashTable == null) {
            this.setupHashTable();
        }
        while (this.currentScanElem == null) {
            if (this.scanList.size() > 0) {
                this.currentScanElem = this.removeFirstElement(this.scanList);
            } else if (this.restIter.hasNext()) {
                this.currentScanElem = (BindingSet)this.restIter.next();
            } else {
                return null;
            }
            if (this.currentScanElem instanceof EmptyBindingSet) {
                this.hashTableValues = this.makeList();
                for (Map.Entry<BindingSet, List<BindingSet>> key : this.hashTable.entrySet()) {
                    this.addAll(this.hashTableValues, key.getValue());
                }
                continue;
            }
            BindingSet key = this.calcKey(this.currentScanElem, this.joinAttributes);
            if (this.hashTable.containsKey(key)) {
                this.hashTableValues = this.makeList(this.hashTable.get(key));
                continue;
            }
            this.currentScanElem = null;
            this.hashTableValues = null;
        }
        BindingSet nextHashTableValue = this.removeFirstElement(this.hashTableValues);
        QueryBindingSet result = new QueryBindingSet(this.currentScanElem);
        for (String name : nextHashTableValue.getBindingNames()) {
            Binding b = nextHashTableValue.getBinding(name);
            if (result.hasBinding(name)) continue;
            result.addBinding(b);
        }
        if (this.hashTableValues.size() == 0) {
            this.currentScanElem = null;
            this.hashTableValues = null;
        }
        return result;
    }

    protected void handleClose() throws QueryEvaluationException {
        super.handleClose();
        this.leftIter.close();
        this.rightIter.close();
        this.hashTable = null;
        this.hashTableValues = null;
        this.scanList = null;
    }

    protected long clearHashTable() {
        int size = this.hashTable.size();
        this.hashTable.clear();
        return size;
    }

    private BindingSet calcKey(BindingSet bindings, Set<String> commonVars) {
        QueryBindingSet q = new QueryBindingSet();
        for (String varName : commonVars) {
            Binding b = bindings.getBinding(varName);
            if (b == null) continue;
            q.addBinding(b);
        }
        return q;
    }

    private void setupHashTable() throws QueryEvaluationException {
        this.hashTable = this.makeMap();
        List<BindingSet> leftArgResults = this.makeList();
        List<BindingSet> rightArgResults = this.makeList();
        while (this.leftIter.hasNext() && this.rightIter.hasNext()) {
            this.add(leftArgResults, (BindingSet)this.leftIter.next());
            this.add(rightArgResults, (BindingSet)this.rightIter.next());
        }
        List<BindingSet> smallestResult = null;
        if (this.leftIter.hasNext()) {
            smallestResult = rightArgResults;
            this.scanList = leftArgResults;
            this.restIter = this.leftIter;
        } else {
            smallestResult = leftArgResults;
            this.scanList = rightArgResults;
            this.restIter = this.rightIter;
        }
        for (BindingSet b : smallestResult) {
            BindingSet hashKey = this.calcKey(b, this.joinAttributes);
            List<BindingSet> hashValue = null;
            hashValue = this.hashTable.containsKey(hashKey) ? this.hashTable.get(hashKey) : this.makeList();
            this.add(hashValue, b);
            this.put(this.hashTable, hashKey, hashValue);
        }
    }

    protected void put(Map<BindingSet, List<BindingSet>> hashTable, BindingSet hashKey, List<BindingSet> hashValue) throws QueryEvaluationException {
        hashTable.put(hashKey, hashValue);
    }

    protected void addAll(List<BindingSet> hashTableValues, List<BindingSet> values) throws QueryEvaluationException {
        hashTableValues.addAll(values);
    }

    protected void add(List<BindingSet> leftArgResults, BindingSet b) throws QueryEvaluationException {
        leftArgResults.add(b);
    }

    protected Map<BindingSet, List<BindingSet>> makeMap() {
        return new HashMap<BindingSet, List<BindingSet>>();
    }

    protected List<BindingSet> makeList() {
        return new ArrayList<BindingSet>();
    }

    protected List<BindingSet> makeList(List<BindingSet> key) {
        return new ArrayList<BindingSet>(key);
    }

    protected BindingSet removeFirstElement(List<BindingSet> list) throws QueryEvaluationException {
        return list.remove(0);
    }
}

