/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.TableOptions;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.DSL;
import org.jooq.impl.Fields;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.RecordImplN;
import org.jooq.impl.TableAlias;
import org.jooq.impl.Tools;

final class Values<R extends Record>
extends AbstractTable<R> {
    private static final long serialVersionUID = -637982217747670311L;
    static final Set<SQLDialect> NO_SUPPORT_VALUES = SQLDialect.supportedUntil(SQLDialect.FIREBIRD, SQLDialect.MARIADB);
    private final Row[] rows;

    Values(Row[] rows) {
        super(TableOptions.expression(), Names.N_VALUES);
        this.rows = Values.assertNotEmpty(rows);
    }

    static Row[] assertNotEmpty(Row[] rows) {
        if (rows == null || rows.length == 0) {
            throw new IllegalArgumentException("Cannot create a VALUES() constructor with an empty set of rows");
        }
        return rows;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    public final Table<R> as(Name alias) {
        return new TableAlias(this, alias, true);
    }

    @Override
    public final Table<R> as(Name alias, Name ... fieldAliases) {
        return new TableAlias(this, alias, fieldAliases, true);
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (NO_SUPPORT_VALUES.contains((Object)ctx.dialect())) {
            Select<Record> selects = null;
            for (Row row : this.rows) {
                SelectSelectStep<Record> select = DSL.select(row.fields());
                selects = selects == null ? select : selects.unionAll(select);
            }
            Tools.visitSubquery(ctx, selects);
        } else {
            ctx.start(Clause.TABLE_VALUES);
            ctx.visit(Keywords.K_VALUES);
            if (this.rows.length > 1) {
                ctx.formatIndentStart().formatSeparator();
            } else {
                ctx.sql(' ');
            }
            for (int i = 0; i < this.rows.length; ++i) {
                if (i > 0) {
                    ctx.sql(',').formatSeparator();
                }
                if (ctx.family() == SQLDialect.MYSQL) {
                    ctx.visit(Keywords.K_ROW).sql(" ");
                }
                ctx.visit(this.rows[i]);
            }
            if (this.rows.length > 1) {
                ctx.formatIndentEnd().formatNewLine();
            }
            ctx.end(Clause.TABLE_VALUES);
        }
    }

    @Override
    final Fields<R> fields0() {
        return new Fields(this.rows[0].fields());
    }
}

