/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Set;
import org.jooq.Clause;
import org.jooq.Comparator;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.QueryPartInternal;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.InCondition;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.RowCondition;

final class RowInCondition
extends AbstractCondition {
    private static final long serialVersionUID = -1806139685201770706L;
    private static final Clause[] CLAUSES_IN = new Clause[]{Clause.CONDITION, Clause.CONDITION_IN};
    private static final Clause[] CLAUSES_IN_NOT = new Clause[]{Clause.CONDITION, Clause.CONDITION_NOT_IN};
    private static final Set<SQLDialect> EMULATE_IN = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.SQLITE);
    private final Row left;
    private final QueryPartList<? extends Row> right;
    private final boolean not;

    RowInCondition(Row left, QueryPartList<? extends Row> right, boolean not) {
        this.left = left;
        this.right = right;
        this.not = not;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.delegate(ctx.configuration()));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    private final QueryPartInternal delegate(Configuration configuration) {
        if (EMULATE_IN.contains((Object)configuration.dialect())) {
            ArrayList<RowCondition> conditions = new ArrayList<RowCondition>(this.right.size());
            for (Row row : this.right) {
                conditions.add(new RowCondition(this.left, row, Comparator.EQUALS));
            }
            Condition result = DSL.or(conditions);
            if (this.not) {
                result = result.not();
            }
            return (QueryPartInternal)((Object)result);
        }
        return new Native();
    }

    private class Native
    extends AbstractCondition {
        private static final long serialVersionUID = -7019193803316281371L;

        private Native() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            if (RowInCondition.this.right.size() == 0) {
                if (RowInCondition.this.not) {
                    ctx.visit(DSL.trueCondition());
                } else {
                    ctx.visit(DSL.falseCondition());
                }
            } else {
                ctx.visit(RowInCondition.this.left).sql(' ').visit((RowInCondition.this.not ? Comparator.NOT_IN : Comparator.IN).toKeyword()).sql(" (").visit(new QueryPartListView(InCondition.padded(ctx, RowInCondition.this.right))).sql(')');
            }
        }

        @Override
        public final Clause[] clauses(Context<?> ctx) {
            return RowInCondition.this.not ? CLAUSES_IN_NOT : CLAUSES_IN;
        }
    }
}

