/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mercator1SP
extends Projection {
    public static final Identifier MERC = new Identifier("EPSG", "9804", "Mercator (1SP)", "MERC");
    protected final double lat0;
    protected final double lon0 = this.getCentralMeridian();
    protected final double FE;
    protected final double FN;
    protected final double n;
    protected final double[] invcoeff;

    public Mercator1SP(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(MERC, ellipsoid, parameters);
        this.lat0 = this.getLatitudeOfOrigin();
        this.FE = this.getFalseEasting();
        this.FN = this.getFalseNorthing();
        double lat_ts = this.getLatitudeOfTrueScale();
        double e2 = ellipsoid.getSquareEccentricity();
        double k0 = lat_ts != 0.0 ? Math.cos(lat_ts) / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(lat_ts), 2.0)) : this.getScaleFactor();
        double a = this.getSemiMajorAxis();
        this.n = k0 * a;
        this.invcoeff = Mercator1SP.getInverseMercatorCoeff(ellipsoid);
    }

    public static double[] getInverseMercatorCoeff(Ellipsoid ellps) {
        double e2 = ellps.getSquareEccentricity();
        double e4 = e2 * e2;
        double e6 = e4 * e2;
        double e8 = e4 * e4;
        double[] inv_merc_coeff = new double[]{1.0, e2 * 1.0 / 2.0 + e4 * 5.0 / 24.0 + e6 * 1.0 / 12.0 + e8 * 13.0 / 360.0, e4 * 7.0 / 48.0 + e6 * 29.0 / 240.0 + e8 * 811.0 / 11520.0, e6 * 7.0 / 120.0 + e8 * 81.0 / 1120.0, e8 * 4279.0 / 161280.0};
        return inv_merc_coeff;
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.CYLINDRICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.CONFORMAL;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TANGENT;
    }

    @Override
    public double[] transform(double[] coord) throws CoordinateDimensionException {
        double lon = coord[1];
        double lat = Math.abs(coord[0]) > 1.4835298641951802 ? 1.4835298641951802 : coord[0];
        double E = this.n * (lon - this.lon0);
        double N = this.n * this.ellipsoid.isometricLatitude(lat);
        coord[0] = this.FE + E;
        coord[1] = this.FN + N;
        return coord;
    }

    @Override
    public Projection inverse() throws NonInvertibleOperationException {
        return new Mercator1SP(this.ellipsoid, this.parameters){

            public double[] transform(double[] coord) throws CoordinateDimensionException {
                double ki;
                double t = Math.exp((this.FN - coord[1]) / this.n);
                double lat = ki = 1.5707963267948966 - 2.0 * Math.atan(t);
                for (int i = 1; i < 5; ++i) {
                    lat += this.invcoeff[i] * Math.sin((double)(2 * i) * ki);
                }
                coord[1] = (coord[0] - this.FE) / this.n + this.lon0;
                coord[0] = lat;
                return coord;
            }

            public Projection inverse() throws NonInvertibleOperationException {
                return Mercator1SP.this;
            }

            public boolean isDirect() {
                return false;
            }

            public String toString() {
                return Mercator1SP.this.toString() + " inverse";
            }
        };
    }
}

